/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ExternalFormatProcessor;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.completion.ClangdLiveTemplate;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangdCompletionUtils {
    @NotNull
    public static String getText(@NotNull Document document, int startOffset, int endOffset) {
        if (document == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(0);
        }
        if (startOffset >= 0 && endOffset > startOffset) {
            CharSequence chars = document.getImmutableCharSequence();
            String string = chars.subSequence(Math.min(chars.length(), startOffset), Math.min(chars.length(), endOffset)).toString();
            if (string == null) {
                ClangdCompletionUtils.$$$reportNull$$$0(1);
            }
            return string;
        }
        return "";
    }

    @NotNull
    public static String getText(@NotNull Editor editor, int startOffset, int endOffset) {
        if (editor == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(2);
        }
        return ClangdCompletionUtils.getText(editor.getDocument(), startOffset, endOffset);
    }

    public static boolean hasMatchingSpaceAfterInsertion(@NotNull String insertion, @NotNull Document document, int endOffset) {
        if (insertion == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(3);
        }
        if (document == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(4);
        }
        return insertion.endsWith(" ") && endOffset < document.getTextLength() && ClangdCompletionUtils.getText(document, endOffset, endOffset + 1).equals(" ");
    }

    public static boolean adjustCompletionInLiveTemplateIfNeeded(@NotNull Project project, @NotNull Editor editor, @NotNull Document document, @NotNull String insertion, int endOffset) {
        Template currentTemplate;
        if (project == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(6);
        }
        if (document == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(7);
        }
        if (insertion == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(8);
        }
        if ((currentTemplate = TemplateManager.getInstance((Project)project).getActiveTemplate(editor)) != null && insertion.endsWith(" ")) {
            document.replaceString(endOffset - 1, endOffset, (CharSequence)"");
            return true;
        }
        return false;
    }

    public static boolean isLiveTemplateNameSegmentCompletion(@NotNull Project project, @NotNull Editor editor) {
        Template currentTemplate;
        if (project == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(10);
        }
        if ((currentTemplate = TemplateManager.getInstance((Project)project).getActiveTemplate(editor)) == null) {
            return false;
        }
        @Nullable TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
        if (templateState == null) {
            return false;
        }
        if (currentTemplate.getSegmentsCount() <= templateState.getCurrentVariableNumber()) {
            return false;
        }
        return currentTemplate.getSegmentName(templateState.getCurrentVariableNumber()).equals("name") && currentTemplate instanceof ClangdLiveTemplate && ((ClangdLiveTemplate)currentTemplate).getDontCompleteName();
    }

    static void reformatCompletion(@NotNull InsertionContext context, int startOffset, int endOffset) {
        if (context == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(11);
        }
        Document document = context.getDocument();
        Project project = context.getProject();
        RangeMarker marker = document.createRangeMarker(startOffset, endOffset);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
        PsiDocumentManager.getInstance((Project)project).performForCommittedDocument(document, () -> CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            int _startOffset = marker.getStartOffset();
            int _endOffset = marker.getEndOffset();
            marker.dispose();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile == null) {
                return;
            }
            if (ExternalFormatProcessor.useExternalFormatter((PsiFile)psiFile)) {
                ExternalFormatProcessor.formatRangeInFile((PsiFile)psiFile, (TextRange)new TextRange(_startOffset, _endOffset), (boolean)true, (boolean)true, (boolean)false);
                return;
            }
            OCChangeUtil.reformatTextIfNotInjected((PsiFile)psiFile, (int)_startOffset, (int)_endOffset);
        })));
    }

    static void reindentCompletion(@NotNull InsertionContext context, int startOffset, int endOffset) {
        if (context == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(12);
        }
        Document document = context.getDocument();
        Project project = context.getProject();
        RangeMarker marker = document.createRangeMarker(startOffset, endOffset);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        }
        PsiDocumentManager.getInstance((Project)project).performForCommittedDocument(document, () -> CommandProcessor.getInstance().runUndoTransparentAction(() -> ApplicationManager.getApplication().runWriteAction(() -> {
            int _startOffset = marker.getStartOffset();
            int _endOffset = marker.getEndOffset();
            marker.dispose();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile == null) {
                return;
            }
            int startLine = document.getLineNumber(_startOffset);
            int endLine = document.getLineNumber(_endOffset);
            for (int line = startLine; line <= endLine; ++line) {
                String indent;
                int startOfLineOffset = document.getLineStartOffset(line);
                String string = indent = ExternalFormatProcessor.useExternalFormatter((PsiFile)psiFile) ? ExternalFormatProcessor.indentLine((PsiFile)psiFile, (int)startOfLineOffset) : OCChangeUtil.indentLineIfNotInjected((PsiFile)psiFile, (int)startOfLineOffset);
                if (indent == null) continue;
                int startOfTextInLine = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)startOfLineOffset, (String)" \t");
                document.replaceString(startOfLineOffset, startOfTextInLine, (CharSequence)indent);
            }
        })));
    }

    public static String trimKeywordLookup(@NotNull String lookupString) {
        if (lookupString == null) {
            ClangdCompletionUtils.$$$reportNull$$$0(13);
        }
        return StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimEnd((String)StringUtil.trimStart((String)StringUtil.trimStart((String)StringUtil.trimStart((String)lookupString.trim(), (String)"@"), (String)"~"), (String)"#"), (String)";"), (String)"}").trim(), (String)"{").trim();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/completion/ClangdCompletionUtils";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertion";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/completion/ClangdCompletionUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 1: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasMatchingSpaceAfterInsertion";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "adjustCompletionInLiveTemplateIfNeeded";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isLiveTemplateNameSegmentCompletion";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reformatCompletion";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "reindentCompletion";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "trimKeywordLookup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

