/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.namehint;

import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayInfo;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResultConsumer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.params.ClangdInlayHint;
import com.jetbrains.cidr.lang.daemon.clang.namehint.InlayHintsProvider;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/namehint/ClangBasicInlayParameterHintsProvider;", "Lcom/jetbrains/cidr/lang/daemon/clang/namehint/InlayHintsProvider;", "()V", "getHintInfo", "Lcom/intellij/codeInsight/hints/HintInfo;", "element", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/jetbrains/cidr/lang/psi/OCPsiFile;", "getInlayHints", "", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/params/ClangdInlayHint;", "timeoutMs", "", "getParameterHints", "Lcom/intellij/codeInsight/hints/InlayInfo;", "intellij.c.clangdBridge"})
public final class ClangBasicInlayParameterHintsProvider
implements InlayHintsProvider {
    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<InlayInfo> getParameterHints(@NotNull PsiElement element, @NotNull OCPsiFile file) {
        Object v7;
        Document document;
        block5: {
            void $this$singleOrNull$iv;
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Document document2 = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument((PsiFile)file);
            if (document2 == null) {
                return CollectionsKt.emptyList();
            }
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"PsiDocumentManager.getIn\u2026le) ?: return emptyList()");
            document = document2;
            List<ClangdInlayHint> hints = this.getInlayHints(Long.MAX_VALUE, file);
            int elementOffset = element.getTextOffset();
            Iterable $this$filter$iv = hints;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ClangdInlayHint it = (ClangdInlayHint)element$iv$iv;
                boolean bl = false;
                Range range = it.getRange();
                if (!((range != null ? range.getStart() : null) != null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                ClangdInlayHint it = (ClangdInlayHint)element$iv;
                boolean bl = false;
                Range range = it.getRange();
                Intrinsics.checkNotNull((Object)range);
                Position position = range.getStart();
                Intrinsics.checkNotNull((Object)position);
                int n = document.getLineStartOffset(position.getLine());
                Range range2 = it.getRange();
                Intrinsics.checkNotNull((Object)range2);
                Position position2 = range2.getStart();
                Intrinsics.checkNotNull((Object)position2);
                if (!(n + position2.getCharacter() == elementOffset)) continue;
                if (found$iv) {
                    v7 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v7 = !found$iv ? null : single$iv;
        }
        ClangdInlayHint clangdInlayHint = v7;
        if (clangdInlayHint == null) {
            return CollectionsKt.emptyList();
        }
        ClangdInlayHint hint = clangdInlayHint;
        String string = hint.getLabel();
        Intrinsics.checkNotNull((Object)string);
        String string2 = string.stripTrailing();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"hint.label!!.stripTrailing()");
        String string3 = StringsKt.removeSuffix((String)string2, (CharSequence)":");
        Range range = hint.getRange();
        Intrinsics.checkNotNull((Object)range);
        Position position = range.getStart();
        Intrinsics.checkNotNull((Object)position);
        int n = document.getLineStartOffset(position.getLine());
        Range range3 = hint.getRange();
        Intrinsics.checkNotNull((Object)range3);
        Position position3 = range3.getStart();
        Intrinsics.checkNotNull((Object)position3);
        return CollectionsKt.listOf((Object)new InlayInfo(string3, n + position3.getCharacter(), false));
    }

    @Override
    @Nullable
    public HintInfo getHintInfo(@NotNull PsiElement element, @NotNull OCPsiFile file) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return null;
    }

    private final List<ClangdInlayHint> getInlayHints(long timeoutMs, OCPsiFile file) {
        ClangLanguageService clangLanguageService = ClangLanguageServiceProvider.getIfStarted((Project)file.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)clangLanguageService, (String)"ClangLanguageServiceProv\u2026etIfStarted(file.project)");
        ClangLanguageService service = clangLanguageService;
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"Ref.create()");
        Ref hints = ref;
        service.getInlayHints(file.getVirtualFile(), new ClangResultConsumer(hints, timeoutMs){
            final /* synthetic */ Ref $hints;
            final /* synthetic */ long $timeoutMs;

            public final void consume(@NotNull ClangResult<List<ClangdInlayHint>> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$hints.set(it.waitForResult(this.$timeoutMs));
            }
            {
                this.$hints = ref;
                this.$timeoutMs = l;
            }
        });
        List list = (List)hints.get();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

