/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ClangTidyIntentionAction
implements IntentionAction {
    @NotNull
    @IntentionName
    private final String myMessage;
    @NotNull
    @IntentionFamilyName
    private final String myCheckName;
    @NotNull
    private final List<Replacement> myReplacements;

    public ClangTidyIntentionAction(@NotNull @IntentionName String message, @NotNull @IntentionFamilyName String checkName, @NotNull List<ClangTidyReplacement> replacements) {
        if (message == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(0);
        }
        if (checkName == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(1);
        }
        if (replacements == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(2);
        }
        this.myMessage = message;
        this.myCheckName = checkName;
        this.myReplacements = ClangTidyIntentionAction.createReplacements(replacements);
    }

    @NotNull
    public String getText() {
        String string = this.myMessage;
        if (string == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myCheckName;
        if (string == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(5);
        }
        return OCLanguageUtils.isSupported((PsiFile)file) && !this.myReplacements.isEmpty() && this.myReplacements.stream().allMatch(replacement -> replacement != null && replacement.isValid());
    }

    public void invoke(@NotNull Project project, Editor intentionStarterEditor, PsiFile intentionStarterFile) throws IncorrectOperationException {
        if (project == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(6);
        }
        if (!this.isAvailable(project, intentionStarterEditor, intentionStarterFile)) {
            return;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Set<Document> documentsWithReplacements = this.myReplacements.stream().map(replacement -> replacement.myRangeMarker.getDocument()).collect(Collectors.toSet());
        documentsWithReplacements.forEach(replaceHolderDocument -> {
            PsiFile replaceHolderFileIfOpen = documentManager.getCachedPsiFile(replaceHolderDocument);
            if (replaceHolderFileIfOpen != null) {
                OCChangeUtil.processPostponedFormatIfNeed((PsiFile)replaceHolderFileIfOpen);
            }
        });
        for (Replacement replacement2 : this.myReplacements) {
            RangeMarker rangeMarker = replacement2.myRangeMarker;
            rangeMarker.getDocument().replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)replacement2.myReplacementText);
        }
        documentsWithReplacements.forEach(replaceHolderDocument -> documentManager.commitDocument(replaceHolderDocument));
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    private static List<Replacement> createReplacements(@NotNull List<ClangTidyReplacement> replacements) {
        if (replacements == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.map(replacements, replacement -> {
            VirtualFile filePath = VfsUtil.findFile((Path)Paths.get(replacement.getFilePath(), new String[0]), (boolean)true);
            if (filePath == null) {
                return null;
            }
            Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(filePath));
            if (document == null) {
                return null;
            }
            int beginOffset = replacement.getBeginOffset();
            int endOffset = replacement.getEndOffset();
            if (!DocumentUtil.isValidOffset((int)beginOffset, (Document)document) || !DocumentUtil.isValidOffset((int)endOffset, (Document)document)) {
                return null;
            }
            RangeMarker rangeMarker = document.createRangeMarker(beginOffset, endOffset);
            String oldText = document.getText(new TextRange(beginOffset, endOffset));
            return new Replacement(rangeMarker, oldText, replacement.getReplacementText());
        });
        if (list == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkName";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacements";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyIntentionAction";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyIntentionAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createReplacements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createReplacements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Replacement {
        @NotNull
        private final RangeMarker myRangeMarker;
        @NotNull
        private final String myOldText;
        @NotNull
        private final String myReplacementText;

        Replacement(@NotNull RangeMarker rangeMarker, @NotNull String oldText, @NotNull String replacementText) {
            if (rangeMarker == null) {
                Replacement.$$$reportNull$$$0(0);
            }
            if (oldText == null) {
                Replacement.$$$reportNull$$$0(1);
            }
            if (replacementText == null) {
                Replacement.$$$reportNull$$$0(2);
            }
            this.myRangeMarker = rangeMarker;
            this.myOldText = oldText;
            this.myReplacementText = replacementText;
        }

        public boolean isValid() {
            if (!this.myRangeMarker.isValid()) {
                return false;
            }
            TextRange textRange = new TextRange(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset());
            String actualText = this.myRangeMarker.getDocument().getText(textRange);
            return actualText.equals(this.myOldText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rangeMarker";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "replacementText";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyIntentionAction$Replacement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

