/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyUtil;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import java.awt.Desktop;
import java.awt.Dimension;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyUpdatedChecksDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(ClangTidyUpdatedChecksDialog.class);
    @NotNull
    private final List<String> myNewChecks;
    @Nullable
    private final ClangTidyInspection myInspection;
    @Nullable
    private final Set<String> myEnabledNewChecks;
    @Nullable
    private final ClangTidyFilesState myClangTidyFilesState;

    public ClangTidyUpdatedChecksDialog(@NotNull Collection<String> newChecks, @NotNull Project project) {
        if (newChecks == null) {
            ClangTidyUpdatedChecksDialog.$$$reportNull$$$0(0);
        }
        if (project == null) {
            ClangTidyUpdatedChecksDialog.$$$reportNull$$$0(1);
        }
        super(project, false);
        this.myNewChecks = new ArrayList<String>(newChecks);
        ContainerUtil.sort(this.myNewChecks);
        this.myInspection = ClangTidyUtil.getInspection(null, project);
        this.myEnabledNewChecks = this.getEnabledNewChecks();
        this.myClangTidyFilesState = (ClangTidyFilesState)project.getService(ClangTidyFilesState.class);
        this.setTitle(OCInspectionsBundle.message((String)"clang.tidy.update.new.checks.dialog.title", (Object[])new Object[0]));
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        FormBuilder builder = new FormBuilder();
        JBTable table = this.createTable();
        JComponent decorator = this.createTableDecorator(table);
        builder.addComponentFillVertically(decorator, 0);
        if (this.isClangTidyFilesCanOverrideDefaultSettings()) {
            builder.addComponent(ClangTidyUpdatedChecksDialog.createClangTidyFilesOverrideHint());
        }
        builder.getPanel().setPreferredSize(ClangTidyUpdatedChecksDialog.getPreferredDialogDimension((JTable)table));
        return builder.getPanel();
    }

    protected void doOKAction() {
        this.updateClangTidyConfiguration();
        super.doOKAction();
    }

    private void updateClangTidyConfiguration() {
        if (this.myInspection == null || this.myEnabledNewChecks == null) {
            LOG.warn("Cannot update clang-tidy configuration: myInspection/myEnabledNewChecks is null");
            return;
        }
        for (String checkName : this.myNewChecks) {
            if (this.myEnabledNewChecks.contains(checkName)) {
                this.myInspection.setClangTidyChecks(ClangTidyUtil.enableCheck(this.myInspection.getClangTidyChecks(), checkName));
                continue;
            }
            this.myInspection.setClangTidyChecks(ClangTidyUtil.disableCheck(this.myInspection.getClangTidyChecks(), checkName));
        }
    }

    @Nullable
    private Set<String> getEnabledNewChecks() {
        if (this.myInspection == null) {
            return null;
        }
        String configuration = this.myInspection.getClangTidyChecks();
        List<String> options = ClangTidyUtil.getTrimmedOptions(configuration);
        HashSet<String> enabledNewChecks = new HashSet<String>();
        for (String check : this.myNewChecks) {
            if (ClangTidyUtil.isDisabled(options, check)) continue;
            enabledNewChecks.add(check);
        }
        return enabledNewChecks;
    }

    @NotNull
    private static Dimension getPreferredDialogDimension(@NotNull JTable table) {
        if (table == null) {
            ClangTidyUpdatedChecksDialog.$$$reportNull$$$0(2);
        }
        int VISIBLE_ROWS = 10;
        int height = table.getRowHeight() * 10 + table.getIntercellSpacing().height * 11 + table.getTableHeader().getPreferredSize().height + 50;
        return new Dimension(450, height);
    }

    private boolean isClangTidyFilesCanOverrideDefaultSettings() {
        return this.myInspection != null && this.myInspection.isPreferClangTidyFilesOverIDESettings() && this.myClangTidyFilesState != null && !this.myClangTidyFilesState.getClangTidyFiles().isEmpty();
    }

    @NotNull
    private static JComponent createClangTidyFilesOverrideHint() {
        JBLabel hint = new JBLabel(AllIcons.General.Warning, 2);
        hint.setText(OCInspectionsBundle.message((String)"clang.tidy.update.settings.override", (Object[])new Object[0]));
        JBLabel jBLabel = hint;
        if (jBLabel == null) {
            ClangTidyUpdatedChecksDialog.$$$reportNull$$$0(3);
        }
        return jBLabel;
    }

    @NotNull
    private JBTable createTable() {
        DefaultTableModel model = this.createTableModel();
        JBTable table = new JBTable((TableModel)model);
        ClangTidyUpdatedChecksDialog.setHeaderValues(table);
        ClangTidyUpdatedChecksDialog.setColumnRenderers(table);
        ClangTidyUpdatedChecksDialog.setColumnWidths((JTable)table);
        table.setFillsViewportHeight(true);
        JBTable jBTable = table;
        if (jBTable == null) {
            ClangTidyUpdatedChecksDialog.$$$reportNull$$$0(4);
        }
        return jBTable;
    }

    @NotNull
    private JComponent createTableDecorator(final @NotNull JBTable table) {
        if (table == null) {
            ClangTidyUpdatedChecksDialog.$$$reportNull$$$0(5);
        }
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)table).addExtraAction(new AnActionButton(OCInspectionsBundle.message((String)"clang.tidy.update.go.to.help.page", (Object[])new Object[0]), AllIcons.ToolbarDecorator.Export){

            public void actionPerformed(@NotNull AnActionEvent e) {
                int row;
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((row = table.getSelectedRow()) >= 0 && row < ClangTidyUpdatedChecksDialog.this.myNewChecks.size()) {
                    ClangTidyUpdatedChecksDialog.tryNavigateToHelpPage(ClangTidyUpdatedChecksDialog.this.myNewChecks.get(row));
                }
            }

            public boolean isEnabled() {
                return table.getSelectedRowCount() == 1;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyUpdatedChecksDialog$1", "actionPerformed"));
            }
        }).setToolbarPosition(ActionToolbarPosition.RIGHT).createPanel();
        if (jPanel == null) {
            ClangTidyUpdatedChecksDialog.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    private static void tryNavigateToHelpPage(@NotNull String checkName) {
        if (checkName == null) {
            ClangTidyUpdatedChecksDialog.$$$reportNull$$$0(7);
        }
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI("https://clang.llvm.org/extra/clang-tidy/checks/" + checkName + ".html"));
            }
            catch (Exception e) {
                LOG.warn("Cannot navigate to clang-tidy help page", (Throwable)e);
            }
        }
    }

    private static void setColumnRenderers(@NotNull JBTable table) {
        if (table == null) {
            ClangTidyUpdatedChecksDialog.$$$reportNull$$$0(8);
        }
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn firstColumn = columnModel.getColumn(0);
        TableColumn secondColumn = columnModel.getColumn(1);
        firstColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        firstColumn.setHeaderRenderer(ClangTidyUpdatedChecksDialog.createDefaultTableCellRenderer());
        firstColumn.setCellEditor((TableCellEditor)new BooleanTableCellEditor());
        secondColumn.setCellRenderer(ClangTidyUpdatedChecksDialog.createDefaultTableCellRenderer());
        secondColumn.setHeaderRenderer(ClangTidyUpdatedChecksDialog.createDefaultTableCellRenderer());
    }

    @NotNull
    private static TableCellRenderer createDefaultTableCellRenderer() {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        DefaultTableCellRenderer defaultTableCellRenderer = renderer;
        if (defaultTableCellRenderer == null) {
            ClangTidyUpdatedChecksDialog.$$$reportNull$$$0(9);
        }
        return defaultTableCellRenderer;
    }

    private static void setHeaderValues(@NotNull JBTable table) {
        if (table == null) {
            ClangTidyUpdatedChecksDialog.$$$reportNull$$$0(10);
        }
        TableColumnModel columnModel = table.getColumnModel();
        columnModel.getColumn(0).setHeaderValue(OCInspectionsBundle.message((String)"clang.tidy.update.check.enabled.column.title", (Object[])new Object[0]));
        columnModel.getColumn(1).setHeaderValue(OCInspectionsBundle.message((String)"clang.tidy.update.check.name.column.title", (Object[])new Object[0]));
    }

    private static void setColumnWidths(@NotNull JTable table) {
        if (table == null) {
            ClangTidyUpdatedChecksDialog.$$$reportNull$$$0(11);
        }
        TableColumnModel columnModel = table.getColumnModel();
        TableColumn testNumberColumn = columnModel.getColumn(0);
        testNumberColumn.setMaxWidth(100);
    }

    @NotNull
    private DefaultTableModel createTableModel() {
        DefaultTableModel model = new DefaultTableModel(this.myNewChecks.size(), 2){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 0 && ClangTidyUpdatedChecksDialog.this.myEnabledNewChecks != null;
            }

            @Override
            public Object getValueAt(int row, int column) {
                switch (column) {
                    case 0: {
                        return ClangTidyUpdatedChecksDialog.this.myEnabledNewChecks == null || ClangTidyUpdatedChecksDialog.this.myEnabledNewChecks.contains(ClangTidyUpdatedChecksDialog.this.myNewChecks.get(row));
                    }
                    case 1: {
                        return ClangTidyUpdatedChecksDialog.this.myNewChecks.get(row);
                    }
                }
                return "";
            }

            @Override
            public void setValueAt(Object aValue, int row, int column) {
                if (ClangTidyUpdatedChecksDialog.this.myEnabledNewChecks == null) {
                    return;
                }
                boolean isEnabled = (Boolean)aValue;
                if (isEnabled) {
                    ClangTidyUpdatedChecksDialog.this.myEnabledNewChecks.add(ClangTidyUpdatedChecksDialog.this.myNewChecks.get(row));
                } else {
                    ClangTidyUpdatedChecksDialog.this.myEnabledNewChecks.remove(ClangTidyUpdatedChecksDialog.this.myNewChecks.get(row));
                }
            }
        };
        model.setRowCount(this.myNewChecks.size());
        DefaultTableModel defaultTableModel = model;
        if (defaultTableModel == null) {
            ClangTidyUpdatedChecksDialog.$$$reportNull$$$0(12);
        }
        return defaultTableModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChecks";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyUpdatedChecksDialog";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyUpdatedChecksDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createClangTidyFilesOverrideHint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createTable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableDecorator";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultTableCellRenderer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createTableModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredDialogDimension";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTableDecorator";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "tryNavigateToHelpPage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setColumnRenderers";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setHeaderValues";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setColumnWidths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

