/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.ImagesBundle;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.options.impl.ImagesConfigurable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/intellij/images/actions/EditExternallyAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.platform.images"})
public final class EditExternallyAction
extends DumbAwareAction {
    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getRequiredData(CommonDataKeys.VIRTUAL_FILE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(CommonDataKeys.VIRTUAL_FILE)");
        VirtualFile imageFile = (VirtualFile)object;
        String string = PropertiesComponent.getInstance().getValue("Images.ExternalEditorPath", "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PropertiesComponent.getI\u2026rAction.EXT_PATH_KEY, \"\")");
        String executablePath = string;
        if (!StringUtil.isEmpty((String)executablePath)) {
            String path;
            Map map = EnvironmentUtil.getEnvironmentMap();
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"EnvironmentUtil.getEnvironmentMap()");
            Map $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Map map2 = $this$forEach$iv;
            boolean bl = false;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                String string2;
                void varName;
                Map.Entry element$iv;
                Map.Entry $dstr$varName$varValue = element$iv = iterator.next();
                boolean bl2 = false;
                Map.Entry entry = $dstr$varName$varValue;
                boolean bl3 = false;
                String string3 = (String)entry.getKey();
                entry = $dstr$varName$varValue;
                bl3 = false;
                String varValue = (String)entry.getValue();
                if (SystemInfo.isWindows) {
                    String string4 = StringUtil.replace((String)executablePath, (String)('%' + (String)varName + '%'), (String)varValue, (boolean)true);
                    string2 = string4;
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringUtil.replace(execu\u2026arName%\", varValue, true)");
                } else {
                    String string5 = StringUtil.replace((String)executablePath, (String)("${" + (String)varName + '}'), (String)varValue, (boolean)false);
                    string2 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"StringUtil.replace(execu\u2026rName}\", varValue, false)");
                }
                executablePath = string2;
            }
            String string6 = FileUtil.toSystemDependentName((String)executablePath);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"FileUtil.toSystemDependentName(executablePath)");
            executablePath = string6;
            File executable = new File(executablePath);
            GeneralCommandLine commandLine = new GeneralCommandLine();
            String string7 = path = executable.exists() ? executable.getAbsolutePath() : executablePath;
            if (SystemInfo.isMac) {
                commandLine.setExePath(ExecUtil.getOpenCommandPath());
                commandLine.addParameter("-a");
                commandLine.addParameter(path);
            } else {
                commandLine.setExePath(path);
            }
            ImageFileTypeManager typeManager = ImageFileTypeManager.getInstance();
            if (imageFile.isInLocalFileSystem() && typeManager.isImage(imageFile)) {
                File file = VfsUtilCore.virtualToIoFile((VirtualFile)imageFile);
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"VfsUtilCore.virtualToIoFile(imageFile)");
                commandLine.addParameter(file.getAbsolutePath());
            }
            commandLine.setWorkDirectory(new File(executablePath).getParentFile());
            try {
                Intrinsics.checkNotNullExpressionValue((Object)commandLine.createProcess(), (String)"commandLine.createProcess()");
            }
            catch (ExecutionException ex) {
                Messages.showErrorDialog((Project)e.getProject(), (String)ex.getLocalizedMessage(), (String)ImagesBundle.message("error.title.launching.external.editor", new Object[0]));
                ImagesConfigurable.show(e.getProject());
            }
        } else {
            try {
                Desktop.getDesktop().open(imageFile.toNioPath().toFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        boolean enabled;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        boolean bl = enabled = file != null && ImageFileTypeManager.getInstance().isImage(file);
        if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"ProjectViewPopup")) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setVisible(enabled);
        }
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(enabled);
    }
}

