/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.DynamicBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.util.SmartFMap;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Presentation
implements Cloneable {
    public static final Supplier<String> NULL_STRING = () -> null;
    private static final Logger LOG = Logger.getInstance(Presentation.class);
    private SmartFMap<String, Object> myUserMap;
    @NonNls
    public static final String PROP_TEXT = "text";
    @NonNls
    public static final String PROP_TEXT_WITH_SUFFIX = "textWithSuffix";
    @NonNls
    public static final String PROP_MNEMONIC_KEY = "mnemonicKey";
    @NonNls
    public static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    @NonNls
    public static final String PROP_DESCRIPTION = "description";
    @NonNls
    public static final String PROP_ICON = "icon";
    @NonNls
    public static final String PROP_DISABLED_ICON = "disabledIcon";
    @NonNls
    public static final String PROP_SELECTED_ICON = "selectedIcon";
    @NonNls
    public static final String PROP_HOVERED_ICON = "hoveredIcon";
    @NonNls
    public static final String PROP_VISIBLE = "visible";
    @NonNls
    public static final String PROP_ENABLED = "enabled";
    public static final @NonNls Key<@Nls String> PROP_VALUE = Key.create((String)"value");
    public static final double DEFAULT_WEIGHT = 0.0;
    public static final double HIGHER_WEIGHT = 42.0;
    public static final double EVEN_HIGHER_WEIGHT = 239.0;
    private PropertyChangeSupport myChangeSupport;
    private @NotNull Supplier<@NlsActions.ActionDescription String> myDescriptionSupplier;
    private Icon myIcon;
    private Icon myDisabledIcon;
    private Icon myHoveredIcon;
    private Icon mySelectedIcon;
    @NotNull
    private Supplier<TextWithMnemonic> myTextWithMnemonicSupplier;
    private boolean myVisible;
    private boolean myEnabled;
    private boolean myMultipleChoice;
    private double myWeight;
    @NotNull
    private static final NotNullLazyValue<Boolean> removeMnemonics = NotNullLazyValue.createValue(() -> SystemInfoRt.isMac && DynamicBundle.LanguageBundleEP.EP_NAME.hasAnyExtensions());

    public Presentation() {
        this.myUserMap = SmartFMap.emptyMap();
        this.myDescriptionSupplier = () -> null;
        this.myTextWithMnemonicSupplier = () -> null;
        this.myVisible = true;
        this.myEnabled = true;
        this.myMultipleChoice = false;
        this.myWeight = 0.0;
    }

    public Presentation(@NotNull @NlsActions.ActionText String text2) {
        if (text2 == null) {
            Presentation.$$$reportNull$$$0(0);
        }
        this.myUserMap = SmartFMap.emptyMap();
        this.myDescriptionSupplier = () -> null;
        this.myTextWithMnemonicSupplier = () -> null;
        this.myVisible = true;
        this.myEnabled = true;
        this.myMultipleChoice = false;
        this.myWeight = 0.0;
        this.myTextWithMnemonicSupplier = () -> TextWithMnemonic.fromPlainText((String)text2);
    }

    public Presentation(@NotNull Supplier<@NlsActions.ActionText String> dynamicText) {
        if (dynamicText == null) {
            Presentation.$$$reportNull$$$0(1);
        }
        this.myUserMap = SmartFMap.emptyMap();
        this.myDescriptionSupplier = () -> null;
        this.myTextWithMnemonicSupplier = () -> null;
        this.myVisible = true;
        this.myEnabled = true;
        this.myMultipleChoice = false;
        this.myWeight = 0.0;
        this.myTextWithMnemonicSupplier = () -> TextWithMnemonic.fromPlainText((String)((String)dynamicText.get()));
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener l) {
        PropertyChangeSupport support;
        if (l == null) {
            Presentation.$$$reportNull$$$0(2);
        }
        if ((support = this.myChangeSupport) == null) {
            this.myChangeSupport = support = new PropertyChangeSupport(this);
        }
        support.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener l) {
        PropertyChangeSupport support;
        if (l == null) {
            Presentation.$$$reportNull$$$0(3);
        }
        if ((support = this.myChangeSupport) != null) {
            support.removePropertyChangeListener(l);
        }
    }

    @NlsActions.ActionText
    public String getText() {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? null : textWithMnemonic.getText();
    }

    @NlsActions.ActionText
    public String getText(boolean withSuffix) {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? null : textWithMnemonic.getText(withSuffix);
    }

    public void setText(@NotNull @Nls(capitalization=Nls.Capitalization.Title) Supplier<String> text2, boolean mayContainMnemonic) {
        if (text2 == null) {
            Presentation.$$$reportNull$$$0(4);
        }
        this.setTextWithMnemonic(this.getTextWithMnemonic(text2, mayContainMnemonic));
    }

    public void setText(@Nullable @NlsActions.ActionText String text2, boolean mayContainMnemonic) {
        this.setTextWithMnemonic(this.getTextWithMnemonic(() -> text2, mayContainMnemonic));
    }

    @NotNull
    public Supplier<TextWithMnemonic> getTextWithMnemonic(@NotNull Supplier<@Nls(capitalization=Nls.Capitalization.Title) String> text2, boolean mayContainMnemonic) {
        if (text2 == null) {
            Presentation.$$$reportNull$$$0(5);
        }
        if (mayContainMnemonic) {
            Supplier<TextWithMnemonic> supplier = () -> {
                String s = (String)text2.get();
                if (s == null) {
                    return null;
                }
                TextWithMnemonic parsed = TextWithMnemonic.parse((String)s);
                UISettings uiSettings = UISettings.getInstanceOrNull();
                boolean mnemonicsDisabled = uiSettings != null && uiSettings.getDisableMnemonicsInControls();
                return mnemonicsDisabled ? parsed.dropMnemonic(((Boolean)removeMnemonics.getValue()).booleanValue()) : parsed;
            };
            if (supplier == null) {
                Presentation.$$$reportNull$$$0(6);
            }
            return supplier;
        }
        Supplier<TextWithMnemonic> supplier = () -> {
            String s = (String)text2.get();
            return s == null ? null : TextWithMnemonic.fromPlainText((String)s);
        };
        if (supplier == null) {
            Presentation.$$$reportNull$$$0(7);
        }
        return supplier;
    }

    public void setTextWithMnemonic(@NotNull Supplier<TextWithMnemonic> textWithMnemonicSupplier) {
        if (textWithMnemonicSupplier == null) {
            Presentation.$$$reportNull$$$0(8);
        }
        String oldText = this.getText();
        String oldTextWithSuffix = this.getText(true);
        int oldMnemonic = this.getMnemonic();
        int oldIndex = this.getDisplayedMnemonicIndex();
        this.myTextWithMnemonicSupplier = textWithMnemonicSupplier;
        this.fireObjectPropertyChange(PROP_TEXT, oldText, this.getText());
        this.fireObjectPropertyChange(PROP_TEXT_WITH_SUFFIX, oldTextWithSuffix, this.getText(true));
        this.fireObjectPropertyChange(PROP_MNEMONIC_KEY, oldMnemonic, this.getMnemonic());
        this.fireObjectPropertyChange(PROP_MNEMONIC_INDEX, oldIndex, this.getDisplayedMnemonicIndex());
    }

    public void setText(@Nullable @NlsActions.ActionText String text2) {
        this.setText(() -> text2, true);
    }

    public void setText(@NotNull @Nls(capitalization=Nls.Capitalization.Title) Supplier<String> text2) {
        if (text2 == null) {
            Presentation.$$$reportNull$$$0(9);
        }
        this.setText(text2, true);
    }

    @NlsActions.ActionText
    @Nullable
    public String getTextWithMnemonic() {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? null : textWithMnemonic.toString();
    }

    @NotNull
    public Supplier<TextWithMnemonic> getTextWithPossibleMnemonic() {
        Supplier<TextWithMnemonic> supplier = this.myTextWithMnemonicSupplier;
        if (supplier == null) {
            Presentation.$$$reportNull$$$0(10);
        }
        return supplier;
    }

    public void restoreTextWithMnemonic(Presentation presentation) {
        this.setTextWithMnemonic(presentation.getTextWithPossibleMnemonic());
    }

    @NlsActions.ActionDescription
    public String getDescription() {
        return this.myDescriptionSupplier.get();
    }

    public void setDescription(@NotNull Supplier<@NlsActions.ActionDescription String> dynamicDescription) {
        if (dynamicDescription == null) {
            Presentation.$$$reportNull$$$0(11);
        }
        Supplier<String> oldDescription = this.myDescriptionSupplier;
        this.myDescriptionSupplier = dynamicDescription;
        this.fireObjectPropertyChange(PROP_DESCRIPTION, oldDescription.get(), this.myDescriptionSupplier.get());
    }

    public void setDescription(@NlsActions.ActionDescription String description) {
        Supplier<String> oldDescriptionSupplier = this.myDescriptionSupplier;
        this.myDescriptionSupplier = () -> description;
        this.fireObjectPropertyChange(PROP_DESCRIPTION, oldDescriptionSupplier.get(), description);
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    public void setIcon(@Nullable Icon icon2) {
        Icon oldIcon = this.myIcon;
        this.myIcon = icon2;
        this.fireObjectPropertyChange(PROP_ICON, oldIcon, this.myIcon);
    }

    public Icon getDisabledIcon() {
        return this.myDisabledIcon;
    }

    public void setDisabledIcon(@Nullable Icon icon2) {
        Icon oldDisabledIcon = this.myDisabledIcon;
        this.myDisabledIcon = icon2;
        this.fireObjectPropertyChange(PROP_DISABLED_ICON, oldDisabledIcon, this.myDisabledIcon);
    }

    public Icon getHoveredIcon() {
        return this.myHoveredIcon;
    }

    public void setHoveredIcon(@Nullable Icon hoveredIcon) {
        Icon old = this.myHoveredIcon;
        this.myHoveredIcon = hoveredIcon;
        this.fireObjectPropertyChange(PROP_HOVERED_ICON, old, this.myHoveredIcon);
    }

    public Icon getSelectedIcon() {
        return this.mySelectedIcon;
    }

    public void setSelectedIcon(Icon selectedIcon) {
        Icon old = this.mySelectedIcon;
        this.mySelectedIcon = selectedIcon;
        this.fireObjectPropertyChange(PROP_SELECTED_ICON, old, this.mySelectedIcon);
    }

    public int getMnemonic() {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? 0 : textWithMnemonic.getMnemonic();
    }

    public int getDisplayedMnemonicIndex() {
        TextWithMnemonic textWithMnemonic = this.myTextWithMnemonicSupplier.get();
        return textWithMnemonic == null ? -1 : textWithMnemonic.getMnemonicIndex();
    }

    public boolean isVisible() {
        return this.myVisible;
    }

    public void setVisible(boolean visible2) {
        boolean oldVisible = this.myVisible;
        this.myVisible = visible2;
        this.fireBooleanPropertyChange(PROP_VISIBLE, oldVisible, this.myVisible);
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = this.myEnabled;
        this.myEnabled = enabled;
        this.fireBooleanPropertyChange(PROP_ENABLED, oldEnabled, this.myEnabled);
    }

    public void setEnabledAndVisible(boolean enabled) {
        this.setEnabled(enabled);
        this.setVisible(enabled);
    }

    private void fireBooleanPropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        PropertyChangeSupport support = this.myChangeSupport;
        if (oldValue != newValue && support != null) {
            support.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private void fireObjectPropertyChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeSupport support = this.myChangeSupport;
        if (support != null && !Objects.equals(oldValue, newValue)) {
            support.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public Presentation clone() {
        try {
            Presentation clone = (Presentation)super.clone();
            clone.myChangeSupport = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void copyFrom(Presentation presentation) {
        this.copyFrom(presentation, null);
    }

    public void copyFrom(Presentation presentation, @Nullable Component customComponent) {
        if (presentation == this) {
            return;
        }
        this.setTextWithMnemonic(presentation.getTextWithPossibleMnemonic());
        this.setDescription(presentation.myDescriptionSupplier);
        this.setIcon(presentation.getIcon());
        this.setSelectedIcon(presentation.getSelectedIcon());
        this.setDisabledIcon(presentation.getDisabledIcon());
        this.setHoveredIcon(presentation.getHoveredIcon());
        this.setVisible(presentation.isVisible());
        this.setEnabled(presentation.isEnabled());
        this.setWeight(presentation.getWeight());
        if (!this.myUserMap.equals(presentation.myUserMap)) {
            HashSet allKeys = new HashSet(presentation.myUserMap.keySet());
            allKeys.addAll(this.myUserMap.keySet());
            if (!allKeys.isEmpty()) {
                for (String key : allKeys) {
                    if (key.equals(CustomComponentAction.COMPONENT_KEY.toString()) && customComponent != null) {
                        this.putClientProperty(key, customComponent);
                        continue;
                    }
                    this.putClientProperty(key, presentation.getClientProperty(key));
                }
            }
        }
    }

    @Nullable
    public <T> T getClientProperty(@NotNull Key<T> key) {
        if (key == null) {
            Presentation.$$$reportNull$$$0(12);
        }
        return (T)this.myUserMap.get((Object)key.toString());
    }

    public <T> void putClientProperty(@NotNull Key<T> key, @Nullable T value2) {
        if (key == null) {
            Presentation.$$$reportNull$$$0(13);
        }
        this.putClientProperty(key.toString(), value2);
    }

    @Deprecated
    @Nullable
    public Object getClientProperty(@NonNls @NotNull String key) {
        if (key == null) {
            Presentation.$$$reportNull$$$0(14);
        }
        return this.myUserMap.get((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void putClientProperty(@NonNls @NotNull String key, @Nullable Object value2) {
        Object oldValue;
        if (key == null) {
            Presentation.$$$reportNull$$$0(15);
        }
        Presentation presentation = this;
        synchronized (presentation) {
            oldValue = this.myUserMap.get((Object)key);
            if (Comparing.equal((Object)oldValue, (Object)value2)) {
                return;
            }
            if (key.equals(CustomComponentAction.COMPONENT_KEY.toString()) && oldValue != null) {
                LOG.error("Trying to reset custom component in a presentation", new Throwable());
            }
            this.myUserMap = value2 == null ? this.myUserMap.minus((Object)key) : this.myUserMap.plus((Object)key, value2);
        }
        this.fireObjectPropertyChange(key, oldValue, value2);
    }

    public double getWeight() {
        return this.myWeight;
    }

    public void setWeight(double weight) {
        this.myWeight = weight;
    }

    @Nls
    public String toString() {
        return this.getText() + " (" + this.myDescriptionSupplier.get() + ")";
    }

    public boolean isEnabledAndVisible() {
        return this.isEnabled() && this.isVisible();
    }

    public void setMultipleChoice(boolean b) {
        this.myMultipleChoice = b;
    }

    public boolean isMultipleChoice() {
        return this.myMultipleChoice;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROP_TEXT;
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/Presentation";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textWithMnemonicSupplier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/Presentation";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextWithMnemonic";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextWithPossibleMnemonic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 4: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTextWithMnemonic";
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setTextWithMnemonic";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

