/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.application.options.RegistryManager;
import com.intellij.execution.Platform;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.jcef.JBCefAppRequiredArgumentsProvider;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefFileSchemeHandlerFactory;
import com.intellij.ui.jcef.JBCefProxySettings;
import com.intellij.ui.jcef.JBCefSourceSchemeHandlerFactory;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cef.JCefAppConfig;
import com.jetbrains.cef.JCefVersionDetails;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.cef.CefApp;
import org.cef.CefSettings;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.callback.CefSchemeRegistrar;
import org.cef.handler.CefAppHandler;
import org.cef.handler.CefAppHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JBCefApp {
    private static final Logger LOG = Logger.getInstance(JBCefApp.class);
    @NotNull
    public static final NotNullLazyValue<NotificationGroup> NOTIFICATION_GROUP = NotNullLazyValue.createValue(() -> NotificationGroup.create("JCEF", NotificationDisplayType.BALLOON, true, null, null, null, null));
    private static final String MISSING_LIBS_SUPPORT_URL = "https://intellij-support.jetbrains.com/hc/en-us/articles/360016421559";
    private static final int MIN_SUPPORTED_CEF_MAJOR_VERSION = 87;
    @NotNull
    private final CefApp myCefApp;
    @NotNull
    private final Disposable myDisposable;
    private static volatile AtomicBoolean ourSupported;
    private static final Object ourSupportedLock;
    private static final AtomicBoolean ourInitialized;
    private static final List<JBCefCustomSchemeHandlerFactory> ourCustomSchemeHandlerFactoryList;
    private static final JBCefSourceSchemeHandlerFactory ourSourceSchemeHandlerFactory;

    private JBCefApp(@NotNull JCefAppConfig config) throws IllegalStateException {
        Object[] extraArgs;
        String extraArgsProp;
        if (config == null) {
            JBCefApp.$$$reportNull$$$0(0);
        }
        this.myDisposable = new Disposable(){

            public void dispose() {
                JBCefApp.this.myCefApp.dispose();
            }
        };
        boolean started = false;
        try {
            started = CefApp.startup((String[])ArrayUtil.EMPTY_STRING_ARRAY);
        }
        catch (UnsatisfiedLinkError e) {
            LOG.error(e.getMessage());
        }
        if (!started) {
            if (SystemInfoRt.isLinux) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        Process proc = Runtime.getRuntime().exec("ldd " + System.getProperty("java.home") + "/lib/libjcef.so");
                        StringBuilder missingLibs = new StringBuilder();
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream(), StandardCharsets.UTF_8));){
                            String line;
                            String delim = " => ";
                            String prevLib = null;
                            while ((line = reader.readLine()) != null) {
                                String lib;
                                String[] split2;
                                if (!line.contains("not found") || line.contains("libjvm") || (split2 = line.split(delim)).length != 2 || (lib = split2[0]).equals(prevLib)) continue;
                                if (missingLibs.length() > 0) {
                                    missingLibs.append(", ");
                                }
                                missingLibs.append(lib);
                                prevLib = lib;
                            }
                        }
                        if (proc.waitFor() == 0 && missingLibs.length() > 0) {
                            String msg = IdeBundle.message("notification.content.jcef.missingLibs", missingLibs);
                            Notification notification = ((NotificationGroup)NOTIFICATION_GROUP.getValue()).createNotification(IdeBundle.message("notification.title.jcef.startFailure", new Object[0]), msg, NotificationType.ERROR);
                            notification.addAction(new AnAction(IdeBundle.message("action.jcef.followInstructions", new Object[0])){

                                @Override
                                public void actionPerformed(@NotNull AnActionEvent e) {
                                    if (e == null) {
                                        2.$$$reportNull$$$0(0);
                                    }
                                    BrowserUtil.open(JBCefApp.MISSING_LIBS_SUPPORT_URL);
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ui/jcef/JBCefApp$2", "actionPerformed"));
                                }
                            });
                            notification.notify(null);
                        }
                    }
                    catch (Throwable t) {
                        LOG.error("failed to identify JCEF missing libs", t);
                    }
                });
            }
            throw new IllegalStateException("CefApp failed to start");
        }
        CefSettings settings = config.getCefSettings();
        settings.windowless_rendering_enabled = JBCefApp.isOffScreenRenderingModeEnabled();
        settings.log_severity = JBCefApp.getLogLevel();
        settings.log_file = System.getProperty("ide.browser.jcef.log.path", System.getProperty("user.home") + Platform.current().fileSeparator + "jcef_" + ProcessHandle.current().pid() + ".log");
        int port = Registry.intValue((String)"ide.browser.jcef.debug.port");
        if (ApplicationManager.getApplication().isInternal() && port > 0) {
            settings.remote_debugging_port = port;
        }
        String[] argsFromProviders = (String[])JBCefAppRequiredArgumentsProvider.getProviders().stream().flatMap(p -> {
            LOG.debug("got options: [" + p.getOptions() + "] from:" + p.getClass().getName());
            return p.getOptions().stream();
        }).distinct().toArray(String[]::new);
        String[] args = ArrayUtil.mergeArrays((String[])config.getAppArgs(), (String[])argsFromProviders);
        JBCefProxySettings proxySettings = JBCefProxySettings.getInstance();
        String[] proxyArgs = null;
        if (proxySettings.USE_PROXY_PAC) {
            proxyArgs = proxySettings.USE_PAC_URL ? new String[]{"--proxy-pac-url=" + proxySettings.PAC_URL + ":" + proxySettings.PROXY_PORT} : new String[]{"--proxy-auto-detect"};
        } else if (proxySettings.USE_HTTP_PROXY) {
            proxyArgs = new String[]{"--proxy-server=" + proxySettings.PROXY_HOST + ":" + proxySettings.PROXY_PORT};
        }
        if (proxyArgs != null) {
            args = ArrayUtil.mergeArrays((String[])args, proxyArgs);
        }
        if (Registry.is((String)"ide.browser.jcef.gpu.disable")) {
            args = ArrayUtil.mergeArrays((String[])args, (String[])new String[]{"--disable-gpu", "--disable-gpu-compositing"});
        }
        if (!(extraArgsProp = System.getProperty("ide.browser.jcef.extra.args", "")).isEmpty() && (extraArgs = extraArgsProp.split(" ")) != null && extraArgs.length > 0) {
            LOG.debug("add extra CEF args: [" + Arrays.toString(extraArgs) + "]");
            args = ArrayUtil.mergeArrays((String[])args, (String[])extraArgs);
        }
        CefApp.addAppHandler((CefAppHandler)new MyCefAppHandler(args));
        this.myCefApp = CefApp.getInstance((CefSettings)settings);
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)this.myDisposable);
    }

    private static CefSettings.LogSeverity getLogLevel() {
        String level;
        switch (level = System.getProperty("ide.browser.jcef.log.level", "disable").toLowerCase(Locale.ENGLISH)) {
            case "disable": {
                return CefSettings.LogSeverity.LOGSEVERITY_DISABLE;
            }
            case "verbose": {
                return CefSettings.LogSeverity.LOGSEVERITY_VERBOSE;
            }
            case "info": {
                return CefSettings.LogSeverity.LOGSEVERITY_INFO;
            }
            case "warning": {
                return CefSettings.LogSeverity.LOGSEVERITY_WARNING;
            }
            case "error": {
                return CefSettings.LogSeverity.LOGSEVERITY_ERROR;
            }
            case "fatal": {
                return CefSettings.LogSeverity.LOGSEVERITY_FATAL;
            }
        }
        return CefSettings.LogSeverity.LOGSEVERITY_DEFAULT;
    }

    @NotNull
    Disposable getDisposable() {
        Disposable disposable = this.myDisposable;
        if (disposable == null) {
            JBCefApp.$$$reportNull$$$0(1);
        }
        return disposable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static JBCefApp getInstance() {
        if (Holder.INSTANCE == null) {
            Class<Holder> clazz = Holder.class;
            // MONITORENTER : com.intellij.ui.jcef.JBCefApp$Holder.class
            if (Holder.INSTANCE == null) {
                if (!RegistryManager.getInstance().is("ide.browser.jcef.testMode.enabled")) throw new IllegalStateException("JCEF is not supported in this env or failed to initialize");
                Holder.INSTANCE = Holder.init();
                if (Holder.INSTANCE == null) throw new IllegalStateException("JCEF is not supported in this env or failed to initialize");
                JBCefApp jBCefApp = Objects.requireNonNull(Holder.INSTANCE);
                // MONITOREXIT : clazz
                if (jBCefApp != null) return jBCefApp;
                JBCefApp.$$$reportNull$$$0(2);
                return jBCefApp;
            }
            // MONITOREXIT : clazz
        }
        JBCefApp jBCefApp = Objects.requireNonNull(Holder.INSTANCE);
        if (jBCefApp != null) return jBCefApp;
        JBCefApp.$$$reportNull$$$0(3);
        return jBCefApp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isSupported() {
        boolean testModeEnabled = RegistryManager.getInstance().is("ide.browser.jcef.testMode.enabled");
        if (ourSupported != null && !testModeEnabled) {
            return ourSupported.get();
        }
        Object object = ourSupportedLock;
        synchronized (object) {
            boolean isJbrModule;
            JCefVersionDetails version;
            if (testModeEnabled) {
                ourSupported = null;
            } else if (ourSupported != null) {
                return ourSupported.get();
            }
            Function<String, Boolean> unsupported = msg -> {
                ourSupported = new AtomicBoolean(false);
                LOG.warn(msg + (!msg.contains("disabled") ? " (Use JBR bundled with the IDE)" : ""));
                return false;
            };
            if (!RegistryManager.getInstance().is("ide.browser.jcef.enabled")) {
                return unsupported.apply("JCEF is manually disabled via 'ide.browser.jcef.enabled=false'");
            }
            if (ApplicationManager.getApplication().isHeadlessEnvironment() && !RegistryManager.getInstance().is("ide.browser.jcef.headless.enabled")) {
                return unsupported.apply("JCEF is manually disabled in headless env via 'ide.browser.jcef.headless.enabled=false'");
            }
            try {
                version = JCefAppConfig.getVersionDetails();
            }
            catch (Throwable e) {
                return unsupported.apply("JCEF runtime version is not supported");
            }
            if (87 > version.cefVersion.major) {
                return unsupported.apply("JCEF minimum supported major version is 87, current is " + version.cefVersion.major);
            }
            URL url = JCefAppConfig.class.getResource("JCefAppConfig.class");
            if (url == null) {
                return unsupported.apply("JCefAppConfig.class not found");
            }
            String path2 = url.toString();
            String name = JCefAppConfig.class.getName().replace('.', '/');
            boolean bl = isJbrModule = path2 != null && path2.contains("/jcef/" + name);
            if (!isJbrModule) {
                return unsupported.apply("JCEF runtime library is not a JBR module");
            }
            ourSupported = new AtomicBoolean(true);
            return true;
        }
    }

    public static boolean isStarted() {
        boolean initialised = ourInitialized.get();
        if (!initialised) {
            return false;
        }
        return JBCefApp.getInstance() != null;
    }

    @NotNull
    public JBCefClient createClient() {
        JBCefClient jBCefClient = this.createClient(false);
        if (jBCefClient == null) {
            JBCefApp.$$$reportNull$$$0(4);
        }
        return jBCefClient;
    }

    @NotNull
    JBCefClient createClient(boolean isDefault) {
        return new JBCefClient(this.myCefApp.createClient(), isDefault);
    }

    public static boolean isOffScreenRenderingModeEnabled() {
        return RegistryManager.getInstance().is("ide.browser.jcef.osr.enabled");
    }

    static void checkOffScreenRenderingModeEnabled() {
        if (!JBCefApp.isOffScreenRenderingModeEnabled()) {
            throw new IllegalStateException("off-screen rendering mode is disabled: 'ide.browser.jcef.osr.enabled=false'");
        }
    }

    static void addCefCustomSchemeHandlerFactory(@NotNull JBCefCustomSchemeHandlerFactory factory) {
        if (factory == null) {
            JBCefApp.$$$reportNull$$$0(5);
        }
        if (ourInitialized.get()) {
            throw new IllegalStateException("JBCefApp has already been initialized!");
        }
        ourCustomSchemeHandlerFactoryList.add(factory);
    }

    static {
        ourSupportedLock = new Object();
        ourInitialized = new AtomicBoolean(false);
        ourCustomSchemeHandlerFactoryList = Collections.synchronizedList(new ArrayList());
        ourSourceSchemeHandlerFactory = new JBCefSourceSchemeHandlerFactory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefApp";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefApp";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createClient";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addCefCustomSchemeHandlerFactory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCefAppHandler
    extends CefAppHandlerAdapter {
        MyCefAppHandler(String @Nullable [] args) {
            super(args);
        }

        public boolean onBeforeTerminate() {
            return true;
        }

        public void onRegisterCustomSchemes(CefSchemeRegistrar registrar) {
            for (JBCefCustomSchemeHandlerFactory f : ourCustomSchemeHandlerFactoryList) {
                f.registerCustomScheme(registrar);
            }
            ourSourceSchemeHandlerFactory.registerCustomScheme(registrar);
        }

        public void onContextInitialized() {
            for (JBCefCustomSchemeHandlerFactory f : ourCustomSchemeHandlerFactoryList) {
                JBCefApp.getInstance().myCefApp.registerSchemeHandlerFactory(f.getSchemeName(), f.getDomainName(), (CefSchemeHandlerFactory)f);
            }
            ourCustomSchemeHandlerFactoryList.clear();
            JBCefApp.getInstance().myCefApp.registerSchemeHandlerFactory(ourSourceSchemeHandlerFactory.getSchemeName(), ourSourceSchemeHandlerFactory.getDomainName(), (CefSchemeHandlerFactory)ourSourceSchemeHandlerFactory);
            JBCefApp.getInstance().myCefApp.registerSchemeHandlerFactory("file", "", (CefSchemeHandlerFactory)new JBCefFileSchemeHandlerFactory());
        }
    }

    public static interface JBCefCustomSchemeHandlerFactory
    extends CefSchemeHandlerFactory {
        public void registerCustomScheme(@NotNull CefSchemeRegistrar var1);

        @NotNull
        public String getSchemeName();

        @NotNull
        public String getDomainName();
    }

    private static final class Holder {
        @Nullable
        static volatile JBCefApp INSTANCE = Holder.init();

        private Holder() {
        }

        @Nullable
        static JBCefApp init() {
            ourInitialized.set(true);
            JCefAppConfig config = null;
            if (JBCefApp.isSupported()) {
                try {
                    config = JCefAppConfig.getInstance();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
            JBCefApp app = null;
            if (config != null) {
                try {
                    app = new JBCefApp(config);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            return app;
        }
    }
}

