/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.LightEditActionFactory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefBrowserBuilder;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.ui.jcef.JBCefEventUtils;
import com.intellij.ui.jcef.PropertiesHelper;
import com.intellij.util.Consumer;
import com.jetbrains.cef.JCefAppConfig;
import com.jetbrains.cef.JCefVersionDetails;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefFocusHandler;
import org.cef.handler.CefFocusHandlerAdapter;
import org.cef.handler.CefKeyboardHandler;
import org.cef.handler.CefKeyboardHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBCefBrowser
extends JBCefBrowserBase {
    @NotNull
    private static final List<java.util.function.Consumer<? super JBCefBrowser>> ourOnBrowserMoveResizeCallbacks = Collections.synchronizedList(new ArrayList(1));
    @NotNull
    static final Dimension DEF_PREF_SIZE = new Dimension(800, 600);
    @NotNull
    private final JPanel myComponent;
    @NotNull
    private final CefFocusHandler myCefFocusHandler;
    @NotNull
    private final CefKeyboardHandler myKeyboardHandler;
    private volatile boolean myFirstShow;

    @NotNull
    public static JBCefBrowserBuilder createBuilder() {
        return new JBCefBrowserBuilder();
    }

    @NotNull
    public static JBCefBrowser create(@NotNull JBCefBrowserBuilder builder) {
        if (builder == null) {
            JBCefBrowser.$$$reportNull$$$0(0);
        }
        return new JBCefBrowser(builder);
    }

    public JBCefBrowser() {
        this(JBCefBrowser.createBuilder());
    }

    public JBCefBrowser(@NotNull String url) {
        if (url == null) {
            JBCefBrowser.$$$reportNull$$$0(1);
        }
        this(JBCefBrowser.createBuilder().setUrl(url));
    }

    public JBCefBrowser(@NotNull JBCefClient client, @Nullable String url) {
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(2);
        }
        this(JBCefBrowser.createBuilder().setClient(client).setUrl(url));
    }

    public JBCefBrowser(@NotNull CefBrowser cefBrowser, @NotNull JBCefClient client) {
        if (cefBrowser == null) {
            JBCefBrowser.$$$reportNull$$$0(3);
        }
        if (client == null) {
            JBCefBrowser.$$$reportNull$$$0(4);
        }
        this(JBCefBrowser.createBuilder().setCefBrowser(cefBrowser).setClient(client));
    }

    protected JBCefBrowser(@NotNull JBCefBrowserBuilder builder) {
        if (builder == null) {
            JBCefBrowser.$$$reportNull$$$0(5);
        }
        super(builder);
        this.myFirstShow = true;
        if (this.myCefClient.isDisposed()) {
            throw new IllegalArgumentException("JBCefClient is disposed");
        }
        this.myComponent = this.createComponent();
        this.myCefFocusHandler = new CefFocusHandlerAdapter(){

            public void onTakeFocus(CefBrowser browser, boolean next) {
                super.onTakeFocus(browser, next);
                JBCefBrowserBase.focusedBrowser = null;
            }

            public void onGotFocus(CefBrowser browser) {
                super.onGotFocus(browser);
                JBCefBrowserBase.focusedBrowser = JBCefBrowser.this;
            }

            public boolean onSetFocus(CefBrowser browser, CefFocusHandler.FocusSource source) {
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                boolean componentFocused = focusOwner == JBCefBrowser.this.getComponent() || focusOwner == JBCefBrowser.this.getCefBrowser().getUIComponent();
                boolean focusOnNavigation = JBCefBrowser.this.myFirstShow && JBCefBrowser.this.isProperty("JBCefBrowser.focusOnShow") || JBCefBrowser.this.isProperty("JBCefBrowser.focusOnNavigation") || componentFocused;
                JBCefBrowser.this.myFirstShow = false;
                if (source == CefFocusHandler.FocusSource.FOCUS_SOURCE_NAVIGATION && !focusOnNavigation) {
                    if (SystemInfo.isWindows) {
                        JBCefBrowser.this.myCefBrowser.setFocus(false);
                    }
                    return true;
                }
                if (!browser.getUIComponent().hasFocus()) {
                    if (SystemInfo.isLinux) {
                        if (JBCefBrowser.this.isOffScreenRendering()) {
                            browser.getUIComponent().requestFocusInWindow();
                        } else {
                            browser.getUIComponent().requestFocus();
                        }
                    } else {
                        browser.getUIComponent().requestFocusInWindow();
                    }
                }
                return false;
            }
        };
        this.myCefClient.addFocusHandler(this.myCefFocusHandler, this.myCefBrowser);
        this.myKeyboardHandler = new CefKeyboardHandlerAdapter(){

            public boolean onKeyEvent(CefBrowser browser, CefKeyboardHandler.CefKeyEvent cefKeyEvent) {
                boolean consume;
                if (JBCefBrowser.this.isOffScreenRendering()) {
                    return false;
                }
                Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                boolean bl = consume = focusOwner != browser.getUIComponent();
                if (consume && SystemInfo.isMac && JBCefEventUtils.isUpDownKeyEvent(cefKeyEvent)) {
                    return true;
                }
                Window focusedWindow = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
                if (focusedWindow == null) {
                    return true;
                }
                KeyEvent javaKeyEvent = JBCefEventUtils.convertCefKeyEvent(cefKeyEvent, focusedWindow);
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(javaKeyEvent);
                return consume;
            }
        };
        this.myCefClient.addKeyboardHandler(this.myKeyboardHandler, this.myCefBrowser);
    }

    @NotNull
    private JPanel createComponent() {
        final Component uiComp = this.getCefBrowser().getUIComponent();
        JPanel resultPanel = new JPanel(new BorderLayout()){
            {
                super(arg0);
                this.enableEvents(131072L);
            }

            @Override
            public void setBackground(Color bg) {
                uiComp.setBackground(bg);
                super.setBackground(bg);
            }

            @Override
            public void removeNotify() {
                if (SystemInfo.isWindows && JBCefBrowser.this.myCefBrowser.getUIComponent().hasFocus()) {
                    JBCefBrowser.this.myCefBrowser.setFocus(false);
                }
                JBCefBrowser.this.myFirstShow = true;
                super.removeNotify();
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                return size.width > 0 && size.height > 0 ? size : DEF_PREF_SIZE;
            }

            @Override
            protected void processFocusEvent(FocusEvent e) {
                super.processFocusEvent(e);
                if (e.getID() == 1004) {
                    uiComp.requestFocusInWindow();
                }
            }
        };
        resultPanel.setBackground(JBColor.background());
        resultPanel.putClientProperty("JBCefBrowser.instance", this);
        if (SystemInfo.isMac) {
            ShortcutProvider.registerShortcuts(resultPanel, this);
        }
        resultPanel.add(uiComp, "Center");
        if (SystemInfo.isWindows) {
            this.myCefBrowser.getUIComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (JBCefBrowser.this.myCefBrowser.getUIComponent().isFocusable()) {
                        JBCefBrowser.this.getCefBrowser().setFocus(true);
                    }
                }
            });
        }
        resultPanel.setFocusCycleRoot(true);
        resultPanel.setFocusTraversalPolicyProvider(true);
        resultPanel.setFocusTraversalPolicy(new MyFTP());
        resultPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ourOnBrowserMoveResizeCallbacks.forEach(callback -> callback.accept(JBCefBrowser.this));
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                ourOnBrowserMoveResizeCallbacks.forEach(callback -> callback.accept(JBCefBrowser.this));
            }

            @Override
            public void componentShown(ComponentEvent e) {
                ourOnBrowserMoveResizeCallbacks.forEach(callback -> callback.accept(JBCefBrowser.this));
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                ourOnBrowserMoveResizeCallbacks.forEach(callback -> callback.accept(JBCefBrowser.this));
            }
        });
        JPanel jPanel = resultPanel;
        if (jPanel == null) {
            JBCefBrowser.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    public static void addOnBrowserMoveResizeCallback(@NotNull java.util.function.Consumer<? super JBCefBrowser> callback) {
        if (callback == null) {
            JBCefBrowser.$$$reportNull$$$0(7);
        }
        ourOnBrowserMoveResizeCallbacks.add(callback);
    }

    public static void removeOnBrowserMoveResizeCallback(@NotNull java.util.function.Consumer<? super JBCefBrowser> callback) {
        if (callback == null) {
            JBCefBrowser.$$$reportNull$$$0(8);
        }
        ourOnBrowserMoveResizeCallbacks.remove(callback);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myComponent;
        if (jPanel == null) {
            JBCefBrowser.$$$reportNull$$$0(9);
        }
        return jPanel;
    }

    @Override
    public void setProperty(@NotNull String name, @Nullable Object value2) {
        if (name == null) {
            JBCefBrowser.$$$reportNull$$$0(10);
        }
        super.setProperty(name, value2);
    }

    @Override
    public void dispose() {
        super.dispose(() -> {
            this.myCefClient.removeFocusHandler(this.myCefFocusHandler, this.myCefBrowser);
            this.myCefClient.removeKeyboardHandler(this.myKeyboardHandler, this.myCefBrowser);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cefBrowser";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/jcef/JBCefBrowser";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/jcef/JBCefBrowser";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addOnBrowserMoveResizeCallback";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeOnBrowserMoveResizeCallback";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyFTP
    extends FocusTraversalPolicy {
        private MyFTP() {
        }

        @Override
        public Component getComponentAfter(Container aContainer, Component aComponent) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }

        @Override
        public Component getComponentBefore(Container aContainer, Component aComponent) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }

        @Override
        public Component getFirstComponent(Container aContainer) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }

        @Override
        public Component getLastComponent(Container aContainer) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }

        @Override
        public Component getDefaultComponent(Container aContainer) {
            return JBCefBrowser.this.myCefBrowser.getUIComponent();
        }
    }

    protected class DefaultCefContextMenuHandler
    extends JBCefBrowserBase.DefaultCefContextMenuHandler {
        public DefaultCefContextMenuHandler(boolean isInternal) {
            super(isInternal);
        }
    }

    private static final class ShortcutProvider {
        private static final List<Pair<String, AnAction>> ourActions = ShortcutProvider.isSupportedByJCefApi() ? List.of(ShortcutProvider.createAction("$Cut", CefFrame::cut), ShortcutProvider.createAction("$Copy", CefFrame::copy), ShortcutProvider.createAction("$Paste", CefFrame::paste), ShortcutProvider.createAction("$Delete", CefFrame::delete), ShortcutProvider.createAction("$SelectAll", CefFrame::selectAll), ShortcutProvider.createAction("$Undo", CefFrame::undo), ShortcutProvider.createAction("$Redo", CefFrame::redo)) : List.of();

        private ShortcutProvider() {
        }

        private static boolean isSupportedByJCefApi() {
            try {
                JCefAppConfig.getVersionDetails();
                return true;
            }
            catch (JCefVersionDetails.VersionUnavailableException | NoSuchMethodError e) {
                Logger.getInstance(ShortcutProvider.class).warn("JCEF shortcuts are unavailable (incompatible API)", e);
                return false;
            }
        }

        private static Pair<String, AnAction> createAction(String shortcut, java.util.function.Consumer<? super CefFrame> action2) {
            return Pair.create((Object)shortcut, (Object)LightEditActionFactory.create((Consumer<? super AnActionEvent>)((Consumer)event -> {
                Component component = event.getData(PlatformDataKeys.CONTEXT_COMPONENT);
                if (component == null) {
                    return;
                }
                Container parentComponent = component.getParent();
                if (!(parentComponent instanceof JComponent)) {
                    return;
                }
                Object browser = ((JComponent)parentComponent).getClientProperty("JBCefBrowser.instance");
                if (!(browser instanceof JBCefBrowser)) {
                    return;
                }
                action2.accept(((JBCefBrowser)browser).getCefBrowser().getFocusedFrame());
            })));
        }

        private static void registerShortcuts(JComponent uiComp, JBCefBrowser jbCefBrowser) {
            ActionManager actionManager = ActionManager.getInstance();
            for (Pair<String, AnAction> action2 : ourActions) {
                ((AnAction)action2.second).registerCustomShortcutSet(actionManager.getAction((String)action2.first).getShortcutSet(), uiComp, jbCefBrowser);
            }
        }
    }

    public static class Properties
    extends JBCefBrowserBase.Properties {
        @NotNull
        public static final String FOCUS_ON_NAVIGATION = "JBCefBrowser.focusOnNavigation";
        @NotNull
        public static final String FOCUS_ON_SHOW = "JBCefBrowser.focusOnShow";

        static {
            PropertiesHelper.setType(FOCUS_ON_NAVIGATION, Boolean.class);
            PropertiesHelper.setType(FOCUS_ON_SHOW, Boolean.class);
        }
    }
}

