/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.table;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsUtil;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.TabLayout;
import com.intellij.ui.tabs.impl.table.TablePassInfo;
import com.intellij.ui.tabs.impl.table.TableRow;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableLayout
extends TabLayout
implements MorePopupAware {
    private int myScrollOffset = 0;
    private boolean myScrollSelectionInViewPending = false;
    final JBTabsImpl myTabs;
    public TablePassInfo myLastTableLayout;

    public TableLayout(JBTabsImpl tabs) {
        this.myTabs = tabs;
    }

    private TablePassInfo computeLayoutTable(List<TabInfo> visibleInfos) {
        int width;
        boolean pinned;
        TabLabel eachLabel;
        TablePassInfo data = new TablePassInfo(this, visibleInfos);
        if (this.myTabs.isHideTabs()) {
            return data;
        }
        boolean singleRow = this.myTabs.isSingleRow();
        boolean showPinnedTabsSeparately = UISettings.getInstance().getState().getShowPinnedTabsInASeparateRow();
        boolean scrollable = UISettings.getInstance().getHideTabsIfNeeded() && singleRow;
        int titleWidth = this.myTabs.myTitleWrapper.getPreferredSize().width;
        data.titleRect.setBounds(data.toFitRec.x, data.toFitRec.y, titleWidth, this.myTabs.myHeaderFitSize.height);
        data.moreRect.setBounds(data.toFitRec.x + data.toFitRec.width, data.toFitRec.y, 0, this.myTabs.myHeaderFitSize.height);
        this.calculateLengths(data);
        int eachX = data.titleRect.x + data.titleRect.width;
        Insets insets = this.myTabs.getLayoutInsets();
        int eachY = insets.top;
        TableRow eachTableRow = new TableRow(data);
        data.table.add(eachTableRow);
        int requiredRowsPinned = 0;
        int requiredRowsUnpinned = 0;
        int maxX = data.moreRect.x - 1;
        int hGap = this.myTabs.getTabHGap();
        for (TabInfo eachInfo : data.myVisibleInfos) {
            eachLabel = this.myTabs.getTabLabel(eachInfo);
            pinned = eachLabel.isPinned();
            width = data.lengths.get(eachInfo);
            if (!pinned || !showPinnedTabsSeparately) {
                data.requiredLength += width;
            }
            if (pinned && showPinnedTabsSeparately) {
                if (requiredRowsPinned == 0) {
                    requiredRowsPinned = 1;
                }
                this.myTabs.layout(eachLabel, eachX, eachY, width, this.myTabs.myHeaderFitSize.height);
                data.bounds.put(eachInfo, eachLabel.getBounds());
            } else {
                if (!scrollable && eachX + width + hGap > maxX && !singleRow || showPinnedTabsSeparately && eachLabel.isNextToLastPinned()) {
                    ++requiredRowsUnpinned;
                    eachY += this.myTabs.myHeaderFitSize.height;
                    eachX = data.toFitRec.x;
                } else if (requiredRowsUnpinned == 0) {
                    requiredRowsUnpinned = 1;
                }
                if (scrollable && eachX - this.getScrollOffset() + width + hGap > maxX) {
                    width = Math.max(0, maxX - eachX + this.getScrollOffset());
                    data.invisible.add(eachInfo);
                }
                this.myTabs.layout(eachLabel, eachX - this.getScrollOffset(), eachY, width == 1 ? 0 : width, this.myTabs.myHeaderFitSize.height);
                Rectangle rectangle = new Rectangle(this.myTabs.myHeaderFitSize);
                data.bounds.put(eachInfo, eachLabel.getBounds());
                int intersection = eachLabel.getBounds().intersection((Rectangle)rectangle).width;
                if (scrollable && intersection < eachLabel.getBounds().width) {
                    data.invisible.add(eachInfo);
                }
            }
            eachX += width + hGap;
        }
        if (requiredRowsPinned > 0 && requiredRowsUnpinned > 0) {
            data.moreRect.y += this.myTabs.myHeaderFitSize.height;
        }
        if (data.invisible.isEmpty()) {
            data.moreRect.setBounds(0, 0, 0, 0);
        }
        eachX = data.toFitRec.x + titleWidth;
        for (TabInfo eachInfo : data.myVisibleInfos) {
            boolean useSameRow;
            eachLabel = this.myTabs.getTabLabel(eachInfo);
            pinned = eachLabel.isPinned();
            width = data.lengths.get(eachInfo);
            if (pinned && showPinnedTabsSeparately) {
                eachTableRow.add(eachInfo, width);
                eachX += width;
                continue;
            }
            boolean bl = useSameRow = singleRow || eachX + width + hGap <= maxX;
            if (showPinnedTabsSeparately && eachLabel.isNextToLastPinned()) {
                useSameRow = false;
            }
            if (useSameRow) {
                eachTableRow.add(eachInfo, width);
                eachX += width;
                continue;
            }
            eachTableRow = new TableRow(data);
            data.table.add(eachTableRow);
            eachX = data.toFitRec.x + titleWidth + width;
            eachTableRow.add(eachInfo, width);
        }
        if (this.myScrollSelectionInViewPending) {
            this.myScrollSelectionInViewPending = false;
            this.doScrollSelectionInView(data);
        }
        this.clampScrollOffsetToBounds(data);
        return data;
    }

    private void calculateLengths(TablePassInfo data) {
        boolean compressible = this.isCompressible();
        boolean showPinnedTabsSeparately = UISettings.getInstance().getState().getShowPinnedTabsInASeparateRow();
        int standardLengthToFit = data.moreRect.x - (data.titleRect.x + data.titleRect.width);
        if (compressible || showPinnedTabsSeparately) {
            if (showPinnedTabsSeparately) {
                List pinned = ContainerUtil.filter((Collection)data.myVisibleInfos, info -> info.isPinned());
                this.calculateCompressibleLengths(pinned, data, standardLengthToFit + data.moreRect.width);
                List unpinned = ContainerUtil.filter((Collection)data.myVisibleInfos, info -> !info.isPinned());
                if (compressible) {
                    this.calculateCompressibleLengths(unpinned, data, pinned.isEmpty() ? standardLengthToFit + data.moreRect.width : standardLengthToFit + data.titleRect.width + data.moreRect.width);
                } else {
                    this.calculateRawLengths(unpinned, data);
                    if (TableLayout.getTotalLength(unpinned, data) > standardLengthToFit) {
                        int moreWidth = this.myTabs.isSingleRow() ? this.myTabs.myMoreToolbar.getComponent().getPreferredSize().width : 0;
                        data.moreRect.setBounds(data.toFitRec.x + data.toFitRec.width - moreWidth, this.myTabs.getLayoutInsets().top, moreWidth, this.myTabs.myHeaderFitSize.height);
                        this.calculateRawLengths(unpinned, data);
                    }
                }
            } else {
                this.calculateCompressibleLengths(data.myVisibleInfos, data, standardLengthToFit);
            }
        } else {
            this.calculateRawLengths(data.myVisibleInfos, data);
            if (TableLayout.getTotalLength(data.myVisibleInfos, data) > standardLengthToFit) {
                int moreWidth = this.myTabs.isSingleRow() ? this.myTabs.myMoreToolbar.getComponent().getPreferredSize().width : 0;
                data.moreRect.setBounds(data.toFitRec.x + data.toFitRec.width - moreWidth, data.toFitRec.y, moreWidth, this.myTabs.myHeaderFitSize.height);
                this.calculateRawLengths(data.myVisibleInfos, data);
            }
        }
    }

    private static int getTotalLength(@NotNull List<TabInfo> list, @NotNull TablePassInfo data) {
        if (list == null) {
            TableLayout.$$$reportNull$$$0(0);
        }
        if (data == null) {
            TableLayout.$$$reportNull$$$0(1);
        }
        int total = 0;
        for (TabInfo info : list) {
            total += data.lengths.get(info).intValue();
        }
        return total;
    }

    private boolean isCompressible() {
        return this.myTabs.isSingleRow() && !UISettings.getInstance().getHideTabsIfNeeded() && this.myTabs.supportsCompression();
    }

    private void calculateCompressibleLengths(List<TabInfo> list, TablePassInfo data, int toFitLength) {
        if (list.isEmpty()) {
            return;
        }
        int spentLength = 0;
        int lengthEstimation = 0;
        for (TabInfo tabInfo : list) {
            lengthEstimation += Math.max(TableLayout.getMinTabWidth(), this.myTabs.myInfo2Label.get((Object)tabInfo).getPreferredSize().width);
        }
        int extraWidth = toFitLength - lengthEstimation;
        Iterator<TabInfo> iterator = list.iterator();
        while (iterator.hasNext()) {
            TabInfo tabInfo = iterator.next();
            TabLabel label = this.myTabs.myInfo2Label.get(tabInfo);
            int lengthIncrement = label.getPreferredSize().width;
            int length = !iterator.hasNext() ? Math.min(toFitLength - spentLength, lengthIncrement) : (extraWidth <= 0 ? (int)((float)lengthIncrement * (float)toFitLength / (float)lengthEstimation) : lengthIncrement);
            if (tabInfo.isPinned()) {
                length = Math.min(TableLayout.getMaxPinnedTabWidth(), length);
            }
            length = Math.max(TableLayout.getMinTabWidth(), length);
            data.lengths.put(tabInfo, length);
            spentLength += length + this.myTabs.getTabHGap();
        }
    }

    private void calculateRawLengths(List<TabInfo> list, TablePassInfo data) {
        boolean showPinnedTabsSeparately = UISettings.getInstance().getState().getShowPinnedTabsInASeparateRow();
        for (TabInfo info : list) {
            TabLabel eachLabel = this.myTabs.getTabLabel(info);
            Dimension size = eachLabel.isPinned() && showPinnedTabsSeparately ? eachLabel.getNotStrictPreferredSize() : eachLabel.getPreferredSize();
            data.lengths.put(info, Math.max(TableLayout.getMinTabWidth(), size.width + this.myTabs.getTabHGap()));
        }
    }

    public LayoutPassInfo layoutTable(List<TabInfo> visibleInfos, JComponent title, JComponent moreToolbar) {
        this.myTabs.resetLayout(true);
        Rectangle unitedTabArea = null;
        TablePassInfo data = this.computeLayoutTable(visibleInfos);
        Rectangle rect = new Rectangle(data.moreRect);
        rect.y += this.myTabs.getBorderThickness();
        moreToolbar.setBounds(rect);
        title.setBounds(data.titleRect);
        Insets insets = this.myTabs.getLayoutInsets();
        int eachY = insets.top;
        for (TabInfo info : visibleInfos) {
            Rectangle bounds = data.bounds.get(info);
            if (unitedTabArea == null) {
                unitedTabArea = bounds;
                continue;
            }
            unitedTabArea = unitedTabArea.union(bounds);
        }
        if (this.myTabs.getSelectedInfo() != null) {
            JBTabsImpl.Toolbar selectedToolbar = this.myTabs.myInfo2Toolbar.get(this.myTabs.getSelectedInfo());
            int componentY = (unitedTabArea != null ? unitedTabArea.y + unitedTabArea.height : eachY) + (this.myTabs.isEditorTabs() ? 0 : 2) - this.myTabs.getLayoutInsets().top;
            if (!this.myTabs.myHorizontalSide && selectedToolbar != null && !selectedToolbar.isEmpty()) {
                int vSeparatorWidth;
                int toolbarWidth = selectedToolbar.getPreferredSize().width;
                int n = vSeparatorWidth = toolbarWidth > 0 ? this.myTabs.getSeparatorWidth() : 0;
                if (this.myTabs.isSideComponentBefore()) {
                    Rectangle compRect = this.myTabs.layoutComp(toolbarWidth + vSeparatorWidth, componentY, this.myTabs.getSelectedInfo().getComponent(), 0, 0);
                    this.myTabs.layout(selectedToolbar, compRect.x - toolbarWidth - vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
                } else {
                    int width = this.myTabs.getWidth() - toolbarWidth - vSeparatorWidth;
                    Rectangle compRect = this.myTabs.layoutComp(new Rectangle(0, componentY, width, this.myTabs.getHeight()), this.myTabs.getSelectedInfo().getComponent(), 0, 0);
                    this.myTabs.layout(selectedToolbar, compRect.x + compRect.width + vSeparatorWidth, compRect.y, toolbarWidth, compRect.height);
                }
            } else {
                this.myTabs.layoutComp(0, componentY, this.myTabs.getSelectedInfo().getComponent(), 0, 0);
            }
        }
        if (unitedTabArea != null) {
            data.tabRectangle.setBounds(unitedTabArea);
        }
        this.myLastTableLayout = data;
        return data;
    }

    @Override
    public boolean isDragOut(@NotNull TabLabel tabLabel, int deltaX, int deltaY) {
        if (tabLabel == null) {
            TableLayout.$$$reportNull$$$0(2);
        }
        if (this.myLastTableLayout == null) {
            return super.isDragOut(tabLabel, deltaX, deltaY);
        }
        Rectangle area = new Rectangle(this.myLastTableLayout.toFitRec.width, tabLabel.getBounds().height);
        for (int i = 0; i < this.myLastTableLayout.myVisibleInfos.size(); ++i) {
            area = area.union(this.myTabs.myInfo2Label.get(this.myLastTableLayout.myVisibleInfos.get(i)).getBounds());
        }
        return (double)Math.abs(deltaY) > (double)area.height * TableLayout.getDragOutMultiplier();
    }

    @Override
    public int getDropIndexFor(Point point) {
        int i;
        if (this.myLastTableLayout == null) {
            return -1;
        }
        int result = -1;
        Component c = this.myTabs.getComponentAt(point);
        HashSet<TabInfo> lastInRow = new HashSet<TabInfo>();
        for (i = 0; i < this.myLastTableLayout.table.size(); ++i) {
            List<TabInfo> columns = this.myLastTableLayout.table.get((int)i).myColumns;
            lastInRow.add(columns.get(columns.size() - 1));
        }
        if (c instanceof JBTabsImpl) {
            for (i = 0; i < this.myLastTableLayout.myVisibleInfos.size() - 1; ++i) {
                boolean between;
                TabInfo firstInfo = (TabInfo)this.myLastTableLayout.myVisibleInfos.get(i);
                TabInfo secondInfo = (TabInfo)this.myLastTableLayout.myVisibleInfos.get(i + 1);
                TabLabel first = this.myTabs.myInfo2Label.get(firstInfo);
                TabLabel second = this.myTabs.myInfo2Label.get(secondInfo);
                Rectangle firstBounds = first.getBounds();
                Rectangle secondBounds = second.getBounds();
                boolean bl = between = firstBounds.getMaxX() < (double)point.x && secondBounds.getX() > (double)point.x && firstBounds.y < point.y && secondBounds.getMaxY() > (double)point.y;
                if (between) {
                    c = first;
                    break;
                }
                if (!lastInRow.contains(firstInfo) || firstBounds.y > point.y || !(firstBounds.getMaxY() >= (double)point.y) || !(firstBounds.getMaxX() <= (double)point.x)) continue;
                c = second;
                break;
            }
        }
        if (c instanceof TabLabel) {
            TabInfo info = ((TabLabel)c).getInfo();
            int index = this.myLastTableLayout.myVisibleInfos.indexOf(info);
            boolean isDropTarget = this.myTabs.isDropTarget(info);
            if (!isDropTarget) {
                for (int i2 = 0; i2 <= index; ++i2) {
                    if (!this.myTabs.isDropTarget((TabInfo)this.myLastTableLayout.myVisibleInfos.get(i2))) continue;
                    --index;
                    break;
                }
                result = index;
            } else if (index < this.myLastTableLayout.myVisibleInfos.size()) {
                result = index;
            }
        }
        return result;
    }

    @Override
    public int getDropSideFor(@NotNull Point point) {
        if (point == null) {
            TableLayout.$$$reportNull$$$0(3);
        }
        return TabsUtil.getDropSideFor(point, this.myTabs);
    }

    int getScrollOffset() {
        return this.myScrollOffset;
    }

    public void scroll(int units) {
        if (!this.myTabs.isSingleRow()) {
            this.myScrollOffset = 0;
            return;
        }
        this.myScrollOffset += units;
        this.clampScrollOffsetToBounds(this.myLastTableLayout);
    }

    private void clampScrollOffsetToBounds(@Nullable TablePassInfo data) {
        if (data == null) {
            return;
        }
        this.myScrollOffset = data.requiredLength < data.toFitRec.width ? 0 : Math.max(0, Math.min(this.myScrollOffset, data.requiredLength - data.toFitRec.width + data.moreRect.width + data.titleRect.width));
    }

    public int getScrollUnitIncrement() {
        return 10;
    }

    public void scrollSelectionInView() {
        this.myScrollSelectionInViewPending = true;
        this.doScrollSelectionInView(this.myLastTableLayout);
    }

    @Override
    public boolean canShowMorePopup() {
        return this.myLastTableLayout != null && !this.myLastTableLayout.moreRect.isEmpty();
    }

    @Override
    public void showMorePopup() {
        Rectangle rect;
        Rectangle rectangle = rect = this.myLastTableLayout != null ? this.myLastTableLayout.moreRect : null;
        if (rect == null || rect.isEmpty()) {
            return;
        }
        JBPopupMenu menu = new JBPopupMenu();
        for (TabInfo each : this.myLastTableLayout.invisible) {
            menu.add(this.createMenuItem(each));
        }
        menu.show(this.myTabs, rect.x, rect.y + rect.height);
    }

    private JBMenuItem createMenuItem(@NotNull TabInfo tabInfo) {
        if (tabInfo == null) {
            TableLayout.$$$reportNull$$$0(4);
        }
        JBMenuItem item = new JBMenuItem(tabInfo.getText(), tabInfo.getIcon());
        item.setForeground(tabInfo.getDefaultForeground());
        item.setBackground(tabInfo.getTabColor());
        item.addActionListener(__ -> this.myTabs.select(tabInfo, true));
        return item;
    }

    private void doScrollSelectionInView(TablePassInfo data) {
        if (this.myTabs.isMouseInsideTabsArea() || data == null || data.lengths.isEmpty() || this.myTabs.isHideTabs() || !UISettings.getInstance().getState().getShowPinnedTabsInASeparateRow()) {
            return;
        }
        int offset = -this.myScrollOffset;
        for (TabInfo info : data.myVisibleInfos) {
            if (info.isPinned()) continue;
            int length = data.lengths.get(info);
            if (info == this.myTabs.getSelectedInfo()) {
                if (offset < 0) {
                    this.scroll(offset);
                    break;
                }
                int maxLength = data.moreRect.x;
                if (offset + length <= maxLength) break;
                if (length < maxLength) {
                    this.scroll(offset + length - maxLength);
                    break;
                }
                this.scroll(offset);
                break;
            }
            offset += length;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabLabel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabInfo";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tabs/impl/table/TableLayout";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getTotalLength";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isDragOut";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getDropSideFor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createMenuItem";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

