/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.evaluation;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebuggerEditorsProviderBase
extends XDebuggerEditorsProvider {
    @Override
    @NotNull
    public final Document createDocument(@NotNull Project project, @NotNull String text2, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        if (project == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(1);
        }
        if (mode == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(2);
        }
        PsiElement context = null;
        if (sourcePosition != null) {
            context = this.getContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project);
        }
        PsiFile codeFragment = this.createExpressionCodeFragment(project, text2, context, true);
        Document document = PsiDocumentManager.getInstance(project).getDocument(codeFragment);
        assert (document != null);
        Document document2 = document;
        if (document2 == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(3);
        }
        return document2;
    }

    @Override
    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull XExpression expression, @Nullable XSourcePosition sourcePosition, @NotNull EvaluationMode mode) {
        if (project == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(4);
        }
        if (expression == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(5);
        }
        if (mode == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(6);
        }
        PsiElement context = null;
        if (sourcePosition != null) {
            context = this.getContextElement(sourcePosition.getFile(), sourcePosition.getOffset(), project);
        }
        Document document = this.createDocument(project, expression, context, mode);
        if (document == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(7);
        }
        return document;
    }

    @NotNull
    public Document createDocument(@NotNull Project project, @NotNull XExpression expression, @Nullable PsiElement context, @NotNull EvaluationMode mode) {
        if (project == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(8);
        }
        if (expression == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(9);
        }
        if (mode == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(10);
        }
        PsiFile codeFragment = this.createExpressionCodeFragment(project, expression, context, true);
        Document document = PsiDocumentManager.getInstance(project).getDocument(codeFragment);
        assert (document != null);
        Document document2 = document;
        if (document2 == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(11);
        }
        return document2;
    }

    protected abstract PsiFile createExpressionCodeFragment(@NotNull Project var1, @NotNull String var2, @Nullable PsiElement var3, boolean var4);

    protected PsiFile createExpressionCodeFragment(@NotNull Project project, @NotNull XExpression expression, @Nullable PsiElement context, boolean isPhysical) {
        if (project == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(12);
        }
        if (expression == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(13);
        }
        return this.createExpressionCodeFragment(project, expression.getExpression(), context, isPhysical);
    }

    @NotNull
    public Collection<Language> getSupportedLanguages(@Nullable PsiElement context) {
        if (context != null) {
            Collection<Language> collection = this.getSupportedLanguages(context.getProject(), null);
            if (collection == null) {
                XDebuggerEditorsProviderBase.$$$reportNull$$$0(14);
            }
            return collection;
        }
        List<Language> list = Collections.emptyList();
        if (list == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Nullable
    protected PsiElement getContextElement(@NotNull VirtualFile virtualFile2, int offset, @NotNull Project project) {
        if (virtualFile2 == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(16);
        }
        if (project == null) {
            XDebuggerEditorsProviderBase.$$$reportNull$$$0(17);
        }
        return XDebuggerUtil.getInstance().findContextElement(virtualFile2, offset, project, false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase";
                break;
            }
            case 5: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/evaluation/XDebuggerEditorsProviderBase";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedLanguages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 14: 
            case 15: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createExpressionCodeFragment";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getContextElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

