/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.meteor.runner;

import com.google.gson.stream.JsonReader;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.JavaScriptDebugProcessKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.PathUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.plugins.meteor.runner.MeteorFileFinderKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001e\u001a\u00020\u00062\b\u0010\u001f\u001a\u0004\u0018\u00010\u0003H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/jetbrains/plugins/meteor/runner/MeteorFileFinder;", "Lcom/intellij/javascript/debugger/DebuggableFileFinder;", "workDir", "", "(Ljava/lang/String;)V", "isopacksDir", "Ljava/io/File;", "getIsopacksDir$intellij_javascript_chrome_connector", "()Ljava/io/File;", "localPackagesExists", "Lcom/intellij/util/ThreeState;", "meteorDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "virtualDir", "findFileForLocalPackage", "url", "Lcom/intellij/util/Url;", "findFileForMeteorSpecificUrl", "findFileInWorkingDirectory", "path", "findFileInWorkingDirectory$intellij_javascript_chrome_connector", "getRemoteUrls", "", "file", "guessFile", "project", "Lcom/intellij/openapi/project/Project;", "isOnlySourceMappedBreakpoints", "", "readSourceRoot", "buildInfo", "packageName", "intellij.javascript.chrome.connector"})
public final class MeteorFileFinder
implements DebuggableFileFinder {
    private final VirtualFile virtualDir;
    private final VirtualFile meteorDir;
    @NotNull
    private final File isopacksDir;
    private ThreeState localPackagesExists;

    @NotNull
    public final File getIsopacksDir$intellij_javascript_chrome_connector() {
        return this.isopacksDir;
    }

    @Nullable
    public VirtualFile guessFile(@NotNull Url url, @NotNull Project project) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile file = this.findFileForMeteorSpecificUrl(url);
        if (file == null && this.virtualDir != null) {
            String string = url.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.path");
            virtualFile = this.findFileInWorkingDirectory$intellij_javascript_chrome_connector(string);
        } else {
            virtualFile = file;
        }
        return virtualFile;
    }

    @Nullable
    public final VirtualFile findFileInWorkingDirectory$intellij_javascript_chrome_connector(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int i = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6, null);
        while (i != -1) {
            String subPath;
            String string = path;
            int n = i + 1;
            int n2 = path.length();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)string.substring(n, n2), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            boolean bl2 = this.virtualDir != null;
            n = 0;
            n2 = 0;
            if (_Assertions.ENABLED && !bl2) {
                bl = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            VirtualFile virtualFile = this.virtualDir;
            Intrinsics.checkNotNull((Object)virtualFile);
            VirtualFile file = virtualFile.findFileByRelativePath(subPath);
            if (file != null) {
                return file;
            }
            i = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)(i + 2), (boolean)false, (int)4, null);
        }
        return null;
    }

    public boolean isOnlySourceMappedBreakpoints(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean result = DebuggableFileFinder.DefaultImpls.isOnlySourceMappedBreakpoints((DebuggableFileFinder)this, (VirtualFile)file);
        return !result && this.meteorDir != null ? !VfsUtilCore.isAncestor((VirtualFile)this.meteorDir, (VirtualFile)file, (boolean)true) : result;
    }

    private final VirtualFile findFileForMeteorSpecificUrl(Url url) {
        try {
            String string = url.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url.path");
            String scriptPath = string;
            String urlString = url.toString();
            String meteorDirSlashedName = "/.meteor/";
            int index = StringsKt.lastIndexOf$default((CharSequence)scriptPath, (String)meteorDirSlashedName, (int)0, (boolean)false, (int)6, null);
            if (index != -1 && StringsKt.startsWith$default((String)scriptPath, (String)"local/build/programs/server/app/", (int)(index + meteorDirSlashedName.length()), (boolean)false, (int)4, null)) {
                String string2 = scriptPath;
                int n = 0;
                int n2 = index + 1;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String sourceRoot = string4;
                JavaScriptDebugProcessKt.getLOG().assertTrue(StringsKt.startsWith$default((String)urlString, (String)"meteor://\ud83d\udcbbapp/", (boolean)false, (int)2, null));
                LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                StringBuilder stringBuilder = new StringBuilder().append(sourceRoot);
                string2 = urlString;
                n = "meteor://\ud83d\udcbbapp/".length();
                n2 = 0;
                String string5 = string2;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                return localFileSystem.findFileByPath(stringBuilder.append(string6).toString());
            }
            return this.findFileForLocalPackage(url);
        }
        catch (Exception e) {
            JavaScriptDebugProcessKt.getLOG().warn((Throwable)e);
            return null;
        }
    }

    private final VirtualFile findFileForLocalPackage(Url url) {
        int i;
        boolean bl;
        int n;
        String urlString = url.toString();
        String packageName = null;
        String packageFileName = null;
        int prefixLength = -1;
        if (StringsKt.startsWith$default((String)urlString, (String)"meteor://\ud83d\udcbbapp/", (boolean)false, (int)2, null)) {
            String string = PathUtil.getFileName((String)url.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PathUtil.getFileName(url.path)");
            String fileName = string;
            int dotIndex = StringsKt.indexOf$default((CharSequence)fileName, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dotIndex > 0) {
                String string2;
                int firstUnderscoreIndex = StringsKt.indexOf$default((CharSequence)fileName, (char)'_', (int)0, (boolean)false, (int)4, null);
                if (firstUnderscoreIndex > 0 && firstUnderscoreIndex < dotIndex) {
                    string2 = fileName;
                    n = 0;
                    bl = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n, dotIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    packageFileName = string4;
                    StringBuilder stringBuilder = new StringBuilder();
                    string2 = fileName;
                    n = 0;
                    bl = false;
                    String string5 = string2;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.substring(n, firstUnderscoreIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    StringBuilder stringBuilder2 = stringBuilder.append(string6).append(':');
                    string2 = fileName;
                    n = firstUnderscoreIndex + 1;
                    bl = false;
                    String string7 = string2;
                    if (string7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string8 = string7.substring(n, dotIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    packageName = stringBuilder2.append(string8).toString();
                } else {
                    string2 = fileName;
                    n = 0;
                    bl = false;
                    String string9 = string2;
                    if (string9 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string10 = string9.substring(n, dotIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    packageName = packageFileName = string10;
                }
                prefixLength = 14;
                if (StringsKt.startsWith$default((String)urlString, (String)"packages/", (int)"meteor://\ud83d\udcbbapp/".length(), (boolean)false, (int)4, null)) {
                    Character c = StringsKt.getOrNull((CharSequence)urlString, (int)((prefixLength += "packages/".length()) + 1 + packageName.length()));
                    if (c != null && c.charValue() == '/' && (StringsKt.startsWith$default((String)urlString, (String)packageFileName, (int)(prefixLength + 1), (boolean)false, (int)4, null) || StringsKt.startsWith$default((String)urlString, (String)packageName, (int)(prefixLength + 1), (boolean)false, (int)4, null))) {
                        prefixLength += packageName.length() + 1;
                    }
                }
            }
        } else if (!SourceResolver.Companion.isAbsolute(urlString) && (i = StringsKt.indexOf$default((CharSequence)urlString, (char)'/', (int)0, (boolean)false, (int)6, null)) > 0) {
            String packageNameCandidate;
            String firstUnderscoreIndex = urlString;
            int n2 = 0;
            n = 0;
            String string = firstUnderscoreIndex;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string11 = string.substring(n2, i);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            packageName = packageNameCandidate = string11;
        }
        if (packageName == null) {
            return null;
        }
        File isopacksDir = this.isopacksDir;
        if (this.localPackagesExists == ThreeState.UNSURE) {
            ThreeState threeState = ThreeState.fromBoolean((boolean)isopacksDir.exists());
            Intrinsics.checkNotNullExpressionValue((Object)threeState, (String)"ThreeState.fromBoolean(isopacksDir.exists())");
            this.localPackagesExists = threeState;
        }
        if (this.localPackagesExists == ThreeState.NO) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = packageFileName;
        if (string == null) {
            string = StringsKt.replace$default((String)packageName, (char)':', (char)'_', (boolean)false, (int)4, null);
        }
        File buildInfo = new File(isopacksDir, stringBuilder.append(string).append(File.separatorChar).append("isopack-buildinfo.json").toString());
        if (!buildInfo.exists()) {
            return null;
        }
        String string12 = this.readSourceRoot(buildInfo, packageName);
        if (string12 == null) {
            return null;
        }
        String sourceRoot = string12;
        if (SystemInfo.isWindows && sourceRoot.length() > 4 && sourceRoot.charAt(0) == '/' && sourceRoot.charAt(2) == '/') {
            StringBuilder stringBuilder3 = new StringBuilder().append(sourceRoot.charAt(1)).append(':');
            String string13 = sourceRoot;
            n = 2;
            bl = false;
            String string14 = string13;
            if (string14 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string15 = string14.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"(this as java.lang.String).substring(startIndex)");
            sourceRoot = stringBuilder3.append(string15).toString();
        }
        if (prefixLength == -1) {
            prefixLength = packageName.length();
        }
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        StringBuilder stringBuilder4 = new StringBuilder().append(sourceRoot);
        String string16 = urlString;
        n = 0;
        String string17 = string16;
        if (string17 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string18 = string17.substring(prefixLength);
        Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"(this as java.lang.String).substring(startIndex)");
        return localFileSystem.findFileByPath(stringBuilder4.append(string18).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final String readSourceRoot(File buildInfo, String packageName) {
        sourceRoot = null;
        var4_4 = buildInfo;
        var5_5 = false;
        var4_4 = new FileInputStream((File)var4_4);
        var5_6 = Charsets.UTF_8;
        var6_8 = false;
        var4_4 = (Closeable)new JsonReader((Reader)new InputStreamReader((InputStream)var4_4, var5_6));
        var5_7 = false;
        var6_8 = false;
        var6_9 = null;
        try {
            reader = (JsonReader)var4_4;
            $i$a$-use-MeteorFileFinder$readSourceRoot$1 = false;
            if (MeteorFileFinderKt.access$readUntilName(reader, "pluginProviderPackageMap")) {
                v0 = packageName;
                Intrinsics.checkNotNull((Object)v0);
                if (MeteorFileFinderKt.access$readUntilName(reader, v0)) {
                    reader.beginObject();
                    kind = null;
                    block10: while (reader.hasNext()) {
                        if (reader.nextName() != null) {
                            switch (var10_15.hashCode()) {
                                case -1111500899: {
                                    if (!var10_15.equals("sourceRoot")) ** break;
                                    break;
                                }
                                case 3292052: {
                                    if (!var10_15.equals("kind")) ** break;
                                    kind = reader.nextString();
                                    continue block10;
                                }
                            }
                            sourceRoot = reader.nextString();
                            continue;
                        }
                        reader.skipValue();
                    }
                    if (Intrinsics.areEqual((Object)"local", (Object)kind) ^ true) {
                        var11_16 = null;
                        return var11_16;
                    }
                }
            }
            var7_10 = Unit.INSTANCE;
        }
        catch (Throwable var7_11) {
            var6_9 = var7_11;
            throw var7_11;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var4_4, (Throwable)var6_9);
        }
        return sourceRoot;
    }

    @NotNull
    public List<Url> getRemoteUrls(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
        return CollectionsKt.listOf((Object)Urls.newLocalFileUrl((String)string));
    }

    public MeteorFileFinder(@NotNull String workDir) {
        Intrinsics.checkNotNullParameter((Object)workDir, (String)"workDir");
        this.isopacksDir = new File(workDir, ".meteor" + File.separatorChar + "local" + File.separatorChar + "isopacks");
        this.localPackagesExists = ThreeState.UNSURE;
        VirtualFile virtualFile = this.virtualDir = LocalFileSystem.getInstance().findFileByPath(workDir);
        this.meteorDir = virtualFile != null ? virtualFile.findChild(".meteor") : null;
        JavaScriptDebugProcessKt.getLOG().assertTrue(this.virtualDir != null);
        JavaScriptDebugProcessKt.getLOG().assertTrue(this.meteorDir != null);
    }

    public boolean canSetRemoteUrl(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DebuggableFileFinder.DefaultImpls.canSetRemoteUrl((DebuggableFileFinder)this, (VirtualFile)file, (Project)project);
    }

    @Nullable
    public VirtualFile findFile(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DebuggableFileFinder.DefaultImpls.findFile((DebuggableFileFinder)this, (Url)url, (Project)project);
    }

    @Nullable
    public Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return DebuggableFileFinder.DefaultImpls.findNavigatable((DebuggableFileFinder)this, (Url)url, (Project)project);
    }

    public boolean searchesByName() {
        return DebuggableFileFinder.DefaultImpls.searchesByName((DebuggableFileFinder)this);
    }
}

