/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.images;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.MergeableLineMarkerInfo;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.images.ConfigureImageDialog;
import org.intellij.plugins.markdown.editor.images.MarkdownImageData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b \u0018\u0000 \u0019*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH&J\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\fJ\u0016\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u0002H&J\u0017\u0010\u0013\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0007\u001a\u00020\u0002H&\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0007\u001a\u00020\u0002H&J\u000e\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u0010H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/editor/images/ConfigureImageLineMarkerProviderBase;", "T", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/daemon/LineMarkerProviderDescriptor;", "()V", "applyChanges", "", "element", "imageData", "Lorg/intellij/plugins/markdown/editor/images/MarkdownImageData;", "createDialog", "Lorg/intellij/plugins/markdown/editor/images/ConfigureImageDialog;", "(Lcom/intellij/psi/PsiElement;)Lorg/intellij/plugins/markdown/editor/images/ConfigureImageDialog;", "getLineMarkerInfo", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "getMarkerElementPresentation", "", "getName", "obtainLeafElement", "obtainOuterElement", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "obtainPathText", "performAction", "processFileName", "filePath", "Companion", "ConfigureImageLineMarkerInfo", "intellij.markdown"})
public abstract class ConfigureImageLineMarkerProviderBase<T extends PsiElement>
extends LineMarkerProviderDescriptor {
    private static final GutterIconRenderer.Alignment ALIGNMENT;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public abstract ConfigureImageDialog createDialog(@NotNull T var1);

    @Nullable
    public abstract String obtainPathText(@NotNull PsiElement var1);

    public abstract void applyChanges(@NotNull PsiElement var1, @NotNull MarkdownImageData var2);

    @Nullable
    public abstract PsiElement obtainLeafElement(@NotNull PsiElement var1);

    @Nullable
    public abstract T obtainOuterElement(@NotNull PsiElement var1);

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiElement psiElement = this.obtainLeafElement(element);
        if (psiElement == null) {
            return null;
        }
        PsiElement leaf = psiElement;
        TextRange textRange = leaf.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"leaf.textRange");
        return (LineMarkerInfo)new ConfigureImageLineMarkerInfo(element, textRange);
    }

    public final void performAction(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        T t = this.obtainOuterElement(element);
        if (t == null) {
            return;
        }
        T outerElement = t;
        ConfigureImageDialog configureImageDialog = this.createDialog(outerElement);
        if (configureImageDialog == null) {
            return;
        }
        ConfigureImageDialog dialog = configureImageDialog;
        dialog.show((Function1<? super MarkdownImageData, Unit>)((Function1)new Function1<MarkdownImageData, Unit>(this, element){
            final /* synthetic */ ConfigureImageLineMarkerProviderBase this$0;
            final /* synthetic */ PsiElement $element;

            public final void invoke(@NotNull MarkdownImageData it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.this$0.applyChanges(this.$element, it);
            }
            {
                this.this$0 = configureImageLineMarkerProviderBase;
                this.$element = psiElement;
                super(1);
            }
        }));
    }

    @NotNull
    public String getName() {
        String string = MarkdownBundle.message("markdown.configure.markdown.image.line.marker.provider.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MarkdownBundle.message(\"\u2026ne.marker.provider.name\")");
        return string;
    }

    private final String processFileName(String filePath) {
        try {
            URI uRI = URI.create(FileUtil.toSystemIndependentName((String)filePath));
            Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"URI.create(FileUtil.toSy\u2026ndependentName(filePath))");
            String uri = uRI.getPath();
            Path path = Paths.get(uri, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"Paths.get(uri)");
            Path path2 = path.getFileName();
            return path2 != null ? ((Object)path2).toString() : null;
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
        catch (InvalidPathException exception) {
            return null;
        }
    }

    private final String getMarkerElementPresentation(PsiElement element) {
        String string;
        CharSequence charSequence;
        String string2;
        block6: {
            block5: {
                string2 = this.obtainPathText(element);
                if (string2 == null) break block5;
                charSequence = string2;
                ConfigureImageLineMarkerProviderBase configureImageLineMarkerProviderBase = this;
                boolean bl = false;
                boolean bl2 = false;
                CharSequence p1 = charSequence;
                boolean bl3 = false;
                string2 = configureImageLineMarkerProviderBase.processFileName((String)p1);
                if (string2 != null) break block6;
            }
            string2 = "";
        }
        String fileName = string2;
        charSequence = fileName;
        boolean bl = false;
        if (charSequence.length() == 0) {
            String string3 = MarkdownBundle.message("markdown.configure.image.text", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MarkdownBundle.message(\"\u2026wn.configure.image.text\")");
        } else {
            String string4 = MarkdownBundle.message("markdown.configure.image.line.marker.presentation", fileName);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"MarkdownBundle.message(\"\u2026.presentation\", fileName)");
        }
        return string;
    }

    static {
        Companion = new Companion(null);
        ALIGNMENT = GutterIconRenderer.Alignment.CENTER;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0016J\u001c\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00010\rH\u0016J\u001c\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\f\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00010\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/editor/images/ConfigureImageLineMarkerProviderBase$ConfigureImageLineMarkerInfo;", "Lcom/intellij/codeInsight/daemon/MergeableLineMarkerInfo;", "Lcom/intellij/psi/PsiElement;", "element", "textRange", "Lcom/intellij/openapi/util/TextRange;", "(Lorg/intellij/plugins/markdown/editor/images/ConfigureImageLineMarkerProviderBase;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "canMergeWith", "", "info", "getCommonIcon", "Ljavax/swing/Icon;", "infos", "", "getCommonIconAlignment", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer$Alignment;", "getElementPresentation", "", "intellij.markdown"})
    private final class ConfigureImageLineMarkerInfo
    extends MergeableLineMarkerInfo<PsiElement> {
        @NotNull
        public String getElementPresentation(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return ConfigureImageLineMarkerProviderBase.this.getMarkerElementPresentation(element);
        }

        public boolean canMergeWith(@NotNull MergeableLineMarkerInfo<?> info) {
            Intrinsics.checkNotNullParameter(info, (String)"info");
            return info instanceof ConfigureImageLineMarkerInfo;
        }

        @NotNull
        public Icon getCommonIcon(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
            Intrinsics.checkNotNullParameter(infos, (String)"infos");
            Icon icon = ((MergeableLineMarkerInfo)CollectionsKt.first(infos)).getIcon();
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"infos.first().icon");
            return icon;
        }

        @NotNull
        public GutterIconRenderer.Alignment getCommonIconAlignment(@NotNull List<? extends MergeableLineMarkerInfo<?>> infos) {
            Intrinsics.checkNotNullParameter(infos, (String)"infos");
            return ALIGNMENT;
        }

        public ConfigureImageLineMarkerInfo(@NotNull PsiElement element, TextRange textRange) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
            Function1 function1 = (Function1)new Function1<PsiElement, String>(ConfigureImageLineMarkerProviderBase.this){

                @NotNull
                public final String invoke(@NotNull PsiElement p1) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    return ((ConfigureImageLineMarkerProviderBase)((Object)this.receiver)).getMarkerElementPresentation(p1);
                }
            };
            super(element, textRange, AllIcons.General.LayoutPreviewOnly, new Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ Object fun(Object p0) {
                    return this.function.invoke(p0);
                }
            }, new GutterIconNavigationHandler(){

                public final void navigate(MouseEvent $noName_0, PsiElement e) {
                    PsiElement psiElement = e;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"e");
                    ConfigureImageLineMarkerProviderBase.this.performAction(psiElement);
                }
            }, ALIGNMENT, (Supplier)3.INSTANCE);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/editor/images/ConfigureImageLineMarkerProviderBase$Companion;", "", "()V", "ALIGNMENT", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer$Alignment;", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

