/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.codeInsight.editorActions.AutoHardWrapHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.DocumentUtil;
import kotlin.ExperimentalStdlibApi;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.intellij.plugins.markdown.editor.lists.ListRenumberUtils;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.MarkdownListItemUnindentHandler;
import org.intellij.plugins.markdown.editor.lists.MarkdownListMarkerBackspaceHandlerDelegate;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownBlockQuoteImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceImpl;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItemImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016JF\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/MarkdownListEnterHandlerDelegate;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate;", "()V", "marker", "", "handleEmptyItem", "", "item", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItemImpl;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "invokeInsideIndent", "", "newLineCharOffset", "", "isInBlockQuoteOrCodeFence", "caretOffset", "postProcessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "preprocessEnter", "Lcom/intellij/openapi/util/Ref;", "caretAdvance", "intellij.markdown"})
@ExperimentalStdlibApi
public final class MarkdownListEnterHandlerDelegate
implements EnterHandlerDelegate {
    private String marker;

    public boolean invokeInsideIndent(int newLineCharOffset, @NotNull Editor editor2, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return PsiEditorUtil.getPsiFile((Editor)editor2) instanceof MarkdownFile;
    }

    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        boolean prevLineBlank;
        block10: {
            block9: {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                Intrinsics.checkNotNullParameter(caretOffset, (String)"caretOffset");
                Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
                Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                this.marker = null;
                if (!(file instanceof MarkdownFile)) break block9;
                Object object = caretOffset.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"caretOffset.get()");
                if (!this.isInBlockQuoteOrCodeFence(((Number)object).intValue(), file)) break block10;
            }
            return EnterHandlerDelegate.Result.Continue;
        }
        if (Intrinsics.areEqual((Object)((Boolean)DataManager.getInstance().loadFromDataContext(dataContext, AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY)), (Object)true)) {
            editor2.putUserData(AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY, (Object)true);
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)((MarkdownFile)file).getProject()).commitDocument(document2);
        Object object = caretOffset.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"caretOffset.get()");
        int line = document2.getLineNumber(((Number)object).intValue());
        if (line > 0) {
            TextRange indentRange = ListUtils.INSTANCE.getLineIndentRange(document2, line);
            boolean insideIndent = !indentRange.isEmpty() && ((Number)caretOffset.get()).intValue() <= indentRange.getEndOffset();
            prevLineBlank = DocumentUtil.isLineEmpty((Document)document2, (int)(line - 1));
            if (insideIndent && prevLineBlank) {
                return EnterHandlerDelegate.Result.Continue;
            }
        }
        MarkdownFile markdownFile = (MarkdownFile)file;
        Object object2 = caretOffset.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"caretOffset.get()");
        MarkdownListItemImpl markdownListItemImpl = ListUtils.INSTANCE.getListItemAt(markdownFile, ((Number)object2).intValue(), document2);
        if (markdownListItemImpl == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        MarkdownListItemImpl item = markdownListItemImpl;
        PsiElement[] psiElementArray = item.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"item.children");
        PsiElement[] insideIndent = psiElementArray;
        prevLineBlank = false;
        if (insideIndent.length == 0) {
            this.handleEmptyItem(item, editor2, file, originalHandler, dataContext);
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            caretOffset.set((Object)caretModel.getOffset());
            return EnterHandlerDelegate.Result.Stop;
        }
        int itemLine = document2.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)item)));
        PsiElement psiElement = item.getMarkerElement();
        Intrinsics.checkNotNull((Object)psiElement);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"item.markerElement!!");
        PsiElement markerElement = psiElement;
        TextRange textRange = ListUtils.INSTANCE.getLineIndentRange(document2, itemLine).union(markerElement.getTextRange());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"document.getLineIndentRa\u2026(markerElement.textRange)");
        TextRange indentWithMakerRange = textRange;
        Object object3 = caretOffset.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"caretOffset.get()");
        if (indentWithMakerRange.contains(((Number)object3).intValue())) {
            caretOffset.set((Object)UtilsKt.getEndOffset((PsiElement)markerElement));
        }
        this.marker = ListUtils.INSTANCE.getNormalizedMarker(item);
        return EnterHandlerDelegate.Result.Default;
    }

    private final boolean isInBlockQuoteOrCodeFence(int caretOffset, PsiFile file) {
        if (caretOffset == 0) {
            return false;
        }
        PsiElement psiElement = file.findElementAt(caretOffset - 1);
        return (psiElement != null ? PsiTreeUtilKt.parentOfTypes$default((PsiElement)psiElement, (KClass[])new KClass[]{Reflection.getOrCreateKotlinClass(MarkdownBlockQuoteImpl.class), Reflection.getOrCreateKotlinClass(MarkdownCodeFenceImpl.class)}, (boolean)false, (int)2, null) : null) != null;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleEmptyItem(MarkdownListItemImpl item, Editor editor2, PsiFile file, EditorActionHandler originalHandler, DataContext dataContext) {
        void $this$parentOfType$iv;
        PsiElement psiElement = item.getMarkerElement();
        Intrinsics.checkNotNull((Object)psiElement);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"item.markerElement!!");
        PsiElement markerElement = psiElement;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        PsiElement psiElement2 = (PsiElement)item;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        if (PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownListItemImpl.class, (boolean)true) == null) {
            MarkdownListMarkerBackspaceHandlerDelegate backspaceHandler = new MarkdownListMarkerBackspaceHandlerDelegate();
            int markerEnd = UtilsKt.getEndOffset((PsiElement)markerElement);
            editor2.getCaretModel().moveToOffset(markerEnd);
            Document document3 = editor2.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"editor.document");
            char c = document3.getCharsSequence().charAt(markerEnd - 1);
            backspaceHandler.beforeCharDeleted(c, file, editor2);
            boolean $i$f$runWriteAction = false;
            ApplicationManager.getApplication().runWriteAction(new Computable(document2, markerEnd){
                final /* synthetic */ Document $document$inlined;
                final /* synthetic */ int $markerEnd$inlined;
                {
                    this.$document$inlined = document;
                    this.$markerEnd$inlined = n;
                }

                public final T compute() {
                    boolean bl = false;
                    this.$document$inlined.deleteString(this.$markerEnd$inlined - 1, this.$markerEnd$inlined);
                    return (T)Unit.INSTANCE;
                }
            });
            backspaceHandler.charDeleted(c, file, editor2);
        } else {
            MarkdownListItemUnindentHandler unindentHandler = new MarkdownListItemUnindentHandler(originalHandler);
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            unindentHandler.execute(editor2, caretModel.getCurrentCaret(), dataContext);
        }
    }

    @NotNull
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file, @NotNull Editor editor2, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (Intrinsics.areEqual((Object)((Boolean)editor2.getUserData(AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY)), (Object)true)) {
            editor2.putUserData(AutoHardWrapHandler.AUTO_WRAP_LINE_IN_PROGRESS_KEY, null);
            return EnterHandlerDelegate.Result.Continue;
        }
        String string = this.marker;
        if (string == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        String marker2 = string;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        boolean $i$f$runWriteAction = false;
        ApplicationManager.getApplication().runWriteAction(new Computable(editor2, marker2){
            final /* synthetic */ Editor $editor$inlined;
            final /* synthetic */ String $marker$inlined;
            {
                this.$editor$inlined = editor2;
                this.$marker$inlined = string;
            }

            public final T compute() {
                boolean bl = false;
                EditorModificationUtil.insertStringAtCaret((Editor)this.$editor$inlined, (String)this.$marker$inlined);
                return (T)Unit.INSTANCE;
            }
        });
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document2);
        MarkdownFile markdownFile = (MarkdownFile)file;
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        MarkdownListItemImpl markdownListItemImpl = ListUtils.INSTANCE.getListItemAt(markdownFile, caretModel.getOffset(), document2);
        Intrinsics.checkNotNull((Object)markdownListItemImpl);
        ListRenumberUtils.INSTANCE.renumberInBulk(ListUtils.INSTANCE.getList(markdownListItemImpl), document2, false, false);
        this.marker = null;
        return EnterHandlerDelegate.Result.Stop;
    }
}

