/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.presentation;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.extras.custom.CommonDiagramExtras;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DSelectionEvent;
import com.intellij.openapi.graph.view.Graph2DSelectionListener;
import com.intellij.openapi.project.Project;
import com.intellij.uml.presentation.DiagramPresentationModelImpl;

public class DiagramSelectionModePresentationModelImpl
extends DiagramPresentationModelImpl {
    public DiagramSelectionModePresentationModelImpl(Graph2D graph, Project project, DiagramProvider provider) {
        super(graph, project, provider);
        graph.addGraph2DSelectionListener(new Graph2DSelectionListener(){
            private boolean myDataModelUpdateScheduled = false;

            public void onGraph2DSelectionEvent(Graph2DSelectionEvent e) {
                if (e.isNodeSelection() && !this.myDataModelUpdateScheduled) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        this.myDataModelUpdateScheduled = false;
                        DiagramSelectionModePresentationModelImpl.this.updateDataPresentation();
                    });
                    this.myDataModelUpdateScheduled = true;
                }
            }
        });
    }

    private void updateDataPresentation() {
        DiagramBuilder builder = this.getBuilder();
        DiagramDataModel<?> dataModel = builder.getDataModel();
        if (DiagramUtils.isSelectionMode(builder) || dataModel.getNodeContentManager().isCategoryEnabled(CommonDiagramExtras.PATH_TO_ROOT)) {
            this.updateData(dataModel);
            builder.update(true, true);
            builder.getGraph().fitGraph2DView();
        }
    }

    protected void updateData(DiagramDataModel dataModel) {
        dataModel.refreshDataModel();
    }
}

