/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.sql;

import com.intellij.database.remote.jdba.core.ResultLayout;
import com.intellij.database.remote.jdba.sql.SqlStatement;
import com.intellij.database.remote.jdba.sql.TextFragment;
import com.intellij.database.remote.jdba.util.StringOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlQuery<S>
extends SqlStatement {
    @NotNull
    private final ResultLayout<S> myLayout;
    private transient String myDisplayName;

    public SqlQuery(@NotNull TextFragment sourceFragment, @NotNull ResultLayout<S> layout) {
        if (sourceFragment == null) {
            SqlQuery.$$$reportNull$$$0(0);
        }
        if (layout == null) {
            SqlQuery.$$$reportNull$$$0(1);
        }
        super(sourceFragment);
        this.myLayout = layout;
    }

    public SqlQuery(@NotNull String sourceText, @NotNull ResultLayout<S> layout) {
        if (sourceText == null) {
            SqlQuery.$$$reportNull$$$0(2);
        }
        if (layout == null) {
            SqlQuery.$$$reportNull$$$0(3);
        }
        super(sourceText);
        this.myLayout = layout;
    }

    public SqlQuery(int row, @NotNull String sourceText, @Nullable String name, @NotNull String description, @NotNull ResultLayout<S> layout, String displayName) {
        if (sourceText == null) {
            SqlQuery.$$$reportNull$$$0(4);
        }
        if (description == null) {
            SqlQuery.$$$reportNull$$$0(5);
        }
        if (layout == null) {
            SqlQuery.$$$reportNull$$$0(6);
        }
        super(row, sourceText, name, description);
        this.myLayout = layout;
        this.myDisplayName = displayName;
    }

    protected void setDisplayName(String displayName) {
        this.myDisplayName = displayName;
    }

    public String getDisplayName() {
        if (this.myDisplayName == null) {
            this.prepareDisplayName();
        }
        return this.myDisplayName;
    }

    private synchronized void prepareDisplayName() {
        if (this.myDisplayName != null) {
            return;
        }
        int nl = this.mySourceText.indexOf(10);
        String str1 = nl > 0 ? this.mySourceText.substring(0, nl) : this.mySourceText;
        this.myDisplayName = str1 = str1.trim();
    }

    @Override
    @NotNull
    public SqlQuery<S> rewrite(@NotNull StringOperator operator) {
        if (operator == null) {
            SqlQuery.$$$reportNull$$$0(7);
        }
        String transformedSourceText = (String)operator.apply(this.mySourceText);
        return new SqlQuery<S>(this.myRow, transformedSourceText, this.myName, this.myDescription, this.myLayout, this.myDescription);
    }

    @NotNull
    public ResultLayout<S> getLayout() {
        ResultLayout<S> resultLayout = this.myLayout;
        if (resultLayout == null) {
            SqlQuery.$$$reportNull$$$0(8);
        }
        return resultLayout;
    }

    @Override
    public String toString() {
        return this.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFragment";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/sql/SqlQuery";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/sql/SqlQuery";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "rewrite";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

