/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.impl.cassandra;

import com.intellij.database.remote.jdbc.RemoteCassConnection;
import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.RemoteConnectionImpl;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class RemoteCassConnectionImpl
extends RemoteConnectionImpl
implements RemoteCassConnection {
    public RemoteCassConnectionImpl(Connection delegate, JdbcHelperImpl helper) {
        super(delegate, helper);
    }

    @Override
    @Nullable
    public Map<String, String> getAggregateInitConditions(String keyspace) {
        try {
            Class<?> ParseUtils = Class.forName("com.datastax.driver.core.ParseUtils");
            Method isDoubleQuoted = ParseUtils.getMethod("isDoubleQuoted", String.class);
            Method doubleQuote = ParseUtils.getMethod("doubleQuote", String.class);
            Method quote = ParseUtils.getMethod("quote", String.class);
            Object bool = isDoubleQuoted.invoke(null, keyspace);
            if (Boolean.FALSE.equals(bool)) {
                keyspace = (String)doubleQuote.invoke(null, keyspace);
            }
            Method getSession = ((Connection)this.myDelegate).getClass().getDeclaredMethod("getSession", new Class[0]);
            getSession.setAccessible(true);
            Object session = getSession.invoke(this.myDelegate, new Object[0]);
            Method getCluster = session.getClass().getMethod("getCluster", new Class[0]);
            getCluster.setAccessible(true);
            Object cluster = getCluster.invoke(session, new Object[0]);
            Object metadata = cluster.getClass().getMethod("getMetadata", new Class[0]).invoke(cluster, new Object[0]);
            Object keyspaceMetadata = metadata.getClass().getMethod("getKeyspace", String.class).invoke(metadata, keyspace);
            Collection aggregates = (Collection)keyspaceMetadata.getClass().getMethod("getAggregates", new Class[0]).invoke(keyspaceMetadata, new Object[0]);
            Class<?> AggregateMetadata = Class.forName("com.datastax.driver.core.AggregateMetadata");
            Method getInitCond = AggregateMetadata.getMethod("getInitCond", new Class[0]);
            Method getSignature = AggregateMetadata.getMethod("getSignature", new Class[0]);
            LinkedHashMap<String, String> initConditions = new LinkedHashMap<String, String>();
            for (Object aggregate : aggregates) {
                Object initCond = getInitCond.invoke(aggregate, new Object[0]);
                String signature = (String)getSignature.invoke(aggregate, new Object[0]);
                if (initCond instanceof String) {
                    initConditions.put(signature, (String)quote.invoke(null, initCond));
                    continue;
                }
                if (initCond == null) continue;
                initConditions.put(signature, initCond.toString());
            }
            return initConditions;
        }
        catch (Exception e) {
            JdbcNativeUtil.logWarn("Cannot retrieve aggregate conditions", e);
            return null;
        }
    }
}

