/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import a.d.la;
import com.intellij.DynamicBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.JBUI;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.ScriptingLibrariesPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class EditLibraryDialog
extends DialogWrapper {
    private static final int FILE_LOCATION_COL = 0;
    private static final int FILE_TYPE_COL = 1;
    private final String mySourceTypeName;
    private final String myCompactTypeName;
    private static final Comparator<VirtualFilePointer> FILE_COMPARATOR;
    private JPanel contentPane;
    private JTextField myLibName;
    private final JBTable myFileTable;
    private final JBList<String> myDocUrlList;
    private JComboBox myFrameworkCombo;
    private JTextField myVersionField;
    private JRadioButton myProjectRadioButton;
    private JRadioButton myGlobalRadioButton;
    private JPanel myFilesPanel;
    private JPanel myUrlsPanel;
    private final Project myProject;
    private final FileTableModel myFileTableModel;
    private final LangScriptingContextProvider myProvider;
    private final MyDocUrlListModel myDocUrlListModel;
    private ScriptingFrameworkDescriptor mySelectedFramework;
    private final Icon myFileIcon;
    private final Icon myDirectoryIcon;
    private final AnActionButton myDownloadButton;
    private final AnActionButton myEditDocUrlButton;
    private final FileChooserDescriptor LIB_FILES_CHOOSER_DESCRIPTOR;
    private static final long a;

    public EditLibraryDialog(@NlsContexts.DialogTitle String title, LangScriptingContextProvider provider, Project project) {
        long l2 = a ^ 0x53E4D1C8B7E6L;
        super(true);
        this.k();
        this.LIB_FILES_CHOOSER_DESCRIPTOR = new FileChooserDescriptor(this, true, false, false, true, false, true){
            final /* synthetic */ EditLibraryDialog this$0;
            private static final long a = la.a(8198647083339679519L, 8935018673556498935L, MethodHandles.lookup().lookupClass()).a(185740884496434L);
            {
                long l2 = a ^ 0x7DA7C90DA192L;
                this.this$0 = this$0;
                super(arg0, arg1, arg2, arg3, arg4, arg5);
                this.setTitle(WebCoreBundle.message((String)"edit.library.attach.files.dialog.title", (Object[])new Object[0]));
            }

            public boolean isFileSelectable(VirtualFile file) {
                if (!file.isDirectory() && !this.this$0.myProvider.acceptsExtension(file.getExtension())) {
                    return false;
                }
                return super.isFileSelectable(file);
            }

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!file.isDirectory() && !this.this$0.myProvider.acceptsExtension(file.getExtension())) {
                    return false;
                }
                return super.isFileVisible(file, showHiddenFiles);
            }
        };
        this.myFileIcon = provider.getFileIcon();
        this.myDirectoryIcon = AllIcons.Nodes.Folder;
        this.myProvider = provider;
        this.myProject = project;
        this.myFileTable = new JBTable();
        this.myFileTable.setShowGrid(false);
        this.myFileTable.setUpdateSelectionOnSort(true);
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)this.myFileTable).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List<AnAction> list2 = EditLibraryDialog.this.a();
                if (list2.isEmpty()) {
                    return;
                }
                DefaultActionGroup defaultActionGroup = new DefaultActionGroup(list2.toArray(AnAction.EMPTY_ARRAY));
                ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)defaultActionGroup, DataManager.getInstance().getDataContext((Component)button.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
                RelativePoint relativePoint = button.getPreferredPopupPoint();
                if (relativePoint != null) {
                    listPopup.show(relativePoint);
                } else {
                    listPopup.showInBestPositionFor(button.getDataContext());
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                EditLibraryDialog.this.f();
            }
        }).createPanel();
        this.myFilesPanel.add((Component)jPanel, "Center");
        this.setTitle(title);
        this.mySourceTypeName = Objects.requireNonNull(provider.getLibraryTypeName(OrderRootType.SOURCES));
        this.myCompactTypeName = Objects.requireNonNull(provider.getLibraryTypeName(OrderRootType.CLASSES));
        this.myFileTableModel = new FileTableModel();
        this.myFileTable.setRowHeight((int)((double)this.myFileTable.getRowHeight() * 1.2));
        this.myFileTable.setModel((TableModel)this.myFileTableModel);
        new TableSpeedSearch((JTable)this.myFileTable);
        this.myDocUrlListModel = new MyDocUrlListModel();
        this.myDocUrlList = new JBList((ListModel)this.myDocUrlListModel);
        this.myDocUrlListModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e10) {
                EditLibraryDialog.this.h();
            }

            @Override
            public void intervalRemoved(ListDataEvent e10) {
                Object object = e10.getSource();
                if (object instanceof MyDocUrlListModel && ((MyDocUrlListModel)object).getDocUrls().length == 0) {
                    EditLibraryDialog.this.h();
                }
            }

            @Override
            public void contentsChanged(ListDataEvent e10) {
            }
        });
        this.myDocUrlList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e10) {
                EditLibraryDialog.this.myEditDocUrlButton.setEnabled(EditLibraryDialog.this.myDocUrlList.getSelectedIndex() >= 0);
            }
        });
        this.myDownloadButton = new AnActionButton(WebCoreBundle.messagePointer((String)"action.AnActionButton.text.download", (Object[])new Object[0]), AllIcons.Actions.Download){
            private static final long a = la.a(8842564405877905836L, 8997215603453136493L, MethodHandles.lookup().lookupClass()).a(190586699699497L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    5.a(0);
                }
                EditLibraryDialog.this.e();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x5E431888D5F4L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$5", "actionPerformed"));
            }
        };
        this.myEditDocUrlButton = new AnActionButton(WebCoreBundle.messagePointer((String)"action.AnActionButton.text.edit", (Object[])new Object[0]), AllIcons.Actions.Edit){
            private static final long a = la.a(4671193555853924484L, -843597035125580708L, MethodHandles.lookup().lookupClass()).a(166789858762679L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    6.a(0);
                }
                EditLibraryDialog.this.i();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x3C25F36A5A69L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$6", "actionPerformed"));
            }
        };
        this.myUrlsPanel.add((Component)ToolbarDecorator.createDecorator(this.myDocUrlList).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditLibraryDialog.this.b();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditLibraryDialog.this.l();
            }
        }).addExtraAction(this.myEditDocUrlButton).addExtraAction(this.myDownloadButton).createPanel(), "Center");
        this.myDownloadButton.setEnabled(false);
        this.myEditDocUrlButton.setEnabled(false);
        this.g();
        this.myVersionField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e10) {
                EditLibraryDialog.this.d();
            }
        });
        this.init();
        TableColumn tableColumn = this.myFileTable.getColumnModel().getColumn(1);
        ScriptingLibrariesPanel.setColumnWidth(tableColumn, JBUI.scale((int)80));
        tableColumn.setCellEditor((TableCellEditor)((Object)new TypeCellEditor()));
        tableColumn.setCellRenderer(new DefaultTableCellRenderer(){
            private final JBComboBoxLabel myLabel = new JBComboBoxLabel();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                VirtualFilePointer virtualFilePointer = EditLibraryDialog.this.myFileTableModel.a(row);
                VirtualFile virtualFile = EditLibraryDialog.b(virtualFilePointer);
                if (virtualFile == null || virtualFile.isDirectory()) {
                    this.myLabel.setText("");
                    this.myLabel.setIcon(null);
                } else {
                    this.myLabel.setText(String.valueOf(value));
                    if (isSelected) {
                        this.myLabel.setSelectionIcon();
                    } else {
                        this.myLabel.setRegularIcon();
                    }
                }
                this.myLabel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                this.myLabel.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                return this.myLabel;
            }
        });
        TableColumn tableColumn2 = this.myFileTable.getColumnModel().getColumn(0);
        tableColumn2.setCellRenderer(new FileNameTableCellRenderer());
    }

    @NotNull
    private List<AnAction> a() {
        long l2 = a ^ 0xED47F811E30L;
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new AnAction[]{new AnAction(WebCoreBundle.message((String)"edit.library.attach.files.popup.title", (Object[])new Object[0]), null, this.myFileIcon){
            private static final long a = la.a(7951219136062340293L, 8209942745555034922L, MethodHandles.lookup().lookupClass()).a(242631824543193L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    11.a(0);
                }
                EditLibraryDialog.this.a();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x174644016C21L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$11", "actionPerformed"));
            }
        }, new AnAction(WebCoreBundle.message((String)"edit.library.attach.directories.popup.title", (Object[])new Object[0]), null, this.myDirectoryIcon){
            private static final long a = la.a(6950410845266858959L, -3429660017515628874L, MethodHandles.lookup().lookupClass()).a(277962958261897L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    12.a(0);
                }
                EditLibraryDialog.this.c();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x517F719560FDL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$12", "actionPerformed"));
            }
        }});
        if (arrayList == null) {
            EditLibraryDialog.a(0);
        }
        return arrayList;
    }

    public EditLibraryDialog(@NlsContexts.DialogTitle String title, LangScriptingContextProvider provider, Project project, ScriptingLibraryModel lib) {
        this(title, provider, project);
        this.myLibName.setText(lib.getName());
        this.myFileTableModel.setFiles(lib.getSourceFilePointers(), lib.getCompactFilePointers());
        Set set = lib.getDocUrls();
        this.myDocUrlListModel.setDocUrls(set);
        if (lib.getFrameworkDescriptor() != null) {
            this.a(lib.getFrameworkDescriptor());
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.myProjectRadioButton);
        buttonGroup.add(this.myGlobalRadioButton);
        if (lib.getLibraryLevel() == ScriptingLibraryModel.LibraryLevel.GLOBAL) {
            this.myGlobalRadioButton.setSelected(true);
        } else {
            this.myProjectRadioButton.setSelected(true);
        }
        this.h();
    }

    private void a(ScriptingFrameworkDescriptor scriptingFrameworkDescriptor) {
        this.mySelectedFramework = scriptingFrameworkDescriptor;
        this.myVersionField.setText(scriptingFrameworkDescriptor.getFrameworkVersion());
        for (int i10 = 0; i10 < this.myFrameworkCombo.getItemCount(); ++i10) {
            Object e10 = this.myFrameworkCombo.getItemAt(i10);
            if (!(e10 instanceof ScriptingFrameworkDescriptor) || !scriptingFrameworkDescriptor.getFrameworkName().equals(((ScriptingFrameworkDescriptor)e10).getFrameworkName())) continue;
            this.myFrameworkCombo.setSelectedItem(e10);
        }
    }

    private void h() {
        for (String string : this.getDocUrls()) {
            if (this.myProvider.getOfflineDocUrl(string) == null) continue;
            this.myDownloadButton.setEnabled(true);
            return;
        }
        this.myDownloadButton.setEnabled(false);
    }

    private void g() {
        long l2 = a ^ 0x204807B6864CL;
        ArrayList<String> arrayList = new ArrayList<String>();
        ScriptingFrameworkDescriptor[] scriptingFrameworkDescriptorArray = this.myProvider.getSupportedFrameworks(this.myProject);
        arrayList.add(WebCoreBundle.message((String)"library.edit.dialog.custom_framework_type.name", (Object[])new Object[0]));
        if (scriptingFrameworkDescriptorArray != null) {
            arrayList.addAll(Arrays.asList(scriptingFrameworkDescriptorArray));
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(arrayList));
        this.myFrameworkCombo.setModel(defaultComboBoxModel);
        this.myFrameworkCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                Object object = EditLibraryDialog.this.myFrameworkCombo.getSelectedItem();
                if (object instanceof ScriptingFrameworkDescriptor) {
                    String string = ((ScriptingFrameworkDescriptor)object).getFrameworkName();
                    if (EditLibraryDialog.this.mySelectedFramework == null || !string.equals(EditLibraryDialog.this.mySelectedFramework.getFrameworkName())) {
                        EditLibraryDialog.this.mySelectedFramework = new ScriptingFrameworkDescriptor(((ScriptingFrameworkDescriptor)object).getFrameworkName(), null);
                        EditLibraryDialog.this.myVersionField.setText("");
                    }
                } else {
                    EditLibraryDialog.this.mySelectedFramework = null;
                    EditLibraryDialog.this.myVersionField.setText("");
                }
            }
        });
    }

    private void e() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string : this.getDocUrls()) {
            String string2 = this.myProvider.getOfflineDocUrl(string);
            if (string2 == null) continue;
            linkedHashSet.add(string2);
        }
        this.a(new LinkedList<String>(linkedHashSet), this.getRootPane());
    }

    private void a(@NotNull Queue<String> queue, @Nullable Component component) {
        if (queue == null) {
            EditLibraryDialog.a(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String string = queue.poll();
        if (string != null) {
            this.myProvider.downloadOfflineDoc(this.myProject, string, component, (Consumer<? super File>)((Consumer)file -> {
                AtomicBoolean atomicBoolean = new AtomicBoolean(true);
                if (file != null) {
                    WriteAction.run(() -> {
                        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
                        if (virtualFile != null) {
                            atomicBoolean.set(false);
                            this.myDocUrlListModel.addUrl(virtualFile.getUrl());
                        }
                    });
                }
                if (atomicBoolean.get()) {
                    this.a(queue, component);
                }
            }));
        }
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    public String getLibName() {
        return this.myLibName.getText();
    }

    private void a() {
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)this.LIB_FILES_CHOOSER_DESCRIPTOR, (Project)this.myProject, null);
        if (virtualFileArray.length == 0) {
            return;
        }
        VfsUtilCore.DistinctVFilesRootsCollection distinctVFilesRootsCollection = new VfsUtilCore.DistinctVFilesRootsCollection(virtualFileArray);
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : distinctVFilesRootsCollection) {
            if (!virtualFile.isValid()) continue;
            if (virtualFile.isDirectory()) {
                this.a(virtualFile, arrayList);
                continue;
            }
            arrayList.add(virtualFile);
        }
        this.b(arrayList);
    }

    private void c() {
        long l2 = a ^ 0x11564F4C6D67L;
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createMultipleFoldersDescriptor();
        fileChooserDescriptor.setTitle(WebCoreBundle.message((String)"edit.library.dialog.attach.directories.dialog.title", (Object[])new Object[0]));
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)this.myProject, null);
        if (virtualFileArray.length == 0) {
            return;
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : virtualFileArray) {
            if (!virtualFile.isValid()) continue;
            arrayList.add(virtualFile);
        }
        this.b(arrayList);
    }

    private void b(@NotNull List<VirtualFile> list2) {
        if (list2 == null) {
            EditLibraryDialog.a(2);
        }
        this.a(ContainerUtil.map(list2, virtualFile -> new LightFilePointer(virtualFile)));
    }

    private void a(@NotNull List<VirtualFilePointer> list2) {
        if (list2 == null) {
            EditLibraryDialog.a(3);
        }
        list2.sort(FILE_COMPARATOR);
        int n2 = 0;
        for (VirtualFilePointer virtualFilePointer2 : list2) {
            this.a(virtualFilePointer2, n2++ == list2.size() - 1);
        }
        this.j();
        if (this.myLibName.getText().isEmpty() && !list2.isEmpty()) {
            list2.stream().map(virtualFilePointer -> virtualFilePointer.getFileName()).findFirst().ifPresent(string -> this.myLibName.setText((String)string));
        }
    }

    private void a(VirtualFile virtualFile, final Collection<VirtualFile> collection) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){
            private static final long a = la.a(5631058613447747375L, 3599259571205717352L, MethodHandles.lookup().lookupClass()).a(161297455939096L);

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    14.a(0);
                }
                if (file.isValid() && !file.isDirectory() && EditLibraryDialog.this.myProvider.acceptsExtension(file.getExtension())) {
                    collection.add(file);
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x59F0080C5CF4L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/libraries/ui/EditLibraryDialog$14", "visitFile"));
            }
        });
    }

    private void a(@NotNull VirtualFilePointer virtualFilePointer, boolean bl2) {
        if (virtualFilePointer == null) {
            EditLibraryDialog.a(4);
        }
        int n2 = this.myFileTableModel.a(virtualFilePointer);
        this.myFileTable.setRowSelectionInterval(n2, n2);
        if (bl2) {
            TableUtil.scrollSelectionToVisible((JTable)this.myFileTable);
        }
    }

    @Nullable
    private static VirtualFile b(@Nullable VirtualFilePointer virtualFilePointer) {
        return virtualFilePointer != null ? virtualFilePointer.getFile() : null;
    }

    private void f() {
        int[] nArray = this.myFileTable.getSelectedRows();
        ArrayList<VirtualFilePointer> arrayList = new ArrayList<VirtualFilePointer>();
        for (int n2 : nArray) {
            arrayList.add(this.myFileTableModel.a(n2));
        }
        this.myFileTableModel.a(arrayList);
    }

    @NotNull
    public List<String> getSourceFileUrls() {
        List list2 = ContainerUtil.map(this.myFileTableModel.a(), VirtualFilePointer::getUrl);
        if (list2 == null) {
            EditLibraryDialog.a(5);
        }
        return list2;
    }

    @NotNull
    public List<String> getCompactFileUrls() {
        List list2 = ContainerUtil.map(this.myFileTableModel.getCompactFilePointers(), VirtualFilePointer::getUrl);
        if (list2 == null) {
            EditLibraryDialog.a(6);
        }
        return list2;
    }

    public String[] getDocUrls() {
        return this.myDocUrlListModel.getDocUrls();
    }

    protected void doOKAction() {
        long l2 = a ^ 0x1F20A200D93AL;
        if (!EditLibraryDialog.a(this.myLibName.getText())) {
            Messages.showErrorDialog((Project)this.myProject, (String)WebCoreBundle.message((String)"scripting.lib.invalid.name", (Object[])new Object[0]), (String)WebCoreBundle.message((String)"dialog.title.error", (Object[])new Object[0]));
            return;
        }
        super.doOKAction();
    }

    private static boolean a(String string) {
        long l2 = a ^ 0x6345ED7B646FL;
        return string != null && string.matches("\\w[\\w\\d\\._\\-\\d ]*");
    }

    private void i() {
        String string = (String)this.myDocUrlList.getSelectedValue();
        int n2 = this.myDocUrlList.getSelectedIndex();
        VirtualFile virtualFile = Util.showSpecifyJavadocUrlDialog((JComponent)this.contentPane, (String)string);
        if (virtualFile != null && virtualFile.isValid()) {
            String string2 = virtualFile.getUrl();
            this.myDocUrlListModel.replaceUrl(string, string2);
            this.myDocUrlList.ensureIndexIsVisible(n2);
            this.myDocUrlList.setSelectedIndex(n2);
            this.h();
        }
    }

    private void b() {
        VirtualFile virtualFile;
        String string = null;
        if (this.mySelectedFramework == null) {
            this.j();
        }
        if (this.mySelectedFramework != null) {
            string = this.a();
        }
        if ((virtualFile = Util.showSpecifyJavadocUrlDialog((JComponent)this.contentPane, (String)(string != null ? string : ""))) != null && virtualFile.isValid()) {
            String string2 = virtualFile.getUrl();
            int n2 = this.myDocUrlListModel.addUrl(string2);
            this.myDocUrlList.ensureIndexIsVisible(n2);
            this.myDocUrlList.setSelectedIndex(n2);
            this.h();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myLibName;
    }

    @Nullable
    private String a() {
        String string = this.myProvider.getDefaultDocUrl(this.mySelectedFramework);
        if (string != null && !this.myDocUrlListModel.contains(string)) {
            return string;
        }
        return null;
    }

    private void l() {
        this.myDocUrlListModel.remove((String)this.myDocUrlList.getSelectedValue());
    }

    @Nullable
    public ScriptingFrameworkDescriptor getSelectedFramework() {
        return this.mySelectedFramework;
    }

    private void j() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(ContainerUtil.map(this.myFileTableModel.getCompactFilePointers(), virtualFilePointer -> virtualFilePointer.getFile()));
        arrayList.addAll(ContainerUtil.map(this.myFileTableModel.a(), virtualFilePointer -> virtualFilePointer.getFile()));
        for (VirtualFile virtualFile : arrayList) {
            ScriptingFrameworkDescriptor scriptingFrameworkDescriptor = this.myProvider.detectFramework(virtualFile);
            if (scriptingFrameworkDescriptor == null) continue;
            this.myVersionField.setText(scriptingFrameworkDescriptor.getFrameworkVersion());
            this.a(scriptingFrameworkDescriptor);
            if (this.myLibName.getText().isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(scriptingFrameworkDescriptor.getFrameworkName());
                if (scriptingFrameworkDescriptor.getFrameworkVersion() != null) {
                    stringBuilder.append(' ').append(scriptingFrameworkDescriptor.getFrameworkVersion());
                }
                this.myLibName.setText(stringBuilder.toString());
            }
            return;
        }
    }

    private void d() {
        if (this.mySelectedFramework != null) {
            this.mySelectedFramework.setFrameworkVersion(this.myVersionField.getText());
        }
    }

    @NotNull
    public ScriptingLibraryModel.LibraryLevel getLibraryLevel() {
        ScriptingLibraryModel.LibraryLevel libraryLevel = this.myGlobalRadioButton.isSelected() ? ScriptingLibraryModel.LibraryLevel.GLOBAL : ScriptingLibraryModel.LibraryLevel.PROJECT;
        if (libraryLevel == null) {
            EditLibraryDialog.a(7);
        }
        return libraryLevel;
    }

    static {
        a = la.a(6152767953798931330L, 6965348807746915025L, MethodHandles.lookup().lookupClass()).a(159840264462898L);
        FILE_COMPARATOR = (virtualFilePointer, virtualFilePointer2) -> virtualFilePointer.getUrl().compareToIgnoreCase(virtualFilePointer2.getUrl());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x506F31988342L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ui/EditLibraryDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToAdd";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddFilesActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ui/EditLibraryDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFileUrls";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompactFileUrls";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryLevel";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processUrlQueue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addVirtualFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFilePointers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSingleFilePointer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void k() {
        JPanel jPanel;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JTextField jTextField;
        JComboBox jComboBox;
        JTextField jTextField2;
        JPanel jPanel3;
        long l2 = a ^ 0x6DEAA93570CL;
        this.contentPane = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.myLibName = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.a(jLabel, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("scripting.lib.name"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.a(jLabel2, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("library.edit.dialog.framework_type.name"));
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFrameworkCombo = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.a(jLabel3, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("library.edit.dialog.version.name"));
        jPanel4.add((Component)jLabel3, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVersionField = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(55, -1), new Dimension(55, -1)));
        JLabel jLabel4 = new JLabel();
        this.a(jLabel4, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("library.edit.dialog.visibility.name"));
        jPanel4.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 1, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myProjectRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.a(jRadioButton2, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("library.level.project.name"));
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myGlobalRadioButton = jRadioButton = new JRadioButton();
        this.a(jRadioButton, DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("library.level.global.name"));
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(1, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myFilesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 7, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 2, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/WebCoreBundle", EditLibraryDialog.class).getString("scripting.lib.docUrl.title"), (int)0, (int)0, null, null));
        this.myUrlsPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void a(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c10 = '\u0000';
        int n2 = -1;
        for (int i10 = 0; i10 < string.length(); ++i10) {
            if (string.charAt(i10) == '&') {
                if (++i10 == string.length()) break;
                if (!bl2 && string.charAt(i10) != '&') {
                    bl2 = true;
                    c10 = string.charAt(i10);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i10));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl2) {
            jLabel.setDisplayedMnemonic(c10);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private /* synthetic */ void a(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c10 = '\u0000';
        int n2 = -1;
        for (int i10 = 0; i10 < string.length(); ++i10) {
            if (string.charAt(i10) == '&') {
                if (++i10 == string.length()) break;
                if (!bl2 && string.charAt(i10) != '&') {
                    bl2 = true;
                    c10 = string.charAt(i10);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i10));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl2) {
            abstractButton.setMnemonic(c10);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }

    private static class MyDocUrlListModel
    extends AbstractListModel<String> {
        private final List<String> myDocUrls = new ArrayList<String>();

        private MyDocUrlListModel() {
        }

        public void setDocUrls(Set<String> urls) {
            if (urls != null && urls.size() > 0) {
                this.myDocUrls.addAll(urls);
            }
        }

        @Override
        public int getSize() {
            return this.myDocUrls.size();
        }

        @Override
        public String getElementAt(int index) {
            return this.myDocUrls.get(index);
        }

        public int addUrl(String url) {
            if (!this.myDocUrls.contains(url)) {
                this.myDocUrls.add(url);
                int n2 = this.myDocUrls.indexOf(url);
                this.fireIntervalAdded(this, n2, n2);
                return n2;
            }
            return this.myDocUrls.indexOf(url);
        }

        public void replaceUrl(String oldUrl, String newUrl) {
            if (oldUrl == null || !this.myDocUrls.contains(oldUrl)) {
                return;
            }
            int n2 = this.myDocUrls.indexOf(oldUrl);
            this.myDocUrls.remove(oldUrl);
            this.myDocUrls.add(n2, newUrl);
        }

        public int indexOf(String url) {
            return this.myDocUrls.indexOf(url);
        }

        public void remove(String url) {
            if (url == null || !this.myDocUrls.contains(url)) {
                return;
            }
            int n2 = this.myDocUrls.indexOf(url);
            this.myDocUrls.remove(url);
            this.fireIntervalRemoved(this, n2, n2);
        }

        public boolean contains(String url) {
            return this.myDocUrls.contains(url);
        }

        public String[] getDocUrls() {
            return ArrayUtilRt.toStringArray(this.myDocUrls);
        }
    }

    private class FileTableModel
    extends AbstractTableModel {
        private final SortedList<VirtualFilePointer> myFilePointers = new SortedList(FILE_COMPARATOR);
        private final Set<VirtualFilePointer> myCompactFilePointers = new HashSet<VirtualFilePointer>();
        private static final long a = la.a(-8453479928255211095L, 3117289330201663381L, MethodHandles.lookup().lookupClass()).a(38654167241121L);

        private FileTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            long l2 = a ^ 0x7A871A176960L;
            switch (column) {
                case 0: {
                    return WebCoreBundle.message((String)"scripting.lib.file.name", (Object[])new Object[0]);
                }
                case 1: {
                    return WebCoreBundle.message((String)"scripting.lib.file.type", (Object[])new Object[0]);
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            VirtualFilePointer virtualFilePointer;
            VirtualFile virtualFile;
            return columnIndex == 1 && (virtualFile = EditLibraryDialog.b(virtualFilePointer = this.a(rowIndex))) != null && !virtualFile.isDirectory();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            VirtualFilePointer virtualFilePointer;
            if (columnIndex == 1 && (virtualFilePointer = EditLibraryDialog.this.myFileTableModel.a(rowIndex)) != null && aValue instanceof String) {
                this.a(virtualFilePointer, EditLibraryDialog.this.myCompactTypeName.equals(aValue));
            }
        }

        private int a(@NotNull VirtualFilePointer virtualFilePointer) {
            int n2;
            if (virtualFilePointer == null) {
                FileTableModel.a(0);
            }
            if ((n2 = this.myFilePointers.indexOf((Object)virtualFilePointer)) == -1) {
                this.myFilePointers.add((Object)virtualFilePointer);
                VirtualFile virtualFile = virtualFilePointer.getFile();
                if (virtualFile != null && !virtualFile.isDirectory() && EditLibraryDialog.this.myProvider.isCompact(virtualFile)) {
                    this.myCompactFilePointers.add(virtualFilePointer);
                }
                this.fireTableDataChanged();
                n2 = this.myFilePointers.indexOf((Object)virtualFilePointer);
            }
            return n2;
        }

        public void setFiles(@NotNull Set<VirtualFilePointer> sourceFilePointers, @NotNull Set<VirtualFilePointer> compactFilePointers) {
            if (sourceFilePointers == null) {
                FileTableModel.a(1);
            }
            if (compactFilePointers == null) {
                FileTableModel.a(2);
            }
            this.myFilePointers.clear();
            this.myFilePointers.addAll(sourceFilePointers);
            this.myFilePointers.addAll(compactFilePointers);
            for (VirtualFilePointer virtualFilePointer : sourceFilePointers) {
                this.a(virtualFilePointer, false, false);
            }
            for (VirtualFilePointer virtualFilePointer : compactFilePointers) {
                this.a(virtualFilePointer, true, false);
            }
        }

        private void a(@NotNull VirtualFilePointer virtualFilePointer, boolean bl2) {
            if (virtualFilePointer == null) {
                FileTableModel.a(3);
            }
            this.a(virtualFilePointer, bl2, true);
        }

        private void a(@NotNull VirtualFilePointer virtualFilePointer, boolean bl2, boolean bl3) {
            if (virtualFilePointer == null) {
                FileTableModel.a(4);
            }
            boolean bl4 = false;
            VirtualFile virtualFile = virtualFilePointer.getFile();
            if (virtualFile != null && virtualFile.isValid() && virtualFile.isDirectory()) {
                bl2 = false;
            }
            if (bl2) {
                if (!this.myCompactFilePointers.contains(virtualFilePointer)) {
                    this.myCompactFilePointers.add(virtualFilePointer);
                    bl4 = true;
                }
            } else if (this.myCompactFilePointers.contains(virtualFilePointer)) {
                this.myCompactFilePointers.remove(virtualFilePointer);
                bl4 = true;
            }
            if (bl4 && bl3) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public int getRowCount() {
            return this.myFilePointers.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            VirtualFilePointer virtualFilePointer = (VirtualFilePointer)this.myFilePointers.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return virtualFilePointer.getFileName();
                }
                case 1: {
                    return this.myCompactFilePointers.contains(virtualFilePointer) ? EditLibraryDialog.this.myCompactTypeName : EditLibraryDialog.this.mySourceTypeName;
                }
            }
            return "";
        }

        @Nullable
        private VirtualFilePointer a(int n2) {
            if (n2 < 0 || n2 >= this.myFilePointers.size()) {
                return null;
            }
            return (VirtualFilePointer)this.myFilePointers.get(n2);
        }

        private void a(@NotNull List<VirtualFilePointer> list2) {
            if (list2 == null) {
                FileTableModel.a(5);
            }
            if (this.myFilePointers.removeAll(list2)) {
                this.fireTableDataChanged();
            }
        }

        @NotNull
        private List<VirtualFilePointer> a(boolean bl2) {
            ArrayList<VirtualFilePointer> arrayList = new ArrayList<VirtualFilePointer>();
            for (VirtualFilePointer virtualFilePointer : this.myFilePointers) {
                if (this.myCompactFilePointers.contains(virtualFilePointer) != bl2) continue;
                arrayList.add(virtualFilePointer);
            }
            ArrayList<VirtualFilePointer> arrayList2 = arrayList;
            if (arrayList2 == null) {
                FileTableModel.a(6);
            }
            return arrayList2;
        }

        @NotNull
        public List<VirtualFilePointer> getCompactFilePointers() {
            return this.a(true);
        }

        @NotNull
        private List<VirtualFilePointer> a() {
            return this.a(false);
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = a ^ 0x7119152D98E7L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 6: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePointer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFilePointers";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compactFilePointers";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePointers";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/libraries/ui/EditLibraryDialog$FileTableModel";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/libraries/ui/EditLibraryDialog$FileTableModel";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePointers";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addFilePointer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setFiles";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setFileType";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeFilePointers";
                    break;
                }
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class TypeCellEditor
    extends AbstractTableCellEditor {
        private final JBComboBoxTableCellEditorComponent myEditorComponent = new JBComboBoxTableCellEditorComponent();

        TypeCellEditor() {
            this.myEditorComponent.setOptions(new Object[]{EditLibraryDialog.this.mySourceTypeName, EditLibraryDialog.this.myCompactTypeName});
            this.myEditorComponent.setToString(object -> (String)object);
        }

        public Object getCellEditorValue() {
            return this.myEditorComponent.getEditorValue();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            VirtualFilePointer virtualFilePointer = EditLibraryDialog.this.myFileTableModel.a(row);
            this.myEditorComponent.setCell(table, row, column);
            if (virtualFilePointer != null) {
                Object object = EditLibraryDialog.this.myFileTableModel.getValueAt(row, 1);
                this.myEditorComponent.setDefaultValue(object);
            }
            return this.myEditorComponent;
        }
    }

    private class FileNameTableCellRenderer
    extends DefaultTableCellRenderer {
        private FileNameTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(null);
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            VirtualFilePointer virtualFilePointer = EditLibraryDialog.this.myFileTableModel.a(row);
            if (virtualFilePointer != null) {
                this.setToolTipText(virtualFilePointer.getPresentableUrl());
                VirtualFile virtualFile = EditLibraryDialog.b(virtualFilePointer);
                this.setIcon(virtualFile == null ? AllIcons.FileTypes.Unknown : (virtualFile.isDirectory() ? EditLibraryDialog.this.myDirectoryIcon : EditLibraryDialog.this.myFileIcon));
                if (!(virtualFile != null && virtualFile.isValid() || isSelected)) {
                    this.setForeground((Color)JBColor.red);
                }
            }
            this.setBorder(null);
            return component;
        }
    }
}

