/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.UserConfig;
import org.languagetool.chunking.Chunker;
import org.languagetool.chunking.EnglishChunker;
import org.languagetool.language.AmericanEnglish;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.BERTSuggestionRanking;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.EmptyLineRule;
import org.languagetool.rules.Example;
import org.languagetool.rules.GRPCRule;
import org.languagetool.rules.LongParagraphRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.MultipleWhitespaceRule;
import org.languagetool.rules.ParagraphRepeatBeginningRule;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd2;
import org.languagetool.rules.ReadabilityRule;
import org.languagetool.rules.RemoteRuleConfig;
import org.languagetool.rules.Rule;
import org.languagetool.rules.SentenceWhitespaceRule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhiteSpaceAtBeginOfParagraph;
import org.languagetool.rules.WhiteSpaceBeforeParagraphEnd;
import org.languagetool.rules.en.AvsAnRule;
import org.languagetool.rules.en.CompoundRule;
import org.languagetool.rules.en.ConsistentApostrophesRule;
import org.languagetool.rules.en.ContractionSpellingRule;
import org.languagetool.rules.en.EnglishConfusionProbabilityRule;
import org.languagetool.rules.en.EnglishDashRule;
import org.languagetool.rules.en.EnglishDiacriticsRule;
import org.languagetool.rules.en.EnglishForDutchmenFalseFriendRule;
import org.languagetool.rules.en.EnglishForFrenchFalseFriendRule;
import org.languagetool.rules.en.EnglishForGermansFalseFriendRule;
import org.languagetool.rules.en.EnglishForSpaniardsFalseFriendRule;
import org.languagetool.rules.en.EnglishNgramProbabilityRule;
import org.languagetool.rules.en.EnglishPlainEnglishRule;
import org.languagetool.rules.en.EnglishRedundancyRule;
import org.languagetool.rules.en.EnglishUnpairedBracketsRule;
import org.languagetool.rules.en.EnglishWordRepeatBeginningRule;
import org.languagetool.rules.en.EnglishWordRepeatRule;
import org.languagetool.rules.en.EnglishWrongWordInContextRule;
import org.languagetool.rules.en.SimpleReplaceRule;
import org.languagetool.rules.en.SpecificCaseRule;
import org.languagetool.rules.en.UpperCaseNgramRule;
import org.languagetool.rules.en.WordCoherencyRule;
import org.languagetool.rules.neuralnetwork.NeuralNetworkRuleCreator;
import org.languagetool.rules.neuralnetwork.Word2VecModel;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.en.EnglishSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.en.EnglishHybridDisambiguator;
import org.languagetool.tagging.en.EnglishTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.en.EnglishWordTokenizer;

public class English
extends Language
implements AutoCloseable {
    private static final LoadingCache<String, List<Rule>> cache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, List<Rule>>(){

        public List<Rule> load(@NotNull String path) throws IOException {
            ArrayList<Rule> rules = new ArrayList<Rule>();
            PatternRuleLoader loader = new PatternRuleLoader();
            try (InputStream is = JLanguageTool.getDataBroker().getAsStream(path);){
                rules.addAll(loader.getRules(is, path));
            }
            return rules;
        }
    });
    private static final Language AMERICAN_ENGLISH = new AmericanEnglish();
    private LanguageModel languageModel;

    @Deprecated
    public English() {
    }

    public Language getDefaultLanguageVariant() {
        return AMERICAN_ENGLISH;
    }

    public SentenceTokenizer createDefaultSentenceTokenizer() {
        return new SRXSentenceTokenizer((Language)this);
    }

    public String getName() {
        return "English";
    }

    public String getShortCode() {
        return "en";
    }

    public String[] getCountries() {
        return new String[0];
    }

    @NotNull
    public Tagger createDefaultTagger() {
        return EnglishTagger.INSTANCE;
    }

    @Nullable
    public Chunker createDefaultChunker() {
        return new EnglishChunker();
    }

    @Nullable
    public Synthesizer createDefaultSynthesizer() {
        return new EnglishSynthesizer(this);
    }

    public Disambiguator createDefaultDisambiguator() {
        return new EnglishHybridDisambiguator();
    }

    public Tokenizer createDefaultWordTokenizer() {
        return new EnglishWordTokenizer();
    }

    public synchronized LanguageModel getLanguageModel(File indexDir) throws IOException {
        this.languageModel = this.initLanguageModel(indexDir, this.languageModel);
        return this.languageModel;
    }

    public synchronized Word2VecModel getWord2VecModel(File indexDir) throws IOException {
        return new Word2VecModel(indexDir + File.separator + this.getShortCode());
    }

    public Contributor[] getMaintainers() {
        return new Contributor[]{new Contributor("Mike Unwalla"), Contributors.MARCIN_MILKOWSKI, Contributors.DANIEL_NABER};
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.ActivelyMaintained;
    }

    public List<Rule> getRelevantRules(ResourceBundle messages, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        ArrayList<Rule> allRules = new ArrayList<Rule>();
        if (motherTongue != null) {
            if ("de".equals(motherTongue.getShortCode())) {
                allRules.addAll((Collection)cache.getUnchecked((Object)"/org/languagetool/rules/en/grammar-l2-de.xml"));
            } else if ("fr".equals(motherTongue.getShortCode())) {
                allRules.addAll((Collection)cache.getUnchecked((Object)"/org/languagetool/rules/en/grammar-l2-fr.xml"));
            }
        }
        allRules.addAll(Arrays.asList(new Rule[]{new CommaWhitespaceRule(messages, Example.wrong((String)"We had coffee<marker> ,</marker> cheese and crackers and grapes."), Example.fixed((String)"We had coffee<marker>,</marker> cheese and crackers and grapes.")), new DoublePunctuationRule(messages), new UppercaseSentenceStartRule(messages, (Language)this, Example.wrong((String)"This house is old. <marker>it</marker> was built in 1950."), Example.fixed((String)"This house is old. <marker>It</marker> was built in 1950.")), new MultipleWhitespaceRule(messages, (Language)this), new SentenceWhitespaceRule(messages), new WhiteSpaceBeforeParagraphEnd(messages, (Language)this), new WhiteSpaceAtBeginOfParagraph(messages), new EmptyLineRule(messages, (Language)this), new LongSentenceRule(messages, userConfig, 40), new LongParagraphRule(messages, (Language)this, userConfig), new ParagraphRepeatBeginningRule(messages, (Language)this), new PunctuationMarkAtParagraphEnd(messages, (Language)this), new PunctuationMarkAtParagraphEnd2(messages, (Language)this), new ConsistentApostrophesRule(messages), new SpecificCaseRule(messages), new EnglishUnpairedBracketsRule(messages, this), new EnglishWordRepeatRule(messages, this), new AvsAnRule(messages), new EnglishWordRepeatBeginningRule(messages, this), new CompoundRule(messages), new ContractionSpellingRule(messages), new EnglishWrongWordInContextRule(messages), new EnglishDashRule(messages), new WordCoherencyRule(messages), new EnglishDiacriticsRule(messages), new EnglishPlainEnglishRule(messages), new EnglishRedundancyRule(messages), new SimpleReplaceRule(messages, this), new ReadabilityRule(messages, (Language)this, userConfig, false), new ReadabilityRule(messages, (Language)this, userConfig, true)}));
        return allRules;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel, UserConfig userConfig) throws IOException {
        return Arrays.asList(new Rule[]{new UpperCaseNgramRule(messages, languageModel, this, userConfig), new EnglishConfusionProbabilityRule(messages, languageModel, this), new EnglishNgramProbabilityRule(messages, languageModel, this)});
    }

    public List<Rule> getRelevantLanguageModelCapableRules(ResourceBundle messages, @Nullable LanguageModel lm, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        if (lm != null && motherTongue != null && "fr".equals(motherTongue.getShortCode())) {
            return Arrays.asList(new Rule[]{new EnglishForFrenchFalseFriendRule(messages, lm, motherTongue, this)});
        }
        if (lm != null && motherTongue != null && "de".equals(motherTongue.getShortCode())) {
            return Arrays.asList(new Rule[]{new EnglishForGermansFalseFriendRule(messages, lm, motherTongue, this)});
        }
        if (lm != null && motherTongue != null && "es".equals(motherTongue.getShortCode())) {
            return Arrays.asList(new Rule[]{new EnglishForSpaniardsFalseFriendRule(messages, lm, motherTongue, this)});
        }
        if (lm != null && motherTongue != null && "nl".equals(motherTongue.getShortCode())) {
            return Arrays.asList(new Rule[]{new EnglishForDutchmenFalseFriendRule(messages, lm, motherTongue, this)});
        }
        return Arrays.asList(new Rule[0]);
    }

    public boolean hasNGramFalseFriendRule(Language motherTongue) {
        return motherTongue != null && ("de".equals(motherTongue.getShortCode()) || "fr".equals(motherTongue.getShortCode()) || "es".equals(motherTongue.getShortCode()) || "nl".equals(motherTongue.getShortCode()));
    }

    public List<Rule> getRelevantWord2VecModelRules(ResourceBundle messages, Word2VecModel word2vecModel) throws IOException {
        return NeuralNetworkRuleCreator.createRules((ResourceBundle)messages, (Language)this, (Word2VecModel)word2vecModel);
    }

    public String getOpeningDoubleQuote() {
        return "\u201c";
    }

    public String getClosingDoubleQuote() {
        return "\u201d";
    }

    public String getOpeningSingleQuote() {
        return "\u2018";
    }

    public String getClosingSingleQuote() {
        return "\u2019";
    }

    public boolean isAdvancedTypographyEnabled() {
        return true;
    }

    @Override
    public void close() throws Exception {
        if (this.languageModel != null) {
            this.languageModel.close();
        }
    }

    protected int getPriorityForId(String id) {
        switch (id) {
            case "I_E": {
                return 10;
            }
            case "EN_DIACRITICS_REPLACE": {
                return 9;
            }
            case "CHILDISH_LANGUAGE": {
                return 8;
            }
            case "RUDE_SARCASTIC": {
                return 6;
            }
            case "FOR_NOUN_SAKE": {
                return 6;
            }
            case "YEAR_OLD_HYPHEN": {
                return 6;
            }
            case "MISSING_HYPHEN": {
                return 5;
            }
            case "TRANSLATION_RULE": {
                return 5;
            }
            case "WRONG_APOSTROPHE": {
                return 5;
            }
            case "DOS_AND_DONTS": {
                return 3;
            }
            case "EN_COMPOUNDS": {
                return 2;
            }
            case "ABBREVIATION_PUNCTUATION": {
                return 2;
            }
            case "FEDEX": {
                return 2;
            }
            case "LIFE_COMPOUNDS": {
                return 1;
            }
            case "CAUSE_COURSE": {
                return 1;
            }
            case "AN_AND": {
                return 1;
            }
            case "HER_S": {
                return 1;
            }
            case "COVID_19": {
                return 1;
            }
            case "OTHER_WISE_COMPOUND": {
                return 1;
            }
            case "ON_EXCEL": {
                return 1;
            }
            case "IF_VB_PCT": {
                return 1;
            }
            case "CAUSE_BECAUSE": {
                return 1;
            }
            case "MAY_MANY": {
                return 1;
            }
            case "BOUT_TO": {
                return 1;
            }
            case "HAVE_HAVE": {
                return 1;
            }
            case "LUV": {
                return 1;
            }
            case "DAT": {
                return 1;
            }
            case "MAC_OS": {
                return 1;
            }
            case "BESTEST": {
                return 1;
            }
            case "OFF_OF": {
                return 1;
            }
            case "SHELL_COMPOUNDS": {
                return 1;
            }
            case "HANDS_ON_HYPHEN": {
                return 1;
            }
            case "QUIET_QUITE": {
                return 1;
            }
            case "A_OK": {
                return 1;
            }
            case "I_A": {
                return 1;
            }
            case "GOT_GO": {
                return 1;
            }
            case "THERE_FORE": {
                return 1;
            }
            case "PRP_NO_VB": {
                return 1;
            }
            case "FOLLOW_UP": {
                return 1;
            }
            case "IT_SOMETHING": {
                return 1;
            }
            case "NO_KNOW": {
                return 1;
            }
            case "WILL_BASED_ON": {
                return 1;
            }
            case "DON_T_AREN_T": {
                return 1;
            }
            case "WILL_BECOMING": {
                return 1;
            }
            case "WOULD_NEVER_VBN": {
                return 1;
            }
            case "MD_APPRECIATED": {
                return 1;
            }
            case "MONEY_BACK_HYPHEN": {
                return 1;
            }
            case "WORLDS_BEST": {
                return 1;
            }
            case "STEP_COMPOUNDS": {
                return 1;
            }
            case "WON_T_TO": {
                return 1;
            }
            case "WAN_T": {
                return 1;
            }
            case "THE_US": {
                return 1;
            }
            case "THE_IT": {
                return 1;
            }
            case "THANK_YOU_MUCH": {
                return 1;
            }
            case "TO_DO_HYPHEN": {
                return 1;
            }
            case "A_NUMBER_NNS": {
                return 1;
            }
            case "A_HUNDREDS": {
                return 1;
            }
            case "NOW_A_DAYS": {
                return 1;
            }
            case "COUPLE_OF_TIMES": {
                return 1;
            }
            case "A_WINDOWS": {
                return 1;
            }
            case "A_SCISSOR": {
                return 1;
            }
            case "A_SNICKERS": {
                return 1;
            }
            case "ROUND_A_BOUT": {
                return 1;
            }
            case "A_NNS_BEST_NN": {
                return 1;
            }
            case "A_BACHELORS_IN": {
                return 1;
            }
            case "NEITHER_NOR": {
                return 1;
            }
            case "FOR_AWHILE": {
                return 1;
            }
            case "A_BUT": {
                return 1;
            }
            case "MAY_BE": {
                return 1;
            }
            case "BORN_IN": {
                return 1;
            }
            case "DO_TO": {
                return 1;
            }
            case "CURIOS_CURIOUS": {
                return 1;
            }
            case "INCORRECT_POSSESSIVE_APOSTROPHE": {
                return 1;
            }
            case "THIS_YEARS_POSSESSIVE_APOSTROPHE": {
                return 1;
            }
            case "SPURIOUS_APOSTROPHE": {
                return 1;
            }
            case "IN_THIS_REGARDS": {
                return 1;
            }
            case "NO_WHERE": {
                return 1;
            }
            case "APOSTROPHE_VS_QUOTE": {
                return 1;
            }
            case "COMMA_PERIOD": {
                return 1;
            }
            case "HERE_HEAR": {
                return 1;
            }
            case "LIGATURES": {
                return 1;
            }
            case "APPSTORE": {
                return 1;
            }
            case "INCORRECT_CONTRACTIONS": {
                return 1;
            }
            case "DONT_T": {
                return 1;
            }
            case "WHATS_APP": {
                return 1;
            }
            case "NON_STANDARD_COMMA": {
                return 1;
            }
            case "NON_STANDARD_ALPHABETIC_CHARACTERS": {
                return 1;
            }
            case "WONT_CONTRACTION": {
                return 1;
            }
            case "YOU_GOOD": {
                return 1;
            }
            case "THAN_THANK": {
                return 1;
            }
            case "CD_NN_APOSTROPHE_S": {
                return 1;
            }
            case "IT_IF": {
                return 1;
            }
            case "FINE_TUNE_COMPOUNDS": {
                return 1;
            }
            case "WHAT_IS_YOU": {
                return 1;
            }
            case "SUPPOSE_TO": {
                return 1;
            }
            case "SEEN_SEEM": {
                return 1;
            }
            case "PROFANITY": {
                return 1;
            }
            case "THE_THEM": {
                return 1;
            }
            case "THERE_THEIR": {
                return 1;
            }
            case "IT_IS_DEPENDING_ON": {
                return 1;
            }
            case "IRREGARDLESS": {
                return 1;
            }
            case "LOOK_FORWARD_TO": {
                return 1;
            }
            case "LOOK_SLIKE": {
                return 1;
            }
            case "MISSING_GENITIVE": {
                return -1;
            }
            case "EN_UNPAIRED_BRACKETS": {
                return -1;
            }
            case "NEEDS_FIXED": {
                return -1;
            }
            case "BLACK_SEA": {
                return -1;
            }
            case "A_TO": {
                return -1;
            }
            case "MANY_NN": {
                return -1;
            }
            case "WE_BE": {
                return -1;
            }
            case "A_LOT_OF_NN": {
                return -1;
            }
            case "IT_VBZ": {
                return -1;
            }
            case "ORDER_OF_WORDS_WITH_NOT": {
                return -1;
            }
            case "ADVERB_WORD_ORDER_10_TEMP": {
                return 1;
            }
            case "ADVERB_WORD_ORDER": {
                return -1;
            }
            case "IT_IS_2": {
                return -1;
            }
            case "A_RB_NN": {
                return -1;
            }
            case "DT_RB_IN": {
                return -1;
            }
            case "VERB_NOUN_CONFUSION": {
                return -1;
            }
            case "NOUN_VERB_CONFUSION": {
                return -1;
            }
            case "PLURAL_VERB_AFTER_THIS": {
                return -1;
            }
            case "BE_RB_BE": {
                return -1;
            }
            case "IT_ITS": {
                return -1;
            }
            case "ENGLISH_WORD_REPEAT_RULE": {
                return -1;
            }
            case "PRP_MD_NN": {
                return -1;
            }
            case "NON_ANTI_PRE_JJ": {
                return -1;
            }
            case "DT_JJ_NO_NOUN": {
                return -1;
            }
            case "AGREEMENT_SENT_START": {
                return -1;
            }
            case "HAVE_PART_AGREEMENT": {
                return -1;
            }
            case "PREPOSITION_VERB": {
                return -1;
            }
            case "EN_A_VS_AN": {
                return -1;
            }
            case "CD_NN": {
                return -1;
            }
            case "ATD_VERBS_TO_COLLOCATION": {
                return -1;
            }
            case "ADVERB_OR_HYPHENATED_ADJECTIVE": {
                return -1;
            }
            case "GOING_TO_VBD": {
                return -1;
            }
            case "MISSING_PREPOSITION": {
                return -1;
            }
            case "BE_TO_VBG": {
                return -1;
            }
            case "NON3PRS_VERB": {
                return -1;
            }
            case "DID_FOUND_AMBIGUOUS": {
                return -1;
            }
            case "BE_I_BE_GERUND": {
                return -1;
            }
            case "VBZ_VBD": {
                return -1;
            }
            case "SUPERLATIVE_THAN": {
                return -1;
            }
            case "UNLIKELY_OPENING_PUNCTUATION": {
                return -1;
            }
            case "METRIC_UNITS_EN_IMPERIAL": {
                return -1;
            }
            case "METRIC_UNITS_EN_GB": {
                return -1;
            }
            case "COMMA_COMPOUND_SENTENCE": {
                return -1;
            }
            case "COMMA_COMPOUND_SENTENCE_2": {
                return -1;
            }
            case "REPEATED_VERBS": {
                return -1;
            }
            case "PRP_RB_NO_VB": {
                return -2;
            }
            case "PRP_VBG": {
                return -2;
            }
            case "PRP_VBZ": {
                return -2;
            }
            case "PRP_VB": {
                return -2;
            }
            case "BE_VBP_IN": {
                return -2;
            }
            case "BEEN_PART_AGREEMENT": {
                return -3;
            }
            case "A_INFINITIVE": {
                return -3;
            }
            case "HE_VERB_AGR": {
                return -3;
            }
            case "PRP_JJ": {
                return -3;
            }
            case "PRONOUN_NOUN": {
                return -3;
            }
            case "INDIAN_ENGLISH": {
                return -3;
            }
            case "GONNA_TEMP": {
                return -3;
            }
            case "PRP_THE": {
                return -4;
            }
            case "GONNA": {
                return -4;
            }
            case "WHATCHA": {
                return -4;
            }
            case "DONTCHA": {
                return -4;
            }
            case "GOTCHA": {
                return -4;
            }
            case "OUTTA": {
                return -4;
            }
            case "Y_ALL": {
                return -4;
            }
            case "GIMME": {
                return -4;
            }
            case "LEMME": {
                return -4;
            }
            case "MORFOLOGIK_RULE_EN_US": {
                return -10;
            }
            case "MORFOLOGIK_RULE_EN_GB": {
                return -10;
            }
            case "MORFOLOGIK_RULE_EN_CA": {
                return -10;
            }
            case "MORFOLOGIK_RULE_EN_ZA": {
                return -10;
            }
            case "MORFOLOGIK_RULE_EN_NZ": {
                return -10;
            }
            case "MORFOLOGIK_RULE_EN_AU": {
                return -10;
            }
            case "TWO_CONNECTED_MODAL_VERBS": {
                return -15;
            }
            case "WANT_TO_NN": {
                return -25;
            }
            case "QUESTION_WITHOUT_VERB": {
                return -25;
            }
            case "SENTENCE_FRAGMENT": {
                return -50;
            }
            case "AI_HYDRA_LEO_MISSING_COMMA": {
                return -51;
            }
            case "SENTENCE_FRAGMENT_SINGLE_WORDS": {
                return -51;
            }
            case "EN_REDUNDANCY_REPLACE": {
                return -510;
            }
            case "EN_PLAIN_ENGLISH_REPLACE": {
                return -511;
            }
            case "THREE_NN": {
                return -600;
            }
            case "SENT_START_NUM": {
                return -600;
            }
            case "PASSIVE_VOICE": {
                return -600;
            }
            case "EG_NO_COMMA": {
                return -600;
            }
            case "IE_NO_COMMA": {
                return -600;
            }
            case "REASON_WHY": {
                return -600;
            }
            case "TOO_LONG_SENTENCE": {
                return -997;
            }
            case "TOO_LONG_PARAGRAPH": {
                return -998;
            }
        }
        if (id.startsWith("CONFUSION_RULE_")) {
            return -20;
        }
        if (id.startsWith("AI_HYDRA_LEO")) {
            return -11;
        }
        if (id.startsWith("AI_EN_G_")) {
            return -21;
        }
        if (id.matches("EN_FOR_[A-Z]+_SPEAKERS_FALSE_FRIENDS.*")) {
            return -21;
        }
        return super.getPriorityForId(id);
    }

    public Function<Rule, Rule> getRemoteEnhancedRules(ResourceBundle messageBundle, List<RemoteRuleConfig> configs, UserConfig userConfig, Language motherTongue, List<Language> altLanguages, boolean inputLogging) throws IOException {
        Function fallback = super.getRemoteEnhancedRules(messageBundle, configs, userConfig, motherTongue, altLanguages, inputLogging);
        RemoteRuleConfig bert = RemoteRuleConfig.getRelevantConfig((String)"BERT_SUGGESTION_RANKING", configs);
        return original -> {
            if (original.isDictionaryBasedSpellingRule() && original.getId().startsWith("MORFOLOGIK_RULE_EN") && bert != null) {
                return new BERTSuggestionRanking((Language)this, original, bert, inputLogging);
            }
            return (Rule)fallback.apply(original);
        };
    }

    public List<Rule> getRelevantRemoteRules(ResourceBundle messageBundle, List<RemoteRuleConfig> configs, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages, boolean inputLogging) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>(super.getRelevantRemoteRules(messageBundle, configs, globalConfig, userConfig, motherTongue, altLanguages, inputLogging));
        rules.addAll(GRPCRule.createAll((Language)this, configs, (boolean)inputLogging, (String)"AI_EN_", (String)"INTERNAL - dynamically loaded rule supported by remote server"));
        rules.addAll(GRPCRule.createAll((Language)this, configs, (boolean)inputLogging, (String)"AI_HYDRA_LEO", (String)"INTERNAL - dynamically loaded rule supported by remote server"));
        return rules;
    }
}

