/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.grazie.text.Rule;
import com.intellij.grazie.text.RuleGroup;
import com.intellij.grazie.text.TextContent;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TextProblem {
    private final Rule rule;
    private final TextContent text;
    private final TextRange highlightRange;

    protected TextProblem(@NotNull Rule rule, @NotNull TextContent text2, @NotNull TextRange highlightRange) {
        if (rule == null) {
            TextProblem.$$$reportNull$$$0(0);
        }
        if (text2 == null) {
            TextProblem.$$$reportNull$$$0(1);
        }
        if (highlightRange == null) {
            TextProblem.$$$reportNull$$$0(2);
        }
        this.rule = rule;
        this.text = text2;
        this.highlightRange = highlightRange;
        assert (highlightRange.getStartOffset() >= 0 && highlightRange.getEndOffset() <= text2.length());
    }

    @NotNull
    public final Rule getRule() {
        Rule rule = this.rule;
        if (rule == null) {
            TextProblem.$$$reportNull$$$0(3);
        }
        return rule;
    }

    @NotNull
    public abstract String getShortMessage();

    @NotNull
    @InspectionMessage
    public abstract String getDescriptionTemplate(boolean var1);

    @NotNull
    public final TextContent getText() {
        TextContent textContent = this.text;
        if (textContent == null) {
            TextProblem.$$$reportNull$$$0(4);
        }
        return textContent;
    }

    @NotNull
    public final TextRange getHighlightRange() {
        TextRange textRange = this.highlightRange;
        if (textRange == null) {
            TextProblem.$$$reportNull$$$0(5);
        }
        return textRange;
    }

    @NotNull
    public abstract TextRange getReplacementRange();

    @Nullable
    public TextRange getPatternRange() {
        return null;
    }

    @NotNull
    public abstract List<String> getCorrections();

    public boolean fitsGroup(@NotNull RuleGroup group) {
        if (group == null) {
            TextProblem.$$$reportNull$$$0(6);
        }
        return group.getRules().contains(this.rule.getGlobalId());
    }

    public String toString() {
        return this.highlightRange.subSequence((CharSequence)this.text) + " (" + this.getShortMessage() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rule";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightRange";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/grazie/text/TextProblem";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/grazie/text/TextProblem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fitsGroup";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

