/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions.createproject;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.ui.ProductIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.interaction.ConnectionOwner;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.roots.ToolbarPanel;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.actions.ToggleRemoteExclusionAction;
import com.jetbrains.plugins.webDeployment.actions.createproject.ActionTypeDescription;
import com.jetbrains.plugins.webDeployment.actions.createproject.ChooseRemotePathStep;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.DefaultServerTreeContentListener;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeContext;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeViewOptions;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.WebServerTreeBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerTreeForm
implements Disposable {
    private JPanel myContentPane;
    private ServerTree myTree;
    private JBScrollPane myScrollPane;
    private WebServerTreeBuilder myTreeBuilder;
    private WebServerConfig myServer;
    private PublishConfig myConfig;
    private final MultiMap<String, WebServerConfig.RemotePath> myActionPaths;
    private final EventDispatcher<RootChangedListener> myEventDispatcher;

    ServerTreeForm() {
        this.$$$setupUI$$$();
        this.myActionPaths = new MultiMap();
        this.myEventDispatcher = EventDispatcher.create(RootChangedListener.class);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.addAction((AnAction)new SetRootFolderAction());
        actionGroup.addAction((AnAction)new ToggleRemoteExclusionAction(AllIcons.Actions.Cancel));
        for (ActionTypeDescription.Remote actionTypeDescription : ChooseRemotePathStep.REMOTE_ACTION_TYPE_DESCRIPTIONS) {
            actionGroup.addAction((AnAction)new ParametrizedAction(actionTypeDescription));
        }
        this.myContentPane.add((Component)new ToolbarPanel((JComponent)this.myScrollPane, (ActionGroup)actionGroup, "WebDeploymentServerTreeToolbar"), "Center");
    }

    private void createUIComponents() {
        this.myTree = new ServerTree(null, null, null);
        this.myTree.getSelectionModel().setSelectionMode(1);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        DefaultActionGroup group = (DefaultActionGroup)ActionManager.getInstance().getAction("RemoteHostViewPopupMenu");
        for (AnAction action : group.getChildActionsOrStubs()) {
            if (action instanceof ToggleRemoteExclusionAction || action instanceof ActionStub && ToggleRemoteExclusionAction.class.getName().equals(((ActionStub)action).getClassName())) {
                actionGroup.addSeparator();
                SetRootFolderAction setRootFolderAction = new SetRootFolderAction();
                actionGroup.add((AnAction)setRootFolderAction);
                setRootFolderAction.registerCustomShortcutSet(setRootFolderAction.getShortcutSet(), (JComponent)((Object)this.myTree), this);
                ToggleRemoteExclusionAction excludeFolderAction = new ToggleRemoteExclusionAction();
                excludeFolderAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(68, 512), null)}), (JComponent)((Object)this.myTree), this);
                actionGroup.add((AnAction)excludeFolderAction);
                ParametrizedAction resourceRootAction = new ParametrizedAction(ActionTypeDescription.REMOTE_RESOURCE_ROOTS_ACTION_DESCRIPTION);
                actionGroup.add((AnAction)resourceRootAction);
                resourceRootAction.registerCustomShortcutSet(resourceRootAction.getShortcutSet(), (JComponent)((Object)this.myTree), this);
                ParametrizedAction excludeAction = new ParametrizedAction(ActionTypeDescription.REMOTE_EXCLUDE_FOLDERS_ACTION_DESCRIPTION);
                actionGroup.add((AnAction)excludeAction);
                excludeAction.registerCustomShortcutSet(excludeAction.getShortcutSet(), (JComponent)((Object)this.myTree), this);
                continue;
            }
            actionGroup.add(action);
        }
        PopupHandler.installPopupMenu((JComponent)((Object)this.myTree), (ActionGroup)actionGroup, (String)"RemoteHostDialogPopup");
    }

    public void initialize(@NotNull WebServerConfig server, boolean foldersOnly, PublishConfig config, @Nullable WebServerConfig.RemotePath initialPath) {
        ServerTreeNode selection;
        if (server == null) {
            ServerTreeForm.$$$reportNull$$$0(0);
        }
        this.myConfig = config;
        this.myServer = server;
        ServerTreeViewOptions options = new ServerTreeViewOptions(){

            @Override
            public boolean isShowSize() {
                return false;
            }

            @Override
            public boolean isShowTimestamp() {
                return false;
            }

            @Override
            public boolean isShowPermissions() {
                return false;
            }

            @Override
            public boolean isShowPermissionsAsNumber() {
                return false;
            }

            @Override
            public boolean isHighlightSymlinks() {
                return false;
            }

            @Override
            public boolean isHighlightMappings() {
                return true;
            }

            @Override
            public boolean isHidden(FileName name) {
                return false;
            }
        };
        Deployable deployable = Deployable.create(server, null);
        DecoratedServerTreeNode root = new DecoratedServerTreeNode(null, ConnectionOwnerFactory.createConnectionOwner((Component)this.myContentPane), deployable, config, foldersOnly, options);
        this.myTreeBuilder = WebServerTreeBuilder.createInstance(root, (JTree)((Object)this.myTree));
        this.myTree.setServer(deployable);
        this.myTree.setConfig(config);
        this.registerActionShortcut("$Delete");
        this.registerActionShortcut("$Cut");
        this.registerActionShortcut("$Paste");
        if (initialPath != null && (selection = root.createForSelection(initialPath)) != null) {
            this.myTreeBuilder.select((Object)selection);
        }
        this.myTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ((RootChangedListener)ServerTreeForm.this.myEventDispatcher.getMulticaster()).rootChanged();
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(WebDeploymentTopics.SERVER_TREE, (Object)new DefaultServerTreeContentListener(this.myTree, this.myTreeBuilder, deployable));
    }

    private void registerActionShortcut(String actionId) {
        AnAction action = ActionManager.getInstance().getAction(actionId);
        action.registerCustomShortcutSet(action.getShortcutSet(), (JComponent)((Object)this.myTree), (Disposable)this);
    }

    @Nullable
    WebServerConfig.RemotePath getSelectedPath() {
        if (this.myTreeBuilder == null) {
            return null;
        }
        Set selection = this.myTreeBuilder.getSelectedElements();
        if (selection.isEmpty()) {
            return null;
        }
        Object o = selection.iterator().next();
        return o instanceof ServerTreeNode ? ((ServerTreeNode)((Object)o)).getPath() : null;
    }

    public void dispose() {
        if (this.myTreeBuilder == null || this.myTreeBuilder.isDisposed()) {
            return;
        }
        ((ServerTreeNode)((Object)this.myTreeBuilder.getTreeStructure().getRootElement())).releaseConnection();
        Disposer.dispose((Disposable)this.myTreeBuilder);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    private boolean isSelectionMapped(WebServerConfig.RemotePath path) {
        if (path == null || path.path == null) {
            return false;
        }
        DeploymentPathMapping mapping = (DeploymentPathMapping)this.getTempMapping().getFirst();
        if (mapping == null || StringUtil.isEmpty((String)mapping.getDeployPath())) {
            return false;
        }
        return this.myConfig.getNearestMappingDeploy2Local(path, false, (Mappable)this.myServer).getFirst() != null;
    }

    @Nullable
    public String getProjectRootPath() {
        if (this.myConfig == null) {
            return null;
        }
        String deployPath = ((DeploymentPathMapping)this.getTempMapping().getFirst()).getDeployPath();
        if (deployPath == null) {
            return null;
        }
        if (!this.myServer.getFileTransferConfig().getAccessType().isProtocolBased()) {
            return DeploymentPathUtils.join(this.myServer.getFileTransferConfig().getMountedFolder(), deployPath, File.separatorChar);
        }
        return deployPath;
    }

    @Nullable
    public String getProjectRootPathOrCommitSelectedPath() {
        String path = this.getProjectRootPath();
        if (path != null) {
            return path;
        }
        this.setSelectedPathAsProjectRoot(true);
        return this.getProjectRootPath();
    }

    public void addStateChangedListener(RootChangedListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public MultiMap<String, WebServerConfig.RemotePath> getActionPaths() {
        return this.myActionPaths;
    }

    public static String getMountedServerRelativePath(String path, Mappable serverConfig) {
        String pathToCheck = path;
        if (!serverConfig.getAccessType().isProtocolBased() && "".equals(pathToCheck = DeploymentPathUtils.getPathRemainder(serverConfig.getMountedFolder(), path, serverConfig.isCaseSensitive()))) {
            pathToCheck = File.separator;
        }
        return pathToCheck;
    }

    private void setSelectedPathAsProjectRoot(boolean state) {
        WebServerConfig.RemotePath path = this.getSelectedPath();
        if (path == null) {
            return;
        }
        String pathToCheck = ServerTreeForm.getMountedServerRelativePath(path.path, this.myServer);
        Pair<DeploymentPathMapping, List<DeploymentPathMapping>> tempMapping = this.getTempMapping();
        if (tempMapping.getFirst() != null && "".equals(DeploymentPathUtils.getPathRemainder(((DeploymentPathMapping)tempMapping.getFirst()).getDeployPath(), pathToCheck, this.myServer.isCaseSensitive()))) {
            if (state) {
                return;
            }
            ((DeploymentPathMapping)tempMapping.getFirst()).setDeployPath(null);
            this.commitTempMapping((List)tempMapping.getSecond());
            this.myTreeBuilder.refreshSubtree(Collections.singleton(path), false, false, path);
            ((RootChangedListener)this.myEventDispatcher.getMulticaster()).rootChanged();
        }
        if (state) {
            String oldPath = ((DeploymentPathMapping)tempMapping.getFirst()).getDeployPath();
            if (oldPath != null && !this.myServer.getFileTransferConfig().getAccessType().isProtocolBased()) {
                oldPath = DeploymentPathUtils.join(this.myServer.getFileTransferConfig().getMountedFolder(), oldPath, File.separatorChar);
            }
            ((DeploymentPathMapping)tempMapping.getFirst()).setDeployPath(pathToCheck);
            this.commitTempMapping((List)tempMapping.getSecond());
            ArrayList<WebServerConfig.RemotePath> pathsToRefresh = new ArrayList<WebServerConfig.RemotePath>(2);
            pathsToRefresh.add(path);
            pathsToRefresh.add(new WebServerConfig.RemotePath(oldPath));
            this.myTreeBuilder.refreshSubtree(pathsToRefresh, false, false, null);
            ((RootChangedListener)this.myEventDispatcher.getMulticaster()).rootChanged();
        }
    }

    @NotNull
    Pair<DeploymentPathMapping, List<DeploymentPathMapping>> getTempMapping() {
        ChooseRemotePathStep.TempDeploymentPathMapping tempMapping = null;
        List<DeploymentPathMapping> pathMappings = this.myConfig.getPathMappings(this.myServer.getId());
        for (DeploymentPathMapping mapping : pathMappings) {
            if (!(mapping instanceof ChooseRemotePathStep.TempDeploymentPathMapping)) continue;
            tempMapping = (ChooseRemotePathStep.TempDeploymentPathMapping)mapping;
        }
        assert (tempMapping != null);
        Pair pair = Pair.create(tempMapping, pathMappings);
        if (pair == null) {
            ServerTreeForm.$$$reportNull$$$0(1);
        }
        return pair;
    }

    private void commitTempMapping(List<DeploymentPathMapping> mappings) {
        this.myConfig.setPathMappings(this.myServer.getId(), mappings);
    }

    private boolean isActionApplied(ActionTypeDescription.Remote desc, WebServerConfig.RemotePath path) {
        if (desc.isRecursive) {
            for (WebServerConfig.RemotePath remotePath : this.myActionPaths.get((Object)desc.key)) {
                if (!DeploymentPathUtils.isAncestor(remotePath.path, path.path, this.myServer.isCaseSensitive())) continue;
                return true;
            }
        } else if (this.myActionPaths.get((Object)desc.key).contains(path)) {
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/createproject/ServerTreeForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/createproject/ServerTreeForm";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initialize";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBScrollPane jBScrollPane;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, "Center");
        ServerTree serverTree = this.myTree;
        jBScrollPane.setViewportView((Component)((Object)serverTree));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    public static interface RootChangedListener
    extends EventListener {
        public void rootChanged();
    }

    private final class DecoratedServerTreeNode
    extends ServerTreeNode {
        private DecoratedServerTreeNode(@NotNull Project project, ConnectionOwner connectionOwner, @Nullable Deployable serverConfig, PublishConfig publishConfig, @NotNull boolean foldersOnly, ServerTreeViewOptions viewOptions) {
            if (connectionOwner == null) {
                DecoratedServerTreeNode.$$$reportNull$$$0(0);
            }
            if (viewOptions == null) {
                DecoratedServerTreeNode.$$$reportNull$$$0(1);
            }
            super(project, connectionOwner, serverConfig, publishConfig, foldersOnly, FileTransferConfig.Origin.Default, viewOptions);
        }

        private DecoratedServerTreeNode(@NotNull ServerTreeNode parent, FileObject file, @NotNull FileType fileType, ServerTreeContext treeContext) {
            if (file == null) {
                DecoratedServerTreeNode.$$$reportNull$$$0(2);
            }
            if (treeContext == null) {
                DecoratedServerTreeNode.$$$reportNull$$$0(3);
            }
            super(parent, file, fileType, treeContext);
        }

        @Override
        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                DecoratedServerTreeNode.$$$reportNull$$$0(4);
            }
            super.update(presentation);
            WebServerConfig.RemotePath path = this.getPath();
            String rootPath = ServerTreeForm.this.getProjectRootPath();
            if (rootPath != null && "".equals(DeploymentPathUtils.getPathRemainder(path.path, rootPath, ServerTreeForm.this.myServer.isCaseSensitive()))) {
                presentation.setIcon(ProductIcons.getInstance().getProjectNodeIcon());
                return;
            }
            if (!ServerTreeForm.this.isSelectionMapped(path)) {
                return;
            }
            for (ActionTypeDescription.Remote desc : ChooseRemotePathStep.REMOTE_ACTION_TYPE_DESCRIPTIONS) {
                if (!ServerTreeForm.this.isActionApplied(desc, path)) continue;
                presentation.setIcon(desc.closedIcon);
                return;
            }
        }

        @Override
        @NotNull
        protected ServerTreeNode createChildNode(FileType childType, FileObject child, ServerTreeContext context) {
            return new DecoratedServerTreeNode(this, child, childType, context);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connectionOwner";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewOptions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "treeContext";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/createproject/ServerTreeForm$DecoratedServerTreeNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ParametrizedAction
    extends ToggleAction
    implements DumbAware {
        private final ActionTypeDescription.Remote myDescription;

        private ParametrizedAction(ActionTypeDescription.Remote description) {
            super(description.title, description.description, description.closedIcon);
            this.myDescription = description;
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(description.keystroke, 512), null)}));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ParametrizedAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            boolean underRoot = ServerTreeForm.this.isSelectionMapped(ServerTreeForm.this.getSelectedPath());
            e.getPresentation().setEnabled(underRoot);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                ParametrizedAction.$$$reportNull$$$0(1);
            }
            WebServerConfig.RemotePath path = ServerTreeForm.this.getSelectedPath();
            if (!ServerTreeForm.this.isSelectionMapped(ServerTreeForm.this.getSelectedPath())) {
                return false;
            }
            return ServerTreeForm.this.isActionApplied(this.myDescription, path);
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                ParametrizedAction.$$$reportNull$$$0(2);
            }
            ArrayList<WebServerConfig.RemotePath> selectedPaths = new ArrayList<WebServerConfig.RemotePath>();
            for (Object o : ServerTreeForm.this.myTreeBuilder.getSelectedElements()) {
                if (!(o instanceof ServerTreeNode)) continue;
                selectedPaths.add(((ServerTreeNode)((Object)o)).getPath());
            }
            if (state) {
                Collection paths = ServerTreeForm.this.myActionPaths.get((Object)this.myDescription.key);
                for (WebServerConfig.RemotePath path : selectedPaths) {
                    if (paths.contains(path)) continue;
                    ServerTreeForm.this.myActionPaths.putValue((Object)this.myDescription.key, (Object)path);
                }
            } else {
                for (WebServerConfig.RemotePath path : selectedPaths) {
                    ServerTreeForm.this.myActionPaths.remove((Object)this.myDescription.key, (Object)path);
                }
            }
            ServerTreeForm.this.myTreeBuilder.refreshSubtree(selectedPaths, false, false, null);
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/createproject/ServerTreeForm$ParametrizedAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class SetRootFolderAction
    extends ToggleAction
    implements DumbAware {
        private SetRootFolderAction() {
            super(WDBundle.message("project.root.action.text", new Object[0]), WDBundle.message("project.root.action.description", new Object[0]), ProductIcons.getInstance().getProjectIcon());
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(74, 512), null)}));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SetRootFolderAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setEnabled(ServerTreeForm.this.myTreeBuilder != null && ServerTreeForm.this.myTreeBuilder.getSelectedElements().size() == 1);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            WebServerConfig.RemotePath path;
            if (e == null) {
                SetRootFolderAction.$$$reportNull$$$0(1);
            }
            if ((path = ServerTreeForm.this.getSelectedPath()) == null) {
                return false;
            }
            String pathToCheck = ServerTreeForm.getMountedServerRelativePath(path.path, ServerTreeForm.this.myServer);
            DeploymentPathMapping tempMapping = (DeploymentPathMapping)ServerTreeForm.this.getTempMapping().getFirst();
            return !StringUtil.isEmpty((String)tempMapping.getDeployPath()) && "".equals(DeploymentPathUtils.getPathRemainder(tempMapping.getDeployPath(), pathToCheck, ServerTreeForm.this.myServer.isCaseSensitive()));
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                SetRootFolderAction.$$$reportNull$$$0(2);
            }
            ServerTreeForm.this.setSelectedPathAsProjectRoot(state);
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/createproject/ServerTreeForm$SetRootFolderAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

