/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base.generator.producers;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.BaseAlterGenerator;
import com.intellij.database.dialects.base.generator.BaseProducer;
import com.intellij.database.dialects.base.generator.EffectType;
import com.intellij.database.dialects.base.generator.ElementProducer;
import com.intellij.database.dialects.base.generator.Node;
import com.intellij.database.dialects.base.generator.Operation;
import com.intellij.database.dialects.base.generator.ScenarioOperations;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.ScriptingFun;
import com.intellij.database.dialects.base.generator.producers.AlterProducer;
import com.intellij.database.dialects.base.generator.producers.BaseProducersKt;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.DropProducer;
import com.intellij.database.dialects.base.generator.producers.Flag;
import com.intellij.database.dialects.base.generator.producers.Flags;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ElementDelta;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModArrangedElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingFamily;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaProperty;
import com.intellij.database.model.meta.BasicMetaPropertyId;
import com.intellij.database.model.meta.BasicMetaReference;
import com.intellij.database.model.meta.BasicMetaReferenceId;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.script.generator.DelegateScriptingOptions;
import com.intellij.database.script.generator.ScriptingCapabilities;
import com.intellij.database.script.generator.ScriptingOptionStatic;
import com.intellij.database.script.generator.ScriptingOptions;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001e\u001a\u00020\u001fH\u0004J\u001a\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00140!H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00140!H\u0014J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00140!H\u0014J\b\u0010'\u001a\u00020\u0014H\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00140!H\u0014J\b\u0010)\u001a\u00020\u0014H\u0014J\u0018\u0010)\u001a\u00020\u00142\u0006\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0002H\u0004J\u0014\u0010,\u001a\u00020\u001f2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030#H\u0004J \u0010,\u001a\u00020\u001f2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030#2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030/H\u0004J\u0014\u00100\u001a\u00020\u001f2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030#H\u0004J\u0016\u00101\u001a\u00020\u001f2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002020#H\u0004J\u0014\u00103\u001a\u0006\u0012\u0002\b\u0003042\u0006\u00105\u001a\u00020\u0002H\u0004J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020807H\u0016J3\u00109\u001a\u0002H\u0001\"\u0004\b\u0001\u0010\u00012\u0006\u0010:\u001a\u0002H\u00012\u0018\u0010;\u001a\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020=\u0012\u0004\u0012\u0002H\u00010<\u00a2\u0006\u0002\u0010>J\b\u0010?\u001a\u00020\u0014H\u0016J\u0006\u0010@\u001a\u00020\u0013J\u0006\u0010A\u001a\u00020\u0013J\b\u0010B\u001a\u0004\u0018\u00010\u0013J\n\u0010C\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u0010D\u001a\u0004\u0018\u00010\u0013J&\u0010E\u001a\u00020\u00142\u0018\b\u0004\u0010F\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030#\u0012\u0004\u0012\u00020\u00140GH\u0086\b\u00f8\u0001\u0000J\b\u0010H\u001a\u0004\u0018\u00010\u0013J\u0006\u0010I\u001a\u00020\u0014J\u0006\u0010J\u001a\u00020\u0014J\u0006\u0010K\u001a\u00020\u0014J\u0006\u0010L\u001a\u00020\u001fJ\b\u0010M\u001a\u00020\u001fH\u0016J\b\u0010N\u001a\u00020\u001fH\u0016J\b\u0010O\u001a\u00020\u001fH\u0016J\u0010\u0010P\u001a\u00020\u001f2\u0006\u00105\u001a\u00020\u0002H\u0004J\u000e\u0010Q\u001a\u00020\u001f2\u0006\u0010R\u001a\u00020\u0014J\b\u0010S\u001a\u00020\u001fH\u0004J\b\u0010T\u001a\u00020\u001fH\u0004J&\u0010U\u001a\u00020\u001f2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030#2\u0010\u0010V\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0WH\u0016J \u0010X\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020=2\u0010\u0010V\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0WJ$\u0010X\u001a\u00020\u001f2\n\u0010-\u001a\u0006\u0012\u0002\b\u00030#2\u0010\u0010V\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0WJ\u001a\u0010Y\u001a\u00020\u001f2\u0010\u0010V\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0WH\u0004J\u001a\u0010Z\u001a\u00020\u001f2\u0010\u0010V\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030#0WH\u0014J\b\u0010[\u001a\u00020\u001fH\u0016J\b\u0010\\\u001a\u00020\u001fH\u0016J\u001a\u0010]\u001a\u0004\u0018\u00010^2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020^H\u0016J.\u0010b\u001a\u00020\u001f2\u0006\u0010_\u001a\u00020`2\u0006\u0010c\u001a\u00020^2\u0014\b\u0002\u0010d\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00140GH\u0004J\u001a\u0010e\u001a\u0004\u0018\u00010^2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020^H\u0004J\u0018\u0010f\u001a\u00020^2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020^H\u0004J\b\u0010g\u001a\u00020\u001fH\u0002J\b\u0010h\u001a\u00020\u0013H\u0016J\b\u0010i\u001a\u0004\u0018\u00010\u0013J\n\u0010j\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u0010k\u001a\u0004\u0018\u00010\u0013R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R@\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00122\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0013\u0010\u001a\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001c\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006l"}, d2={"Lcom/intellij/database/dialects/base/generator/producers/AlterProducer;", "T", "Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/dialects/base/generator/ElementProducer;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/model/ElementAlteration;)V", "flags", "Lcom/intellij/database/dialects/base/generator/producers/Flags;", "getFlags", "()Lcom/intellij/database/dialects/base/generator/producers/Flags;", "metaObject", "Lcom/intellij/database/model/meta/BasicMetaObject;", "getMetaObject", "()Lcom/intellij/database/model/meta/BasicMetaObject;", "value", "Lkotlin/Pair;", "", "", "tmpName", "getTmpName", "()Lkotlin/Pair;", "setTmpName", "(Lkotlin/Pair;)V", "to", "getTo", "()Lcom/intellij/database/model/basic/BasicElement;", "Lcom/intellij/database/model/basic/BasicElement;", "alterCommentUnsupported", "", "canAlter", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "prop", "Lcom/intellij/database/model/meta/BasicMetaPropertyId;", "canAlterAnything", "canAlterComment", "canAlterOrder", "canProduce", "canRename", "checkRename", "o1", "o2", "computeFlag", "id", "refId", "Lcom/intellij/database/model/meta/BasicMetaReferenceId;", "computeFlagNotNull", "computePasswordFlag", "Lcom/intellij/credentialStore/OneTimeString;", "dropProducer", "Lcom/intellij/database/dialects/base/generator/producers/DropProducer;", "e", "edgeVersions", "", "Lcom/intellij/database/util/Version;", "foldFlags", "f", "acc", "Lkotlin/Function2;", "Lcom/intellij/database/dialects/base/generator/producers/Flag;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "forceCompactSource", "fqFromName", "fqToName", "fromName", "fromNameOpt", "fromNameScr", "hasAnythingExcept", "ignore", "Lkotlin/Function1;", "ifExists", "isAnyRename", "isEmpty", "isRename", "produce", "produceAlter", "produceAlterComment", "produceAlterCommentIfSupported", "produceCreate", "produceCreateOrReplace", "withComment", "produceDrop", "produceDropCreate", "produceFlag", "produced", "", "produceFlagIfSet", "produceFlags", "produceOrderedFlags", "produceRename", "produceRenameIfSupported", "register", "Lcom/intellij/database/dialects/base/generator/Operation;", "generator", "Lcom/intellij/database/dialects/base/generator/BaseAlterGenerator;", "root", "registerChildren", "r", "filter", "registerDropCreate", "registerThis", "renameUnsupported", "shortText", "toName", "toNameOpt", "toNameScr", "intellij.database.dialects.base.core"})
public class AlterProducer<T extends BasicElement>
extends ElementProducer<T> {
    @NotNull
    private final T to;
    @Nullable
    private Pair<String, Boolean> tmpName;
    @NotNull
    private final Flags flags;

    @NotNull
    public final T getTo() {
        return this.to;
    }

    @NotNull
    public final BasicMetaObject<T> getMetaObject() {
        BasicMetaObject basicMetaObject = BasicMetaUtils.getMetaObject(this.getElement());
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaObject, (String)"BasicMetaUtils.getMetaObject(element)");
        return basicMetaObject;
    }

    @Nullable
    public final Pair<String, Boolean> getTmpName() {
        return this.tmpName;
    }

    public final void setTmpName(@Nullable Pair<String, Boolean> value) {
        block1: {
            if (Intrinsics.areEqual(this.tmpName, value)) {
                return;
            }
            this.tmpName = value;
            Flag flag = this.flags.flag(BaseProducersKt.getTMP_NAME_FLAG_ID());
            if (flag == null) break block1;
            flag.setV(value != null);
        }
    }

    @NotNull
    public final Flags getFlags() {
        return this.flags;
    }

    protected final void computeFlag(@NotNull BasicMetaPropertyId<?> id) {
        block0: {
            Intrinsics.checkNotNullParameter(id, (String)"id");
            BasicMetaProperty basicMetaProperty = this.getMetaObject().getObjectProperty(id);
            if (basicMetaProperty == null) break block0;
            BasicMetaProperty basicMetaProperty2 = basicMetaProperty;
            boolean bl = false;
            boolean bl2 = false;
            BasicMetaProperty it = basicMetaProperty2;
            boolean bl3 = false;
            this.flags.add(id, !Objects.deepEquals(it.get(this.getElement()), it.get(this.to)));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void computeFlag(@NotNull BasicMetaPropertyId<?> id, @NotNull BasicMetaReferenceId<?> refId) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter(refId, (String)"refId");
        BasicMetaReference basicMetaReference = this.getMetaObject().getReference(refId);
        if (basicMetaReference == null) return;
        BasicMetaReference basicMetaReference2 = basicMetaReference;
        boolean bl = false;
        boolean bl2 = false;
        BasicMetaReference ref2 = basicMetaReference2;
        boolean bl3 = false;
        BasicElement fromRef = ref2.resolve(this.getElement());
        BasicElement toRef = ref2.resolve(this.to);
        if (fromRef == null || toRef == null) {
            Intrinsics.checkNotNullExpressionValue((Object)ref2.dependencies, (String)"ref.dependencies");
            if (ArraysKt.contains((Object[])ref2.dependencies, id)) {
                this.computeFlag(id);
                return;
            }
        }
        this.flags.add(id, !BaseProducersKt.isAlteredTo(this, fromRef, toRef));
    }

    /*
     * WARNING - void declaration
     */
    protected final void computeFlagNotNull(@NotNull BasicMetaPropertyId<?> id) {
        block0: {
            void it;
            Intrinsics.checkNotNullParameter(id, (String)"id");
            BasicMetaProperty basicMetaProperty = this.getMetaObject().getObjectProperty(id);
            if (basicMetaProperty == null) break block0;
            BasicMetaProperty basicMetaProperty2 = basicMetaProperty;
            boolean bl = false;
            boolean bl2 = false;
            BasicMetaProperty p = basicMetaProperty2;
            boolean bl3 = false;
            Object object = p.get(this.to);
            boolean bl4 = false;
            boolean bl5 = false;
            Object object2 = object;
            BasicMetaPropertyId<?> basicMetaPropertyId = id;
            Flags flags = this.flags;
            boolean bl6 = false;
            boolean bl7 = it != null && !Objects.deepEquals(p.get(this.getElement()), it);
            flags.add(basicMetaPropertyId, bl7);
        }
    }

    protected final void computePasswordFlag(@NotNull BasicMetaPropertyId<OneTimeString> id) {
        block2: {
            boolean bl;
            Intrinsics.checkNotNullParameter(id, (String)"id");
            BasicMetaProperty basicMetaProperty = this.getMetaObject().getObjectProperty(id);
            if (basicMetaProperty == null) break block2;
            BasicMetaProperty basicMetaProperty2 = basicMetaProperty;
            boolean bl2 = false;
            boolean bl3 = false;
            BasicMetaProperty p = basicMetaProperty2;
            boolean bl4 = false;
            OneTimeString toVal = (OneTimeString)p.get(this.to);
            OneTimeString fromVal = (OneTimeString)p.get(this.getElement());
            if (fromVal == null) {
                OneTimeString oneTimeString = toVal;
                bl = StringUtil.isNotEmpty((String)(oneTimeString != null ? oneTimeString.toString(false) : null));
            } else {
                bl = toVal != null && Intrinsics.areEqual((Object)fromVal, (Object)toVal) ^ true;
            }
            this.flags.add(id, bl);
        }
    }

    public boolean forceCompactSource() {
        return false;
    }

    public final boolean isEmpty() {
        AlterProducer this_$iv = this;
        boolean $i$f$hasAnythingExcept = false;
        return this_$iv.foldFlags(false, (Function2)new Function2<Boolean, Flag, Boolean>(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean invoke(boolean v2, @NotNull Flag f) {
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                if (v2) return true;
                BasicMetaPropertyId<?> it = f.getId();
                boolean bl = false;
                if (false) return false;
                if (!f.getV()) return false;
                return true;
            }
        }) == false;
    }

    public final boolean isRename() {
        BasicMetaPropertyId basicMetaPropertyId = BasicModNamedElement.NAME;
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaPropertyId, (String)"BasicModNamedElement.NAME");
        return this.flags.get(basicMetaPropertyId);
    }

    public final boolean isAnyRename() {
        return this.isRename() || this.flags.get(BaseProducersKt.getTMP_NAME_FLAG_ID());
    }

    public final boolean hasAnythingExcept(@NotNull Function1<? super BasicMetaPropertyId<?>, Boolean> ignore) {
        int $i$f$hasAnythingExcept = 0;
        Intrinsics.checkNotNullParameter(ignore, (String)"ignore");
        return this.foldFlags(false, (Function2)new Function2<Boolean, Flag, Boolean>(ignore){
            final /* synthetic */ Function1 $ignore;

            public final boolean invoke(boolean v2, @NotNull Flag f) {
                Intrinsics.checkNotNullParameter((Object)f, (String)"f");
                return v2 || (Boolean)this.$ignore.invoke(f.getId()) == false && f.getV();
            }
            {
                this.$ignore = function1;
                super(2);
            }
        });
    }

    public final <T> T foldFlags(T f, @NotNull Function2<? super T, ? super Flag, ? extends T> acc) {
        Intrinsics.checkNotNullParameter(acc, (String)"acc");
        Iterable<Flag> $this$fold$iv = this.flags.all();
        boolean $i$f$fold = false;
        Object accumulator$iv = f;
        for (Flag element$iv : $this$fold$iv) {
            accumulator$iv = acc.invoke(accumulator$iv, (Object)element$iv);
        }
        return accumulator$iv;
    }

    @Nullable
    public Operation register(@NotNull BaseAlterGenerator generator, @NotNull Operation root2) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        return this.isEmpty() ? null : this.registerThis(generator, root2);
    }

    @NotNull
    protected final Operation registerThis(@NotNull BaseAlterGenerator generator, @NotNull Operation root2) {
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Operation operation2 = new Operation(this);
        boolean bl = false;
        boolean bl2 = false;
        Operation $this$apply = operation2;
        boolean bl3 = false;
        ((Map)generator.getPrepared()).put(this.getElement(), $this$apply);
        $this$apply.setParent((Node)root2);
        if (this.isAnyRename()) {
            ScenarioOperations.provides($this$apply, ScenarioOperations.invoke(EffectType.RenamedFrom, ScenarioOperations.renamed(this.getElement(), null, this.fromNameOpt())), ScenarioOperations.invoke(EffectType.RenamedTo, ScenarioOperations.renamed(this.getElement(), this.to, this.toNameOpt())));
            if (this.toNameOpt() == null) {
                NamingFamily namingFamily;
                Family family = this.getElement().getParentFamily();
                if (!(family instanceof NamingFamily)) {
                    family = null;
                }
                if ((namingFamily = (NamingFamily)family) != null && (namingFamily = namingFamily.get(this.to.getName())) != null) {
                    NamingFamily namingFamily2 = namingFamily;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    NamingFamily it = namingFamily2;
                    boolean bl6 = false;
                    ScenarioOperations.requires($this$apply, ScenarioOperations.matches$default(EffectType.RenamedFrom, ScenarioOperations.renamed(this.getElement(), this.to, null), null, 2, null));
                }
            }
        }
        ScenarioOperations.requires($this$apply, ScenarioOperations.children(EffectType.Unexistent, this.getElement()));
        ScenarioOperations.requires($this$apply, ScenarioOperations.children(EffectType.Modified, this.to));
        if (this.toNameOpt() == null) {
            ScenarioOperations.provides($this$apply, ScenarioOperations.invoke(EffectType.Modified, this.to));
            if (Intrinsics.areEqual(this.to, this.getElement()) ^ true) {
                ScenarioOperations.provides($this$apply, ScenarioOperations.invoke(EffectType.ModifiedFrom, this.getElement()));
            }
        }
        return operation2;
    }

    @Nullable
    public final String ifExists() {
        return (Boolean)this.getContext().getOptions().get(ScriptingOptionStatic.IF_EXISTS) != false ? "if exists" : null;
    }

    protected boolean checkRename() {
        return this.checkRename((BasicElement)this.getElement(), (BasicElement)this.to);
    }

    protected final boolean checkRename(@NotNull BasicElement o1, @NotNull BasicElement o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        return BaseProducersKt.checkRenameImpl(this, o1, o2);
    }

    @Override
    public final void produce() {
        this.getContext().getHelper().produceAlter(this);
    }

    public void produceAlter() {
        this.produceFlags(new HashSet());
    }

    protected final void produceFlags(@NotNull Set<BasicMetaPropertyId<?>> produced) {
        Intrinsics.checkNotNullParameter(produced, (String)"produced");
        this.produceOrderedFlags(produced);
        Iterable<Flag> $this$forEach$iv = this.flags.all();
        boolean $i$f$forEach = false;
        Iterator<Flag> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Flag element$iv;
            Flag it = element$iv = iterator.next();
            boolean bl = false;
            this.produceFlagIfSet(it, produced);
        }
    }

    protected void produceOrderedFlags(@NotNull Set<BasicMetaPropertyId<?>> produced) {
        Intrinsics.checkNotNullParameter(produced, (String)"produced");
        BasicMetaPropertyId basicMetaPropertyId = BasicModNamedElement.NAME;
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaPropertyId, (String)"BasicModNamedElement.NAME");
        this.produceFlagIfSet(basicMetaPropertyId, produced);
        BasicMetaPropertyId basicMetaPropertyId2 = BasicModNamedElement.COMMENT;
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaPropertyId2, (String)"BasicModNamedElement.COMMENT");
        this.produceFlagIfSet(basicMetaPropertyId2, produced);
    }

    public final void produceFlagIfSet(@NotNull BasicMetaPropertyId<?> id, @NotNull Set<BasicMetaPropertyId<?>> produced) {
        block1: {
            Intrinsics.checkNotNullParameter(id, (String)"id");
            Intrinsics.checkNotNullParameter(produced, (String)"produced");
            if (produced.contains(id)) {
                return;
            }
            Flag flag = this.flags.flag(id);
            if (flag == null) break block1;
            Flag flag2 = flag;
            boolean bl = false;
            boolean bl2 = false;
            Flag it = flag2;
            boolean bl3 = false;
            this.produceFlagIfSet(it, produced);
        }
    }

    public final void produceFlagIfSet(@NotNull Flag f, @NotNull Set<BasicMetaPropertyId<?>> produced) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        Intrinsics.checkNotNullParameter(produced, (String)"produced");
        if (!f.getV() || produced.contains(f.getId())) {
            return;
        }
        this.produceFlag(f.getId(), produced);
        produced.add(f.getId());
    }

    public void produceFlag(@NotNull BasicMetaPropertyId<?> id, @NotNull Set<BasicMetaPropertyId<?>> produced) {
        Intrinsics.checkNotNullParameter(id, (String)"id");
        Intrinsics.checkNotNullParameter(produced, (String)"produced");
        BasicMetaPropertyId<?> basicMetaPropertyId = id;
        if (Intrinsics.areEqual(basicMetaPropertyId, (Object)BasicModNamedElement.NAME) || Intrinsics.areEqual(basicMetaPropertyId, BaseProducersKt.getTMP_NAME_FLAG_ID())) {
            this.produceRenameIfSupported();
            BasicMetaPropertyId basicMetaPropertyId2 = BasicModNamedElement.NAME;
            Intrinsics.checkNotNullExpressionValue((Object)basicMetaPropertyId2, (String)"BasicModNamedElement.NAME");
            produced.add(basicMetaPropertyId2);
            produced.add(BaseProducersKt.getTMP_NAME_FLAG_ID());
        } else if (Intrinsics.areEqual(basicMetaPropertyId, (Object)BasicModNamedElement.COMMENT)) {
            this.produceAlterCommentIfSupported();
        } else {
            this.getContext().getHelper().produceAlterFlag(this, id, produced);
        }
    }

    public void produceAlterCommentIfSupported() {
        BasicMetaPropertyId basicMetaPropertyId = BasicModNamedElement.COMMENT;
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaPropertyId, (String)"BasicModNamedElement.COMMENT");
        if (((Boolean)this.canAlter(basicMetaPropertyId).get(this.getTask().getVersion())).booleanValue()) {
            this.produceAlterComment();
        } else {
            this.alterCommentUnsupported();
        }
    }

    public void produceRenameIfSupported() {
        BasicMetaPropertyId basicMetaPropertyId = BasicModNamedElement.NAME;
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaPropertyId, (String)"BasicModNamedElement.NAME");
        if (((Boolean)this.canAlter(basicMetaPropertyId).get(this.getTask().getVersion())).booleanValue()) {
            this.produceRename();
        } else {
            this.renameUnsupported();
        }
    }

    public void produceAlterComment() {
        this.alterCommentUnsupported();
    }

    protected final void alterCommentUnsupported() {
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>(this){
            final /* synthetic */ AlterProducer this$0;

            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $this$newCoding) {
                Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$receiver");
                $this$newCoding.error("comment on " + this.this$0.getElement().getKind() + " not supported");
            }
            {
                this.this$0 = alterProducer;
                super(1);
            }
        }));
    }

    public void produceRename() {
        this.renameUnsupported();
    }

    private final void renameUnsupported() {
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)new Function1<ScriptingContext.NewCodingAdapter, Unit>(this){
            final /* synthetic */ AlterProducer this$0;

            public final void invoke(@NotNull ScriptingContext.NewCodingAdapter $this$newCoding) {
                Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$receiver");
                $this$newCoding.error(this.this$0.getElement().getKind().code() + " does not support rename");
            }
            {
                this.this$0 = alterProducer;
                super(1);
            }
        }));
    }

    @NotNull
    public final String fqFromName() {
        return this.currentScopeName((BasicElement)this.getElement(), this.fromNameScr());
    }

    @NotNull
    public final String fqToName() {
        return this.currentScopeName((BasicElement)this.getElement(), this.toNameScr());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String fromNameScr() {
        String string;
        block3: {
            block2: {
                void $this$plain$iv;
                string = this.fromNameOpt();
                if (string == null) break block2;
                String string2 = string;
                BaseProducer this_$iv = this;
                boolean $i$f$getPlain = false;
                string = this_$iv.getContext().getNamingService().catToScript((String)$this$plain$iv, null, true, this_$iv.getStyle().getQuotesPriority(), ScriptingFun.getForceQuoting(this_$iv.getContext()));
                if (string != null) break block3;
            }
            string = BaseProducer.quote$default(this, this.getElement(), null, 2, null);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final String toNameScr() {
        String string;
        block3: {
            block2: {
                void $this$plain$iv;
                string = this.toNameOpt();
                if (string == null) break block2;
                String string2 = string;
                BaseProducer this_$iv = this;
                boolean $i$f$getPlain = false;
                string = this_$iv.getContext().getNamingService().catToScript((String)$this$plain$iv, null, true, this_$iv.getStyle().getQuotesPriority(), ScriptingFun.getForceQuoting(this_$iv.getContext()));
                if (string != null) break block3;
            }
            string = BaseProducer.quote$default(this, this.to, null, 2, null);
        }
        return string;
    }

    @Nullable
    public final String fromName() {
        String string = this.fromNameOpt();
        if (string == null) {
            string = this.getElement().getName();
        }
        return string;
    }

    @Nullable
    public final String toName() {
        String string = this.toNameOpt();
        if (string == null) {
            string = this.to.getName();
        }
        return string;
    }

    private final String fromNameOpt() {
        String string;
        Pair<String, Boolean> pair = this.tmpName;
        if (pair != null) {
            Pair<String, Boolean> pair2 = pair;
            boolean bl = false;
            boolean bl2 = false;
            Pair<String, Boolean> it = pair2;
            boolean bl3 = false;
            string = !((Boolean)it.getSecond()).booleanValue() ? null : (String)it.getFirst();
        } else {
            string = null;
        }
        return string;
    }

    private final String toNameOpt() {
        String string;
        Pair<String, Boolean> pair = this.tmpName;
        if (pair != null) {
            Pair<String, Boolean> pair2 = pair;
            boolean bl = false;
            boolean bl2 = false;
            Pair<String, Boolean> it = pair2;
            boolean bl3 = false;
            string = ((Boolean)it.getSecond()).booleanValue() ? null : (String)it.getFirst();
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @NotNull
    public String shortText() {
        String p = super.shortText();
        if (this.tmpName == null) {
            return p;
        }
        Pair<String, Boolean> pair = this.tmpName;
        Intrinsics.checkNotNull(pair);
        String d = (Boolean)pair.getSecond() != false ? "->" : "<-";
        StringBuilder stringBuilder = new StringBuilder().append(p).append('(').append(d);
        Pair<String, Boolean> pair2 = this.tmpName;
        Intrinsics.checkNotNull(pair2);
        return stringBuilder.append((String)pair2.getFirst()).append(')').toString();
    }

    @Nullable
    protected final Operation registerDropCreate(@NotNull BaseAlterGenerator generator, @NotNull Operation root2) {
        Operation operation2;
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        generator.makeDropOperation((BasicElement)this.getElement(), root2);
        Operation operation3 = generator.makeCreateOperation((BasicElement)this.to, root2);
        if (operation3 != null) {
            Operation operation4 = operation3;
            boolean bl = false;
            boolean bl2 = false;
            Operation $this$apply = operation4;
            boolean bl3 = false;
            ScenarioOperations.requires($this$apply, ScenarioOperations.matches$default(EffectType.Unexistent, this.getElement(), null, 2, null));
            JBIterable jBIterable = ((JBTreeTraverser)DasUtil.dasTraverser().withRoot(this.getElement())).filter(BasicElement.class);
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"DasUtil.dasTraverser().w\u2026BasicElement::class.java)");
            Iterable $this$forEach$iv = (Iterable)jBIterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BasicElement e2 = (BasicElement)element$iv;
                boolean bl4 = false;
                if (!(Intrinsics.areEqual((Object)e2, this.getElement()) ^ true)) continue;
                Object object = generator.getContext().getBySource().get(e2);
                if (object == null || (object = object.getTargetElement()) == null) continue;
                BasicElement basicElement = object;
                boolean bl5 = false;
                boolean bl6 = false;
                BasicElement it = basicElement;
                boolean bl7 = false;
                object = generator.getCreator().getPrepared().get(it);
                if (object == null) continue;
                basicElement = object;
                bl5 = false;
                bl6 = false;
                it = basicElement;
                boolean bl8 = false;
                Map map2 = generator.getPrepared();
                BasicElement basicElement2 = e2;
                Intrinsics.checkNotNullExpressionValue((Object)basicElement2, (String)"e");
                BasicElement basicElement3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)basicElement3, (String)"it");
                map2.put(basicElement2, basicElement3);
            }
            operation2 = operation4;
        } else {
            operation2 = null;
        }
        return operation2;
    }

    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canAlter(@NotNull BasicMetaPropertyId<?> prop) {
        ScriptingCapabilities.VersionedCapability<Boolean> versionedCapability;
        Intrinsics.checkNotNullParameter(prop, (String)"prop");
        BasicMetaPropertyId<?> basicMetaPropertyId = prop;
        if (Intrinsics.areEqual(basicMetaPropertyId, (Object)BasicModNamedElement.NAME) || Intrinsics.areEqual(basicMetaPropertyId, (Object)BasicModNamedElement.NAME_QUOTED) || Intrinsics.areEqual(basicMetaPropertyId, (Object)BasicModNamedElement.NAME_SCRIPTED) || Intrinsics.areEqual(basicMetaPropertyId, (Object)BasicModNamedElement.NAME_SURROGATE)) {
            versionedCapability = this.canRename();
        } else if (Intrinsics.areEqual(basicMetaPropertyId, (Object)BasicModNamedElement.COMMENT)) {
            versionedCapability = this.canAlterComment();
        } else if (Intrinsics.areEqual(basicMetaPropertyId, (Object)BasicModArrangedElement.POSITION)) {
            versionedCapability = this.canAlterOrder();
        } else {
            BasicMetaProperty basicMetaProperty = this.getMetaObject().getObjectProperty(prop);
            versionedCapability = Intrinsics.areEqual((Object)(basicMetaProperty != null ? basicMetaProperty.internal : null), (Object)false) ^ true ? AbstractScriptGeneratorKt.getUNSUPPORTED() : AbstractScriptGeneratorKt.getSUPPORTED();
        }
        return versionedCapability;
    }

    @NotNull
    protected ScriptingCapabilities.VersionedCapability<Boolean> canRename() {
        return AbstractScriptGeneratorKt.getSUPPORTED();
    }

    @NotNull
    protected ScriptingCapabilities.VersionedCapability<Boolean> canAlterComment() {
        return AbstractScriptGeneratorKt.getSUPPORTED();
    }

    @NotNull
    protected ScriptingCapabilities.VersionedCapability<Boolean> canAlterOrder() {
        return AbstractScriptGeneratorKt.getUNSUPPORTED();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canAlterAnything() {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)this.getMetaObject().properties, (String)"metaObject.properties");
        BasicMetaProperty[] $this$map$iv = this.getMetaObject().properties;
        boolean $i$f$map = false;
        BasicMetaProperty[] basicMetaPropertyArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var6_6 = $this$mapTo$iv$iv;
        int n = ((void)var6_6).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = var6_6[j];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            BasicMetaPropertyId basicMetaPropertyId = it.id;
            Intrinsics.checkNotNullExpressionValue((Object)basicMetaPropertyId, (String)"it.id");
            ScriptingCapabilities.VersionedCapability<Boolean> versionedCapability = this.canAlter(basicMetaPropertyId);
            collection.add(versionedCapability);
        }
        return AbstractScriptGeneratorKt.orSupported((List)destination$iv$iv);
    }

    @NotNull
    public List<Version> edgeVersions() {
        return CollectionsKt.emptyList();
    }

    public boolean canProduce() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void produceCreateOrReplace(boolean withComment) {
        void $this$apply;
        CreateProducer<?> createProducer = this.getContext().getHelper().createProducer(this.getContext(), (BasicElement)this.to);
        boolean bl = false;
        boolean bl2 = false;
        CreateProducer<?> $this$apply2 = createProducer;
        boolean bl3 = false;
        DelegateScriptingOptions delegateScriptingOptions = new DelegateScriptingOptions($this$apply2.getOptions());
        boolean bl4 = false;
        boolean bl5 = false;
        DelegateScriptingOptions delegateScriptingOptions2 = delegateScriptingOptions;
        CreateProducer<?> createProducer2 = $this$apply2;
        boolean bl6 = false;
        $this$apply.getOptions().put(ScriptingOptionStatic.CREATE_OR_REPLACE, true);
        $this$apply.getOptions().put(ScriptingOptionStatic.SKIP_COMMENTS, !withComment);
        $this$apply.getOptions().put(ScriptingOptionStatic.IGNORE_OWNER, true);
        Unit unit = Unit.INSTANCE;
        createProducer2.setOptions((ScriptingOptions)delegateScriptingOptions);
        $this$apply2.produce();
    }

    protected final void produceDropCreate() {
        this.produceDrop();
        this.produceCreate((BasicElement)this.to);
    }

    /*
     * WARNING - void declaration
     */
    protected final void produceCreate(@NotNull BasicElement e2) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        CreateProducer<?> createProducer = this.getContext().getHelper().createProducer(this.getContext(), e2);
        boolean bl = false;
        boolean bl2 = false;
        CreateProducer<?> $this$apply2 = createProducer;
        boolean bl3 = false;
        DelegateScriptingOptions delegateScriptingOptions = new DelegateScriptingOptions($this$apply2.getOptions());
        boolean bl4 = false;
        boolean bl5 = false;
        DelegateScriptingOptions delegateScriptingOptions2 = delegateScriptingOptions;
        CreateProducer<?> createProducer2 = $this$apply2;
        boolean bl6 = false;
        $this$apply.getOptions().put(ScriptingOptionStatic.CREATE_OR_REPLACE, false);
        Unit unit = Unit.INSTANCE;
        createProducer2.setOptions((ScriptingOptions)delegateScriptingOptions);
        $this$apply2.produce();
    }

    protected final void produceDrop() {
        this.dropProducer((BasicElement)this.getElement()).produce();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final DropProducer<?> dropProducer(@NotNull BasicElement e2) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        DropProducer<?> dropProducer = this.getContext().getHelper().createDropProducer(this.getContext(), e2);
        boolean bl = false;
        boolean bl2 = false;
        DropProducer<?> $this$apply2 = dropProducer;
        boolean bl3 = false;
        DelegateScriptingOptions delegateScriptingOptions = new DelegateScriptingOptions($this$apply2.getOptions());
        boolean bl4 = false;
        boolean bl5 = false;
        DelegateScriptingOptions delegateScriptingOptions2 = delegateScriptingOptions;
        DropProducer<?> dropProducer2 = $this$apply2;
        boolean bl6 = false;
        $this$apply.getOptions().put(ScriptingOptionStatic.IF_EXISTS, false);
        Unit unit = Unit.INSTANCE;
        dropProducer2.setOptions((ScriptingOptions)delegateScriptingOptions);
        return dropProducer;
    }

    protected final void registerChildren(@NotNull BaseAlterGenerator generator, @NotNull Operation r, @NotNull Function1<? super BasicElement, Boolean> filter) {
        ElementDelta<?> it;
        ElementDelta<?> elementDelta;
        boolean bl;
        boolean bl2;
        BasicElement it2;
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        JBIterable jBIterable = this.getElement().getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"element.children");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (BasicElement)element$iv;
            boolean bl3 = false;
            BasicElement basicElement = it2;
            Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"it");
            if (!((Boolean)filter.invoke((Object)basicElement)).booleanValue()) continue;
            if (this.getContext().getBySource().get(it2) == null) continue;
            bl2 = false;
            bl = false;
            it = elementDelta;
            boolean bl4 = false;
            ElementDelta<?> elementDelta2 = it;
            Intrinsics.checkNotNullExpressionValue(elementDelta2, (String)"it");
            BaseAlterGenerator.prepareElement$default(generator, elementDelta2, r, false, 4, null);
        }
        JBIterable jBIterable2 = this.to.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"to.children");
        $this$forEach$iv = (Iterable)jBIterable2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (BasicElement)element$iv;
            boolean bl5 = false;
            BasicElement basicElement = it2;
            Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"it");
            if (!((Boolean)filter.invoke((Object)basicElement)).booleanValue()) continue;
            if (this.getContext().getByTarget().get(it2) == null) continue;
            bl2 = false;
            bl = false;
            it = elementDelta;
            boolean bl6 = false;
            ElementDelta<?> elementDelta3 = it;
            Intrinsics.checkNotNullExpressionValue(elementDelta3, (String)"it");
            BaseAlterGenerator.prepareElement$default(generator, elementDelta3, r, false, 4, null);
        }
    }

    public static /* synthetic */ void registerChildren$default(AlterProducer alterProducer, BaseAlterGenerator baseAlterGenerator, Operation operation2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerChildren");
        }
        if ((n & 4) != 0) {
            function1 = registerChildren.1.INSTANCE;
        }
        alterProducer.registerChildren(baseAlterGenerator, operation2, (Function1<BasicElement, Boolean>)function1);
    }

    public AlterProducer(@NotNull ScriptingContext context, @NotNull ElementAlteration<? extends T> elements2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements2, (String)"elements");
        super(context, BaseAlterGenerator.Companion.getALTER(), elements2.getSourceElement(), null, 8, null);
        this.to = elements2.getTargetElement();
        this.flags = new Flags();
        BasicMetaPropertyId basicMetaPropertyId = BasicModNamedElement.NAME;
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaPropertyId, (String)"BasicModNamedElement.NAME");
        this.flags.add(basicMetaPropertyId, this.checkRename());
        this.flags.add(BaseProducersKt.getTMP_NAME_FLAG_ID(), this.tmpName != null);
        BasicMetaPropertyId basicMetaPropertyId2 = BasicModNamedElement.COMMENT;
        Intrinsics.checkNotNullExpressionValue((Object)basicMetaPropertyId2, (String)"BasicModNamedElement.COMMENT");
        this.computeFlag(basicMetaPropertyId2);
    }
}

