/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.dialects.oracle.model.OraCluster;
import com.intellij.database.dialects.oracle.model.OraClusterColumn;
import com.intellij.database.dialects.oracle.model.OraCollectionType;
import com.intellij.database.dialects.oracle.model.OraDbLink;
import com.intellij.database.dialects.oracle.model.OraModel;
import com.intellij.database.dialects.oracle.model.OraRoot;
import com.intellij.database.dialects.oracle.model.OraSingleRoutine;
import com.intellij.database.dialects.oracle.model.OraSourceAware;
import com.intellij.database.dialects.oracle.model.OraTableColumn;
import com.intellij.database.dialects.oracle.model.OraUser;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModTableColumn;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.schemaEditor.SchemaApplyHelper;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.ui.LayeredIcon;
import icons.DatabaseIcons;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\rH\u0016J,\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/oracle/model/OraModelHelper;", "Lcom/intellij/database/model/ModelHelper;", "()V", "exportApplyColumn", "", "helper", "Lcom/intellij/database/schemaEditor/SchemaApplyHelper;", "from", "Lcom/intellij/database/schemaEditor/model/DeColumn;", "to", "Lcom/intellij/database/model/basic/BasicModTableColumn;", "exportLightExport", "Lcom/intellij/database/schemaEditor/SchemaExporters$BasicSchemaExportHelper;", "Lcom/intellij/database/model/basic/BasicTableColumn;", "fillPropertiesWithExamples", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "vars", "", "", "getIcon", "Ljavax/swing/Icon;", "c", "Lcom/intellij/database/model/DasObject;", "handleJdbcComment", "obj", "Lcom/intellij/database/model/basic/BasicModNamedElement;", "comment", "invalidateIntrospectionCache", "model", "Lcom/intellij/database/model/basic/BasicModModel;", "intellij.database.dialects.oracle"})
public final class OraModelHelper
extends ModelHelper {
    public void exportApplyColumn(@NotNull SchemaApplyHelper helper, @NotNull DeColumn from, @NotNull BasicModTableColumn to) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        super.exportApplyColumn(helper, from, to);
        if (to instanceof OraTableColumn) {
            boolean autoInc = from.flags.contains(DeColumn.Flag.AUTO_INC);
            ((OraTableColumn)to).setAutoInc(autoInc);
        }
    }

    public void exportLightExport(@NotNull SchemaExporters.BasicSchemaExportHelper helper, @NotNull DeColumn to, @NotNull BasicTableColumn from) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        if (from instanceof OraTableColumn && from.isAutoInc()) {
            to.flags.add(DeColumn.Flag.AUTO_INC);
        }
    }

    @Nullable
    public String handleJdbcComment(@NotNull BasicModNamedElement obj2, @Nullable String comment) {
        Intrinsics.checkNotNullParameter((Object)obj2, (String)"obj");
        return obj2 instanceof OraSingleRoutine && comment != null && StringsKt.startsWith$default((String)comment, (String)"Standalone", (boolean)false, (int)2, null) ? null : comment;
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e2, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull Map<String, String> vars) {
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        super.fillPropertiesWithExamples(e2, variant, vars);
        if (e2 instanceof OraCluster) {
            OraClusterColumn col = (OraClusterColumn)((OraCluster)e2).getColumns().createNewOne();
            this.setTemplateName(col, "cluster_column");
            OraClusterColumn oraClusterColumn = col;
            Intrinsics.checkNotNullExpressionValue((Object)oraClusterColumn, (String)"col");
            oraClusterColumn.setDataType(DataTypeFactory.of((String)"int"));
            vars.put("cluster_column", "cluster_column int");
        }
        if (e2 instanceof OraCollectionType) {
            ((OraCollectionType)e2).setElementType(DataTypeFactory.of((String)"varchar"));
            vars.put("element_type", "varchar");
        }
        if (e2 instanceof OraDbLink) {
            ((OraDbLink)e2).setRemoteDatabaseString("remote_database");
            vars.put("remote_database", "remote_database");
            ((OraDbLink)e2).setShared(true);
            ((OraDbLink)e2).setConnectUserName("user_name");
            ((OraDbLink)e2).setAuthUserName("user_name");
            vars.put("user_name", "user_name");
            ((OraDbLink)e2).setConnectUserPassword("user_password");
            ((OraDbLink)e2).setAuthUserPassword("user_password");
            vars.put("user_password", "user_password");
        }
        if (e2 instanceof OraUser) {
            ((OraUser)e2).setPassword(new OneTimeString(""));
            vars.put("password", "\"\"");
        }
    }

    @Nullable
    public Icon getIcon(@NotNull DasObject c) {
        BasicElement element;
        BasicElement basicElement;
        Icon originalIcon;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Icon icon = originalIcon = super.getIcon(c);
        DasObject dasObject = c;
        if (!(dasObject instanceof BasicElement)) {
            dasObject = null;
        }
        if ((basicElement = (BasicElement)dasObject) == null) {
            basicElement = element = DbImplUtilCore.getMaybeBasicElement((DasObject)c);
        }
        if (element instanceof OraSourceAware && ((OraSourceAware)element).isWithDebugInfo()) {
            icon = (Icon)new LayeredIcon(new Icon[]{originalIcon, DatabaseIcons.GreenBugOverlap});
        }
        return icon;
    }

    public void invalidateIntrospectionCache(@NotNull BasicModModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        BasicModModel basicModModel = model;
        if (!(basicModModel instanceof OraModel)) {
            basicModModel = null;
        }
        OraModel oraModel = (OraModel)basicModModel;
        if (oraModel == null) {
            return;
        }
        OraModel m = oraModel;
        OraRoot oraRoot = m.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)oraRoot, (String)"m.root");
        oraRoot.setCatalogAccessPermissions(null);
    }
}

