/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle.model;

import com.intellij.database.dialects.oracle.model.OraCollectionTypeBase;
import com.intellij.database.dialects.oracle.model.OraModelUtils$WhenMappings;
import com.intellij.database.dialects.oracle.model.OraPackageCollectionType;
import com.intellij.database.dialects.oracle.model.OraSchema;
import com.intellij.database.dialects.oracle.model.properties.OraCollectionTypeKind;
import com.intellij.database.dialects.oracle.types.OraIntervalType;
import com.intellij.database.dialects.oracle.types.OraNestedTableType;
import com.intellij.database.dialects.oracle.types.OraRefCursorType;
import com.intellij.database.dialects.oracle.types.OraRefType;
import com.intellij.database.dialects.oracle.types.OraTimeAwareType;
import com.intellij.database.dialects.oracle.types.OraVaryingArrayType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTypeAwareObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasBuiltinTypeWithLength;
import com.intellij.database.types.DasBuiltinTypeWithLengthUnits;
import com.intellij.database.types.DasBuiltinTypeWithPrecision;
import com.intellij.database.types.DasBuiltinWrapperType;
import com.intellij.database.types.DasDefinedType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasUnresolvedType;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.oracle.OraTypeService;
import com.intellij.util.ObjectUtils;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e\u001a \u0010\u0019\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0015H\u0002\u001a\u0018\u0010\u001b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a*\u0010\u001b\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000e\u001a(\u0010\u001e\u001a\u0004\u0018\u00010\u0011*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001e\u0010!\u001a\u0004\u0018\u00010\t*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"NUMBER_REGEX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "adjustBuiltinType", "Lcom/intellij/database/types/DasBuiltinType;", "builtinType", "dataType", "Lcom/intellij/database/model/DataType;", "createCollectionType", "Lcom/intellij/database/types/DasType;", "typeDef", "Lcom/intellij/database/dialects/oracle/model/OraCollectionTypeBase;", "createDasType", "context", "Lcom/intellij/database/model/basic/BasicElement;", "createPredefinedType", "getSchema", "Lcom/intellij/database/model/DasObject;", "model", "Lcom/intellij/database/model/basic/BasicModel;", "name", "", "parsePredefinedType", "resolveTypeDefinition", "Lcom/intellij/database/model/DasUserDefinedType;", "resolveTypeInSchema", "schemaName", "resolveTypeReference", "packageName", "typeName", "getChild", "kind", "Lcom/intellij/database/model/ObjectKind;", "getChildType", "intellij.database.dialects.oracle"})
@JvmName(name="OraModelUtils")
public final class OraModelUtils {
    private static final Pattern NUMBER_REGEX = Pattern.compile("\\d+");

    private static final DasObject getSchema(BasicModel model, String name2) {
        Object v1;
        block1: {
            Collection collection = model.getNameIndex().getObjectsByName(name2);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"model.nameIndex.getObjectsByName(name)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DasObject it = (DasObject)element$iv;
                boolean bl = false;
                if (!(it instanceof OraSchema)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private static final DasObject getChild(DasObject $this$getChild, BasicModel model, ObjectKind kind, String name2) {
        Object v2;
        block1: {
            Collection collection = model.getNameIndex().getObjectsByName(name2);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"model.nameIndex.getObjectsByName(name)");
            Iterable $this$firstOrNull$iv = collection;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DasObject it = (DasObject)element$iv;
                boolean bl = false;
                DasObject dasObject = it;
                Intrinsics.checkNotNullExpressionValue((Object)dasObject, (String)"it");
                if (!(Intrinsics.areEqual((Object)dasObject.getDasParent(), (Object)$this$getChild) && (kind == null || Intrinsics.areEqual((Object)kind, (Object)ObjectKind.NONE) || Intrinsics.areEqual((Object)kind, (Object)it.getKind())))) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private static final DasType getChildType(DasObject $this$getChildType, BasicModel model, String name2) {
        Iterator iterator = model.getNameIndex().getObjectsByName(name2).iterator();
        while (iterator.hasNext()) {
            DasObject obj2;
            DasObject dasObject = obj2 = (DasObject)iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)dasObject, (String)"obj");
            if (Intrinsics.areEqual((Object)dasObject.getDasParent(), (Object)$this$getChildType) ^ true || !(obj2 instanceof DasTypeAwareObject)) continue;
            return ((DasTypeAwareObject)obj2).getDasType();
        }
        return null;
    }

    private static final DasType resolveTypeInSchema(BasicModel model, String name2, String schemaName) {
        DasObject dasObject = OraModelUtils.getSchema(model, schemaName);
        if (dasObject != null && (dasObject = OraModelUtils.getChildType(dasObject, model, name2)) != null) {
            DasObject dasObject2 = dasObject;
            boolean bl = false;
            boolean bl2 = false;
            DasObject it = dasObject2;
            boolean bl3 = false;
            return it;
        }
        String expectedSchema = OraTypeService.extraPredefinedTypeSchemas.get(name2);
        DasType predefinedType = Intrinsics.areEqual((Object)expectedSchema, (Object)schemaName) ? OraTypeService.predefinedTypes.get(name2) : null;
        DasType dasType = predefinedType;
        if (dasType == null) {
            dasType = (DasType)new DasUnresolvedType(schemaName + '.' + name2);
        }
        return dasType;
    }

    private static final DasType resolveTypeReference(DataType dataType, BasicElement context) {
        String string = dataType.schemaName;
        String string2 = dataType.packageName;
        String string3 = dataType.typeName;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"dataType.typeName");
        return OraModelUtils.resolveTypeReference(string, string2, string3, context);
    }

    private static final DasBuiltinType adjustBuiltinType(DasBuiltinType builtinType, DataType dataType) {
        String suffix2;
        int scale;
        int size;
        block9: {
            block10: {
                size = dataType.size;
                scale = dataType.scale;
                LengthUnit lengthUnit = dataType.sizeUnit;
                Intrinsics.checkNotNullExpressionValue((Object)lengthUnit, (String)"dataType.sizeUnit");
                LengthUnit unit = lengthUnit;
                if (builtinType instanceof DasBuiltinTypeWithPrecision && (size != -1 || scale != 0)) {
                    return (DasBuiltinType)((DasBuiltinTypeWithPrecision)builtinType).copy(((DasBuiltinTypeWithPrecision)builtinType).getName(), size, scale);
                }
                if (builtinType instanceof DasBuiltinTypeWithLength && size != -1) {
                    return (DasBuiltinType)((DasBuiltinTypeWithLength)builtinType).copy(((DasBuiltinTypeWithLength)builtinType).getName(), ((DasBuiltinTypeWithLength)builtinType).getKind(), size);
                }
                if (builtinType instanceof DasBuiltinTypeWithLengthUnits && (size != -1 || Intrinsics.areEqual((Object)unit, (Object)LengthUnit.NONE) ^ true)) {
                    return (DasBuiltinType)((DasBuiltinTypeWithLengthUnits)builtinType).copy(((DasBuiltinTypeWithLengthUnits)builtinType).getName(), size, unit, dataType.sizeUnitExplicit);
                }
                String string = StringUtil.notNullize((String)StringUtil.toUpperCase((String)dataType.suffix));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringUtil.notNullize(St\u2026perCase(dataType.suffix))");
                suffix2 = string;
                if (!(builtinType instanceof OraTimeAwareType)) break block9;
                if (size != -1) break block10;
                if (!StringUtil.isNotEmpty((String)dataType.suffix)) break block9;
            }
            CharSequence charSequence = suffix2;
            boolean bl = false;
            OraTimeAwareType.TimeZoneKind timeZoneKind = charSequence.length() == 0 ? OraTimeAwareType.TimeZoneKind.NONE : (StringsKt.contains$default((CharSequence)suffix2, (CharSequence)"LOCAL", (boolean)false, (int)2, null) ? OraTimeAwareType.TimeZoneKind.LOCAL_TZ : OraTimeAwareType.TimeZoneKind.TZ);
            return ((OraTimeAwareType)builtinType).copy(((OraTimeAwareType)builtinType).getName(), ((OraTimeAwareType)builtinType).getKind(), size, timeZoneKind);
        }
        if (builtinType instanceof OraIntervalType.YearToMonth && size != -1) {
            return ((OraIntervalType.YearToMonth)builtinType).copy(size);
        }
        if (builtinType instanceof OraIntervalType.DayToSecond && (size != -1 || scale != 0)) {
            Matcher matcher;
            CharSequence timeZoneKind = suffix2;
            boolean bl = false;
            if (timeZoneKind.length() > 0 && (matcher = NUMBER_REGEX.matcher(suffix2)).find()) {
                int secondFraction = StringUtil.parseInt((String)matcher.group(), (int)0);
                return ((OraIntervalType.DayToSecond)builtinType).copy(size, secondFraction);
            }
            return ((OraIntervalType.DayToSecond)builtinType).copy(size, scale);
        }
        return builtinType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final DasType parsePredefinedType(DataType dataType) {
        String name2;
        String string = name2 = StringUtil.toUpperCase((String)dataType.typeName);
        if (string == null) return OraTypeService.predefinedTypes.get(name2);
        String string2 = string;
        switch (string2.hashCode()) {
            case 746814881: {
                if (!string2.equals("INTERVAL DAY")) return OraTypeService.predefinedTypes.get(name2);
                return (DasType)OraTypeService.INTERVAL_DAY_TO_SECOND;
            }
            case 1677053624: {
                if (!string2.equals("INTERVAL YEAR")) return OraTypeService.predefinedTypes.get(name2);
                return (DasType)OraTypeService.INTERVAL_YEAR_TO_MONTH;
            }
        }
        return OraTypeService.predefinedTypes.get(name2);
    }

    private static final DasType createPredefinedType(DataType dataType) {
        DasType dasType = OraModelUtils.parsePredefinedType(dataType);
        if (!(dasType instanceof DasBuiltinType)) {
            return dasType;
        }
        return dasType instanceof DasBuiltinWrapperType ? (DasType)((DasBuiltinWrapperType)dasType).transform((Function1)new Function1<DasBuiltinType, DasBuiltinType>(dataType){
            final /* synthetic */ DataType $dataType;

            @NotNull
            public final DasBuiltinType invoke(@NotNull DasBuiltinType t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                return OraModelUtils.access$adjustBuiltinType(t, this.$dataType);
            }
            {
                this.$dataType = dataType;
                super(1);
            }
        }) : (DasType)OraModelUtils.adjustBuiltinType((DasBuiltinType)dasType, dataType);
    }

    @Nullable
    public static final DasUserDefinedType resolveTypeDefinition(@NotNull DataType dataType, @NotNull BasicElement context) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        DasType dasType = OraModelUtils.resolveTypeReference(dataType, context);
        if (!(dasType instanceof DasDefinedType)) {
            dasType = null;
        }
        DasDefinedType dasDefinedType = (DasDefinedType)dasType;
        return dasDefinedType != null ? dasDefinedType.getDefinition() : null;
    }

    @NotNull
    public static final DasType resolveTypeReference(@Nullable String schemaName, @Nullable String packageName, @NotNull String typeName, @NotNull BasicElement context) {
        DasObject dasObject;
        Object object;
        Intrinsics.checkNotNullParameter((Object)typeName, (String)"typeName");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModel basicModel = context.getModel();
        if (basicModel == null) {
            DasType dasType = DasType.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"DasType.UNKNOWN");
            return dasType;
        }
        Intrinsics.checkNotNullExpressionValue((Object)basicModel, (String)"context.model ?: return DasType.UNKNOWN");
        BasicModel model = basicModel;
        CharSequence charSequence = schemaName;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            charSequence = packageName;
            bl = false;
            bl2 = false;
            if (!(charSequence == null || charSequence.length() == 0)) {
                DasObject dasObject2 = OraModelUtils.getSchema(model, schemaName);
                if (dasObject2 == null || (dasObject2 = OraModelUtils.getChild(dasObject2, model, ObjectKind.PACKAGE, packageName)) == null || (dasObject2 = OraModelUtils.getChildType(dasObject2, model, typeName)) == null) {
                    dasObject2 = (DasType)new DasUnresolvedType(schemaName + '.' + packageName + '.' + typeName);
                }
                return dasObject2;
            }
        }
        CharSequence charSequence2 = schemaName;
        bl2 = false;
        boolean bl3 = false;
        String qualifierName = !(charSequence2 == null || charSequence2.length() == 0) ? schemaName : packageName;
        charSequence2 = qualifierName;
        bl2 = false;
        bl3 = false;
        if (!(charSequence2 == null || charSequence2.length() == 0)) {
            DasObject container;
            DasObject dasObject3;
            DasObject schema = DasUtil.getParentOfKind((DasObject)((DasObject)context), (ObjectKind)ObjectKind.SCHEMA, (boolean)false);
            Object object2 = schema;
            if (object2 == null || (object2 = OraModelUtils.getChild(object2, model, ObjectKind.PACKAGE, qualifierName)) == null) {
                DasObject dasObject4 = schema;
                object2 = dasObject4 != null ? OraModelUtils.getChild(dasObject4, model, ObjectKind.OBJECT_TYPE, qualifierName) : null;
            }
            if ((dasObject3 = (container = object2)) == null || (dasObject3 = OraModelUtils.getChildType(dasObject3, model, typeName)) == null) {
                dasObject3 = OraModelUtils.resolveTypeInSchema(model, typeName, qualifierName);
            }
            return dasObject3;
        }
        Object object3 = DasUtil.getParentOfKind((DasObject)((DasObject)context), (ObjectKind)ObjectKind.PACKAGE, (boolean)false);
        if (object3 == null || (object3 = OraModelUtils.getChildType(object3, model, typeName)) == null) {
            DasObject dasObject5 = DasUtil.getParentOfKind((DasObject)((DasObject)context), (ObjectKind)ObjectKind.OBJECT_TYPE, (boolean)false);
            object3 = object = dasObject5 != null ? OraModelUtils.getChildType(dasObject5, model, typeName) : null;
        }
        if (object3 == null) {
            DasObject dasObject6 = DasUtil.getParentOfKind((DasObject)((DasObject)context), (ObjectKind)ObjectKind.SCHEMA, (boolean)false);
            object = dasObject = dasObject6 != null ? OraModelUtils.getChildType(dasObject6, model, typeName) : null;
        }
        if (object == null) {
            dasObject = (DasType)new DasUnresolvedType(typeName);
        }
        return dasObject;
    }

    @NotNull
    public static final DasType createDasType(@NotNull DataType dataType, @NotNull BasicElement context) {
        Intrinsics.checkNotNullParameter((Object)dataType, (String)"dataType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (dataType.custom) {
            DasType predefinedType;
            String schemaName = dataType.schemaName;
            if ((schemaName == null || Intrinsics.areEqual((Object)"SYS", (Object)schemaName) && OraTypeService.predefinedSysTypeNames.contains(StringUtil.toUpperCase((String)dataType.typeName))) && (predefinedType = OraModelUtils.createPredefinedType(dataType)) != null) {
                return predefinedType;
            }
            DasType dasType = OraModelUtils.resolveTypeReference(dataType, context);
            if (StringsKt.equals((String)"ref", (String)dataType.suffix, (boolean)true)) {
                DasType baseType = OraModelUtils.resolveTypeReference(dataType, context);
                return (DasType)new OraRefType(baseType);
            }
            if (StringsKt.equals((String)"ref cursor", (String)dataType.suffix, (boolean)true)) {
                DasType baseType = OraModelUtils.resolveTypeReference(dataType, context);
                return (DasType)new OraRefCursorType(baseType);
            }
            return dasType;
        }
        Object object = ObjectUtils.notNull((Object)OraModelUtils.createPredefinedType(dataType), (Object)DasType.UNKNOWN);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ObjectUtils.notNull(crea\u2026taType), DasType.UNKNOWN)");
        return (DasType)object;
    }

    @NotNull
    public static final DasType createCollectionType(@NotNull OraCollectionTypeBase typeDef) {
        DasType dasType;
        Intrinsics.checkNotNullParameter((Object)typeDef, (String)"typeDef");
        OraCollectionTypeKind oraCollectionTypeKind = typeDef.getTypeKind();
        if (oraCollectionTypeKind == null) {
            DasType dasType2 = DasType.UNKNOWN;
            Intrinsics.checkNotNullExpressionValue((Object)dasType2, (String)"DasType.UNKNOWN");
            return dasType2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)((Object)oraCollectionTypeKind), (String)"typeDef.typeKind ?: return DasType.UNKNOWN");
        OraCollectionTypeKind kind = oraCollectionTypeKind;
        DataType dataType = typeDef.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"typeDef.elementType");
        DasType elementType = OraModelUtils.createDasType(dataType, (BasicElement)typeDef);
        switch (OraModelUtils$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                if (!(typeDef instanceof OraPackageCollectionType)) {
                    DasType dasType3 = DasType.UNKNOWN;
                    Intrinsics.checkNotNullExpressionValue((Object)dasType3, (String)"DasType.UNKNOWN");
                    return dasType3;
                }
                DataType dataType2 = ((OraPackageCollectionType)typeDef).getIndexElementType();
                Intrinsics.checkNotNullExpressionValue((Object)dataType2, (String)"typeDef.indexElementType");
                DasType indexType = OraModelUtils.createDasType(dataType2, (BasicElement)typeDef);
                dasType = (DasType)new OraNestedTableType(elementType, indexType);
                break;
            }
            case 2: {
                dasType = (DasType)new OraNestedTableType(elementType, null, 2, null);
                break;
            }
            case 3: {
                dasType = (DasType)new OraVaryingArrayType(typeDef.getUpperBound(), elementType);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return dasType;
    }

    public static final /* synthetic */ DasBuiltinType access$adjustBuiltinType(DasBuiltinType builtinType, DataType dataType) {
        return OraModelUtils.adjustBuiltinType(builtinType, dataType);
    }
}

