/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;

public class SqliteDomains
extends BaseDomainRegistry {
    private static final int MAX_CHAR = 20;
    private static final int MAX_NCHAR = 55;
    private static final int MAX_VARCHAR = 255;

    public SqliteDomains() {
        this.add((Domain)new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("int", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9));
        this.add((Domain)new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new IntegerDomain("int8", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18));
        this.add((Domain)new BooleanDomain("boolean", ConversionPoint.BOOLEAN_NUMBER));
        this.add((Domain)new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add((Domain)new IntegerDomain("int2", ConversionPoint.NUMBER, -32768.0, 32767.0));
        this.add((Domain)new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add((Domain)new FloatDomain("double precision", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        this.add((Domain)new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        this.add((Domain)new TextDomain("text", ConversionPoint.TEXT, 0L, Integer.MAX_VALUE, false, true));
        this.add((Domain)new TextDomain("clob", ConversionPoint.TEXT, 0L, Integer.MAX_VALUE, false, true));
        this.add(new SimpleDomain("date", ConversionPoint.TEXT_DATE, PhysicalDomainType.DATE).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("datetime", ConversionPoint.TEXT_TIMESTAMP, PhysicalDomainType.TIMESTAMP, 0, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB_TEXT, PhysicalDomainType.BINARY, Integer.MAX_VALUE, -1L, false, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add((Domain)new TextDomain("char", ConversionPoint.CHAR, 20L, 1L, true, true));
        this.add((Domain)new TextDomain("character", ConversionPoint.CHAR, 20L, 1L, true, true));
        this.add((Domain)new TextDomain("nchar", ConversionPoint.NCHAR, 55L));
        this.add((Domain)new TextDomain("varchar", ConversionPoint.VARCHAR, 255L));
        this.add((Domain)new TextDomain("longvarchar", ConversionPoint.TEXT, Long.MAX_VALUE));
        this.add((Domain)new TextDomain("nvarchar", ConversionPoint.NVARCHAR, 255L));
        this.add((Domain)new FloatDomain("numeric", ConversionPoint.NUMBER, -1.7976931348623157E308, Double.MAX_VALUE));
    }
}

