/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.vertica.plan;

import com.google.common.collect.ImmutableSet;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.vertica.plan.VertRawPlanData;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.text.StringUtil;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VertPlanModelBuilder
extends AbstractPlanModelBuilder<VertRawPlanData, JSONObject> {
    public static final Map<String, PlanModel.NodeType> TYPE_MAPPING = new HashMap<String, PlanModel.NodeType>();
    public static final Set<String> HANDLED_KEYS = ImmutableSet.of((Object)"Outer", (Object)"Inner", (Object)"INPUT", (Object)"ROWS", (Object)"PROJECTION", (Object)"COST", (Object[])new String[0]);

    public VertPlanModelBuilder() {
        super(EnumSet.noneOf(PlanModel.Feature.class));
    }

    @Override
    @NotNull
    public VertRawPlanData createData() {
        return new VertRawPlanData();
    }

    @Override
    protected void parseData() {
        this.parseRoot(((VertRawPlanData)this.myData).json);
    }

    private void parseRoot(@NotNull String json) throws PlanRetrievalException {
        JSONObject data;
        if (json == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(0);
        }
        try {
            data = new JSONObject(json);
        }
        catch (JSONException e2) {
            throw new PlanRetrievalException("Database returned invalid JSON", (Throwable)e2);
        }
        this.openNode(null);
        this.parseStatement(data);
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(1);
        }
        StringBuilder desc = new StringBuilder();
        Iterator it = object.keys();
        while (it.hasNext()) {
            String str;
            String key2 = (String)it.next();
            if (HANDLED_KEYS.contains(key2) || (str = object.optString(key2, null)) == null) continue;
            desc.append(key2).append(" = ").append(str).append(";\n");
        }
        String string = desc.toString();
        if (string == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull JSONObject object) {
        String extra;
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(3);
        }
        if ((extra = object.optString("EXTRA", null)) == null) {
            return null;
        }
        return StringUtil.trimStart((String)extra, (String)"for ");
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(4);
        }
        return VertPlanModelBuilder.optBig(object, "ROWS", null);
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(5);
        }
        return object.optString("PROJECTION", null);
    }

    @Override
    protected void parseSubPlans(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(6);
        }
        this.parseSubPlans(object, "Outer");
        this.parseSubPlans(object, "Inner");
        this.parseSubPlans(object, "INPUT");
    }

    private void parseSubPlans(@NotNull JSONObject object, String key2) {
        Object p;
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(7);
        }
        if ((p = object.opt(key2)) instanceof JSONObject) {
            this.parsePlan((JSONObject)p);
        } else if (p instanceof JSONArray) {
            JSONArray array = (JSONArray)p;
            int end = array.length();
            for (int i2 = 0; i2 < end; ++i2) {
                this.parsePlan(array.optJSONObject(i2));
            }
        }
    }

    @Override
    protected void parseStatement(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(8);
        }
        if (((VertRawPlanData)this.myData).version.isOrGreater(new int[]{9})) {
            JSONObject plan = object.optJSONObject("PLAN");
            if (plan == null) {
                this.unsupportedFormat("No `PLAN` in json plan");
            }
            this.parsePlan(plan);
        } else {
            this.parsePlan(object);
        }
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(9);
        }
        return VertPlanModelBuilder.optDouble(object, "COST", null);
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(10);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(11);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull JSONObject object) {
        if (object == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(12);
        }
        return false;
    }

    @Override
    protected void parsePlan(@NotNull JSONObject state2) {
        if (state2 == null) {
            VertPlanModelBuilder.$$$reportNull$$$0(13);
        }
        if (!this.openNode(state2)) {
            return;
        }
        this.parseSubPlans(state2);
        String nodeType = state2.optString("PATH_NAME");
        PlanModel.NodeType type = TYPE_MAPPING.get(nodeType);
        if (type == PlanModel.NodeType.ACCESS && state2.opt("PROJECTION") != null) {
            type = PlanModel.NodeType.INDEX_SCAN;
        } else if (type == PlanModel.NodeType.UNION && "ALL".equals(state2.opt("EXTRA"))) {
            type = PlanModel.NodeType.UNION_ALL;
        } else if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        PlanModel.GenericNode node = this.createNode(state2, type, nodeType);
        this.closeNode(node);
    }

    static {
        TYPE_MAPPING.put("STORAGE ACCESS", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("SELECT", PlanModel.NodeType.SELECT);
        TYPE_MAPPING.put("UNION", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("GROUPBY", PlanModel.NodeType.GROUP_BY);
        TYPE_MAPPING.put("JOIN", PlanModel.NodeType.JOIN);
        TYPE_MAPPING.put("SORT", PlanModel.NodeType.SORT);
        TYPE_MAPPING.put("ANALYTICAL", PlanModel.NodeType.TRANSFORM);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/vertica/plan/VertPlanModelBuilder";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/vertica/plan/VertPlanModelBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseRoot";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

