/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.layout;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyCurrentLayoutAction
extends AbstractGraphAction {
    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Graph2D graph) {
        GraphBuilder<?, ?> builder;
        if (e == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(0);
        }
        if (graph == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(1);
        }
        if ((builder = this.getBuilder(e)) == null) {
            return;
        }
        Layouter layouter = this.getLayouter(builder);
        if (layouter != null) {
            this.beforeLayoutPerformed(layouter, builder);
            GraphLayoutService.getInstance().doPerformAnimatedLayout(builder, layouter);
            this.afterLayoutPerformed(layouter, builder);
        }
    }

    @Override
    public void update(@NotNull AnActionEvent e, @NotNull Graph2D graph) {
        if (e == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(2);
        }
        if (graph == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(3);
        }
        Project project = ApplyCurrentLayoutAction.getProject(e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(project != null && graph != null && graph.nodeCount() > 0 && this.canLayout(this.getBuilder(e)));
    }

    static boolean areNodesMovingByUserNow(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(4);
        }
        return builder.getEditMode().getMoveSelectionMode().isActive();
    }

    @Nullable
    protected Layouter getLayouter(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(5);
        }
        return builder.getGraphPresentationModel().getSettings().getCurrentLayouter();
    }

    protected boolean canLayout(@Nullable GraphBuilder<?, ?> builder) {
        if (builder == null || ApplyCurrentLayoutAction.areNodesMovingByUserNow(builder)) {
            return false;
        }
        try {
            Layouter layouter = this.getLayouter(builder);
            return layouter != null && layouter.canLayout(builder.getGraph());
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void beforeLayoutPerformed(@NotNull Layouter layouter, @NotNull GraphBuilder<?, ?> builder) {
        if (layouter == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(7);
        }
        GraphLayoutService.getInstance().beforeLayoutPerformed(builder, layouter);
    }

    protected void afterLayoutPerformed(@NotNull Layouter layouter, @NotNull GraphBuilder<?, ?> builder) {
        if (layouter == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(8);
        }
        if (builder == null) {
            ApplyCurrentLayoutAction.$$$reportNull$$$0(9);
        }
        GraphLayoutService.getInstance().afterLayoutPerformed(builder, layouter, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layouter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/graph/builder/actions/layout/ApplyCurrentLayoutAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "areNodesMovingByUserNow";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getLayouter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeLayoutPerformed";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "afterLayoutPerformed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

