/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.gradle.execution;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrExecutionBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.gradle.GradleNativeWorkspace;
import com.jetbrains.cidr.cpp.gradle.execution.GradleAppRunConfigurationType;
import com.jetbrains.cidr.cpp.gradle.execution.GradleNativeBuildConfigurationHelper;
import com.jetbrains.cidr.cpp.gradle.execution.GradleNativeBuildProfileExecutionTarget;
import com.jetbrains.cidr.cpp.gradle.execution.GradleNativeBuildTarget;
import com.jetbrains.cidr.cpp.gradle.execution.GradleNativeConfiguration;
import com.jetbrains.cidr.cpp.gradle.execution.GradleNativeLauncher;
import com.jetbrains.cidr.execution.BuildConfigurationProblems;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrExecutableDataHolder;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleAppRunConfiguration
extends CidrRunConfiguration<GradleNativeConfiguration, GradleNativeBuildTarget>
implements CidrExecutableDataHolder {
    @Nullable
    private ExecutableData myExecutableData;

    public GradleAppRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    @NotNull
    public GradleAppRunConfigurationType getType() {
        GradleAppRunConfigurationType gradleAppRunConfigurationType = (GradleAppRunConfigurationType)super.getType();
        if (gradleAppRunConfigurationType == null) {
            GradleAppRunConfiguration.$$$reportNull$$$0(0);
        }
        return gradleAppRunConfigurationType;
    }

    public boolean canRunOn(@NotNull ExecutionTarget target) {
        if (target == null) {
            GradleAppRunConfiguration.$$$reportNull$$$0(1);
        }
        return target instanceof GradleNativeBuildProfileExecutionTarget;
    }

    @Nullable
    public OCResolveConfiguration getResolveConfiguration(@NotNull ExecutionTarget target) {
        BuildAndRunConfigurations configurations;
        if (target == null) {
            GradleAppRunConfiguration.$$$reportNull$$$0(2);
        }
        return (configurations = this.getBuildAndRunConfigurations(target)) == null ? null : GradleNativeWorkspace.getInstance(this.getProject()).getResolveConfigurationFor(configurations.buildConfiguration);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        this.doCheckConfiguration(this.getBuildProfileIfActive(), false);
    }

    public void checkSettingsBeforeRun() throws RuntimeConfigurationException {
        super.checkSettingsBeforeRun();
        this.doCheckConfiguration(this.getBuildProfileIfActive(), true);
    }

    @Nullable
    private String getBuildProfileIfActive() {
        return this.isSelectedConfiguration() ? GradleNativeBuildProfileExecutionTarget.getProfileName(ExecutionTargetManager.getInstance((Project)this.getProject()).getActiveTarget()) : null;
    }

    boolean isSelectedConfiguration() {
        RunnerAndConfigurationSettings selected = RunManager.getInstance((Project)this.getProject()).getSelectedConfiguration();
        return selected != null && Objects.equals(selected.getUniqueID(), RunnerAndConfigurationSettingsImpl.getUniqueIdFor((RunConfiguration)this));
    }

    private void doCheckConfiguration(@Nullable String buildProfile, boolean checkExecutableSpecified) throws RuntimeConfigurationException {
        BuildConfigurationProblems problems = new BuildConfigurationProblems();
        this.getBuildAndRunConfigurations(buildProfile, problems, checkExecutableSpecified);
        problems.throwAsConfigurationExceptions();
    }

    @Nullable
    public GradleNativeBuildTarget getBuildTarget() {
        GradleNativeBuildConfigurationHelper helper = this.getHelper();
        BuildTargetAndConfigurationData data = this.getTargetAndConfigurationData();
        return (GradleNativeBuildTarget)helper.findTarget(data == null ? null : data.target);
    }

    @NotNull
    public List<String> getBuildProfiles() {
        List list = ContainerUtil.map((Collection)this.getHelper().getConfigurations(this.getBuildTarget()), it -> it.getProfileName());
        if (list == null) {
            GradleAppRunConfiguration.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public BuildAndRunConfigurations getBuildAndRunConfigurations(@NotNull ExecutionTarget target) {
        if (target == null) {
            GradleAppRunConfiguration.$$$reportNull$$$0(4);
        }
        return this.getBuildAndRunConfigurations(target, null, false);
    }

    @Nullable
    public BuildAndRunConfigurations getBuildAndRunConfigurations(@NotNull ExecutionTarget target, @Nullable BuildConfigurationProblems problems, boolean checkExecutableSpecified) {
        if (target == null) {
            GradleAppRunConfiguration.$$$reportNull$$$0(5);
        }
        return this.getBuildAndRunConfigurations(GradleNativeBuildProfileExecutionTarget.getProfileName(target), problems, checkExecutableSpecified);
    }

    @Nullable
    public BuildAndRunConfigurations getBuildAndRunConfigurations(@NotNull String buildProfileName) {
        if (buildProfileName == null) {
            GradleAppRunConfiguration.$$$reportNull$$$0(6);
        }
        return this.getBuildAndRunConfigurations(buildProfileName, null, false);
    }

    @Nullable
    public BuildAndRunConfigurations getBuildAndRunConfigurations(@Nullable String buildProfileName, @Nullable BuildConfigurationProblems problems, boolean checkExecutableSpecified) {
        return (BuildAndRunConfigurations)ReadAction.compute(() -> {
            GradleNativeBuildConfigurationHelper helper;
            if (this.getProject().isDisposed()) {
                return null;
            }
            BuildTargetAndConfigurationData buildData = this.getTargetAndConfigurationData();
            if (buildData != null) {
                buildData = new BuildTargetAndConfigurationData(buildData.target, buildProfileName);
            }
            if (!BuildTargetAndConfigurationData.checkData((CidrBuildConfigurationHelper)(helper = GradleAppRunConfigurationType.getHelper(this.getProject())), (BuildTargetAndConfigurationData)buildData, (BuildConfigurationProblems)problems, (boolean)false, (boolean)true)) {
                return null;
            }
            assert (buildData != null);
            File runExecutable = null;
            GradleNativeConfiguration runConfig = null;
            ExecutableData runData = this.getExecutableData();
            if (runData == null && checkExecutableSpecified) {
                if (problems != null) {
                    problems.problems.add(CidrExecutionBundle.message((String)"build.configuration.parameterNotSelected", (Object[])new Object[]{CidrExecutionBundle.message((String)"build.configuration.executable", (Object[])new Object[0])}));
                }
                return null;
            }
            boolean runTargetIsValid = true;
            if (runData != null) {
                if (runData.target != null) {
                    if (!runData.target.equals((Object)buildData.target)) {
                        runConfig = GradleAppRunConfiguration.checkAndGetConfiguration(helper, problems, runData.target, buildData.configurationName, true, true);
                        runTargetIsValid = runConfig != null;
                    }
                } else {
                    CPPLog.LOG.assertTrue(runData.path != null);
                    runExecutable = new File(runData.path);
                }
            }
            CPPLog.LOG.assertTrue(buildData.target != null);
            GradleNativeConfiguration buildConfig = GradleAppRunConfiguration.checkAndGetConfiguration(helper, problems, buildData.target, buildData.configurationName, false, runConfig == null && runExecutable == null);
            if (buildConfig == null || !runTargetIsValid) {
                return null;
            }
            return new BuildAndRunConfigurations(buildConfig, runConfig, runExecutable, null);
        });
    }

    @Nullable
    private static GradleNativeConfiguration checkAndGetConfiguration(@NotNull GradleNativeBuildConfigurationHelper helper, @Nullable BuildConfigurationProblems problems, @NotNull BuildTargetData dataTarget, @Nullable String configurationName, boolean checkTargetType, boolean checkProduct) {
        GradleNativeBuildTarget target;
        if (helper == null) {
            GradleAppRunConfiguration.$$$reportNull$$$0(7);
        }
        if (dataTarget == null) {
            GradleAppRunConfiguration.$$$reportNull$$$0(8);
        }
        if ((target = (GradleNativeBuildTarget)helper.findTarget(dataTarget)) == null || checkTargetType && !target.isExecutable()) {
            if (problems != null) {
                problems.problems.add(CidrExecutionBundle.message((String)"build.configuration.parameterNotFound", (Object[])new Object[]{helper.getTargetTitle(), dataTarget.getDisplayString()}));
            }
            return null;
        }
        if (configurationName == null) {
            return null;
        }
        GradleNativeConfiguration config = helper.findConfiguration(target, configurationName);
        if (config == null) {
            if (problems != null) {
                problems.problems.add(CidrExecutionBundle.message((String)"build.configuration.parameterNotFoundForTarget", (Object[])new Object[]{helper.getConfigurationTitle(), configurationName, StringUtil.toLowerCase((String)helper.getTargetTitle()), dataTarget.getDisplayString()}));
            }
            return null;
        }
        if (checkProduct && config.getProductFile() == null) {
            if (problems != null) {
                problems.problems.add(CidrExecutionBundle.message((String)"build.configuration.productNotFound", (Object[])new Object[]{StringUtil.toLowerCase((String)helper.getTargetTitle()), dataTarget.getDisplayString(), configurationName}));
            }
            return null;
        }
        return config;
    }

    @Nullable
    public CidrCommandLineState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        if (executor == null) {
            GradleAppRunConfiguration.$$$reportNull$$$0(9);
        }
        if (env == null) {
            GradleAppRunConfiguration.$$$reportNull$$$0(10);
        }
        return new CidrCommandLineState(env, (CidrLauncher)new GradleNativeLauncher(env, this));
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            GradleAppRunConfiguration.$$$reportNull$$$0(11);
        }
        super.writeExternal(element);
        if (this.myExecutableData != null) {
            this.myExecutableData.writeExternal(element);
        }
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            GradleAppRunConfiguration.$$$reportNull$$$0(12);
        }
        super.readExternal(element);
        this.myExecutableData = ExecutableData.loadExternal((Element)element);
    }

    @NotNull
    public GradleNativeBuildConfigurationHelper getHelper() {
        GradleNativeBuildConfigurationHelper gradleNativeBuildConfigurationHelper = GradleAppRunConfigurationType.getHelper(this.getProject());
        if (gradleNativeBuildConfigurationHelper == null) {
            GradleAppRunConfiguration.$$$reportNull$$$0(13);
        }
        return gradleNativeBuildConfigurationHelper;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        SettingsEditor<? extends GradleAppRunConfiguration> settingsEditor = this.getType().createEditor(this.getProject());
        if (settingsEditor == null) {
            GradleAppRunConfiguration.$$$reportNull$$$0(14);
        }
        return settingsEditor;
    }

    @Nullable
    public ExecutableData getExecutableData() {
        return this.myExecutableData;
    }

    public void setExecutableData(@Nullable ExecutableData executableData) {
        this.myExecutableData = executableData;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/gradle/execution/GradleAppRunConfiguration";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildProfileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataTarget";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/gradle/execution/GradleAppRunConfiguration";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildProfiles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelper";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canRunOn";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResolveConfiguration";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getBuildAndRunConfigurations";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkAndGetConfiguration";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class BuildAndRunConfigurations {
        @NotNull
        public final GradleNativeConfiguration buildConfiguration;
        @Nullable
        public final GradleNativeConfiguration runConfiguration;
        @Nullable
        public final File runExecutable;
        @Nullable
        public final String explicitBuildTargetName;

        public BuildAndRunConfigurations(@NotNull GradleNativeConfiguration buildConfiguration, @Nullable GradleNativeConfiguration runConfiguration, @Nullable File runExecutable, @Nullable String explicitBuildTargetName) {
            if (buildConfiguration == null) {
                BuildAndRunConfigurations.$$$reportNull$$$0(0);
            }
            this.buildConfiguration = buildConfiguration;
            this.runConfiguration = runConfiguration;
            this.runExecutable = runExecutable;
            this.explicitBuildTargetName = explicitBuildTargetName;
        }

        public BuildAndRunConfigurations(@NotNull GradleNativeConfiguration buildConfiguration) {
            if (buildConfiguration == null) {
                BuildAndRunConfigurations.$$$reportNull$$$0(1);
            }
            this(buildConfiguration, null, null, null);
        }

        @NotNull
        public GradleNativeConfiguration getRunConfiguration() {
            GradleNativeConfiguration gradleNativeConfiguration = this.runConfiguration != null ? this.runConfiguration : this.buildConfiguration;
            if (gradleNativeConfiguration == null) {
                BuildAndRunConfigurations.$$$reportNull$$$0(2);
            }
            return gradleNativeConfiguration;
        }

        @Nullable
        public File getRunFile() {
            if (this.runExecutable != null) {
                return this.runExecutable;
            }
            return this.getRunConfiguration().getProductFile();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildConfiguration";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/gradle/execution/GradleAppRunConfiguration$BuildAndRunConfigurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/gradle/execution/GradleAppRunConfiguration$BuildAndRunConfigurations";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunConfiguration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

