/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.connector;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.execution.process.ProcessListener;
import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangDebugLevel;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangDaemonNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnection;
import com.jetbrains.cidr.lang.daemon.clang.clangd.connector.ServerConnectionProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ProcessServerConnectionProvider
implements ServerConnectionProvider {
    private static final String CLANGD_LOG_PATH = System.getProperty("CLANGD_LOG_PATH");
    private static final Logger LOG = Logger.getInstance(ProcessServerConnectionProvider.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myExePath;
    private final boolean myIsIndexer;
    private final int myKeepAsts;
    @Nullable
    private Error myLastError;

    public ProcessServerConnectionProvider(@NotNull Project project, @NotNull String exePath, boolean isIndexer, int keepAsts) {
        if (project == null) {
            ProcessServerConnectionProvider.$$$reportNull$$$0(0);
        }
        if (exePath == null) {
            ProcessServerConnectionProvider.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myExePath = exePath;
        this.myIsIndexer = isIndexer;
        this.myKeepAsts = keepAsts;
    }

    @Override
    @Nullable
    public ServerConnection create() {
        GeneralCommandLine commandLine = this.buildCommandLine();
        File clangdPath = new File(commandLine.getExePath());
        if (!ProcessServerConnectionProvider.isAvailable(clangdPath)) {
            if (!clangdPath.exists()) {
                if (this.myLastError != Error.ClangdNotFound) {
                    Notifications.Bus.notify((Notification)new ClangDaemonNotification(ClangdBundle.message("clangd.executable.not.found", clangdPath)), (Project)this.myProject);
                    LOG.warn("clion-clangd is not found at " + clangdPath);
                }
                this.myLastError = Error.ClangdNotFound;
            } else {
                if (this.myLastError != Error.ClangdCannotBeExecuted) {
                    Notifications.Bus.notify((Notification)new ClangDaemonNotification(ClangdBundle.message("clangd.executable.cannot.execute", clangdPath)), (Project)this.myProject);
                    LOG.warn("clion-clangd cannot be executed at " + clangdPath);
                }
                this.myLastError = Error.ClangdCannotBeExecuted;
            }
            return null;
        }
        this.myLastError = null;
        try {
            ClangdProcessHandler processHandler = new ClangdProcessHandler(commandLine.createProcess(), commandLine.getPreparedCommandLine());
            CompletableFuture<Integer> stopFuture = new CompletableFuture<Integer>();
            processHandler.addProcessListener((ProcessListener)new ClangdProcessAdapter(stopFuture));
            processHandler.startNotify();
            return new ProcessServerConnection(processHandler, stopFuture);
        }
        catch (ExecutionException e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @NotNull
    private GeneralCommandLine buildCommandLine() {
        String traceFilePath;
        String mirrorFilePath;
        GeneralCommandLine commandLine = new GeneralCommandLine().withExePath(this.myExePath);
        commandLine.addParameter("--clion-mode=" + (this.myIsIndexer ? "clion-indexer" : "clion-main"));
        commandLine.addParameter("-update-debounce=0");
        commandLine.addParameter("-index=false");
        if (Registry.is((String)"clion.clang.clangd.index.on") && !this.myIsIndexer) {
            commandLine.addParameter("-clion-static-index");
        }
        commandLine.addParameter("-include-ineligible-results");
        commandLine.addParameter("-clang-tidy=0");
        if (CLANGD_LOG_PATH != null) {
            commandLine.addParameter("-trace=" + CLANGD_LOG_PATH);
        }
        String resourceDir = ClangUtils.getClangHeaderDir().getParent();
        commandLine.addParameter("-resource-dir=" + resourceDir);
        commandLine.addParameter("-keep-asts=" + this.myKeepAsts);
        if (Registry.is((String)"clion.clang.clangd.thread.pool")) {
            commandLine.addParameter("-clion-enable-thread-pool");
        }
        if (Registry.is((String)"clion.clang.clangd.recovery.ast")) {
            commandLine.addParameter("-recovery-ast");
        }
        if ((mirrorFilePath = (String)this.myProject.getUserData(ClangDaemonContext.MIRROR_FILE_PATH)) != null) {
            commandLine.addParameter("-input-mirror-file=" + mirrorFilePath);
            commandLine.addParameter("-clion-delimited-mirror-file");
        }
        if ((traceFilePath = (String)this.myProject.getUserData(ClangDaemonContext.TRACE_FILE_PATH)) != null) {
            commandLine.withEnvironment("CLANGD_TRACE", traceFilePath);
        }
        if (ClangDebugLevel.isInfoOrMore()) {
            commandLine.addParameter("-log=verbose");
        }
        commandLine.addParameter("-ranking-model=heuristics");
        commandLine.addParameter("-header-extensions=" + ClangUtils.getCurrentHeaderExtensions(this.myProject));
        if (System.getenv("LLVM_SYMBOLIZER_PATH") == null) {
            commandLine.withEnvironment("LLVM_SYMBOLIZER_PATH", ClangUtils.getBuiltinClangToolPath(SystemInfo.isWindows ? "llvm-symbolizer.exe" : "llvm-symbolizer").getPath());
        }
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            ProcessServerConnectionProvider.$$$reportNull$$$0(2);
        }
        return generalCommandLine;
    }

    private static boolean isAvailable(@Nullable File clangdPath) {
        try {
            return clangdPath != null && clangdPath.exists() && clangdPath.canExecute();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/connector/ProcessServerConnectionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/connector/ProcessServerConnectionProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ClangdProcessHandler
    extends BaseProcessHandler<Process> {
        ClangdProcessHandler(@NotNull Process process, @NotNull String cmdLine) {
            if (process == null) {
                ClangdProcessHandler.$$$reportNull$$$0(0);
            }
            if (cmdLine == null) {
                ClangdProcessHandler.$$$reportNull$$$0(1);
            }
            super(process, cmdLine, StandardCharsets.UTF_8);
        }

        public void startNotify() {
            this.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        myWaitFor.setTerminationCallback(exitCode -> this.notifyProcessTerminated(exitCode));
                    }
                    finally {
                        this.removeProcessListener((ProcessListener)this);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/lang/daemon/clang/clangd/connector/ProcessServerConnectionProvider$ClangdProcessHandler$1", "startNotified"));
                }
            });
            super.startNotify();
        }

        @NotNull
        public Future<?> executeOnPooledThread(@NotNull Runnable task) {
            if (task == null) {
                ClangdProcessHandler.$$$reportNull$$$0(2);
            }
            Future<?> future = ProcessIOExecutorService.INSTANCE.submit(task);
            if (future == null) {
                ClangdProcessHandler.$$$reportNull$$$0(3);
            }
            return future;
        }

        @NotNull
        public Future<?> executeTask(@NotNull Runnable task) {
            if (task == null) {
                ClangdProcessHandler.$$$reportNull$$$0(4);
            }
            Future<?> future = this.executeOnPooledThread(task);
            if (future == null) {
                ClangdProcessHandler.$$$reportNull$$$0(5);
            }
            return future;
        }

        protected void closeStreams() {
            super.closeStreams();
            try {
                this.myProcess.getErrorStream().close();
                this.myProcess.getOutputStream().close();
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
        }

        @Nullable
        public InputStream getProcessOutput() {
            return this.myProcess.getInputStream();
        }

        @Nullable
        public InputStream getProcessErrors() {
            return this.myProcess.getErrorStream();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "process";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cmdLine";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "task";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/connector/ProcessServerConnectionProvider$ClangdProcessHandler";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/connector/ProcessServerConnectionProvider$ClangdProcessHandler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeOnPooledThread";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "executeOnPooledThread";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "executeTask";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ClangdProcessAdapter
    extends ProcessAdapter {
        @NotNull
        final CompletableFuture<Integer> myAssociatedStopFuture;

        ClangdProcessAdapter(@NotNull CompletableFuture<Integer> associatedStopFuture) {
            if (associatedStopFuture == null) {
                ClangdProcessAdapter.$$$reportNull$$$0(0);
            }
            this.myAssociatedStopFuture = associatedStopFuture;
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                ClangdProcessAdapter.$$$reportNull$$$0(1);
            }
            this.myAssociatedStopFuture.complete(event.getExitCode());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "associatedStopFuture";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/connector/ProcessServerConnectionProvider$ClangdProcessAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class ProcessServerConnection
    implements ServerConnection {
        @NotNull
        private final ClangdProcessHandler myProcessHandler;
        @NotNull
        private final CompletableFuture<Integer> myStopFuture;

        ProcessServerConnection(@NotNull ClangdProcessHandler processHandler, @NotNull CompletableFuture<Integer> stopFuture) {
            if (processHandler == null) {
                ProcessServerConnection.$$$reportNull$$$0(0);
            }
            if (stopFuture == null) {
                ProcessServerConnection.$$$reportNull$$$0(1);
            }
            this.myProcessHandler = processHandler;
            this.myStopFuture = stopFuture;
        }

        public Process getProcess() {
            return this.myProcessHandler.getProcess();
        }

        @Override
        public void stop() {
            if (this.isActive()) {
                this.myProcessHandler.destroyProcess();
            }
        }

        @Override
        public void kill() {
            Process process = this.getProcess();
            if (this.isActive()) {
                if (OSProcessHandler.processCanBeKilledByOS((Process)process)) {
                    OSProcessUtil.killProcess((Process)process);
                } else {
                    process.destroy();
                }
            }
        }

        @Override
        @NotNull
        public CompletableFuture<Integer> getStopFuture() {
            CompletableFuture<Integer> completableFuture = this.myStopFuture;
            if (completableFuture == null) {
                ProcessServerConnection.$$$reportNull$$$0(2);
            }
            return completableFuture;
        }

        @Override
        public boolean isActive() {
            return !this.myStopFuture.isDone();
        }

        @Override
        @Nullable
        public InputStream getInputStream() {
            return this.myProcessHandler.getProcessOutput();
        }

        @Override
        @Nullable
        public OutputStream getOutputStream() {
            return this.myProcessHandler.getProcessInput();
        }

        @Override
        @Nullable
        public InputStream getErrorStream() {
            return this.myProcessHandler.getProcessErrors();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processHandler";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stopFuture";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/connector/ProcessServerConnectionProvider$ProcessServerConnection";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/connector/ProcessServerConnectionProvider$ProcessServerConnection";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getStopFuture";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum Error {
        ClangdNotFound,
        ClangdCannotBeExecuted;

    }
}

