/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.memory;

import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangStopData;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangMemoryUsageInfo;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServerListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.memory.ClangMemoryUsageWatchDogListener;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;

public class ClangMemoryUsageWatchDogImpl
implements ClangMemoryUsageWatchDog,
ClangServerListener,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)ClangMemoryUsageWatchDog.class.getName());
    private static final int DELAY = 10000;
    @NotNull
    private final ClangDaemonContext myContext;
    @NotNull
    private final ClangLanguageService myService;
    @NotNull
    private final ScheduledFuture<?> myFuture;

    public ClangMemoryUsageWatchDogImpl(final @NotNull ClangDaemonContext context, @NotNull ClangLanguageService service) {
        if (context == null) {
            ClangMemoryUsageWatchDogImpl.$$$reportNull$$$0(0);
        }
        if (service == null) {
            ClangMemoryUsageWatchDogImpl.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.myService = service;
        Disposer.register((Disposable)context, (Disposable)this);
        ClangMemoryUsageWatchDogImpl.getMaxMemoryRegistryValue().addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context.canPublishMessage()) {
                    ((ClangMemoryUsageWatchDogListener)context.getMessageBus().syncPublisher(ClangMemoryUsageWatchDogListener.TOPIC)).onMaxMemoryChanged(ClangMemoryUsageWatchDogImpl.getMaxMemoryImpl(value));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/memory/ClangMemoryUsageWatchDogImpl$1", "afterValueChanged"));
            }
        }, (Disposable)context);
        context.getMessageBus().connect().subscribe(ClangServerListener.TOPIC, (Object)this);
        this.myFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(this::requestState, 1000L, 10000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public long getMaxMemory() {
        return ClangMemoryUsageWatchDogImpl.getMaxMemoryImpl(ClangMemoryUsageWatchDogImpl.getMaxMemoryRegistryValue());
    }

    @Override
    public void onServerFailure() {
        this.reportMemoryUsed(0L);
    }

    @Override
    public void onServerShutDown() {
        this.reportMemoryUsed(0L);
    }

    private void requestState() {
        block8: {
            if (ClangMemoryUsageWatchDogImpl.isEnabled()) {
                try {
                    ClangMemoryUsageInfo memoryUsage = (ClangMemoryUsageInfo)CidrConcurrentUtilsKt.waitCancelAware(this.myService.debugDumpMemoryStat(), (long)10000L, (String)"memory stats");
                    if (memoryUsage == null) break block8;
                    long workingSet = Long.valueOf(memoryUsage.getWorkingSet()) * 1024L;
                    long maxMemory = this.getMaxMemory();
                    if (ClangMemoryUsageWatchDogImpl.isEnabled() && workingSet > maxMemory) {
                        String nativeStackTrace = maxMemory >= 4096L ? "\n\n" + this.myService.getNativeStacktrace() : "";
                        ClangStopData stopData = this.myService.shutDownServer();
                        LOG.warn("Server was restarted because the memory limit was exceeded: " + workingSet / 0x100000L + "M used of " + maxMemory / 0x100000L + "M" + nativeStackTrace);
                        FUCounterUsageLogger.getInstance().logEvent("oc.clangd.memoryLimitExceedances", "total");
                        try {
                            stopData.exitCode.get(5L, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            LOG.warn((Throwable)ex);
                        }
                        catch (TimeoutException ex) {
                            LOG.warn("clangd is not down after 5 seconds, killing it.");
                            stopData.killRunnable.run();
                        }
                    }
                    this.reportMemoryUsed(workingSet);
                }
                catch (ExecutionException ex) {
                    LOG.warn((Throwable)ex);
                }
                catch (TimeoutException ex) {
                    LOG.warn("Timeout when getting memory stats");
                }
            }
        }
    }

    public void dispose() {
        this.myFuture.cancel(true);
        this.reportMemoryUsed(0L);
    }

    private void reportMemoryUsed(long howMuch) {
        if (this.myContext.canPublishMessage()) {
            ((ClangMemoryUsageWatchDogListener)this.myContext.getMessageBus().syncPublisher(ClangMemoryUsageWatchDogListener.TOPIC)).onUsedMemoryChanged(howMuch);
        }
    }

    private static boolean isEnabled() {
        return ClangMemoryUsageWatchDogImpl.getMaxMemoryImpl(ClangMemoryUsageWatchDogImpl.getMaxMemoryRegistryValue()) > 0L;
    }

    private static long getMaxMemoryImpl(@NotNull RegistryValue value) {
        if (value == null) {
            ClangMemoryUsageWatchDogImpl.$$$reportNull$$$0(2);
        }
        return Long.valueOf(value.asInteger()) * 0x100000L;
    }

    @NotNull
    private static RegistryValue getMaxMemoryRegistryValue() {
        RegistryValue registryValue = Registry.get((String)"clion.clangd.max.memory");
        if (registryValue == null) {
            ClangMemoryUsageWatchDogImpl.$$$reportNull$$$0(3);
        }
        return registryValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/memory/ClangMemoryUsageWatchDogImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/memory/ClangMemoryUsageWatchDogImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaxMemoryRegistryValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMaxMemoryImpl";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

