/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangInteractionPromiseImpl<I extends ClangInteraction>
implements ClangInteractionPromise<I> {
    @NotNull
    private final Class<I> myRequestClass;
    @NotNull
    private final CompletableFuture<I> myFutureRequest;
    @Nullable
    private final Runnable myRejectedHandler;
    @Nullable
    private final List<Pair<String, ClangProperty>> myReadAccessedProperties;
    @Nullable
    private final List<Pair<String, ClangProperty>> myWriteAccessedProperties;
    private final boolean myIsRearrangeable;
    private final boolean myIsImmediate;

    public ClangInteractionPromiseImpl(@NotNull Class<I> requestClass, @NotNull CompletableFuture<I> futureRequest, @Nullable Runnable rejectedHandler, @Nullable List<Pair<String, ClangProperty>> readAccessedProperties, @Nullable List<Pair<String, ClangProperty>> writeAccessedProperties, boolean isRearrangeable, boolean isImmediate) {
        if (requestClass == null) {
            ClangInteractionPromiseImpl.$$$reportNull$$$0(0);
        }
        if (futureRequest == null) {
            ClangInteractionPromiseImpl.$$$reportNull$$$0(1);
        }
        this.myRequestClass = requestClass;
        this.myFutureRequest = futureRequest;
        this.myRejectedHandler = rejectedHandler;
        this.myReadAccessedProperties = readAccessedProperties;
        this.myWriteAccessedProperties = writeAccessedProperties;
        this.myIsRearrangeable = isRearrangeable;
        this.myIsImmediate = isImmediate;
    }

    @Override
    @NotNull
    public Class<I> getInteractionClass() {
        Class<I> clazz = this.myRequestClass;
        if (clazz == null) {
            ClangInteractionPromiseImpl.$$$reportNull$$$0(2);
        }
        return clazz;
    }

    @Override
    @NotNull
    public CompletableFuture<I> getInteraction() {
        CompletableFuture<I> completableFuture = this.myFutureRequest;
        if (completableFuture == null) {
            ClangInteractionPromiseImpl.$$$reportNull$$$0(3);
        }
        return completableFuture;
    }

    @Override
    @Nullable
    public Runnable getRejectedHandler() {
        return this.myRejectedHandler;
    }

    @Override
    @Nullable
    public List<Pair<String, ClangProperty>> getWrittenProperties() {
        return this.myWriteAccessedProperties;
    }

    @Override
    @Nullable
    public List<Pair<String, ClangProperty>> getReadProperties() {
        return this.myReadAccessedProperties;
    }

    @Override
    public boolean isRearrangeable() {
        return this.myIsRearrangeable;
    }

    @Override
    public boolean isImmediate() {
        return this.myIsImmediate;
    }

    @NonNls
    public String toString() {
        return this.myRequestClass.getSimpleName() + (String)(this.myReadAccessedProperties != null ? "\nReads: " + ClangInteractionPromiseImpl.toStringProperties(this.myReadAccessedProperties) : "") + (String)(this.myWriteAccessedProperties != null ? "\nWrites: " + ClangInteractionPromiseImpl.toStringProperties(this.myWriteAccessedProperties) : "");
    }

    @NotNull
    private static String toStringProperties(@NotNull List<Pair<String, ClangProperty>> properties) {
        if (properties == null) {
            ClangInteractionPromiseImpl.$$$reportNull$$$0(4);
        }
        StringBuilder sb = new StringBuilder();
        HashMap propertiesByFile = new HashMap();
        properties.forEach(urlAndProperty -> propertiesByFile.computeIfAbsent((String)urlAndProperty.first, k -> new ArrayList()).add((ClangProperty)((Object)((Object)urlAndProperty.second))));
        propertiesByFile.keySet().stream().sorted().forEach(url -> sb.append((String)url).append(propertiesByFile.get(url)).append(" "));
        String string = sb.toString();
        if (string == null) {
            ClangInteractionPromiseImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "futureRequest";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangInteractionPromiseImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangInteractionPromiseImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInteractionClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInteraction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "toStringProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toStringProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class Builder<I extends ClangInteraction> {
        @NotNull
        private final Class<I> myRequestClass;
        @NotNull
        private final CompletableFuture<I> myFutureRequest;
        @Nullable
        private Runnable myRejectedHandler;
        @Nullable
        private List<Pair<String, ClangProperty>> myReadAccessedProperties;
        @Nullable
        private List<Pair<String, ClangProperty>> myWriteAccessedProperties;
        private boolean myIsRearrangeable;
        private boolean myIsImmediate;

        public Builder(@NotNull Class<I> requestClass, @NotNull CompletableFuture<I> futureRequest) {
            if (requestClass == null) {
                Builder.$$$reportNull$$$0(0);
            }
            if (futureRequest == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myIsRearrangeable = true;
            this.myIsImmediate = true;
            this.myRequestClass = requestClass;
            this.myFutureRequest = futureRequest;
        }

        public Builder(@NotNull I request) {
            if (request == null) {
                Builder.$$$reportNull$$$0(2);
            }
            this.myIsRearrangeable = true;
            this.myIsImmediate = true;
            this.myRequestClass = request.getClass();
            this.myFutureRequest = CompletableFuture.completedFuture(request);
        }

        @NotNull
        public Builder<I> addRejectedHandler(@NotNull Runnable rejectedHandler) {
            if (rejectedHandler == null) {
                Builder.$$$reportNull$$$0(3);
            }
            assert (this.myRejectedHandler == null);
            this.myRejectedHandler = rejectedHandler;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder;
        }

        @NotNull
        public Builder<I> addReadAccessedProperties(@NotNull String url, ClangProperty ... properties) {
            if (url == null) {
                Builder.$$$reportNull$$$0(5);
            }
            if (properties == null) {
                Builder.$$$reportNull$$$0(6);
            }
            if (this.myReadAccessedProperties == null) {
                this.myReadAccessedProperties = new ArrayList<Pair<String, ClangProperty>>();
            }
            for (ClangProperty property : properties) {
                this.myReadAccessedProperties.add((Pair<String, ClangProperty>)Pair.create((Object)url, (Object)((Object)property)));
            }
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(7);
            }
            return builder;
        }

        @NotNull
        public Builder<I> setReadAccessedProperties(@Nullable List<Pair<String, ClangProperty>> readAccessedProperties) {
            this.myReadAccessedProperties = readAccessedProperties;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder;
        }

        @NotNull
        public Builder<I> addWriteAccessedProperties(@NotNull String url, ClangProperty ... properties) {
            if (url == null) {
                Builder.$$$reportNull$$$0(9);
            }
            if (properties == null) {
                Builder.$$$reportNull$$$0(10);
            }
            if (this.myWriteAccessedProperties == null) {
                this.myWriteAccessedProperties = new ArrayList<Pair<String, ClangProperty>>();
            }
            for (ClangProperty property : properties) {
                this.myWriteAccessedProperties.add((Pair<String, ClangProperty>)Pair.create((Object)url, (Object)((Object)property)));
            }
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(11);
            }
            return builder;
        }

        @NotNull
        public Builder<I> setWriteAccessedProperties(@Nullable List<Pair<String, ClangProperty>> writeAccessedProperties) {
            this.myWriteAccessedProperties = writeAccessedProperties;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(12);
            }
            return builder;
        }

        @NotNull
        public Builder<I> setRearrangeable(boolean rearrangeable) {
            this.myIsRearrangeable = rearrangeable;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(13);
            }
            return builder;
        }

        @NotNull
        public Builder<I> setImmediate(boolean isImmediate) {
            this.myIsImmediate = isImmediate;
            Builder builder = this;
            if (builder == null) {
                Builder.$$$reportNull$$$0(14);
            }
            return builder;
        }

        @NotNull
        public ClangInteractionPromise<I> create() {
            return new ClangInteractionPromiseImpl<I>(this.myRequestClass, this.myFutureRequest, this.myRejectedHandler, this.myReadAccessedProperties, this.myWriteAccessedProperties, this.myIsRearrangeable, this.myIsImmediate);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestClass";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "futureRequest";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rejectedHandler";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangInteractionPromiseImpl$Builder";
                    break;
                }
                case 5: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 6: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "properties";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ClangInteractionPromiseImpl$Builder";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addRejectedHandler";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addReadAccessedProperties";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setReadAccessedProperties";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addWriteAccessedProperties";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setWriteAccessedProperties";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRearrangeable";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setImmediate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addRejectedHandler";
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addReadAccessedProperties";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "addWriteAccessedProperties";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

