/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.impl.LocationImpl;
import com.fasterxml.aalto.in.InputBootstrapper;
import com.fasterxml.aalto.in.MergedStream;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.in.ReaderScanner;
import com.fasterxml.aalto.in.Utf32Reader;
import com.fasterxml.aalto.in.Utf8Scanner;
import com.fasterxml.aalto.in.XmlScanner;
import com.fasterxml.aalto.util.CharsetNames;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;

public final class ByteSourceBootstrapper
extends InputBootstrapper {
    private static final byte BYTE_NULL = 0;
    private static final byte BYTE_CR = 13;
    private static final byte BYTE_LF = 10;
    final InputStream _in;
    final byte[] _inputBuffer;
    private int _inputPtr;
    private int _inputLen;
    boolean mBigEndian = true;
    int mBytesPerChar = 0;
    boolean mHadBOM = false;
    boolean mByteSizeFound = false;

    private ByteSourceBootstrapper(ReaderConfig cfg, InputStream in) {
        super(cfg);
        this._in = in;
        this._inputBuffer = cfg.allocFullBBuffer(4000);
        this._inputPtr = 0;
        this._inputLen = 0;
    }

    private ByteSourceBootstrapper(ReaderConfig cfg, byte[] inputBuffer, int inputStart, int inputLen) {
        super(cfg);
        this._in = null;
        this._inputBuffer = inputBuffer;
        this._inputPtr = inputStart;
        this._inputLen = inputStart + inputLen;
        this._inputProcessed = -inputStart;
    }

    public static ByteSourceBootstrapper construct(ReaderConfig cfg, InputStream in) throws XMLStreamException {
        return new ByteSourceBootstrapper(cfg, in);
    }

    public static ByteSourceBootstrapper construct(ReaderConfig cfg, byte[] inputBuffer, int inputStart, int inputLen) throws XMLStreamException {
        return new ByteSourceBootstrapper(cfg, inputBuffer, inputStart, inputLen);
    }

    @Override
    public final XmlScanner bootstrap() throws XMLStreamException {
        try {
            XmlScanner xmlScanner = this.doBootstrap();
            return xmlScanner;
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
        finally {
            this._config.freeSmallCBuffer(this.mKeyword);
        }
    }

    public XmlScanner doBootstrap() throws IOException, XMLStreamException {
        String normEnc = null;
        this.determineStreamEncoding();
        if (this.hasXmlDeclaration()) {
            this.readXmlDeclaration();
            if (this.mFoundEncoding != null) {
                normEnc = this.verifyXmlEncoding(this.mFoundEncoding);
            }
        }
        if (normEnc == null) {
            normEnc = this.mBytesPerChar == 2 ? (this.mBigEndian ? "UTF-16BE" : "UTF-16LE") : (this.mBytesPerChar == 4 ? (this.mBigEndian ? "UTF-32BE" : "UTF-32LE") : "UTF-8");
        }
        this._config.setActualEncoding(normEnc);
        this._config.setXmlDeclInfo(this.mDeclaredXmlVersion, this.mFoundEncoding, this.mStandalone);
        if (normEnc == "UTF-8" || normEnc == "ISO-8859-1" || normEnc == "US-ASCII") {
            return new Utf8Scanner(this._config, this._in, this._inputBuffer, this._inputPtr, this._inputLen);
        }
        if (normEnc.startsWith("UTF-32")) {
            if (normEnc == "UTF-32") {
                normEnc = this.mBigEndian ? "UTF-32BE" : "UTF-32LE";
            }
            Utf32Reader r = new Utf32Reader(this._config, this._in, this._inputBuffer, this._inputPtr, this._inputLen, this.mBigEndian);
            return new ReaderScanner(this._config, r);
        }
        InputStream in = this._in;
        if (this._inputPtr < this._inputLen) {
            in = new MergedStream(this._config, in, this._inputBuffer, this._inputPtr, this._inputLen);
        }
        if (normEnc == "UTF-16") {
            normEnc = this.mBigEndian ? "UTF-16BE" : "UTF-16LE";
        }
        try {
            InputStreamReader r = new InputStreamReader(in, normEnc);
            return new ReaderScanner(this._config, r);
        }
        catch (UnsupportedEncodingException usex) {
            throw new IoStreamException("Unsupported encoding: " + usex.getMessage());
        }
    }

    private void determineStreamEncoding() throws IOException {
        if (this.ensureLoaded(4)) {
            int origPtr = this._inputPtr;
            int quartet = this._inputBuffer[this._inputPtr] << 24 | (this._inputBuffer[this._inputPtr + 1] & 0xFF) << 16 | (this._inputBuffer[this._inputPtr + 2] & 0xFF) << 8 | this._inputBuffer[this._inputPtr + 3] & 0xFF;
            block0 : switch (quartet) {
                case 65279: {
                    this.mBigEndian = true;
                    this._inputPtr += 4;
                    this.mBytesPerChar = 4;
                    break;
                }
                case -131072: {
                    this.mBigEndian = false;
                    this._inputPtr += 4;
                    this.mBytesPerChar = 4;
                    break;
                }
                case 65534: {
                    this.reportWeirdUCS4("2143");
                    break;
                }
                case -16842752: {
                    this.reportWeirdUCS4("3412");
                    break;
                }
                default: {
                    int msw = quartet >>> 16;
                    if (msw == 65279) {
                        this._inputPtr += 2;
                        this.mBytesPerChar = 2;
                        this.mBigEndian = true;
                        break;
                    }
                    if (msw == 65534) {
                        this._inputPtr += 2;
                        this.mBytesPerChar = 2;
                        this.mBigEndian = false;
                        break;
                    }
                    if (quartet >>> 8 == 0xEFBBBF) {
                        this._inputPtr += 3;
                        this.mBytesPerChar = 1;
                        this.mBigEndian = true;
                        break;
                    }
                    switch (quartet) {
                        case 60: {
                            this.mBigEndian = true;
                            this.mBytesPerChar = 4;
                            break block0;
                        }
                        case 0x3C000000: {
                            this.mBytesPerChar = 4;
                            this.mBigEndian = false;
                            break block0;
                        }
                        case 15360: {
                            this.reportWeirdUCS4("2143");
                            break block0;
                        }
                        case 0x3C0000: {
                            this.reportWeirdUCS4("3412");
                            break block0;
                        }
                        case 3932223: {
                            this.mBytesPerChar = 2;
                            this.mBigEndian = true;
                            break block0;
                        }
                        case 1006649088: {
                            this.mBytesPerChar = 2;
                            this.mBigEndian = false;
                            break block0;
                        }
                        case 1010792557: {
                            this.mBytesPerChar = 1;
                            this.mBigEndian = true;
                            break block0;
                        }
                        case 1282385812: {
                            this.reportEBCDIC();
                        }
                    }
                }
            }
            this.mHadBOM = this._inputPtr > origPtr;
            this._inputRowStart = this._inputPtr;
        }
        boolean bl = this.mByteSizeFound = this.mBytesPerChar > 0;
        if (!this.mByteSizeFound) {
            this.mBytesPerChar = 1;
            this.mBigEndian = true;
        }
    }

    protected boolean hasXmlDeclaration() throws IOException, XMLStreamException {
        if (this.mBytesPerChar == 1) {
            if (this.ensureLoaded(6) && this._inputBuffer[this._inputPtr] == 60 && this._inputBuffer[this._inputPtr + 1] == 63 && this._inputBuffer[this._inputPtr + 2] == 120 && this._inputBuffer[this._inputPtr + 3] == 109 && this._inputBuffer[this._inputPtr + 4] == 108 && (this._inputBuffer[this._inputPtr + 5] & 0xFF) <= 32) {
                this._inputPtr += 6;
                return true;
            }
        } else if (this.ensureLoaded(6 * this.mBytesPerChar)) {
            int start = this._inputPtr;
            if (this.nextMultiByte() == 60 && this.nextMultiByte() == 63 && this.nextMultiByte() == 120 && this.nextMultiByte() == 109 && this.nextMultiByte() == 108 && this.nextMultiByte() <= 32) {
                return true;
            }
            this._inputPtr = start;
        }
        return false;
    }

    protected String verifyXmlEncoding(String enc) throws XMLStreamException {
        if ((enc = CharsetNames.normalize(enc)) == "UTF-8") {
            this.verifyEncoding(enc, 1);
        } else if (enc == "ISO-8859-1") {
            this.verifyEncoding(enc, 1);
        } else if (enc == "US-ASCII") {
            this.verifyEncoding(enc, 1);
        } else if (enc == "UTF-16") {
            this.verifyEncoding(enc, 2);
        } else if (enc == "UTF-16LE") {
            this.verifyEncoding(enc, 2, false);
        } else if (enc == "UTF-16BE") {
            this.verifyEncoding(enc, 2, true);
        } else if (enc == "UTF-32") {
            this.verifyEncoding(enc, 4);
        } else if (enc == "UTF-32LE") {
            this.verifyEncoding(enc, 4, false);
        } else if (enc == "UTF-32BE") {
            this.verifyEncoding(enc, 4, true);
        }
        return enc;
    }

    protected boolean ensureLoaded(int minimum) throws IOException {
        int count;
        for (int gotten = this._inputLen - this._inputPtr; gotten < minimum; gotten += count) {
            count = this._in == null ? -1 : this._in.read(this._inputBuffer, this._inputLen, this._inputBuffer.length - this._inputLen);
            if (count < 1) {
                return false;
            }
            this._inputLen += count;
        }
        return true;
    }

    protected void loadMore() throws IOException, XMLStreamException {
        this._inputProcessed += this._inputLen;
        this._inputRowStart -= this._inputLen;
        this._inputPtr = 0;
        this._inputLen = this._in == null ? -1 : this._in.read(this._inputBuffer, 0, this._inputBuffer.length);
        if (this._inputLen < 1) {
            this.reportEof();
        }
    }

    @Override
    protected void pushback() {
        this._inputPtr -= this.mBytesPerChar;
    }

    @Override
    protected int getNext() throws IOException, XMLStreamException {
        if (this.mBytesPerChar > 1) {
            return this.nextMultiByte();
        }
        byte b = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
        return b & 0xFF;
    }

    @Override
    protected int getNextAfterWs(boolean reqWs) throws IOException, XMLStreamException {
        int count = this.mBytesPerChar > 1 ? this.skipMbWs() : this.skipSbWs();
        if (reqWs && count == 0) {
            this.reportUnexpectedChar(this.getNext(), "; expected a white space");
        }
        if (this.mBytesPerChar > 1) {
            return this.nextMultiByte();
        }
        byte b = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
        return b & 0xFF;
    }

    @Override
    protected int checkKeyword(String exp) throws IOException, XMLStreamException {
        if (this.mBytesPerChar > 1) {
            return this.checkMbKeyword(exp);
        }
        return this.checkSbKeyword(exp);
    }

    @Override
    protected int readQuotedValue(char[] kw, int quoteChar) throws IOException, XMLStreamException {
        boolean mb;
        int i = 0;
        int len = kw.length;
        boolean bl = mb = this.mBytesPerChar > 1;
        while (i < len) {
            int c;
            if (mb) {
                c = this.nextMultiByte();
                if (c == 13 || c == 10) {
                    this.skipMbLF(c);
                    c = 10;
                }
            } else {
                int b;
                int n = b = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
                if (b == 0) {
                    this.reportNull();
                }
                if (b == 13 || b == 10) {
                    this.skipSbLF((byte)b);
                    b = 10;
                }
                c = b & 0xFF;
            }
            if (c == quoteChar) {
                return i;
            }
            kw[i++] = (char)c;
        }
        return -1;
    }

    @Override
    protected Location getLocation() {
        int total = this._inputProcessed + this._inputPtr;
        int col = this._inputPtr - this._inputRowStart;
        if (this.mBytesPerChar > 1) {
            total /= this.mBytesPerChar;
            col /= this.mBytesPerChar;
        }
        return LocationImpl.fromZeroBased(this._config.getPublicId(), this._config.getSystemId(), total, this._inputRow, col);
    }

    protected byte nextByte() throws IOException, XMLStreamException {
        if (this._inputPtr >= this._inputLen) {
            this.loadMore();
        }
        return this._inputBuffer[this._inputPtr++];
    }

    protected int skipSbWs() throws IOException, XMLStreamException {
        int count = 0;
        while (true) {
            byte b;
            byte by = b = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
            if ((b & 0xFF) > 32) {
                --this._inputPtr;
                break;
            }
            if (b == 13 || b == 10) {
                this.skipSbLF(b);
            } else if (b == 0) {
                this.reportNull();
            }
            ++count;
        }
        return count;
    }

    protected void skipSbLF(byte lfByte) throws IOException, XMLStreamException {
        if (lfByte == 13) {
            byte b;
            byte by = b = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
            if (b != 10) {
                --this._inputPtr;
            }
        }
        ++this._inputRow;
        this._inputRowStart = this._inputPtr;
    }

    protected int checkSbKeyword(String expected) throws IOException, XMLStreamException {
        int len = expected.length();
        for (int ptr = 1; ptr < len; ++ptr) {
            byte b;
            byte by = b = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
            if (b == 0) {
                this.reportNull();
            }
            if ((b & 0xFF) == expected.charAt(ptr)) continue;
            return b & 0xFF;
        }
        return 0;
    }

    protected int nextMultiByte() throws IOException, XMLStreamException {
        int c;
        byte b2;
        byte b = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
        byte by = b2 = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
        if (this.mBytesPerChar == 2) {
            c = this.mBigEndian ? (b & 0xFF) << 8 | b2 & 0xFF : b & 0xFF | (b2 & 0xFF) << 8;
        } else {
            byte b3 = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
            byte b4 = this._inputPtr < this._inputLen ? this._inputBuffer[this._inputPtr++] : this.nextByte();
            c = this.mBigEndian ? b << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF : b4 << 24 | (b3 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b & 0xFF;
        }
        if (c == 0) {
            this.reportNull();
        }
        return c;
    }

    protected int skipMbWs() throws IOException, XMLStreamException {
        int count = 0;
        while (true) {
            int c;
            if ((c = this.nextMultiByte()) > 32) {
                this._inputPtr -= this.mBytesPerChar;
                break;
            }
            if (c == 13 || c == 10) {
                this.skipMbLF(c);
            } else if (c == 0) {
                this.reportNull();
            }
            ++count;
        }
        return count;
    }

    protected void skipMbLF(int lf) throws IOException, XMLStreamException {
        int c;
        if (lf == 13 && (c = this.nextMultiByte()) != 10) {
            this._inputPtr -= this.mBytesPerChar;
        }
        ++this._inputRow;
        this._inputRowStart = this._inputPtr;
    }

    protected int checkMbKeyword(String expected) throws IOException, XMLStreamException {
        int len = expected.length();
        for (int ptr = 1; ptr < len; ++ptr) {
            int c = this.nextMultiByte();
            if (c == 0) {
                this.reportNull();
            }
            if (c == expected.charAt(ptr)) continue;
            return c;
        }
        return 0;
    }

    private void verifyEncoding(String id, int bpc) throws XMLStreamException {
        if (this.mByteSizeFound && bpc != this.mBytesPerChar) {
            this.reportXmlProblem("Declared encoding '" + id + "' uses " + bpc + " bytes per character; but physical encoding appeared to use " + this.mBytesPerChar + "; cannot decode");
        }
    }

    private void verifyEncoding(String id, int bpc, boolean bigEndian) throws XMLStreamException {
        if (this.mByteSizeFound) {
            this.verifyEncoding(id, bpc);
            if (bigEndian != this.mBigEndian) {
                String bigStr = bigEndian ? "big" : "little";
                this.reportXmlProblem("Declared encoding '" + id + "' has different endianness (" + bigStr + " endian) than what physical ordering appeared to be; cannot decode");
            }
        }
    }

    private void reportWeirdUCS4(String type) throws IOException {
        throw new CharConversionException("Unsupported UCS-4 endianness (" + type + ") detected");
    }

    private void reportEBCDIC() throws IOException {
        throw new CharConversionException("Unsupported encoding (EBCDIC)");
    }
}

