/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.resolve.UrlReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class CssUnknownTargetInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssUnknownTargetInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(){

            public void visitCssString(CssString string) {
                CssUnknownTargetInspection.processElement((PsiElement)string, holder);
            }

            public void visitCssUri(CssUri uri) {
                PsiElement element = uri.getValueElement();
                if (element != null && !(element instanceof CssString)) {
                    CssUnknownTargetInspection.processElement(element, holder);
                }
            }
        };
    }

    private static void processElement(@NotNull PsiElement element, ProblemsHolder holder) {
        if (element == null) {
            CssUnknownTargetInspection.$$$reportNull$$$0(1);
        }
        if (!element.isValid() || PsiTreeUtil.getChildOfType((PsiElement)element, OuterLanguageElement.class) != null) {
            return;
        }
        PsiReference[] references = element.getReferences();
        for (PsiFileReference reference : CssUnknownTargetInspection.findUnresolvedFileReferences(references)) {
            CssUnknownTargetInspection.registerProblem(holder, (PsiReference)reference, reference.isSoft() ? ProblemHighlightType.WEAK_WARNING : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        for (PsiReference reference : references) {
            PsiElement resolve;
            if (!(reference instanceof UrlReference) || (resolve = reference.resolve()) != null) continue;
            CssUnknownTargetInspection.registerProblem(holder, reference, ProblemHighlightType.WEAK_WARNING);
        }
    }

    private static void registerProblem(ProblemsHolder holder, PsiReference reference, ProblemHighlightType highlightType) {
        String errorMessage = ProblemsHolder.unresolvedReferenceMessage((PsiReference)reference);
        holder.registerProblem(reference, errorMessage, highlightType);
    }

    private static Collection<PsiFileReference> findUnresolvedFileReferences(PsiReference[] references) {
        HashMap<TextRange, PsiFileReference> rangeToUnresolvedRef = new HashMap<TextRange, PsiFileReference>();
        HashSet<TextRange> resolvedRanges = new HashSet<TextRange>();
        for (PsiReference reference : references) {
            if (!(reference instanceof PsiFileReference)) continue;
            TextRange range = reference.getRangeInElement();
            if (reference instanceof FileReference && ((FileReference)reference).getIndex() == 0 && ((FileReference)reference).getText().startsWith("~")) {
                range = TextRange.create((int)(range.getStartOffset() + 1), (int)range.getEndOffset());
            }
            if (((PsiFileReference)reference).multiResolve(false).length > 0) {
                resolvedRanges.add(range);
                rangeToUnresolvedRef.remove(range);
                continue;
            }
            if (resolvedRanges.contains(range) || reference.isSoft() && rangeToUnresolvedRef.containsKey(range)) continue;
            rangeToUnresolvedRef.put(range, (PsiFileReference)reference);
        }
        return rangeToUnresolvedRef.values();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssUnknownTargetInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

