/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.CidrLangUtil;
import com.jetbrains.cidr.lang.documentation.ClangdBridgeCompletionItem;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExternalResolver;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.impl.OCReferenceElementImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.util.CidrConcurrentUtilsKt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalResolveUtils {
    private static final ThreadLocal<Integer> ourResolveProhibited = ThreadLocal.withInitial(() -> 0);
    @NotNull
    private static final Logger LOG = Logger.getInstance((String)ExternalResolveUtils.class.getName());

    public static void prohibitClangResolve() {
        assert (ourResolveProhibited.get() >= 0) : "Unbalanced prohibitClangResolve()";
        ourResolveProhibited.set(ourResolveProhibited.get() + 1);
    }

    public static void allowClangResolve() {
        assert (ourResolveProhibited.get() > 0) : "Unbalanced allowClangResolve()";
        ourResolveProhibited.set(ourResolveProhibited.get() - 1);
    }

    @Nullable
    public static List<OCSymbol> resolveSymbols(@NotNull PsiReference ref) {
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(0);
        }
        if (!ExternalResolveUtils.canDoExternalResolve(ref)) {
            return null;
        }
        List<PsiElement> elements = ExternalResolveUtils.doExternalResolve(ref);
        return elements != null ? ExternalResolveUtils.toSymbolStream(elements).filter(ExternalResolveUtils.getSymbolsFilter(ref)).collect(Collectors.toList()) : null;
    }

    @Nullable
    public static OCSymbol resolveSymbol(@NotNull PsiReference ref) {
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(1);
        }
        if (!ExternalResolveUtils.canDoExternalResolve(ref)) {
            return null;
        }
        List<PsiElement> elements = ExternalResolveUtils.doExternalResolve(ref);
        return elements != null ? ExternalResolveUtils.chooseBestSymbol(elements, ref) : null;
    }

    public static PsiElement @Nullable [] resolveElements(@NotNull PsiFile file, int offset) {
        if (file == null) {
            ExternalResolveUtils.$$$reportNull$$$0(2);
        }
        if (!ExternalResolveUtils.canDoExternalResolveRelaxed(file.getProject())) {
            return null;
        }
        List<PsiElement> elements = ExternalResolveUtils.doExternalResolve(file, offset);
        return elements != null ? elements.toArray(PsiElement.EMPTY_ARRAY) : null;
    }

    public static <T> T findCombined(@NotNull PsiReference ref, @NotNull Function<PsiReference, T> mainResolver, @NotNull Function<PsiReference, T> secondaryResolver) {
        VirtualFile file;
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(3);
        }
        if (mainResolver == null) {
            ExternalResolveUtils.$$$reportNull$$$0(4);
        }
        if (secondaryResolver == null) {
            ExternalResolveUtils.$$$reportNull$$$0(5);
        }
        if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isWriteAccessAllowed() && ExternalResolveUtils.canDoExternalResolve(ref) && (file = ExternalResolveUtils.getRefFile(ref)) != null) {
            return (T)ExternalResolveUtils.findInParallel(15L, () -> mainResolver.apply(ref), () -> secondaryResolver.apply(ref), false, true);
        }
        T mainResult = mainResolver.apply(ref);
        if (mainResult != null) {
            return mainResult;
        }
        return secondaryResolver.apply(ref);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T findInParallel(long mainResolverTimeoutMs, @NotNull Callable<? extends T> mainResolver, @NotNull Callable<? extends T> callable) {
        void fallbackResolver;
        if (mainResolver == null) {
            ExternalResolveUtils.$$$reportNull$$$0(6);
        }
        if (callable == null) {
            ExternalResolveUtils.$$$reportNull$$$0(7);
        }
        return ExternalResolveUtils.findInParallel(mainResolverTimeoutMs, mainResolver, fallbackResolver, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static <T> T findInParallel(long mainResolverTimeoutMs, @NotNull Callable<? extends T> mainResolver, @NotNull Callable<? extends T> fallbackResolver, boolean acceptNullFromMainResolver, boolean bl) {
        if (mainResolver == null) {
            ExternalResolveUtils.$$$reportNull$$$0(8);
        }
        if (fallbackResolver == null) {
            ExternalResolveUtils.$$$reportNull$$$0(9);
        }
        assert (!ApplicationManager.getApplication().isWriteAccessAllowed());
        ProgressIndicatorBase indicator = new ProgressIndicatorBase();
        try {
            void acceptNullFromFallbackResolver;
            Object ex2;
            CompletableFuture<? extends T> mainResolveFuture = ExternalResolveUtils.onPooledThread(mainResolver, (ProgressIndicator)indicator);
            CompletableFuture<? extends T> fallbackResolveFuture = ExternalResolveUtils.onPooledThread(fallbackResolver, (ProgressIndicator)indicator);
            Object result = null;
            try {
                result = CidrConcurrentUtilsKt.waitCancelAware(mainResolveFuture, (long)mainResolverTimeoutMs, (String)"main resolver");
            }
            catch (ExecutionException ex2) {
                ExternalResolveUtils.rethrowIfNeeded(ex2);
                CidrLogService.logOnce((Level)Level.WARNING, (String)ex2.getMessage(), (Throwable)ex2);
            }
            catch (TimeoutException ex2) {
                // empty catch block
            }
            if (result != null) {
                ex2 = result;
                return (T)ex2;
            }
            try {
                CidrConcurrentUtilsKt.waitCancelAware(CompletableFuture.anyOf(mainResolveFuture, fallbackResolveFuture), (String)"main or fallback resolver");
            }
            catch (ExecutionException ex3) {
                ExternalResolveUtils.rethrowIfNeeded(ex3);
                CidrLogService.logOnce((Level)Level.WARNING, (String)ex3.getMessage(), (Throwable)ex3);
            }
            result = ExternalResolveUtils.takeNonNull(CidrConcurrentUtilsKt.getIfCompletedNormally(mainResolveFuture), CidrConcurrentUtilsKt.getIfCompletedNormally(fallbackResolveFuture));
            if (result != null) {
                ex2 = result;
                return (T)ex2;
            }
            if (acceptNullFromMainResolver && CidrConcurrentUtilsKt.isCompletedNormally(mainResolveFuture)) {
                ex2 = CidrConcurrentUtilsKt.getIfCompletedNormally(mainResolveFuture);
                return (T)ex2;
            }
            if (acceptNullFromFallbackResolver != false && CidrConcurrentUtilsKt.isCompletedNormally(fallbackResolveFuture)) {
                ex2 = CidrConcurrentUtilsKt.getIfCompletedNormally(fallbackResolveFuture);
                return (T)ex2;
            }
            try {
                CidrConcurrentUtilsKt.waitCancelAware(CompletableFuture.allOf(mainResolveFuture, fallbackResolveFuture), (String)"main and fallback resolver");
            }
            catch (ExecutionException ex4) {
                ExternalResolveUtils.rethrowIfNeeded(ex4);
                CidrLogService.logOnce((Level)Level.WARNING, (String)ex4.getMessage(), (Throwable)ex4);
            }
            Object object = ExternalResolveUtils.takeNonNull(CidrConcurrentUtilsKt.getIfCompletedNormally(mainResolveFuture), CidrConcurrentUtilsKt.getIfCompletedNormally(fallbackResolveFuture));
            return (T)object;
        }
        finally {
            indicator.cancel();
        }
    }

    public static void assertFoundSameSymbol(@NotNull Project project, @Nullable OCSymbol clangSymbol, @NotNull Supplier<OCSymbol> clionResolver) {
        if (project == null) {
            ExternalResolveUtils.$$$reportNull$$$0(10);
        }
        if (clionResolver == null) {
            ExternalResolveUtils.$$$reportNull$$$0(11);
        }
    }

    public static void assertFoundSameElement(@Nullable PsiElement clangElement, @NotNull Supplier<PsiElement> clionResolver) {
        if (clionResolver == null) {
            ExternalResolveUtils.$$$reportNull$$$0(12);
        }
    }

    @Nullable
    private static <T> T takeNonNull(@Nullable T first, @Nullable T second) {
        return first != null ? first : second;
    }

    private static void rethrowIfNeeded(@NotNull ExecutionException ex) {
        if (ex == null) {
            ExternalResolveUtils.$$$reportNull$$$0(13);
        }
        Throwable thr = ex.getCause();
        while (thr instanceof ExecutionException) {
            thr = thr.getCause();
        }
        if (thr instanceof ControlFlowException) {
            ExceptionUtil.rethrow((Throwable)thr);
        }
    }

    private static Predicate<OCSymbol> getSymbolsFilter(@NotNull PsiReference ref) {
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(14);
        }
        if (ref instanceof OCReferenceElement) {
            return sym -> sym != null && !(sym instanceof OCFunctionSymbol);
        }
        if (ref instanceof OCOperatorReference) {
            return sym -> sym instanceof OCFunctionSymbol && ((OCFunctionSymbol)sym).isCppOperator();
        }
        return sym -> true;
    }

    @Nullable
    private static OCSymbol chooseBestSymbol(@NotNull List<PsiElement> elements, @NotNull PsiReference ref) {
        Optional<OCSymbol> firstOperatorOrNone;
        if (elements == null) {
            ExternalResolveUtils.$$$reportNull$$$0(15);
        }
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(16);
        }
        if (ref instanceof OCReferenceElement) {
            Optional<OCSymbol> firstSymOrNone = ExternalResolveUtils.toSymbolStream(elements).filter(ExternalResolveUtils.getSymbolsFilter(ref)).findFirst();
            if (firstSymOrNone.isPresent()) {
                OCClassSymbol definitionSymbolSymbol;
                OCInterfaceSymbol interfaceSymbol;
                OCSymbol firstSymbol = firstSymOrNone.get();
                if (firstSymbol instanceof OCStructSymbol) {
                    OCSymbol ctor = ExternalResolveUtils.runClionOverloadResolutionForStruct((OCReferenceElement)ref, (OCStructSymbol)firstSymbol);
                    if (ctor != null) {
                        return ctor;
                    }
                } else if (firstSymbol instanceof OCInterfaceSymbol && (interfaceSymbol = (OCInterfaceSymbol)firstSymbol).isPredeclaration() && (definitionSymbolSymbol = interfaceSymbol.getDefinitionSymbol(((OCReferenceElement)ref).getProject())) != null) {
                    return definitionSymbolSymbol;
                }
                return firstSymbol;
            }
        } else if (ref instanceof OCOperatorReference && (firstOperatorOrNone = ExternalResolveUtils.toSymbolStream(elements).filter(ExternalResolveUtils.getSymbolsFilter(ref)).findFirst()).isPresent()) {
            return firstOperatorOrNone.get();
        }
        return ExternalResolveUtils.toSymbolStream(elements).filter(sym -> sym != null).findFirst().orElse(null);
    }

    @NotNull
    private static Stream<OCSymbol> toSymbolStream(@NotNull List<PsiElement> elements) {
        if (elements == null) {
            ExternalResolveUtils.$$$reportNull$$$0(17);
        }
        Stream<OCSymbol> stream = elements.stream().filter(element -> element instanceof OCSymbolDeclarator).map(element -> ((OCSymbolDeclarator)element).getSymbol());
        if (stream == null) {
            ExternalResolveUtils.$$$reportNull$$$0(18);
        }
        return stream;
    }

    private static boolean canDoExternalResolve(@NotNull PsiReference ref) {
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(19);
        }
        if (!ExternalResolveUtils.canDoExternalResolveRelaxed(ref.getElement().getProject())) {
            return false;
        }
        return !OCElementUtil.isPartOfMacroSubstitution(ref.getElement());
    }

    public static boolean canDoExternalResolveRelaxed(@NotNull Project project) {
        if (project == null) {
            ExternalResolveUtils.$$$reportNull$$$0(20);
        }
        if (PlatformUtils.isAppCode()) {
            return false;
        }
        int resolveProhibitedValue = ourResolveProhibited.get();
        if (resolveProhibitedValue > 0) {
            LOG.error("Clang resolving is prohibited!");
            return false;
        }
        assert (resolveProhibitedValue == 0) : "Unexpected resolve prohibited value";
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            return false;
        }
        return !OCExternalResolver.EP_NAME.getExtensionList().isEmpty();
    }

    @Nullable
    private static List<PsiElement> doExternalResolve(@NotNull PsiReference ref) {
        PsiElement refElement;
        PsiFile file;
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(21);
        }
        if ((file = (refElement = ref.getElement()).getContainingFile()) == null) {
            return null;
        }
        int offset = ref.getRangeInElement().getStartOffset() + refElement.getTextOffset();
        return ExternalResolveUtils.doExternalResolve(file, offset);
    }

    @Nullable
    private static List<PsiElement> doExternalResolve(@NotNull PsiFile file, int offset) {
        if (file == null) {
            ExternalResolveUtils.$$$reportNull$$$0(22);
        }
        for (OCExternalResolver resolver : OCExternalResolver.EP_NAME.getExtensionList()) {
            List<OCExternalResolver.Resolved> resolvedList = resolver.resolve(file, offset);
            if (ContainerUtil.isEmpty(resolvedList)) continue;
            ArrayList<PsiElement> psiElements = new ArrayList<PsiElement>();
            for (OCExternalResolver.Resolved resolved : resolvedList) {
                PsiElement elem = ExternalResolveUtils.toPsi(file.getProject(), resolved, file.getViewProvider().getVirtualFile().getUrl());
                if (elem == null) continue;
                psiElements.add(elem);
            }
            if (psiElements.isEmpty()) continue;
            return psiElements;
        }
        return null;
    }

    @Nullable
    private static VirtualFile getRefFile(@NotNull PsiReference ref) {
        PsiElement refElement;
        PsiFile file;
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(23);
        }
        if ((file = (refElement = ref.getElement()).getContainingFile()) == null) {
            return null;
        }
        return file.getViewProvider().getVirtualFile();
    }

    @Nullable
    private static PsiElement toPsi(@NotNull Project project, @NotNull OCExternalResolver.Resolved sym, @NotNull String requestFileUrl) {
        String path;
        VirtualFile targetVirtualFile;
        if (project == null) {
            ExternalResolveUtils.$$$reportNull$$$0(24);
        }
        if (sym == null) {
            ExternalResolveUtils.$$$reportNull$$$0(25);
        }
        if (requestFileUrl == null) {
            ExternalResolveUtils.$$$reportNull$$$0(26);
        }
        if ((targetVirtualFile = CidrLangUtil.findBestFile((Project)project, (String)(path = sym.uri.getPath()), (int)sym.line, vf -> OCSearchScope.isInProjectSourcesOrLibraries(project, vf))) == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(targetVirtualFile);
        if (document == null) {
            return null;
        }
        PsiFile targetPsiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (targetPsiFile == null) {
            return null;
        }
        if (sym.line >= document.getLineCount()) {
            StringBuilder message = new StringBuilder("Requested line ").append(sym.line).append(" of ").append(document.getLineCount()).append(" in ").append(targetVirtualFile.getUrl()).append(" when looking for resolved ").append(sym);
            message.append("; ");
            message.append("request file was ").append(requestFileUrl);
            throw new IndexOutOfBoundsException(message.toString());
        }
        int offset = document.getLineStartOffset(sym.line) + sym.column;
        return ExternalResolveUtils.findAppropriateElement(targetPsiFile, offset);
    }

    @Nullable
    public static PsiElement findAppropriateElement(@NotNull PsiFile file, int offset) {
        String idName;
        PsiElement clangElement;
        if (file == null) {
            ExternalResolveUtils.$$$reportNull$$$0(27);
        }
        if ((clangElement = file.findElementAt(offset)) == null) {
            return null;
        }
        OCMacroCall macroCall = (OCMacroCall)PsiTreeUtil.getParentOfType((PsiElement)clangElement, OCMacroCall.class);
        if (macroCall != null && clangElement instanceof LeafPsiElement && ((LeafPsiElement)clangElement).getElementType() == OCTokenTypes.IDENTIFIER && !StringUtil.isEmpty((String)(idName = OCElementUtil.getIdentifierName(clangElement)))) {
            for (ForeignLeafPsiElement foreignLeaf : PsiTreeUtil.findChildrenOfType((PsiElement)macroCall.getNextSibling(), ForeignLeafPsiElement.class)) {
                if (foreignLeaf.getElementType() != OCTokenTypes.IDENTIFIER || !idName.contentEquals(OCElementUtil.getIdentifierName(clangElement))) continue;
                clangElement = foreignLeaf;
                break;
            }
        }
        if (clangElement instanceof OCSymbolDeclarator) {
            return clangElement;
        }
        if (clangElement.getParent() instanceof OCSymbolDeclarator) {
            return clangElement.getParent();
        }
        if (clangElement instanceof LeafPsiElement && OCTokenTypes.KEYWORDS.contains(((LeafPsiElement)clangElement).getElementType()) && clangElement.getParent() instanceof OCDeclaration) {
            OCDeclaration decl = (OCDeclaration)clangElement.getParent();
            List<OCDeclarator> declarators = decl.getDeclarators();
            PsiElement bestElement = null;
            for (OCDeclarator declarator : declarators) {
                if (bestElement == null) {
                    bestElement = declarator;
                    continue;
                }
                if (!declarator.getTextRange().contains(offset)) continue;
                bestElement = declarator;
            }
            if (bestElement == null && decl.getTypeElement() != null) {
                OCTypeElement typeElement = decl.getTypeElement();
                for (PsiElement child : typeElement.getChildren()) {
                    if (!(child instanceof OCSymbolDeclarator)) continue;
                    bestElement = child;
                    break;
                }
            }
            return bestElement != null ? bestElement : clangElement;
        }
        return clangElement;
    }

    @Nullable
    public static PsiElement clangdCompletionItem2PsiElement(@NotNull Project project, @NotNull ClangdBridgeCompletionItem item) {
        if (project == null) {
            ExternalResolveUtils.$$$reportNull$$$0(28);
        }
        if (item == null) {
            ExternalResolveUtils.$$$reportNull$$$0(29);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (item.getFromFile() == null) {
            return null;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)item.getFromFile()));
        if (virtualFile == null) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiFile psiFile = psiManager.findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)psiManager.getProject()).getDocument(psiFile);
        if (document == null) {
            return null;
        }
        int offset = item.getFromFileOffset();
        if (offset < 0) {
            return null;
        }
        try {
            String rawContent = new String(virtualFile.contentsToByteArray(), virtualFile.getCharset());
            LineColumn lineCol = StringUtil.offsetToLineColumn((CharSequence)rawContent, (int)offset);
            if (lineCol != null) {
                offset = StringUtil.lineColToOffset((CharSequence)document.getCharsSequence(), (int)lineCol.line, (int)lineCol.column);
            }
        }
        catch (IOException ignored) {
            return null;
        }
        if (offset < 0) {
            return null;
        }
        return ExternalResolveUtils.findAppropriateElement(psiFile, offset);
    }

    @Nullable
    private static OCSymbol runClionOverloadResolutionForStruct(@NotNull OCReferenceElement referenceElement, @NotNull OCStructSymbol clangSymbol) {
        Ref argumentsRef;
        Ref argsRef;
        OCStructType type;
        if (referenceElement == null) {
            ExternalResolveUtils.$$$reportNull$$$0(30);
        }
        if (clangSymbol == null) {
            ExternalResolveUtils.$$$reportNull$$$0(31);
        }
        if ((type = new OCStructType(clangSymbol)).isEnum() || type.isEnumClass()) {
            return null;
        }
        OCResolveContext context = OCResolveContext.forPsi(referenceElement);
        if (!OCReferenceElementImpl.findArgumentsFromContext(referenceElement, context, (Ref<List<OCExpression>>)(argsRef = Ref.create()), (Ref<OCArgumentsList<OCExpression>>)(argumentsRef = Ref.create()))) {
            return null;
        }
        return OCReferenceElementImpl.resolveToConstructors(referenceElement, Collections.singleton(clangSymbol), type, (OCArgumentsList)argumentsRef.get(), context);
    }

    @NotNull
    private static String toMessageWithRef(@NotNull Throwable original, @NotNull PsiReference ref) {
        String string;
        if (original == null) {
            ExternalResolveUtils.$$$reportNull$$$0(32);
        }
        if (ref == null) {
            ExternalResolveUtils.$$$reportNull$$$0(33);
        }
        try {
            PsiElement element = ref.getElement();
            PsiFile file = element.getContainingFile();
            string = "When resolving " + OCElementUtil.getElementDebugName(element) + " at " + file.getName() + ":" + (element.getTextOffset() + ref.getRangeInElement().getStartOffset()) + " happened [" + original.getMessage() + "]";
        }
        catch (Throwable thr) {
            String string2 = original.getMessage();
            if (string2 == null) {
                ExternalResolveUtils.$$$reportNull$$$0(35);
            }
            return string2;
        }
        if (string == null) {
            ExternalResolveUtils.$$$reportNull$$$0(34);
        }
        return string;
    }

    @NotNull
    private static String toMessageWithOffset(@NotNull Throwable original, @NotNull PsiFile file, int offset) {
        String string;
        if (original == null) {
            ExternalResolveUtils.$$$reportNull$$$0(36);
        }
        if (file == null) {
            ExternalResolveUtils.$$$reportNull$$$0(37);
        }
        try {
            string = "When resolving " + file.getName() + ":" + offset + " happened [" + original.getMessage() + "]";
        }
        catch (Throwable thr) {
            String string2 = original.getMessage();
            if (string2 == null) {
                ExternalResolveUtils.$$$reportNull$$$0(39);
            }
            return string2;
        }
        if (string == null) {
            ExternalResolveUtils.$$$reportNull$$$0(38);
        }
        return string;
    }

    @NotNull
    private static <T> CompletableFuture<T> onPooledThread(@NotNull Callable<? extends T> task, @NotNull ProgressIndicator indicator) {
        if (task == null) {
            ExternalResolveUtils.$$$reportNull$$$0(40);
        }
        if (indicator == null) {
            ExternalResolveUtils.$$$reportNull$$$0(41);
        }
        CompletableFuture result = new CompletableFuture();
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> ReadAction.run(() -> {
            try {
                ProgressManager.checkCanceled();
                result.complete(task.call());
            }
            catch (Throwable thr) {
                result.completeExceptionally(thr);
            }
        }), indicator));
        CompletableFuture completableFuture = result;
        if (completableFuture == null) {
            ExternalResolveUtils.$$$reportNull$$$0(42);
        }
        return completableFuture;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 18: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 18: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 42: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 2: 
            case 22: 
            case 27: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainResolver";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "secondaryResolver";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackResolver";
                break;
            }
            case 10: 
            case 20: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clionResolver";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ex";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 18: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/ExternalResolveUtils";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sym";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestFileUrl";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangSymbol";
                break;
            }
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/ExternalResolveUtils";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "toSymbolStream";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "toMessageWithRef";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "toMessageWithOffset";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "onPooledThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbols";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveElements";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCombined";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findInParallel";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "assertFoundSameSymbol";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "assertFoundSameElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "rethrowIfNeeded";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSymbolsFilter";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "chooseBestSymbol";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "toSymbolStream";
                break;
            }
            case 18: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 42: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "canDoExternalResolve";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "canDoExternalResolveRelaxed";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doExternalResolve";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getRefFile";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "toPsi";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findAppropriateElement";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "clangdCompletionItem2PsiElement";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "runClionOverloadResolutionForStruct";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "toMessageWithRef";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "toMessageWithOffset";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "onPooledThread";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 18: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

