/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCSingleSymbolAlgorithm;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class OCLocalDefinitionsSearcher
extends OCSingleSymbolAlgorithm {
    private MultiMap<OCInstruction.InstructionKind, OCInstruction> myInstructions;
    private PsiElement myStartElement;
    private boolean myStopOnWrite;
    private boolean myProcessStartInstruction;

    public OCLocalDefinitionsSearcher(@NotNull OCControlFlowGraph cfg, @NotNull OCSymbol symbol, @NotNull PsiElement startElement, boolean forward, boolean stopOnWrite, boolean processStartInstruction) {
        if (cfg == null) {
            OCLocalDefinitionsSearcher.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            OCLocalDefinitionsSearcher.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            OCLocalDefinitionsSearcher.$$$reportNull$$$0(2);
        }
        super(cfg, forward, symbol);
        this.myInstructions = new MultiMap();
        this.myStartElement = startElement;
        this.myStopOnWrite = stopOnWrite;
        this.myProcessStartInstruction = processStartInstruction;
    }

    @Override
    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCLocalDefinitionsSearcher.$$$reportNull$$$0(3);
        }
        return (OCElementUtil.isEqualWithMacros(this.myStartElement, instruction.getRValue()) || OCElementUtil.isEqualWithMacros(this.myStartElement, instruction.getLValue())) && instruction.getKind() != OCInstruction.InstructionKind.DECLARATOR && instruction.getKind() != OCInstruction.InstructionKind.KILL;
    }

    @Override
    public void process() {
        this.clearProcessedNodes();
        Collection<OCInstruction> startInstructions = this.getStartInstructions();
        if (startInstructions.isEmpty()) {
            return;
        }
        OCInstruction startInstruction = startInstructions.iterator().next();
        for (OCInstruction instruction : startInstructions) {
            if (instruction.getKind() != OCInstruction.InstructionKind.WRITE) continue;
            startInstruction = instruction;
        }
        if (this.myProcessStartInstruction && !this.processInstruction(startInstruction)) {
            return;
        }
        this.traverse(startInstruction, this.mySymbol, this.myIsForward);
    }

    public void processFromStart() {
        this.traverseFromStart(this.mySymbol);
    }

    @Override
    protected boolean processInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCLocalDefinitionsSearcher.$$$reportNull$$$0(4);
        }
        OCInstruction.InstructionKind kind = instruction.getKind();
        this.myInstructions.putValue((Object)kind, (Object)instruction);
        return !this.myStopOnWrite || kind != OCInstruction.InstructionKind.WRITE;
    }

    public Collection<OCInstruction> getInstructionsOfKind(@NotNull OCInstruction.InstructionKind kind) {
        if (kind == null) {
            OCLocalDefinitionsSearcher.$$$reportNull$$$0(5);
        }
        return this.myInstructions.get((Object)kind);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfg";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCLocalDefinitionsSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isStartInstruction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processInstruction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstructionsOfKind";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

