/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.legacy.dfa;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCSingleSymbolAlgorithm;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OCNotUsedValueChecker
extends OCSingleSymbolAlgorithm {
    private boolean[] myReachableNodesFromReference;
    private boolean mySymbolUsed;
    private boolean mySymbolAssigned;
    private boolean myIgnoreKills;

    public OCNotUsedValueChecker(@NotNull OCControlFlowGraph cfg, @NotNull OCSymbol symbol) {
        if (cfg == null) {
            OCNotUsedValueChecker.$$$reportNull$$$0(0);
        }
        if (symbol == null) {
            OCNotUsedValueChecker.$$$reportNull$$$0(1);
        }
        super(cfg, false, symbol);
        this.myReachableNodesFromReference = new boolean[cfg.getNumOfNodes()];
    }

    @Override
    public void process() {
        this.clearProcessedNodes();
        this.myIgnoreKills = true;
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = this.myCfg.getInstructions(this.mySymbol);
        if (instructions == null) {
            return;
        }
        if (!instructions.get((Object)OCInstruction.InstructionKind.READ_IN_BLOCK).isEmpty()) {
            this.mySymbolUsed = true;
            return;
        }
        for (OCInstruction instruction : instructions.get((Object)OCInstruction.InstructionKind.REFERENCE)) {
            this.traverse(instruction.getNode(), this.mySymbol, null, true);
        }
        this.myIgnoreKills = false;
        System.arraycopy(this.myProcessedNodes, 0, this.myReachableNodesFromReference, 0, this.myCfg.getNumOfNodes());
        super.process();
    }

    @Override
    protected boolean acceptsInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCNotUsedValueChecker.$$$reportNull$$$0(2);
        }
        if (this.myIgnoreKills) {
            return true;
        }
        return instruction.getKind() != OCInstruction.InstructionKind.KILL;
    }

    @Override
    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCNotUsedValueChecker.$$$reportNull$$$0(3);
        }
        switch (instruction.getKind()) {
            case READ: 
            case READ_IN_BLOCK: 
            case REFERENCE: {
                this.mySymbolUsed = true;
                return true;
            }
            case WRITE: 
            case WRITE_IN_BLOCK: {
                this.mySymbolAssigned = true;
            }
        }
        return false;
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCNotUsedValueChecker.$$$reportNull$$$0(4);
        }
        return instruction.getKind() == OCInstruction.InstructionKind.WRITE && (!(this.mySymbol instanceof OCDeclaratorSymbol) || !((OCDeclaratorSymbol)this.mySymbol).isFriendOrStatic());
    }

    @Override
    protected boolean isProcessed(@NotNull OCInstruction instruction, boolean isForward) {
        if (instruction == null) {
            OCNotUsedValueChecker.$$$reportNull$$$0(5);
        }
        return this.myReachableNodesFromReference[instruction.getNode().getIndex()] || super.isProcessed(instruction, isForward);
    }

    @NotNull
    public List<PsiElement> getNotUsedWrites() {
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = this.myCfg.getInstructions(this.mySymbol);
        if (instructions == null || !instructions.get((Object)OCInstruction.InstructionKind.READ_IN_BLOCK).isEmpty()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                OCNotUsedValueChecker.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<PsiElement> list = this.getNonReachableElements();
        if (list == null) {
            OCNotUsedValueChecker.$$$reportNull$$$0(7);
        }
        return list;
    }

    @Override
    @Nullable
    protected PsiElement getElementFromInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCNotUsedValueChecker.$$$reportNull$$$0(8);
        }
        return instruction.getLValue();
    }

    public boolean isSymbolUsed() {
        return this.mySymbolUsed;
    }

    public boolean isSymbolAssigned() {
        return this.mySymbolAssigned;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfg";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/legacy/dfa/OCNotUsedValueChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/legacy/dfa/OCNotUsedValueChecker";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotUsedWrites";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "acceptsInstruction";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isStartInstruction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isEndInstruction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isProcessed";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementFromInstruction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

