/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCChangePropertyAttributeIntentionAction
extends OCQuickFix {
    @NotNull
    final Project myProject;
    private SmartPsiElementPointer<OCProperty> myPropertyPtr;
    private OCPropertySymbol myPropertySymbol;
    private OCPropertySymbol.PropertyAttribute myOldAttr;
    private OCPropertySymbol.PropertyAttribute myNewAttr;
    private String myNewValue;
    private String mySubject;

    public OCChangePropertyAttributeIntentionAction(OCPropertySymbol propertySymbol, @Nullable OCPropertySymbol.PropertyAttribute oldAttr, @Nullable OCPropertySymbol.PropertyAttribute newAttr, @Nullable String newValue, @NotNull Project project) {
        if (project == null) {
            OCChangePropertyAttributeIntentionAction.$$$reportNull$$$0(0);
        }
        this.mySubject = "property";
        this.myProject = project;
        this.myPropertyPtr = null;
        this.myPropertySymbol = propertySymbol;
        this.myOldAttr = oldAttr;
        this.myNewAttr = newAttr;
        this.myNewValue = newValue;
    }

    public OCChangePropertyAttributeIntentionAction(OCPropertySymbol propertySymbol, @Nullable OCPropertySymbol.PropertyAttribute oldAttr, @Nullable OCPropertySymbol.PropertyAttribute newAttr, @Nullable String newValue, String subject, @NotNull Project project) {
        if (project == null) {
            OCChangePropertyAttributeIntentionAction.$$$reportNull$$$0(1);
        }
        this(propertySymbol, oldAttr, newAttr, newValue, project);
        this.mySubject = subject;
    }

    public OCChangePropertyAttributeIntentionAction(OCProperty property, OCPropertySymbol.PropertyAttribute oldAttr, OCPropertySymbol.PropertyAttribute newAttr) {
        this.mySubject = "property";
        this.myProject = property.getProject();
        this.myPropertyPtr = OCElementUtil.createPsiElementPointer(property);
        this.myOldAttr = oldAttr;
        this.myNewAttr = newAttr;
    }

    @Override
    @NlsSafe
    protected String getTextInternal() {
        String prefix;
        String string = prefix = this.myPropertySymbol != null ? "' for " + this.myPropertySymbol.getNameWithKindLowercase(OCCompilationContext.create(this.myPropertySymbol, this.myProject)) : "'";
        if (this.myOldAttr == null) {
            return "Enable attribute '" + this.myNewAttr.getTokenName() + prefix;
        }
        if (this.myNewAttr == null) {
            return "Disable attribute '" + this.myOldAttr.getTokenName() + prefix;
        }
        if (this.myNewValue != null) {
            return "Change value of attribute '" + this.myOldAttr.getTokenName() + "' to '" + this.myNewValue + "'";
        }
        return "Change " + this.mySubject + " attribute '" + this.myOldAttr.getTokenName() + "' to '" + this.myNewAttr.getTokenName() + "'";
    }

    @NotNull
    public String getFamilyName() {
        String string = OCInspectionsBundle.message("intentions.change.property.attribute.action", new Object[0]);
        if (string == null) {
            OCChangePropertyAttributeIntentionAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public boolean isAvailable() {
        OCProperty property;
        OCProperty oCProperty = property = this.myPropertyPtr != null ? (OCProperty)this.myPropertyPtr.getElement() : null;
        return (property != null ? OCSearchScope.isInProjectSources(property) : OCSearchScope.isInProjectSources(this.myPropertySymbol, this.myProject)) && (this.myOldAttr != this.myNewAttr || this.myNewValue != null);
    }

    @Override
    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) throws IncorrectOperationException {
        OCProperty property;
        if (project == null) {
            OCChangePropertyAttributeIntentionAction.$$$reportNull$$$0(3);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        OCProperty oCProperty = property = this.myPropertyPtr != null ? (OCProperty)this.myPropertyPtr.getElement() : null;
        if (property == null) {
            property = (OCProperty)PsiTreeUtil.getParentOfType((PsiElement)this.myPropertySymbol.locateDefinition(project), OCProperty.class);
        }
        if (property == null || !FileModificationService.getInstance().prepareFileForWrite(property.getContainingFile())) {
            return;
        }
        OCPropertyAttributesList attrList = property.getPropertyAttributesList();
        OCPropertyAttributesList newAttrList = null;
        OCPropertyAttribute newAttribute = null;
        if (this.myNewAttr != null) {
            newAttrList = OCElementFactory.propertyAttributeList(this.myNewAttr, this.myNewValue, (PsiElement)file);
            newAttribute = newAttrList.getAttributes().get(0);
        }
        if (attrList == null) {
            if (this.myNewAttr != null) {
                PsiElement prevSibling;
                OCDeclaration anchor = property.getDeclaration();
                PsiElement psiElement = prevSibling = anchor != null ? anchor.getPrevSibling() : null;
                if ("IBOutlet".equals(OCElementUtil.getTextWithMacros(prevSibling))) {
                    anchor = prevSibling;
                }
                property.addBefore(newAttrList, anchor);
            }
            return;
        }
        for (OCPropertyAttribute attribute : attrList.getAttributes()) {
            if (this.myOldAttr != null && Objects.equals(attribute.getName(), this.myOldAttr.getTokenName())) {
                if (newAttribute == null) {
                    OCChangeUtil.delete(attribute);
                } else if (this.myNewValue != null) {
                    attribute.setValue(this.myNewValue);
                } else {
                    attribute.replace(newAttribute);
                }
                return;
            }
            if (this.myNewAttr == null || !Objects.equals(attribute.getName(), this.myNewAttr.getTokenName())) continue;
            return;
        }
        if (newAttribute != null) {
            OCChangeUtil.add(attrList, newAttribute);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCChangePropertyAttributeIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCChangePropertyAttributeIntentionAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

