/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references.kvc;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCResolvesToSymbol;
import com.jetbrains.cidr.lang.resolve.references.kvc.KVCReferencesProvider;
import com.jetbrains.cidr.lang.resolve.references.kvc.KVCUtil;
import com.jetbrains.cidr.lang.resolve.references.kvc.KeyReference;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyReferenceProvider
extends KVCReferencesProvider {
    @Override
    protected KeyReference[] getReferences(@NotNull OCLiteralExpression literal, @NotNull ASTNode stringLiteral, final @NotNull OCObjectType receiverClass) {
        TextRange literalContentsRange;
        if (literal == null) {
            KeyReferenceProvider.$$$reportNull$$$0(0);
        }
        if (stringLiteral == null) {
            KeyReferenceProvider.$$$reportNull$$$0(1);
        }
        if (receiverClass == null) {
            KeyReferenceProvider.$$$reportNull$$$0(2);
        }
        int startOffsetInParent = stringLiteral.getPsi().getStartOffsetInParent();
        if (stringLiteral.getTextLength() > 0 && !(literalContentsRange = new TextRange(startOffsetInParent + 1, startOffsetInParent + stringLiteral.getTextLength() - 1)).isEmpty()) {
            String key = stringLiteral.getText().substring(1, stringLiteral.getText().length() - 1);
            if (KVCUtil.isValidPairForReferring(receiverClass.getClassSymbol(), key, literal.getContainingOCFile())) {
                return new KeyReference[]{new KeyReference(new OCResolvesToSymbol<OCClassSymbol>(){

                    @Override
                    @Nullable
                    public OCClassSymbol resolveToSymbol() {
                        return receiverClass.getClassSymbol();
                    }
                }, literal, literalContentsRange, key, literal.getProject())};
            }
        }
        return new KeyReference[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "literal";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "stringLiteral";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "receiverClass";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/resolve/references/kvc/KeyReferenceProvider";
        objectArray[2] = "getReferences";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

