/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.usages;

import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.resolve.OCCompilerGeneratedConstructorSymbol;
import com.jetbrains.cidr.lang.search.OCClassInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.search.OCStructInheritorsSearch;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesDialog;
import com.jetbrains.cidr.lang.search.usages.OCFindUsagesOptions;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolHolderVirtualPsiElement;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.util.OCScopeInfo;
import java.util.HashSet;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFindUsagesHandler
extends FindUsagesHandler {
    private boolean myDeleteMode;
    PsiElement myOCElement;

    public OCFindUsagesHandler(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            OCFindUsagesHandler.$$$reportNull$$$0(0);
        }
        super(psiElement);
        this.myOCElement = null;
    }

    public OCFindUsagesHandler(@NotNull PsiElement psiElement, boolean isDeleteMode) {
        if (psiElement == null) {
            OCFindUsagesHandler.$$$reportNull$$$0(1);
        }
        super(psiElement);
        this.myOCElement = null;
        this.myDeleteMode = isDeleteMode;
    }

    public PsiElement @NotNull [] getPrimaryElements() {
        PsiElement element = this.getElementFromOCFile();
        OCSymbol elementSymbol = null;
        if (element instanceof OCFile) {
            elementSymbol = ((OCFile)element).getSameNamedClass();
        } else if (element instanceof OCSymbolDeclarator) {
            elementSymbol = ((OCSymbolDeclarator)element).getSymbol();
        }
        if (elementSymbol instanceof OCCompilerGeneratedConstructorSymbol) {
            elementSymbol = ((OCCompilerGeneratedConstructorSymbol)elementSymbol).getStruct();
        }
        if (elementSymbol == null) {
            PsiElement[] psiElementArray = super.getPrimaryElements();
            if (psiElementArray == null) {
                OCFindUsagesHandler.$$$reportNull$$$0(2);
            }
            return psiElementArray;
        }
        OCSymbol symbol = elementSymbol;
        HashSet<PsiElement> result = new HashSet<PsiElement>();
        CommonProcessors.CollectProcessor resultCollector = new CommonProcessors.CollectProcessor(result);
        Project project = element.getProject();
        OCSymbol maybeClassSymbol = symbol.getDefinitionSymbol(project);
        if (this.myDeleteMode && maybeClassSymbol instanceof OCClassSymbol) {
            String categoryName = ((OCClassSymbol)maybeClassSymbol).getCategoryName();
            maybeClassSymbol.processSameSymbols((Processor<OCSymbol>)((Processor)curSymbol -> {
                if (categoryName != null && !categoryName.equals(((OCClassSymbol)curSymbol).getCategoryName())) {
                    return true;
                }
                OCFile file = curSymbol.getContainingOCFile(project);
                if (file != null && curSymbol.equals(file.getSameNamedClass()) && !file.hasExtraTopLevelDefinitions()) {
                    resultCollector.process((Object)file);
                } else if (!result.contains(file)) {
                    this.processSymbol((OCSymbol)curSymbol, (Processor<PsiElement>)resultCollector);
                }
                return true;
            }), project);
        } else {
            Processor processDefinitionIfPossible = _symbol -> {
                this.processDefinitionIfPossible((OCSymbol)_symbol, (Processor<PsiElement>)resultCollector);
                return true;
            };
            if (symbol instanceof OCSymbolWithParent) {
                OCSymbolWithParent symbolWithParent = (OCSymbolWithParent)symbol;
                OCSearchUtil.Ancestor ancestor = OCSearchUtil.findSomeAncestor(symbolWithParent, this.getProject());
                if (ancestor != null) {
                    String message;
                    OCCompilationContext context = OCCompilationContext.create(element);
                    String subject = symbol.getKindLowercase(context);
                    String string = message = ancestor.isOutOfProject() ? OCBundle.message("usage.overrides.out.of.project.message", symbol.getNameWithKindUppercase(context), subject, ancestor.getSymbol().getParent().getNameWithKindLowercase(context)) : OCBundle.message("usage.overrides.message", symbol.getNameWithKindUppercase(context), subject, ancestor.getSymbol().getParent().getNameWithKindLowercase(context));
                    if (this.myDeleteMode && ancestor.isOutOfProject()) {
                        int code = Messages.showYesNoDialog((Project)this.getProject(), (String)OCBundle.message("usage.delete.out.of.project.message", message), (String)OCBundle.message("usage.delete.out.of.project.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                        if (code != 0) {
                            if (PsiElement.EMPTY_ARRAY == null) {
                                OCFindUsagesHandler.$$$reportNull$$$0(3);
                            }
                            return PsiElement.EMPTY_ARRAY;
                        }
                    } else {
                        int code = ApplicationManager.getApplication().isUnitTestMode() ? 0 : ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)OCBundle.message("usage.method.search.title", new Object[0]), (String)OCBundle.message(this.myDeleteMode ? "usage.method.search.message.delete" : "usage.method.search.message.find.usages", message, subject)).icon(Messages.getQuestionIcon())).show();
                        if (code == 0) {
                            OCSearchUtil.processMemberAncestors(symbolWithParent, (Processor<? super OCSymbolWithParent>)processDefinitionIfPossible, !this.myDeleteMode, this.getProject());
                        } else {
                            this.processDefinitionIfPossible(symbol, (Processor<PsiElement>)resultCollector);
                        }
                    }
                } else {
                    this.processDefinitionIfPossible(symbol, (Processor<PsiElement>)resultCollector);
                }
                if (this.myDeleteMode) {
                    boolean isGeneratedFromProperty = false;
                    if (symbol instanceof OCMethodSymbol) {
                        OCMethodSymbol method = (OCMethodSymbol)symbol;
                        OCMethodSymbol associatedSymbol = method.getAssociatedSymbol(this.getProject());
                        boolean bl = isGeneratedFromProperty = associatedSymbol != null && associatedSymbol.getGeneratedFromProperty() != null;
                    }
                    if (!isGeneratedFromProperty) {
                        if (symbolWithParent instanceof OCFunctionSymbol || symbolWithParent instanceof OCMemberSymbol) {
                            OCSearchUtil.processMembersHierarchy(symbolWithParent, processDefinitionIfPossible, false, true, true, this.getProject());
                        } else {
                            symbolWithParent.processSameSymbols((Processor<OCSymbol>)((Processor)s -> {
                                this.processSymbol((OCSymbol)s, (Processor<PsiElement>)resultCollector);
                                return true;
                            }), project);
                        }
                    }
                }
            } else if (this.myDeleteMode && element instanceof OCMethodSelectorPart) {
                resultCollector.process((Object)element);
            } else {
                this.processDefinitionIfPossible(symbol, (Processor<PsiElement>)resultCollector);
            }
        }
        if (result.isEmpty()) {
            result.add(element);
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result);
        if (psiElementArray == null) {
            OCFindUsagesHandler.$$$reportNull$$$0(4);
        }
        return psiElementArray;
    }

    @NotNull
    private PsiElement getElementFromOCFile() {
        if (this.myOCElement == null) {
            this.myOCElement = this.getPsiElement();
            OCPsiFile file = OCLanguageUtils.asOCPsiFile(this.myOCElement.getContainingFile());
            if (file != null) {
                this.myOCElement = file.asElementFromOCFile(this.myOCElement);
            }
        }
        PsiElement psiElement = this.myOCElement;
        if (psiElement == null) {
            OCFindUsagesHandler.$$$reportNull$$$0(5);
        }
        return psiElement;
    }

    void processSecondaryElements(AssociatedElementProcessor processor) {
        block15: {
            Object symbol;
            PsiElement element;
            block14: {
                element = this.getElementFromOCFile();
                if (!(element instanceof OCSymbolDeclarator)) {
                    return;
                }
                symbol = ((OCSymbolDeclarator)element).getSymbol();
                if (!(symbol instanceof OCInstanceVariableSymbol)) break block14;
                OCPropertySymbol property = ((OCInstanceVariableSymbol)symbol).getAssociatedProperty(element.getProject());
                if (property == null) break block15;
                if (((OCInstanceVariableSymbol)symbol).isClang4ImplicitIvar(this.getProject())) {
                    processor.process(new OCSymbolHolderVirtualPsiElement((OCSymbol)symbol, this.getProject()));
                }
                if (processor.proceedProperty(property)) {
                    this.processSymbol(property, processor);
                    this.processSynthesizes(property, processor);
                }
                break block15;
            }
            if (symbol instanceof OCPropertySymbol) {
                OCInstanceVariableSymbol ivar = ((OCPropertySymbol)symbol).getAssociatedIvar(element.getProject());
                if (ivar != null) {
                    if (ivar.isClang4ImplicitIvar(this.getProject())) {
                        processor.process(new OCSymbolHolderVirtualPsiElement(ivar, this.getProject()));
                    } else if (processor.proceedIvar(ivar)) {
                        this.processSymbol(ivar, processor);
                    }
                }
                this.processSynthesizes((OCPropertySymbol)symbol, processor);
            } else if (symbol instanceof OCClassSymbol && processor.proceedDerivedClasses()) {
                for (OCClassSymbol clazz : OCClassInheritorsSearch.search((OCClassSymbol)symbol, this.getProject()).findAll()) {
                    this.processSymbol(clazz, processor);
                }
            } else if (symbol instanceof OCStructSymbol && ((OCElement)element).getContainingOCFile().isCpp() && processor.proceedDerivedClasses()) {
                for (OCStructSymbol struct : OCStructInheritorsSearch.search((OCStructSymbol)symbol, element).findAll()) {
                    this.processDefinitionIfPossible(struct, processor);
                }
            }
        }
    }

    private void processSynthesizes(OCPropertySymbol symbol, Processor<PsiElement> processor) {
        if (this.myDeleteMode) {
            symbol.processSynthesizes((Processor<? super OCSynthesizeSymbol>)((Processor)symbol1 -> {
                this.processSymbol((OCSymbol)symbol1, processor);
                return true;
            }), this.getProject());
        }
    }

    public PsiElement @NotNull [] getSecondaryElements() {
        final HashSet result = new HashSet();
        if (this.myDeleteMode) {
            this.processSecondaryElements(new AssociatedElementProcessor(){

                @Override
                public boolean proceedProperty(OCPropertySymbol property) {
                    return ApplicationManager.getApplication().isUnitTestMode() || ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)OCBundle.message("usage.properties.search.title", new Object[0]), (String)OCBundle.message(OCFindUsagesHandler.this.myDeleteMode ? "usage.properties.search.message.delete" : "usage.properties.search.message.find.usages", property.getNameWithKindLowercase(OCCompilationContext.create(OCFindUsagesHandler.this.getElementFromOCFile())))).icon(Messages.getQuestionIcon())).show() == 0;
                }

                @Override
                public boolean proceedIvar(OCInstanceVariableSymbol ivar) {
                    if (ivar.getGeneratedFromProperty() != null) {
                        return true;
                    }
                    return ApplicationManager.getApplication().isUnitTestMode() || ((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)OCBundle.message("usage.instance.variables.search.title", new Object[0]), (String)OCBundle.message(OCFindUsagesHandler.this.myDeleteMode ? "usage.instance.variables.search.message.delete" : "usage.instance.variables.search.message.find.usages", ivar.getNameWithKindLowercase(OCCompilationContext.create(OCFindUsagesHandler.this.getElementFromOCFile())))).icon(Messages.getQuestionIcon())).show() == 0;
                }

                @Override
                public boolean proceedDerivedClasses() {
                    return false;
                }

                public boolean process(PsiElement element) {
                    result.add(element);
                    return true;
                }
            });
        } else {
            final OCFindUsagesOptions options = OCFindUsagesOptions.getInstance(this.getProject());
            options.setDefaults(this.getProject());
            this.processSecondaryElements(new AssociatedElementProcessor(){

                @Override
                public boolean proceedProperty(OCPropertySymbol property) {
                    return options.isSearchForProperties;
                }

                @Override
                public boolean proceedIvar(OCInstanceVariableSymbol ivar) {
                    return options.isSearchForIvars;
                }

                @Override
                public boolean proceedDerivedClasses() {
                    return options.isSearchForDerivedClasses;
                }

                public boolean process(PsiElement element) {
                    result.add(element);
                    return true;
                }
            });
        }
        PsiElement[] psiElementArray = PsiUtilCore.toPsiElementArray(result);
        if (psiElementArray == null) {
            OCFindUsagesHandler.$$$reportNull$$$0(6);
        }
        return psiElementArray;
    }

    private void processSymbol(OCSymbol symbol, Processor<PsiElement> processor) {
        if (symbol == null) {
            return;
        }
        PsiElement def = symbol.locateDefinition(this.getProject());
        if (def != null) {
            processor.process((Object)def);
        }
    }

    private void processDefinitionIfPossible(@NotNull OCSymbol symbol, @NotNull Processor<PsiElement> processor) {
        OCSymbol definitionSymbol;
        if (symbol == null) {
            OCFindUsagesHandler.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            OCFindUsagesHandler.$$$reportNull$$$0(8);
        }
        PsiElement elementToFind = null;
        elementToFind = this.myDeleteMode ? symbol.locateDefinition(this.getProject()) : ((definitionSymbol = symbol.getDefinitionSymbol(this.getProject())) != null ? definitionSymbol : symbol).locateDefinition(this.getProject());
        if (elementToFind != null) {
            processor.process((Object)elementToFind);
        }
    }

    protected boolean isSearchForTextOccurrencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        if (psiElement == null) {
            OCFindUsagesHandler.$$$reportNull$$$0(9);
        }
        return !OCScopeInfo.isLocalDeclarator(psiElement);
    }

    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
        OCFindUsagesOptions oCFindUsagesOptions = OCFindUsagesOptions.getInstance(this.getProject());
        if (oCFindUsagesOptions == null) {
            OCFindUsagesHandler.$$$reportNull$$$0(10);
        }
        return oCFindUsagesOptions;
    }

    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        return new OCFindUsagesDialog(this.getElementFromOCFile(), this.getProject(), (FindUsagesOptions)OCFindUsagesOptions.getInstance(this.getProject()), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/search/usages/OCFindUsagesHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/search/usages/OCFindUsagesHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimaryElements";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementFromOCFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondaryElements";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processDefinitionIfPossible";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSearchForTextOccurrencesAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static interface AssociatedElementProcessor
    extends Processor<PsiElement> {
        public boolean proceedProperty(OCPropertySymbol var1);

        public boolean proceedIvar(OCInstanceVariableSymbol var1);

        public boolean proceedDerivedClasses();
    }
}

