/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.PowerSaveMode;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Alarm;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.Function;
import com.intellij.util.MathUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.VirtualFileChangeListener;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapCacheBuildingSession;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLazyBlockStatementElementType;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.DirtyIncludesInvalidator;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableUpdater;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesPack;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbolTableListener;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.symbols.symtable.ProcessingDependencyGraph;
import com.jetbrains.cidr.lang.symbols.symtable.SymbolTableProvider;
import com.jetbrains.cidr.lang.symbols.symtable.TableBuildingItem;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationService;
import com.jetbrains.cidr.lang.symbols.symtable.serialization.SerializationSession;
import com.jetbrains.cidr.lang.workspace.OCPCHCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.util.events.CidrEventSpan;
import gnu.trove.THashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;

public final class FileSymbolTablesCache
implements ProjectComponent {
    public static final Topic<PsiModificationTracker.Listener> OUT_OF_CODE_BLOCK_TOPIC = new Topic(PsiModificationTracker.Listener.class, Topic.BroadcastDirection.TO_PARENT);
    private static final Logger LOG = Logger.getInstance(FileSymbolTablesCache.class);
    private static final boolean USE_PSI_FOR_INVALIDATION = Registry.is((String)"cidr.indexer.invalidateUsingPsi", (boolean)false);
    private static volatile Boolean ourForceSymbolsLoadedInTests = null;
    private static final SymbolsProperties DEFAULT_SYMBOLS_PROPERTIES;
    private static volatile SymbolsProperties ourSymbolsProperties;
    private final ConcurrentMap<VirtualFile, FileSymbolTablesPack> myCache;
    private final FileSymbolTableUpdater myTableUpdater;
    private final Project myProject;
    private final Set<VirtualFile> myPendingReparses;
    private final Set<VirtualFile> myPendingPSIResets;
    private final Object mySerializationLock;
    private final PeriodicSerializationTask mySerializationTask;
    private final SimpleModificationTracker myOutOfBlockModificationTracker;
    private final AtomicBoolean mySymbolsLoaded;
    private final ProcessingDependencyGraph<TableBuildingItem> myProcessingDependencyGraph;
    private final SerializationService mySerializationService;

    @NotNull
    public static FileSymbolTablesCache getInstance(@NotNull Project project) {
        if (project == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(0);
        }
        FileSymbolTablesCache fileSymbolTablesCache = (FileSymbolTablesCache)project.getComponent(FileSymbolTablesCache.class);
        if (fileSymbolTablesCache == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(1);
        }
        return fileSymbolTablesCache;
    }

    public FileSymbolTablesCache(final @NotNull Project project) {
        if (project == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(2);
        }
        this.myCache = new ConcurrentHashMap<VirtualFile, FileSymbolTablesPack>();
        this.myPendingReparses = new THashSet();
        this.myPendingPSIResets = new THashSet();
        this.mySerializationLock = new Object();
        this.mySerializationTask = new PeriodicSerializationTask();
        this.mySymbolsLoaded = new AtomicBoolean(false);
        this.myProcessingDependencyGraph = new ProcessingDependencyGraph();
        this.myTableUpdater = new FileSymbolTableUpdater(project);
        this.myProject = project;
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        this.myOutOfBlockModificationTracker = new SimpleModificationTracker(){

            public void incModificationCount() {
                super.incModificationCount();
                psiManager.dropPsiCaches();
                ((PsiModificationTracker.Listener)project.getMessageBus().syncPublisher(OUT_OF_CODE_BLOCK_TOPIC)).modificationCountChanged();
            }
        };
        if (psiManager instanceof PsiManagerImpl) {
            ((PsiManagerImpl)psiManager).addTreeChangePreprocessor((PsiTreeChangePreprocessor)new OCCodeBlockModificationListener(this.myProject));
        }
        MessageBusConnection connection = project.getMessageBus().connect();
        this.listenOCWorkspaceChanges(connection);
        this.listenVFSChanges(connection);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            StartupManager.getInstance((Project)project).runAfterOpened((Runnable)new TestSymbolReBuilder(project));
        }
        this.mySerializationService = SerializationService.getService();
    }

    private void listenOCWorkspaceChanges(MessageBusConnection connection) {
        connection.subscribe(OCWorkspaceListener.TOPIC, (Object)new OCWorkspaceListener(){

            public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, FileSymbolTablesCache.this.myProject);
                if (event.resolveConfigurationsChanged() || event.compilerSettingsChanged()) {
                    OCSymbolTablesBuildingActivity.getInstance(FileSymbolTablesCache.this.myProject).rebuildSymbols();
                }
                FileSymbolTablesCache.this.incModificationCount();
            }

            public void selectedResolveConfigurationChanged() {
                OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, FileSymbolTablesCache.this.myProject);
                FileSymbolTablesCache.this.scheduleReparseCachedPsiFiles();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$2", "workspaceChanged"));
            }
        });
    }

    private void listenVFSChanges(MessageBusConnection connection) {
        if (((Boolean)OCLanguage.LANGUAGE_SUPPORT_DISABLED.get((UserDataHolder)this.myProject, (Object)false)).booleanValue()) {
            return;
        }
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new VirtualFileChangeListener(true){
            private ClearTablesAndCollectNamesVisitor visitor;

            protected void begin() {
                this.visitor = new ClearTablesAndCollectNamesVisitor();
            }

            protected void onFileChange(@NotNull VirtualFile file, @NotNull VFileEvent event) {
                if (file == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (event == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (event.isFromSave()) {
                    return;
                }
                VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)this.visitor);
            }

            protected void done() {
                Set<String> toInvalidate = this.visitor.dirtyNames;
                boolean cacheCleared = this.visitor.cacheCleared;
                this.visitor = null;
                boolean includingFilesInvalidated = FileSymbolTablesCache.this.invalidateDirtyIncludes(toInvalidate);
                if (includingFilesInvalidated || cacheCleared) {
                    FileSymbolTablesCache.this.incModificationCount();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$3";
                objectArray[2] = "onFileChange";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @NotNull
    public ModificationTracker getOutOfBlockModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myOutOfBlockModificationTracker;
        if (simpleModificationTracker == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(3);
        }
        return simpleModificationTracker;
    }

    public void projectOpened() {
        if (!this.myProject.isDefault() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.mySerializationTask.schedule(20000);
        }
    }

    public void projectClosed() {
        this.mySerializationTask.cancelAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldBuildTables() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ModuleMapCacheBuildingSession.INSTANCE.isModuleMapBuildingSession()) {
            return true;
        }
        Class<FileSymbolTablesCache> clazz = FileSymbolTablesCache.class;
        synchronized (FileSymbolTablesCache.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourSymbolsProperties == null || FileSymbolTablesCache.ourSymbolsProperties.buildSymbolsKind != SymbolsProperties.SymbolsKind.NO_SYMBOLS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldBuildTablesForAllSystemHeaders() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ModuleMapCacheBuildingSession.INSTANCE.isModuleMapBuildingSession()) {
            return true;
        }
        Class<FileSymbolTablesCache> clazz = FileSymbolTablesCache.class;
        synchronized (FileSymbolTablesCache.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourSymbolsProperties == null || FileSymbolTablesCache.ourSymbolsProperties.buildSymbolsKind == SymbolsProperties.SymbolsKind.ALL_INCLUDING_UNUSED_SYSTEM_HEADERS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSerializationEnabled() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ModuleMapCacheBuildingSession.INSTANCE.isModuleMapBuildingSession()) {
            return true;
        }
        Class<FileSymbolTablesCache> clazz = FileSymbolTablesCache.class;
        synchronized (FileSymbolTablesCache.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourSymbolsProperties == null || FileSymbolTablesCache.ourSymbolsProperties.serializeSymbolTables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isDeserializationEnabled() {
        if (!ApplicationManager.getApplication().isUnitTestMode() && !ModuleMapCacheBuildingSession.INSTANCE.isModuleMapBuildingSession()) {
            return true;
        }
        Class<FileSymbolTablesCache> clazz = FileSymbolTablesCache.class;
        synchronized (FileSymbolTablesCache.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return ourSymbolsProperties == null || FileSymbolTablesCache.ourSymbolsProperties.deserializeSymbolTables;
        }
    }

    @TestOnly
    @Nullable
    public static synchronized SymbolsProperties setShouldBuildTablesInTests(@Nullable SymbolsProperties properties) {
        SymbolsProperties prev = ourSymbolsProperties;
        ourSymbolsProperties = properties != null ? properties : DEFAULT_SYMBOLS_PROPERTIES;
        return prev;
    }

    public boolean invalidateDirtyIncludes(@NotNull Set<String> dirtyNames) {
        if (dirtyNames == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(4);
        }
        return this.invalidateDirtyIncludes(dirtyNames, false);
    }

    public boolean invalidateDirtyIncludes(@NotNull Set<String> dirtyNames, boolean isRelativePath) {
        if (dirtyNames == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (dirtyNames.isEmpty()) {
            return false;
        }
        Set<VirtualFile> allCachedFiles = this.getCachedFiles();
        ImmutableList.Builder cachedFilesBuilder = ImmutableList.builderWithExpectedSize((int)allCachedFiles.size());
        for (VirtualFile cachedFile : allCachedFiles) {
            if (!cachedFile.isValid()) continue;
            cachedFilesBuilder.add((Object)cachedFile);
        }
        ImmutableList cachedFiles = cachedFilesBuilder.build();
        DirtyIncludesInvalidator invalidator = new DirtyIncludesInvalidator(this, dirtyNames, isRelativePath, cachedFiles.size());
        Collection<VirtualFile> pendingInvalidation = invalidator.collect((ImmutableList<VirtualFile>)cachedFiles);
        return this.invalidateDirtyIncludeFiles(pendingInvalidation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean invalidateDirtyIncludeFiles(@NotNull Collection<VirtualFile> dirtyFiles) {
        if (dirtyFiles == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(6);
        }
        boolean result = false;
        if (!dirtyFiles.isEmpty()) {
            THashSet processedFiles = new THashSet();
            for (VirtualFile file : dirtyFiles) {
                if (!this.invalidate(file, true, (Set<VirtualFile>)processedFiles, true)) continue;
                result = true;
                Set<VirtualFile> set = this.myPendingReparses;
                synchronized (set) {
                    this.myPendingReparses.add(file);
                }
            }
            if (result) {
                OCImportGraph.getInstance(this.myProject).invalidateHeaderRootsCache();
                OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(null, this.myProject);
            }
        }
        this.schedulePSIUpdates();
        return result;
    }

    public void compact() {
        for (FileSymbolTablesPack pack : this.myCache.values()) {
            pack.compactSynchronized();
        }
    }

    @NotNull
    public Set<VirtualFile> getFilesToBuildTablesFor() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<VirtualFile> allSourceFiles = OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(this.myProject);
        Set result = (Set)CollectionsKt.filterTo(allSourceFiles, new LinkedHashSet(), virtualFile -> SymbolTableProvider.isSourceFile(this.myProject, virtualFile));
        if (FileSymbolTablesCache.shouldBuildTablesForAllSystemHeaders()) {
            result.addAll(OCResolveConfigurations.getHeaderFilesToBuildSymbols((Project)this.myProject));
        }
        Set set = result;
        if (set == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(7);
        }
        return set;
    }

    public Set<VirtualFile> getCachedFiles() {
        return this.myCache.keySet();
    }

    public void addFileToCache(@Nullable VirtualFile file) {
        if (file == null) {
            return;
        }
        this.myTableUpdater.addFileForUpdate(file);
    }

    public void addFilesToCache(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(8);
        }
        this.myTableUpdater.addFilesForUpdate(files, false);
    }

    @NotNull
    public @NotNull List<@NotNull VirtualFile> removeFilesFromCache(@NotNull @NotNull Iterable<@NotNull ? extends VirtualFile> files) {
        if (files == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(9);
        }
        List list = CollectionsKt.filter(files, this::clearCache);
        if (list == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(10);
        }
        return list;
    }

    public void removeAllChildrenFromCache(@Nullable VirtualFile root) {
        if (root == null) {
            return;
        }
        for (VirtualFile file : this.myCache.keySet()) {
            if (file == null || !VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            this.clearCache(file);
        }
    }

    public FileSymbolTable calcTableUsingPSI(@NotNull PsiFile file, @NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(11);
        }
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(12);
        }
        if (context == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(13);
        }
        return SymbolTableProvider.getProvider(file).calcTableUsingPSI(file, virtualFile, context);
    }

    @Nullable
    public FileSymbolTable forFile(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context) {
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(14);
        }
        if (context == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(15);
        }
        return this.forFile(virtualFile, context, null);
    }

    @Nullable
    public FileSymbolTable forFile(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context, @Nullable SerializationSession serializationSession) {
        Ref outTimeStamp;
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(16);
        }
        if (context == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(17);
        }
        ProgressManager.checkCanceled();
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) {
            LOG.error("deadlock may occur if 'FileSymbolTablesCache.forFile' is called outside of read-action");
        }
        if (!FileSymbolTablesCache.shouldBuildTables() || !virtualFile.isValid()) {
            return null;
        }
        FileSymbolTablesPack pack = this.mutablePackForFile(virtualFile, serializationSession);
        FileSymbolTable table = pack.findConformingTable(context, 0, (Ref<Integer>)(outTimeStamp = new Ref()));
        if (table != null || context.getInclusionLevel() >= OCInclusionContext.getMaxInclusionLevel()) {
            return table;
        }
        return this.buildTableForFile(virtualFile, context, pack, (Ref<Integer>)outTimeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private FileSymbolTable buildTableForFile(@NotNull VirtualFile virtualFile, @NotNull OCInclusionContext context, @NotNull FileSymbolTablesPack pack, @NotNull Ref<Integer> outTimeStamp) {
        Object object;
        block39: {
            FileSymbolTablesPack fileSymbolTablesPack;
            ProcessingDependencyGraph.State state;
            TableBuildingItem item;
            Thread currentThread;
            block38: {
                FileSymbolTable fileSymbolTable;
                block37: {
                    FileSymbolTable fileSymbolTable2;
                    block36: {
                        if (virtualFile == null) {
                            FileSymbolTablesCache.$$$reportNull$$$0(18);
                        }
                        if (context == null) {
                            FileSymbolTablesCache.$$$reportNull$$$0(19);
                        }
                        if (pack == null) {
                            FileSymbolTablesCache.$$$reportNull$$$0(20);
                        }
                        if (outTimeStamp == null) {
                            FileSymbolTablesCache.$$$reportNull$$$0(21);
                        }
                        currentThread = Thread.currentThread();
                        item = new TableBuildingItem(virtualFile, context.getLanguageKind());
                        state = null;
                        try (CidrEventSpan ignored = new CidrEventSpan("symbols", "waitForPack", (Object)item);){
                            object = pack;
                            synchronized (object) {
                                ProgressManager.checkCanceled();
                                FileSymbolTable table = pack.findConformingTable(context, (Integer)outTimeStamp.get(), outTimeStamp);
                                if (table != null) {
                                    FileSymbolTable fileSymbolTable3 = table;
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 35, 13] lbl21 : MonitorExitStatement: MONITOREXIT : var9_10
                                    fileSymbolTable2 = fileSymbolTable3;
                                    break block36;
                                }
                                state = this.myProcessingDependencyGraph.startProcessing(item, currentThread, context.getImpatientRescheduling());
                                while (state == ProcessingDependencyGraph.State.WAIT) {
                                    pack.wait(50L);
                                    ProgressManager.checkCanceled();
                                    table = pack.findConformingTable(context, (Integer)outTimeStamp.get(), outTimeStamp);
                                    if (table != null) {
                                        FileSymbolTable fileSymbolTable4 = table;
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 34, 23, 13] lbl31 : MonitorExitStatement: MONITOREXIT : var9_10
                                        fileSymbolTable = fileSymbolTable4;
                                        break block37;
                                    }
                                    if (!this.myProcessingDependencyGraph.retryStartProcessing(item, currentThread)) continue;
                                    state = ProcessingDependencyGraph.State.ACQUIRED;
                                }
                                break block38;
                            }
                        }
                        catch (InterruptedException e) {
                            throw new ProcessCanceledException((Throwable)e);
                        }
                    }
                    if (fileSymbolTable2 != null) return fileSymbolTable2;
                    FileSymbolTablesCache.$$$reportNull$$$0(22);
                    return fileSymbolTable2;
                }
                if (fileSymbolTable != null) return fileSymbolTable;
                FileSymbolTablesCache.$$$reportNull$$$0(23);
                return fileSymbolTable;
                finally {
                    if (state == ProcessingDependencyGraph.State.WAIT) {
                        this.myProcessingDependencyGraph.stopWaiting(currentThread);
                    }
                }
            }
            FileSymbolTable builtTable = null;
            try {
                if (state == ProcessingDependencyGraph.State.ACQUIRED) {
                    OCSymbolTablesBuildingActivity.getInstance(this.myProject).assertParsingAndSymbolBuildingAllowed(currentThread);
                }
                builtTable = SymbolTableProvider.getProvider(this.myProject, virtualFile, context).calcTable(virtualFile, context);
                context.addProcessedFile(virtualFile);
                object = builtTable;
                if (state != ProcessingDependencyGraph.State.ACQUIRED && (state != ProcessingDependencyGraph.State.RECURSIVE || builtTable == null)) break block39;
                fileSymbolTablesPack = pack;
            }
            catch (Throwable throwable) {
                if (state != ProcessingDependencyGraph.State.ACQUIRED) {
                    if (state != ProcessingDependencyGraph.State.RECURSIVE) throw throwable;
                    if (builtTable == null) throw throwable;
                }
                FileSymbolTablesPack fileSymbolTablesPack2 = pack;
                synchronized (fileSymbolTablesPack2) {
                    if (state == ProcessingDependencyGraph.State.ACQUIRED) {
                        this.myProcessingDependencyGraph.finishProcessing(item);
                        pack.notifyAll();
                    }
                    if (builtTable == null) throw throwable;
                    pack.addCompactSynchronized(this.myProject, builtTable);
                    this.notifyNewTables(virtualFile);
                    throw throwable;
                }
            }
            synchronized (fileSymbolTablesPack) {
                if (state == ProcessingDependencyGraph.State.ACQUIRED) {
                    this.myProcessingDependencyGraph.finishProcessing(item);
                    pack.notifyAll();
                }
                if (builtTable != null) {
                    pack.addCompactSynchronized(this.myProject, builtTable);
                    this.notifyNewTables(virtualFile);
                }
            }
        }
        Object object2 = object;
        if (object2 != null) return object2;
        FileSymbolTablesCache.$$$reportNull$$$0(24);
        return object2;
    }

    private void notifyNewTables(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(25);
        }
        ((OCFileSymbolTableListener)this.myProject.getMessageBus().syncPublisher(OCFileSymbolTableListener.TOPIC)).onFileHasNewSymbolTableInPack(virtualFile);
    }

    @Nullable
    public FileSymbolTable findForFile(@NotNull VirtualFile file, @NotNull OCInclusionContext context) {
        FileSymbolTablesPack pack;
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(26);
        }
        if (context == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(27);
        }
        return (pack = this.packForFile(file)) != null ? pack.findConformingTable(context, 0, null) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleReparseFile(OCFile file) {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            this.myPendingReparses.add(OCInclusionContextUtil.getVirtualFile(file));
        }
        this.schedulePSIUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCachedFilesToReparse() {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            for (PsiFile file : PsiManagerEx.getInstanceEx((Project)this.myProject).getFileManager().getAllCachedFiles()) {
                this.myPendingReparses.add(OCInclusionContextUtil.getVirtualFile(file));
            }
        }
    }

    private void scheduleReparseCachedPsiFiles() {
        this.addCachedFilesToReparse();
        this.schedulePSIUpdates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePSIUpdates() {
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            if (!this.myPendingPSIResets.isEmpty() || !this.myPendingReparses.isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> this.updateDirtyFilesPSI(), ModalityState.NON_MODAL);
            }
        }
    }

    public void reparseCachedPsiFiles() {
        this.addCachedFilesToReparse();
        this.updateDirtyFilesPSI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDirtyFilesPSI() {
        ArrayList<VirtualFile> toResetPSI;
        if (this.myProject.isDisposed()) {
            return;
        }
        HashSet<VirtualFile> toReparse = new HashSet<VirtualFile>();
        FileManager fileManager = PsiManagerEx.getInstanceEx((Project)this.myProject).getFileManager();
        Set<VirtualFile> set = this.myPendingReparses;
        synchronized (set) {
            this.myPendingPSIResets.removeAll(this.myPendingReparses);
            toResetPSI = new ArrayList<VirtualFile>(this.myPendingPSIResets);
            this.myPendingPSIResets.clear();
            for (VirtualFile virtualFile : this.myPendingReparses) {
                FileViewProvider pp;
                if (!virtualFile.isValid() || (pp = fileManager.findCachedViewProvider(virtualFile)) == null) continue;
                OCLog.LOG.assertTrue(pp instanceof AbstractFileViewProvider, (Object)pp);
                for (PsiFile cached : ((AbstractFileViewProvider)pp).getCachedPsiFiles()) {
                    FileSymbolTablesCache.processDirtyFile(toReparse, cached, virtualFile);
                }
            }
            this.myPendingReparses.clear();
        }
        if (!toResetPSI.isEmpty()) {
            ApplicationManager.getApplication().runWriteAction(() -> {
                for (VirtualFile file : toResetPSI) {
                    fileManager.setViewProvider(file, null);
                }
            });
        }
        if (!toReparse.isEmpty()) {
            FileContentUtilCore.reparseFiles(toReparse);
        }
        if (!toResetPSI.isEmpty() || !toReparse.isEmpty()) {
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    private static void processDirtyFile(@NotNull Set<VirtualFile> dirty, @NotNull PsiFile file, @NotNull VirtualFile virtualFile) {
        if (dirty == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(28);
        }
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(29);
        }
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(30);
        }
        if (SymbolTableProvider.isSourceFile(file.getProject(), virtualFile) && file instanceof PsiFileImpl) {
            FileElement node = ((PsiFileImpl)file).getTreeElement();
            if (node != null && node.isParsed()) {
                dirty.add(virtualFile);
            } else {
                file.clearCaches();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invalidate(@Nullable VirtualFile file, boolean reparse, Set<VirtualFile> processed, boolean withIncludingFiles) {
        if (file == null || !processed.add(file)) {
            return false;
        }
        boolean result = this.clearCache(file);
        if (file.isValid() && SymbolTableProvider.isSourceFile(this.myProject, file)) {
            this.myTableUpdater.addFileForUpdate(file);
        }
        if (withIncludingFiles) {
            Collection configs;
            Set<VirtualFile> dirtySet = reparse ? this.myPendingReparses : this.myPendingPSIResets;
            OCWorkspace workspace = OCWorkspace.getInstance((Project)this.myProject);
            if (!OCInclusionContextUtil.isNeedToFindRoot(file, this.myProject)) {
                for (OCResolveConfiguration config : workspace.getConfigurations()) {
                    OCImportGraph.invalidateRootHeadersCache(config, file);
                }
            }
            if (!(configs = OCPCHCache.getBuildConfigurationByPchFile((VirtualFile)file, (Project)this.myProject)).isEmpty()) {
                Runnable runnable = () -> {
                    if (this.myProject.isDisposed()) {
                        return;
                    }
                    for (OCResolveConfiguration config : configs) {
                        OCInclusionContext.onPrecompiledContextChange(config);
                    }
                    Collection<VirtualFile> sourceFiles = OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(this.myProject);
                    List<VirtualFile> clearedFiles = this.myTableUpdater.addFilesForUpdate(sourceFiles, true);
                    if (clearedFiles.isEmpty()) {
                        return;
                    }
                    Set<VirtualFile> set = this.myPendingReparses;
                    synchronized (set) {
                        dirtySet.addAll(clearedFiles);
                    }
                };
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    runnable.run();
                } else {
                    ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL);
                }
            }
            THashSet includingFiles = new THashSet();
            if (USE_PSI_FOR_INVALIDATION) {
                PsiFile psiFile = OCInclusionContextUtil.findCachedPsiFile(file, this.myProject);
                if (psiFile instanceof OCFile) {
                    Collection<VirtualFile> includingFromPsi = ((OCFile)psiFile).resetIncludingFiles();
                    includingFiles.addAll(includingFromPsi);
                }
            } else {
                Collection<VirtualFile> immediateIncludingFiles = OCImportGraph.getInstance(this.myProject).findImmediateIncludingFiles(file, false);
                includingFiles.addAll(immediateIncludingFiles);
            }
            for (VirtualFile including : includingFiles) {
                if (!this.invalidate(including, reparse, processed, true)) continue;
                result = true;
                Set<VirtualFile> set = this.myPendingReparses;
                synchronized (set) {
                    dirtySet.add(including);
                }
            }
        }
        return result;
    }

    public void ensurePendingFilesProcessed() {
        this.ensurePendingFilesProcessed(false);
    }

    public void ensurePendingFilesProcessed(boolean rootsOnly) {
        this.myTableUpdater.ensurePendingFilesProcessed(rootsOnly);
    }

    @NotNull
    public @Unmodifiable List<FileSymbolTable> allTablesForFile(@NotNull PsiFile file) {
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(31);
        }
        List<FileSymbolTable> list = this.allTablesForFile(OCInclusionContextUtil.getVirtualFile(file));
        if (list == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    public @Unmodifiable List<FileSymbolTable> allTablesForFile(@NotNull VirtualFile virtualFile) {
        FileSymbolTablesPack pack;
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(33);
        }
        List<FileSymbolTable> list = (pack = this.packForFile(virtualFile)) != null ? pack.getTablesSynchronized() : ContainerUtil.emptyList();
        if (list == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(34);
        }
        return list;
    }

    public int allTablesForFileCount(@NotNull VirtualFile virtualFile) {
        FileSymbolTablesPack pack;
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(35);
        }
        return (pack = this.packForFile(virtualFile)) != null ? pack.getTablesCountSynchronized() : 0;
    }

    @Nullable
    private FileSymbolTablesPack packForFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(36);
        }
        return (FileSymbolTablesPack)this.myCache.get(virtualFile);
    }

    @NotNull
    private FileSymbolTablesPack mutablePackForFile(@NotNull VirtualFile virtualFile, @Nullable SerializationSession serializationSession) {
        FileSymbolTablesPack pack;
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(37);
        }
        if ((pack = (FileSymbolTablesPack)this.myCache.get(virtualFile)) != null) {
            FileSymbolTablesPack fileSymbolTablesPack = pack;
            if (fileSymbolTablesPack == null) {
                FileSymbolTablesCache.$$$reportNull$$$0(38);
            }
            return fileSymbolTablesPack;
        }
        FileSymbolTablesPack deserializedPack = this.deserializePackForFile(virtualFile, serializationSession);
        FileSymbolTablesPack newPack = deserializedPack != null ? deserializedPack : new FileSymbolTablesPack();
        return this.addDeserializedPack(virtualFile, newPack);
    }

    @NotNull
    private FileSymbolTablesPack addDeserializedPack(@NotNull VirtualFile virtualFile, @NotNull FileSymbolTablesPack newPack) {
        FileSymbolTablesPack prev;
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(39);
        }
        if (newPack == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(40);
        }
        if ((prev = this.myCache.putIfAbsent(virtualFile, newPack)) == null) {
            if (newPack.getTablesCountSynchronized() > 0) {
                newPack.onThaw(this.myProject);
                this.notifyNewTables(virtualFile);
            }
            FileSymbolTablesPack fileSymbolTablesPack = newPack;
            if (fileSymbolTablesPack == null) {
                FileSymbolTablesCache.$$$reportNull$$$0(41);
            }
            return fileSymbolTablesPack;
        }
        FileSymbolTablesPack fileSymbolTablesPack = prev;
        if (fileSymbolTablesPack == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(42);
        }
        return fileSymbolTablesPack;
    }

    @Nullable
    private FileSymbolTablesPack deserializePackForFile(@NotNull VirtualFile virtualFile, @Nullable SerializationSession serializationSession) {
        if (virtualFile == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(43);
        }
        if (serializationSession != null && FileSymbolTablesCache.isDeserializationEnabled() && virtualFile instanceof VirtualFileWithId) {
            return SerializationService.getService().deserializeTables(this.myProject, serializationSession, virtualFile);
        }
        return null;
    }

    public void clearAllTables() {
        ArrayList packs = new ArrayList(this.myCache.values());
        this.myCache.clear();
        for (FileSymbolTablesPack pack : packs) {
            pack.onRemove(this.myProject);
        }
        ((OCFileSymbolTableListener)this.myProject.getMessageBus().syncPublisher(OCFileSymbolTableListener.TOPIC)).onAllSymbolTablesDropped();
    }

    private boolean clearCache(@NotNull VirtualFile file) {
        FileSymbolTablesPack pack;
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(44);
        }
        if ((pack = (FileSymbolTablesPack)this.myCache.remove(file)) != null) {
            pack.onRemove(this.myProject);
            ((OCFileSymbolTableListener)this.myProject.getMessageBus().syncPublisher(OCFileSymbolTableListener.TOPIC)).onFileHasInvalidSymbolTableInPack(file);
        }
        return pack != null;
    }

    private int fillCache(Map<VirtualFile, FileSymbolTablesPack> packs) {
        for (FileSymbolTablesPack pack : packs.values()) {
            pack.onThaw(this.myProject);
        }
        this.myCache.putAll(packs);
        return packs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serializeTables(@NotNull String projectLocationHash, @NotNull Collection<VirtualFile> files, @NotNull ProgressIndicator indicator) {
        if (projectLocationHash == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(45);
        }
        if (files == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(46);
        }
        if (indicator == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(47);
        }
        Object object = this.mySerializationLock;
        synchronized (object) {
            if (!FileSymbolTablesCache.isSerializationEnabled()) {
                return;
            }
            HashMap<VirtualFile, FileSymbolTablesPack> tables = new HashMap<VirtualFile, FileSymbolTablesPack>();
            for (VirtualFile file : files) {
                FileSymbolTablesPack pack = this.packForFile(file);
                if (pack == null) continue;
                tables.put(file, pack);
            }
            this.mySerializationService.serializeTables(this.myProject, projectLocationHash, tables, indicator);
        }
    }

    public static boolean areSymbolsLoaded(@NotNull Project project) {
        if (project == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(48);
        }
        if (ourForceSymbolsLoadedInTests != null) {
            return ourForceSymbolsLoadedInTests;
        }
        FileSymbolTablesCache instance = (FileSymbolTablesCache)project.getComponent(FileSymbolTablesCache.class);
        return instance == null || !FileSymbolTablesCache.shouldBuildTables() || instance.mySymbolsLoaded.get();
    }

    public boolean areSymbolsLoaded() {
        if (ourForceSymbolsLoadedInTests != null) {
            return ourForceSymbolsLoadedInTests;
        }
        return !FileSymbolTablesCache.shouldBuildTables() || this.mySymbolsLoaded.get();
    }

    public boolean isUpToDate() {
        return this.isUpToDate(false);
    }

    public boolean isUpToDate(boolean rootsOnly) {
        return FileSymbolTablesCache.areSymbolsLoaded(this.myProject) && this.myTableUpdater.isUpToDate(rootsOnly);
    }

    public static int getIndexingThreadCount() {
        return FileSymbolTablesCache.getIndexingThreadCount(Registry.intValue((String)"cidr.indexer.thread.count"));
    }

    static int getIndexingThreadCount(int userValue) {
        int cpuCount = Runtime.getRuntime().availableProcessors();
        if (userValue <= 0) {
            userValue = cpuCount + userValue;
        }
        return MathUtil.clamp((int)userValue, (int)1, (int)cpuCount);
    }

    @TestOnly
    public static void forceSymbolsLoadedInTests(@Nullable Boolean force) {
        ourForceSymbolsLoadedInTests = force;
    }

    @TestOnly
    public static Boolean getForceSymbolsLoadedInTests() {
        return ourForceSymbolsLoadedInTests;
    }

    void notifySymbolsLoaded() {
        this.mySymbolsLoaded.getAndSet(true);
    }

    void notifySymbolsUnloaded() {
        this.mySymbolsLoaded.getAndSet(false);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(49);
        }
        return project;
    }

    public void removeJunkTables(boolean includingUnused) {
        for (FileSymbolTablesPack pack : this.myCache.values()) {
            pack.removeJunkTables(this.myProject, includingUnused);
        }
    }

    @NotNull
    public Collection<VirtualFile> getFilesWithChangedTables() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Map.Entry entry : this.myCache.entrySet()) {
            if (!((FileSymbolTablesPack)entry.getValue()).isChanged()) continue;
            result.add((VirtualFile)entry.getKey());
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(50);
        }
        return arrayList;
    }

    @NotNull
    public Collection<VirtualFile> getFilesWithNonFallbackTables(boolean withUsedTablesOnly) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        for (Map.Entry entry : this.myCache.entrySet()) {
            FileSymbolTablesPack pack = (FileSymbolTablesPack)entry.getValue();
            if (pack.isFallback() || withUsedTablesOnly && !pack.hasUsedTables()) continue;
            result.add((VirtualFile)entry.getKey());
        }
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(51);
        }
        return arrayList;
    }

    public long deserializeTables(@NotNull String projectLocationHash, @NotNull Collection<VirtualFile> filesToLoad, @NotNull ProgressIndicator indicator, double indicatorScale) {
        if (projectLocationHash == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(52);
        }
        if (filesToLoad == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(53);
        }
        if (indicator == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(54);
        }
        if (!FileSymbolTablesCache.isDeserializationEnabled()) {
            return 0L;
        }
        Map<VirtualFile, FileSymbolTablesPack> packs = this.mySerializationService.deserializeTables(this.myProject, projectLocationHash, filesToLoad, indicator, indicatorScale);
        return this.fillCache(packs);
    }

    public void deserializeTables(@NotNull SerializationSession session, @NotNull VirtualFile file) {
        if (session == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(55);
        }
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(56);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myCache.get(file) != null) {
            return;
        }
        FileSymbolTablesPack pack = this.deserializePackForFile(file, session);
        if (pack != null) {
            this.addDeserializedPack(file, pack);
        }
    }

    public void handleOutOfCodeBlockChange(@NotNull PsiFile file, boolean hasMacro) {
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(57);
        }
        VirtualFile virtualFile = OCInclusionContextUtil.getVirtualFile(file);
        if (SymbolTableProvider.isSourceFile(file.getProject(), virtualFile)) {
            if (this.invalidate(virtualFile, false, (Set<VirtualFile>)new SmartHashSet(), hasMacro)) {
                OCInclusionContextUtil.invalidateHeaderContextsExcept(virtualFile, file.getProject());
                this.incModificationCount();
            }
            this.schedulePSIUpdates();
        }
        if (hasMacro) {
            OCImportGraph.getInstance(this.myProject).invalidateHeaderRootsCache();
            OCInclusionContextUtil.invalidateHeaderRootAndActiveConfigurationForAllExcept(virtualFile, file.getProject());
        }
    }

    public void incModificationCount() {
        this.myOutOfBlockModificationTracker.incModificationCount();
    }

    public void dumpStats(@Nullable PrintWriter out) {
        if (out == null) {
            out = new PrintWriter(System.out);
        }
        ArrayList list = new ArrayList(this.myCache.entrySet());
        Collections.sort(list, (o1, o2) -> {
            int c = Comparing.compare((int)((FileSymbolTablesPack)o1.getValue()).getTablesCountSynchronized(), (int)((FileSymbolTablesPack)o2.getValue()).getTablesCountSynchronized());
            if (c != 0) {
                return c;
            }
            List<FileSymbolTable> ts1 = ((FileSymbolTablesPack)o1.getValue()).tablesView();
            List<FileSymbolTable> ts2 = ((FileSymbolTablesPack)o2.getValue()).tablesView();
            if (ts1.size() > 0 && ts2.size() > 0) {
                VirtualFile f1 = ts1.get(0).getContainingFile();
                VirtualFile f2 = ts2.get(0).getContainingFile();
                int fc = Comparing.compare((Comparable)((Object)f1.getName()), (Comparable)((Object)f2.getName()));
                if (fc != 0) {
                    return fc;
                }
                return Comparing.compare((Comparable)((Object)f1.getPath()), (Comparable)((Object)f2.getPath()));
            }
            return Comparing.compare((int)ts1.size(), (int)ts2.size());
        });
        int totalFiles = 0;
        int multiTableFiles = 0;
        int totalSymbols = 0;
        int totalUniqueSymbols = 0;
        int totalContents = 0;
        int totalTables = 0;
        int totalUniqueContents = 0;
        int totalUniqueContentsLen = 0;
        for (Map.Entry entry : list) {
            ++totalFiles;
            VirtualFile file = (VirtualFile)entry.getKey();
            FileSymbolTablesPack pack = (FileSymbolTablesPack)entry.getValue();
            List tables = pack.getTablesSynchronized();
            if (tables.size() > 1) {
                ++multiTableFiles;
                Function tablePrinter = table -> Integer.toString(table.getUsageCount());
                int symbolCount = 0;
                int contentsCount = 0;
                ReferenceOpenHashSet uniqueSymbols = new ReferenceOpenHashSet();
                HashSet<List<OCSymbol>> uniqueContents = new HashSet<List<OCSymbol>>();
                int uniqueContentsLength = 0;
                for (FileSymbolTable table2 : tables) {
                    List<OCSymbol> contents = table2.getContents();
                    symbolCount += contents.size();
                    uniqueSymbols.addAll(contents);
                    ++contentsCount;
                    if (!uniqueContents.add(contents)) continue;
                    uniqueContentsLength += contents.size();
                }
                totalSymbols += symbolCount;
                totalUniqueSymbols += uniqueSymbols.size();
                totalTables += contentsCount;
                totalContents += contentsCount;
                totalUniqueContents += uniqueContents.size();
                totalUniqueContentsLen += uniqueContentsLength;
                double reuseFactor = (double)uniqueSymbols.size() / (double)symbolCount;
                if (reuseFactor == 0.5) {
                    int br_1371 = 0;
                    ++br_1371;
                }
                if (reuseFactor < 0.005) {
                    int br_1379 = 0;
                    ++br_1379;
                }
                String num = String.format("%5d", totalFiles + 1);
                Object contentsReuseInfo = "";
                if (uniqueContents.size() != contentsCount) {
                    contentsReuseInfo = ", " + uniqueContents.size() + "/" + contentsCount + " <" + uniqueContentsLength + "/" + symbolCount + ">";
                }
                String tableBaseInfo = file.getName() + " (" + tables.size() + ") -> : [" + String.format("%.4f", reuseFactor) + (String)contentsReuseInfo + "] ";
                out.println(num + " -- " + tableBaseInfo + StringUtil.join(tables, (Function)tablePrinter, (String)", "));
                tables = ContainerUtil.sorted(tables, (o1, o2) -> Comparing.compare((int)o2.getUsageCount(), (int)o1.getUsageCount()));
                out.println(num + "    " + tableBaseInfo + StringUtil.join((Collection)tables, (Function)tablePrinter, (String)", "));
                continue;
            }
            ++totalTables;
        }
        out.println("============================");
        out.println("multitable files: " + multiTableFiles + " / " + totalFiles + " (" + (double)multiTableFiles / (double)totalFiles + ")");
        out.println("reusedSym/totalSym = " + totalUniqueSymbols + "/" + totalSymbols);
        out.println("uniqueMultiTables/totalMultiTables = " + totalUniqueContents + "/" + totalContents);
        out.println("uniqueTablesSize/totalTablesSize = " + totalUniqueContentsLen + "/" + totalSymbols);
        out.println("uniqueTables/totalTables = " + (totalUniqueContents + totalFiles - multiTableFiles) + "/" + totalTables);
    }

    public void dumpTablePackStats(@NotNull VirtualFile file, @Nullable PrintWriter out) {
        if (file == null) {
            FileSymbolTablesCache.$$$reportNull$$$0(58);
        }
        if (out == null) {
            out = new PrintWriter(System.out);
        }
        out.println(file.getPath());
        List<FileSymbolTable> tables = this.allTablesForFile(file);
        out.println("Total: " + tables.size());
        int i2 = 0;
        for (FileSymbolTable table : tables) {
            out.println("=> " + i2 + " -> " + table.getContents().size() + " (valid: " + table.isValid() + ", fallback: " + table.isFallback() + ")");
            table.getSignature().dumpStats(out);
            ++i2;
        }
    }

    static {
        ourSymbolsProperties = DEFAULT_SYMBOLS_PROPERTIES = ApplicationManager.getApplication().isUnitTestMode() ? SymbolsProperties.NO_SYMBOLS : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: 
            case 22: 
            case 23: 
            case 24: 
            case 32: 
            case 34: 
            case 38: 
            case 41: 
            case 42: 
            case 49: 
            case 50: 
            case 51: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: 
            case 22: 
            case 23: 
            case 24: 
            case 32: 
            case 34: 
            case 38: 
            case 41: 
            case 42: 
            case 49: 
            case 50: 
            case 51: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: 
            case 22: 
            case 23: 
            case 24: 
            case 32: 
            case 34: 
            case 38: 
            case 41: 
            case 42: 
            case 49: 
            case 50: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyNames";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyFiles";
                break;
            }
            case 8: 
            case 9: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: 
            case 26: 
            case 29: 
            case 31: 
            case 44: 
            case 56: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 25: 
            case 30: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pack";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outTimeStamp";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirty";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPack";
                break;
            }
            case 45: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLocationHash";
                break;
            }
            case 47: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToLoad";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutOfBlockModificationTracker";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToBuildTablesFor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFilesFromCache";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTableForFile";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "allTablesForFile";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "mutablePackForFile";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "addDeserializedPack";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithChangedTables";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesWithNonFallbackTables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: 
            case 22: 
            case 23: 
            case 24: 
            case 32: 
            case 34: 
            case 38: 
            case 41: 
            case 42: 
            case 49: 
            case 50: 
            case 51: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invalidateDirtyIncludes";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invalidateDirtyIncludeFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addFilesToCache";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeFilesFromCache";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calcTableUsingPSI";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "forFile";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "buildTableForFile";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "notifyNewTables";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findForFile";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processDirtyFile";
                break;
            }
            case 31: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "allTablesForFile";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "allTablesForFileCount";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "packForFile";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "mutablePackForFile";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addDeserializedPack";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "deserializePackForFile";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "clearCache";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "serializeTables";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "areSymbolsLoaded";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "deserializeTables";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "handleOutOfCodeBlockChange";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "dumpTablePackStats";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 10: 
            case 22: 
            case 23: 
            case 24: 
            case 32: 
            case 34: 
            case 38: 
            case 41: 
            case 42: 
            case 49: 
            case 50: 
            case 51: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Delta {
        final int start;
        final int shift;

        private Delta(int start, int shift) {
            this.start = start;
            this.shift = shift;
        }
    }

    class PeriodicSerializationTask
    implements Runnable {
        public static final int IDLE_PERIOD = 20000;
        public static final int POLL_PERIOD = 10000;
        private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

        PeriodicSerializationTask() {
        }

        @Override
        public void run() {
            if (this.shouldStop()) {
                return;
            }
            if (!this.shouldSerialize()) {
                this.schedule(10000);
                return;
            }
            String projectHash = FileSymbolTablesCache.this.myProject.getLocationHash();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    this.serializeInBackground(projectHash);
                }
                finally {
                    this.schedule(10000);
                }
            });
        }

        private void serializeInBackground(@NotNull String projectHash) {
            if (projectHash == null) {
                PeriodicSerializationTask.$$$reportNull$$$0(0);
            }
            ProgressIndicatorBase indicator = new ProgressIndicatorBase();
            indicator.setIndeterminate(false);
            ProgressIndicatorUtils.runInReadActionWithWriteActionPriority(() -> {
                if (this.shouldStop() || !this.shouldSerialize()) {
                    return;
                }
                ArrayList<VirtualFile> fs = new ArrayList<VirtualFile>();
                for (VirtualFile file : FileSymbolTablesCache.this.myCache.keySet()) {
                    ProgressManager.checkCanceled();
                    FileSymbolTablesPack pack = (FileSymbolTablesPack)FileSymbolTablesCache.this.myCache.get(file);
                    if (pack == null || !pack.shouldSerialize()) continue;
                    fs.add(file);
                }
                if (!fs.isEmpty()) {
                    FileSymbolTablesCache.this.serializeTables(projectHash, fs, (ProgressIndicator)indicator);
                }
            }, (ProgressIndicator)indicator);
        }

        private boolean shouldStop() {
            return !FileSymbolTablesCache.this.myProject.isOpen() || FileSymbolTablesCache.this.myProject.isDisposed();
        }

        private boolean shouldSerialize() {
            return FileSymbolTablesCache.isSerializationEnabled() && !PowerSaveMode.isEnabled() && !DumbService.isDumb((Project)FileSymbolTablesCache.this.myProject) && ApplicationManager.getApplication().getIdleTime() >= 20000L && FileSymbolTablesCache.this.isUpToDate();
        }

        public void schedule(int delayMillis) {
            this.cancelAll();
            this.myAlarm.addRequest((Runnable)this, delayMillis);
        }

        public void cancelAll() {
            this.myAlarm.cancelAllRequests();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectHash", "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$PeriodicSerializationTask", "serializeInBackground"));
        }
    }

    public static final class SymbolsProperties {
        public static final SymbolsProperties NO_SYMBOLS = new SymbolsProperties(SymbolsKind.NO_SYMBOLS, false, false);
        @NotNull
        private final SymbolsKind buildSymbolsKind;
        private final boolean deserializeSymbolTables;
        private final boolean serializeSymbolTables;

        public SymbolsProperties(@NotNull SymbolsKind buildSymbolKind, boolean deserializeSymbolTables, boolean serializeSymbolTables) {
            if (buildSymbolKind == null) {
                SymbolsProperties.$$$reportNull$$$0(0);
            }
            this.buildSymbolsKind = buildSymbolKind;
            this.deserializeSymbolTables = deserializeSymbolTables;
            this.serializeSymbolTables = serializeSymbolTables;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildSymbolKind", "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$SymbolsProperties", "<init>"));
        }

        public static enum SymbolsKind {
            NO_SYMBOLS,
            ONLY_USED,
            ALL_INCLUDING_UNUSED_SYSTEM_HEADERS;

        }
    }

    private static class OCCodeBlockModificationListener
    implements PsiTreeChangePreprocessor {
        private final Project myProject;
        private final Key<String> FILE_PREPROCESSOR_STAMP;

        private OCCodeBlockModificationListener(@NotNull Project project) {
            if (project == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(0);
            }
            this.FILE_PREPROCESSOR_STAMP = Key.create((String)"FILE_PREPROCESSOR_STAMP");
            this.myProject = project;
        }

        public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
            String stamp;
            PsiFile file;
            if (event == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(1);
            }
            if ((file = this.getFile(event)) == null) {
                return;
            }
            SymbolTableProvider provider2 = SymbolTableProvider.findProvider(file);
            if (provider2 == null) {
                return;
            }
            if (!(event.getParent() instanceof PsiDirectory) && !provider2.shouldProcessPsiEvents(file)) {
                return;
            }
            boolean shouldCheckDocCreation = ApplicationManager.getApplication().isInternal();
            Document docToCheck = shouldCheckDocCreation ? PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(file) : null;
            Delta delta = this.processChange(event, file);
            if (delta != null && delta.shift != 0) {
                this.validate(file, delta.start, delta.shift);
            }
            if (event.isGenericChange() && (stamp = (String)file.getUserData(this.FILE_PREPROCESSOR_STAMP)) != null) {
                if (!stamp.equals(this.macroStamp(file))) {
                    this.getFileSymbolTablesCache().handleOutOfCodeBlockChange(file, true);
                }
                file.putUserData(this.FILE_PREPROCESSOR_STAMP, null);
            }
            if (shouldCheckDocCreation && docToCheck == null && PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(file) != null) {
                LOG.error("documents must not be created during event processing: " + event);
            }
        }

        @NotNull
        private FileSymbolTablesCache getFileSymbolTablesCache() {
            FileSymbolTablesCache fileSymbolTablesCache = FileSymbolTablesCache.getInstance(this.myProject);
            if (fileSymbolTablesCache == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(2);
            }
            return fileSymbolTablesCache;
        }

        @Nullable
        private Delta processChange(@NotNull PsiTreeChangeEventImpl event, PsiFile file) {
            if (event == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(3);
            }
            switch (event.getCode()) {
                case BEFORE_CHILDREN_CHANGE: 
                case BEFORE_CHILD_REPLACEMENT: 
                case BEFORE_CHILD_ADDITION: 
                case BEFORE_CHILD_REMOVAL: {
                    this.processBeforeChange(event, file);
                    return null;
                }
                case BEFORE_CHILD_MOVEMENT: {
                    return null;
                }
                case CHILD_ADDED: 
                case CHILD_REMOVED: 
                case CHILD_REPLACED: 
                case CHILDREN_CHANGED: {
                    return this.processChildChange(event, file);
                }
                case CHILD_MOVED: 
                case BEFORE_PROPERTY_CHANGE: 
                case PROPERTY_CHANGED: {
                    this.getFileSymbolTablesCache().incModificationCount();
                    return null;
                }
            }
            LOG.error("Unknown code:" + event.getCode());
            return null;
        }

        @Nullable
        private PsiFile getFile(@NotNull PsiTreeChangeEventImpl event) {
            PsiFile childFile;
            PsiFile file;
            if (event == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(4);
            }
            if ((file = event.getFile()) != null) {
                return file;
            }
            PsiElement child = event.getChild();
            PsiFile psiFile = childFile = child != null ? child.getContainingFile() : null;
            if (childFile != null) {
                return childFile;
            }
            PsiElement parent = event.getParent();
            return parent != null ? parent.getContainingFile() : null;
        }

        @Nullable
        private Delta processChildChange(@NotNull PsiTreeChangeEventImpl event, @NotNull PsiFile file) {
            if (event == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(5);
            }
            if (file == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(6);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (event.isGenericChange()) {
                return null;
            }
            if (this.isOutOfCodeBlockChange(event, file)) {
                this.getFileSymbolTablesCache().handleOutOfCodeBlockChange(file, false);
                return null;
            }
            PsiElement child = event.getChild();
            PsiElement parent = event.getParent();
            int offset = event.getOffset();
            switch (event.getCode()) {
                case CHILD_ADDED: {
                    assert (child != null);
                    if (this.checkInvalid((PsiTreeChangeEvent)event, child)) {
                        return null;
                    }
                    return new Delta(offset, child.getTextLength());
                }
                case CHILD_REMOVED: {
                    return new Delta(offset, -event.getOldLength());
                }
                case CHILD_REPLACED: {
                    assert (child != null);
                    if (this.checkInvalid((PsiTreeChangeEvent)event, child)) {
                        return null;
                    }
                    return new Delta(offset, child.getTextLength() - event.getOldLength());
                }
                case CHILDREN_CHANGED: {
                    assert (parent != null);
                    return new Delta(offset, parent.getTextLength() - event.getOldLength());
                }
            }
            OCLog.LOG.error("unexpected event code: " + event.getCode());
            return null;
        }

        private boolean checkInvalid(@NotNull PsiTreeChangeEvent event, @NotNull PsiElement psi) {
            if (event == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(7);
            }
            if (psi == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(8);
            }
            if (!psi.isValid()) {
                LOG.warn("Invalid PSI in OCCodeBlockModificationListener.treeChanged: " + psi + ", event: " + event);
                return true;
            }
            return false;
        }

        private void processBeforeChange(@NotNull PsiTreeChangeEventImpl event, PsiFile file) {
            if (event == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(9);
            }
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (event.getCode() == PsiTreeChangeEventImpl.PsiEventType.BEFORE_CHILDREN_CHANGE && event.getParent() instanceof PsiFile) {
                return;
            }
            boolean isFile = event.getChild() instanceof PsiFile;
            if (!isFile && !(file instanceof OCCodeFragment) && file.getUserData(this.FILE_PREPROCESSOR_STAMP) == null) {
                file.putUserData(this.FILE_PREPROCESSOR_STAMP, (Object)this.macroStamp(file));
            }
        }

        private boolean isOutOfCodeBlockChange(@NotNull PsiTreeChangeEventImpl event, @Nullable PsiFile file) {
            if (event == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(10);
            }
            if (file instanceof OCCodeFragment) {
                return false;
            }
            PsiElement element = event.getParent();
            if (element instanceof PsiFileSystemItem) {
                return true;
            }
            if (element == null || element.getParent() == null) {
                return false;
            }
            return SymbolTableProvider.getProvider(element.getContainingFile()).isOutOfCodeBlockChange(event);
        }

        @NotNull
        private String macroStamp(PsiFile file) {
            if (!(file instanceof OCFile)) {
                return "";
            }
            StringBuilder acc = new StringBuilder();
            this.processASTNodeForMacros((ASTNode)file.getNode(), acc);
            String string = acc.toString();
            if (string == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(11);
            }
            return string;
        }

        private void processASTNodeForMacros(@Nullable ASTNode node, @NotNull StringBuilder acc) {
            if (acc == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(12);
            }
            if (node == null) {
                return;
            }
            IElementType elementType = node.getElementType();
            if (elementType instanceof OCLazyBlockStatementElementType) {
                return;
            }
            if (OCElementTypes.IMPORTANT_DIRECTIVES.contains(elementType)) {
                acc.append(node.getText());
            }
            for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                this.processASTNodeForMacros(child, acc);
            }
        }

        private void validate(@NotNull PsiFile file, int start, int lengthShift) {
            FileSymbolTablesPack pack;
            if (file == null) {
                OCCodeBlockModificationListener.$$$reportNull$$$0(13);
            }
            if ((pack = this.getFileSymbolTablesCache().packForFile(OCInclusionContextUtil.getVirtualFile(file))) != null) {
                pack.updateOffsetsSynchronized(start, lengthShift);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 11: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 11: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$OCCodeBlockModificationListener";
                    break;
                }
                case 6: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psi";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "acc";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$OCCodeBlockModificationListener";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileSymbolTablesCache";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "macroStamp";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "treeChanged";
                    break;
                }
                case 2: 
                case 11: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processChange";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getFile";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processChildChange";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "checkInvalid";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "processBeforeChange";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "isOutOfCodeBlockChange";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "processASTNodeForMacros";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "validate";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 11: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class ClearTablesAndCollectNamesVisitor
    extends VirtualFileVisitor<Object> {
        @NotNull
        final Set<String> dirtyNames;
        boolean cacheCleared;

        private ClearTablesAndCollectNamesVisitor() {
            super(new VirtualFileVisitor.Option[0]);
            this.dirtyNames = CollectionFactory.createFilePathSet();
            this.cacheCleared = false;
        }

        @Nullable
        public Collection<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
            if (file == null) {
                ClearTablesAndCollectNamesVisitor.$$$reportNull$$$0(0);
            }
            return file.isDirectory() ? ((NewVirtualFile)file).getCachedChildren() : null;
        }

        public boolean visitFile(@NotNull VirtualFile file) {
            if (file == null) {
                ClearTablesAndCollectNamesVisitor.$$$reportNull$$$0(1);
            }
            if (file.isDirectory()) {
                return true;
            }
            if (FileSymbolTablesCache.this.clearCache(file)) {
                this.cacheCleared = true;
                FileSymbolTablesCache.this.addFileToCache(file);
            }
            this.dirtyNames.add(file.getName());
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "file";
            objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$ClearTablesAndCollectNamesVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getChildrenIterable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class TestSymbolReBuilder
    implements Runnable,
    DumbAware {
        @NotNull
        private final Project myProject;

        private TestSymbolReBuilder(@NotNull Project project) {
            if (project == null) {
                TestSymbolReBuilder.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public void run() {
            DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> OCSymbolTablesBuildingActivity.getInstance(this.myProject).rebuildSymbols());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/symbols/symtable/FileSymbolTablesCache$TestSymbolReBuilder", "<init>"));
        }
    }
}

