/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBBundle;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GDBTuple
extends ArrayList<Object> {
    private static final List<String> TRUE_STRINGS = Arrays.asList("true", "yes", "on");
    private static final List<String> FALSE_STRINGS = Arrays.asList("false", "no", "off");

    @NotNull
    public static GDBTuple of(Object ... elements) {
        if (elements == null) {
            GDBTuple.$$$reportNull$$$0(0);
        }
        GDBTuple tuple = new GDBTuple();
        tuple.addAll(Arrays.asList(elements));
        GDBTuple gDBTuple = tuple;
        if (gDBTuple == null) {
            GDBTuple.$$$reportNull$$$0(1);
        }
        return gDBTuple;
    }

    @Contract(value="_, _, !null -> !null")
    @Nullable
    protected <T> T get(@NonNls @NotNull String key, @NotNull Class<T> clazz, @Nullable T defaultValue) {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(2);
        }
        if (clazz == null) {
            GDBTuple.$$$reportNull$$$0(3);
        }
        for (Object each : this) {
            T o = GDBTuple.getIfEquals(each, key);
            if (!clazz.isInstance(o)) continue;
            return clazz.cast(o);
        }
        return defaultValue;
    }

    @NonNls
    @Nullable
    public String getString(@NonNls @NotNull String key) {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(4);
        }
        return this.getString(key, null);
    }

    @Contract(value="_, !null -> !null")
    @NonNls
    @Nullable
    public String getString(@NonNls @NotNull String key, @NonNls @Nullable String defaultValue) {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(5);
        }
        return this.get(key, String.class, defaultValue);
    }

    @NonNls
    @NotNull
    public <X extends Throwable> String getRequiredStringOrThrow(@NonNls @NotNull String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(6);
        }
        if (exceptionConstructor == null) {
            GDBTuple.$$$reportNull$$$0(7);
        }
        String string = this.getRequiredStringOrThrow(key, GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
        if (string == null) {
            GDBTuple.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NonNls
    @NotNull
    public <X extends Throwable> String getRequiredStringOrThrow(@NonNls @NotNull String key, @NotNull Supplier<? extends X> exceptionSupplier) throws X {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(9);
        }
        if (exceptionSupplier == null) {
            GDBTuple.$$$reportNull$$$0(10);
        }
        return GDBTuple.checkNotNullOrThrow(this.getString(key), exceptionSupplier);
    }

    @NonNls
    @NotNull
    public String getRequiredString(@NonNls @NotNull String key) throws ExecutionException {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(11);
        }
        String string = this.getRequiredStringOrThrow(key, ExecutionException::new);
        if (string == null) {
            GDBTuple.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public GDBTuple getTuple(@NonNls @NotNull String key) {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(13);
        }
        return this.get(key, GDBTuple.class, null);
    }

    @NotNull
    public GDBTuple getTupleOrEmpty(@NonNls @NotNull String key) {
        GDBTuple value;
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(14);
        }
        if ((value = this.getTuple(key)) == null) {
            value = new GDBTuple();
        }
        GDBTuple gDBTuple = value;
        if (gDBTuple == null) {
            GDBTuple.$$$reportNull$$$0(15);
        }
        return gDBTuple;
    }

    @NotNull
    public GDBTuple getRequiredTuple(@NonNls @NotNull String key) throws ExecutionException {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(16);
        }
        GDBTuple gDBTuple = this.getRequiredTupleOrThrow(key, ExecutionException::new);
        if (gDBTuple == null) {
            GDBTuple.$$$reportNull$$$0(17);
        }
        return gDBTuple;
    }

    @NotNull
    public <X extends Throwable> GDBTuple getRequiredTupleOrThrow(@NonNls @NotNull String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(18);
        }
        if (exceptionConstructor == null) {
            GDBTuple.$$$reportNull$$$0(19);
        }
        GDBTuple gDBTuple = this.getRequiredTupleOrThrow(key, GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
        if (gDBTuple == null) {
            GDBTuple.$$$reportNull$$$0(20);
        }
        return gDBTuple;
    }

    @NotNull
    public <X extends Throwable> GDBTuple getRequiredTupleOrThrow(@NonNls @NotNull String key, @NotNull Supplier<? extends X> exceptionSupplier) throws X {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(21);
        }
        if (exceptionSupplier == null) {
            GDBTuple.$$$reportNull$$$0(22);
        }
        return GDBTuple.checkNotNullOrThrow(this.getTuple(key), exceptionSupplier);
    }

    @Nullable
    public Address getAddress(@NonNls @NotNull String key) {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(23);
        }
        return this.getAddress(key, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public Address getAddress(@NonNls @NotNull String key, @Nullable Address defaultValue) {
        String s;
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(24);
        }
        if ((s = this.getString(key)) != null) {
            return GDBTuple.parseAddress(s, defaultValue);
        }
        return defaultValue;
    }

    @NotNull
    public Address getRequiredAddress(@NonNls @NotNull String key) throws ExecutionException {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(25);
        }
        Address address = this.getRequiredAddressOrThrow(key, ExecutionException::new);
        if (address == null) {
            GDBTuple.$$$reportNull$$$0(26);
        }
        return address;
    }

    @NotNull
    public <X extends Throwable> Address getRequiredAddressOrThrow(@NonNls @NotNull String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(27);
        }
        if (exceptionConstructor == null) {
            GDBTuple.$$$reportNull$$$0(28);
        }
        String s = GDBTuple.checkNotNullOrThrow(this.getString(key), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
        return GDBTuple.checkNotNullOrThrow(GDBTuple.parseAddress(s, null), GDBTuple.withMessage(exceptionConstructor, GDBBundle.messagePointer("error.malformed.value", s, key, this)));
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    private static Address parseAddress(@NonNls @NotNull String s, @Nullable Address defaultValue) {
        if (s == null) {
            GDBTuple.$$$reportNull$$$0(29);
        }
        try {
            return Address.parseHexString(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public Integer getInteger(@NonNls @NotNull String key, @Nullable Integer defaultValue) {
        String s;
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(30);
        }
        if ((s = this.getString(key)) != null) {
            return GDBTuple.parseInteger(s, defaultValue);
        }
        return defaultValue;
    }

    public int getInt(@NonNls @NotNull String key, int defaultValue) {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(31);
        }
        return this.getInteger(key, defaultValue);
    }

    public int getRequiredInt(@NonNls @NotNull String key) throws ExecutionException {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(32);
        }
        return this.getRequiredIntOrThrow(key, ExecutionException::new);
    }

    public <X extends Throwable> int getRequiredIntOrThrow(@NonNls @NotNull String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(33);
        }
        if (exceptionConstructor == null) {
            GDBTuple.$$$reportNull$$$0(34);
        }
        String s = GDBTuple.checkNotNullOrThrow(this.getString(key), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
        return GDBTuple.checkNotNullOrThrow(GDBTuple.parseInteger(s, null), GDBTuple.withMessage(exceptionConstructor, GDBBundle.messagePointer("error.malformed.value", s, key, this)));
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    private static Integer parseInteger(@NonNls @NotNull String s, @Nullable Integer defaultValue) {
        if (s == null) {
            GDBTuple.$$$reportNull$$$0(35);
        }
        try {
            return Integer.decode(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(@NonNls @NotNull String key) {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(36);
        }
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(@NonNls @NotNull String key, boolean defaultValue) {
        String s;
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(37);
        }
        if ((s = this.getString(key)) != null) {
            String lowerCase = StringUtil.toLowerCase((String)s);
            if (TRUE_STRINGS.contains(lowerCase)) {
                return true;
            }
            if (FALSE_STRINGS.contains(lowerCase)) {
                return false;
            }
            Integer integer = GDBTuple.parseInteger(s, null);
            if (integer != null) {
                return integer != 0;
            }
        }
        return defaultValue;
    }

    @Nullable
    public Location getLocation(@NonNls @NotNull String key) {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(38);
        }
        return this.getLocation(key, (Location)null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public Location getLocation(@NonNls @NotNull String key, @Nullable Location defaultValue) {
        String s;
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(39);
        }
        if ((s = this.getString(key)) != null) {
            return Location.tryParse(s, defaultValue);
        }
        return defaultValue;
    }

    @NotNull
    public Location getRequiredLocation(@NonNls @NotNull String key) throws ExecutionException {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(40);
        }
        Location location = this.getRequiredLocationOrThrow(key, ExecutionException::new);
        if (location == null) {
            GDBTuple.$$$reportNull$$$0(41);
        }
        return location;
    }

    @NotNull
    public <X extends Throwable> Location getRequiredLocationOrThrow(@NonNls @NotNull String key, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(42);
        }
        if (exceptionConstructor == null) {
            GDBTuple.$$$reportNull$$$0(43);
        }
        String s = GDBTuple.checkNotNullOrThrow(this.getString(key), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(key)));
        return GDBTuple.checkNotNullOrThrow(Location.tryParse(s), GDBTuple.withMessage(exceptionConstructor, GDBBundle.messagePointer("error.malformed.location.string", s, key, this)));
    }

    @Nullable
    public Location getLocation(@NonNls @NotNull String pathKey, @NonNls @NotNull String lineKey) {
        if (pathKey == null) {
            GDBTuple.$$$reportNull$$$0(44);
        }
        if (lineKey == null) {
            GDBTuple.$$$reportNull$$$0(45);
        }
        return this.getLocation(pathKey, lineKey, null);
    }

    @Nullable
    public Address getAddressLocation(@NonNls @NotNull String addressKey) {
        if (addressKey == null) {
            GDBTuple.$$$reportNull$$$0(46);
        }
        return this.getAddressLocation(addressKey, null);
    }

    @Contract(value="_, _, !null -> !null")
    @Nullable
    public Location getLocation(@NonNls @NotNull String pathKey, @NonNls @NotNull String lineKey, @Nullable Location defaultValue) {
        if (pathKey == null) {
            GDBTuple.$$$reportNull$$$0(47);
        }
        if (lineKey == null) {
            GDBTuple.$$$reportNull$$$0(48);
        }
        String path = this.getString(pathKey);
        Integer lineNumber = this.getInteger(lineKey, null);
        if (path != null && lineNumber != null) {
            return Location.fromFileLineNumber(path, lineNumber);
        }
        return defaultValue;
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public Address getAddressLocation(@NonNls @NotNull String addressKey, @Nullable Address defaultValue) {
        Address address;
        if (addressKey == null) {
            GDBTuple.$$$reportNull$$$0(49);
        }
        if ((address = this.getAddress(addressKey, null)) != null) {
            return address;
        }
        return defaultValue;
    }

    @NotNull
    public Location getRequiredLocation(@NonNls @NotNull String pathKey, @NonNls @NotNull String lineKey) throws ExecutionException {
        if (pathKey == null) {
            GDBTuple.$$$reportNull$$$0(50);
        }
        if (lineKey == null) {
            GDBTuple.$$$reportNull$$$0(51);
        }
        Location location = this.getRequiredLocationOrThrow(pathKey, lineKey, ExecutionException::new);
        if (location == null) {
            GDBTuple.$$$reportNull$$$0(52);
        }
        return location;
    }

    @NotNull
    public <X extends Throwable> Location getRequiredLocationOrThrow(@NonNls @NotNull String pathKey, @NonNls @NotNull String lineKey, @NotNull Function<String, ? extends X> exceptionConstructor) throws X {
        if (pathKey == null) {
            GDBTuple.$$$reportNull$$$0(53);
        }
        if (lineKey == null) {
            GDBTuple.$$$reportNull$$$0(54);
        }
        if (exceptionConstructor == null) {
            GDBTuple.$$$reportNull$$$0(55);
        }
        String path = GDBTuple.checkNotNullOrThrow(this.getString(pathKey), GDBTuple.withMessage(exceptionConstructor, this.missingKeyError(pathKey)));
        int lineNumber = this.getRequiredIntOrThrow(lineKey, exceptionConstructor);
        Location location = Location.fromFileLineNumber(path, lineNumber);
        if (location == null) {
            GDBTuple.$$$reportNull$$$0(56);
        }
        return location;
    }

    @NotNull
    public <T> List<T> getAll(@NonNls @NotNull String key, @NotNull Class<T> clazz) {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(57);
        }
        if (clazz == null) {
            GDBTuple.$$$reportNull$$$0(58);
        }
        SmartList result2 = new SmartList();
        for (Object each : this) {
            T o = GDBTuple.getIfEquals(each, key);
            if (o == null) continue;
            result2.add(clazz.cast(o));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            GDBTuple.$$$reportNull$$$0(59);
        }
        return smartList;
    }

    @NotNull
    public <T> Pair<T, List<T>> getWithSuccessors(@NonNls @NotNull String key, @NotNull Class<T> clazz) {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(60);
        }
        if (clazz == null) {
            GDBTuple.$$$reportNull$$$0(61);
        }
        Pair<Object, List<Object>> pair = this.getWithSuccessors(key, clazz, null);
        if (pair == null) {
            GDBTuple.$$$reportNull$$$0(62);
        }
        return pair;
    }

    @NotNull
    public <T> Pair<T, List<T>> getWithSuccessors(@NonNls @NotNull String key, @NotNull Class<T> clazz, @Nullable T defaultValue) {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(63);
        }
        if (clazz == null) {
            GDBTuple.$$$reportNull$$$0(64);
        }
        SmartList successors = new SmartList();
        Object found = null;
        for (Object each : this) {
            if (found == null) {
                found = GDBTuple.getIfEquals(each, key);
                continue;
            }
            if (each instanceof Pair) break;
            successors.add(clazz.cast(each));
        }
        if (found == null) {
            found = defaultValue;
        }
        Pair pair = Pair.create(found, (Object)successors);
        if (pair == null) {
            GDBTuple.$$$reportNull$$$0(65);
        }
        return pair;
    }

    @NotNull
    private Supplier<String> missingKeyError(@NonNls @NotNull String key) {
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(66);
        }
        Supplier<String> supplier = GDBBundle.messagePointer("error.missing.required.key", key, this);
        if (supplier == null) {
            GDBTuple.$$$reportNull$$$0(67);
        }
        return supplier;
    }

    @NotNull
    private static <X extends Throwable> Supplier<X> withMessage(@NotNull Function<String, ? extends X> exceptionConstructor, @NotNull Supplier<String> messageSupplier) {
        if (exceptionConstructor == null) {
            GDBTuple.$$$reportNull$$$0(68);
        }
        if (messageSupplier == null) {
            GDBTuple.$$$reportNull$$$0(69);
        }
        Supplier<Throwable> supplier = () -> (Throwable)exceptionConstructor.apply((String)messageSupplier.get());
        if (supplier == null) {
            GDBTuple.$$$reportNull$$$0(70);
        }
        return supplier;
    }

    @NotNull
    private static <T, X extends Throwable> T checkNotNullOrThrow(@Nullable T value, @NotNull Supplier<? extends X> exceptionSupplier) throws X {
        if (exceptionSupplier == null) {
            GDBTuple.$$$reportNull$$$0(71);
        }
        if (value == null) {
            throw (Throwable)exceptionSupplier.get();
        }
        T t = value;
        if (t == null) {
            GDBTuple.$$$reportNull$$$0(72);
        }
        return t;
    }

    @Nullable
    private static <T> T getIfEquals(@NotNull Object val, @NonNls @NotNull String key) {
        if (val == null) {
            GDBTuple.$$$reportNull$$$0(73);
        }
        if (key == null) {
            GDBTuple.$$$reportNull$$$0(74);
        }
        if (val.equals(key)) {
            return (T)val;
        }
        if (val instanceof Pair && ((Pair)val).first.equals(key)) {
            return (T)((Pair)val).second;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 41: 
            case 52: 
            case 56: 
            case 59: 
            case 62: 
            case 65: 
            case 67: 
            case 70: 
            case 72: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 41: 
            case 52: 
            case 56: 
            case 59: 
            case 62: 
            case 65: 
            case 67: 
            case 70: 
            case 72: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 41: 
            case 52: 
            case 56: 
            case 59: 
            case 62: 
            case 65: 
            case 67: 
            case 70: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBTuple";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 57: 
            case 60: 
            case 63: 
            case 66: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: 
            case 58: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 7: 
            case 19: 
            case 28: 
            case 34: 
            case 43: 
            case 55: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionConstructor";
                break;
            }
            case 10: 
            case 22: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionSupplier";
                break;
            }
            case 29: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 44: 
            case 47: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathKey";
                break;
            }
            case 45: 
            case 48: 
            case 51: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineKey";
                break;
            }
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addressKey";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageSupplier";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "val";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBTuple";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "of";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredStringOrThrow";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredString";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTupleOrEmpty";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredTuple";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredTupleOrThrow";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredAddress";
                break;
            }
            case 41: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLocation";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLocationOrThrow";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getAll";
                break;
            }
            case 62: 
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getWithSuccessors";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "missingKeyError";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "withMessage";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "checkNotNullOrThrow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "of";
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 41: 
            case 52: 
            case 56: 
            case 59: 
            case 62: 
            case 65: 
            case 67: 
            case 70: 
            case 72: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getString";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredStringOrThrow";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredString";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getTuple";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTupleOrEmpty";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredTuple";
                break;
            }
            case 18: 
            case 19: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredTupleOrThrow";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getAddress";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredAddress";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredAddressOrThrow";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "parseAddress";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getInteger";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getInt";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredInt";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredIntOrThrow";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "parseInteger";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 38: 
            case 39: 
            case 44: 
            case 45: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 40: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredLocation";
                break;
            }
            case 42: 
            case 43: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getRequiredLocationOrThrow";
                break;
            }
            case 46: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getAddressLocation";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getAll";
                break;
            }
            case 60: 
            case 61: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getWithSuccessors";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "missingKeyError";
                break;
            }
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "withMessage";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "checkNotNullOrThrow";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getIfEquals";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 8: 
            case 12: 
            case 15: 
            case 17: 
            case 20: 
            case 26: 
            case 41: 
            case 52: 
            case 56: 
            case 59: 
            case 62: 
            case 65: 
            case 67: 
            case 70: 
            case 72: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Location {
        private static final Pattern LOCATION_PATTERN = Pattern.compile("^(.*):(\\d+)$");
        @NonNls
        @NotNull
        public final String path;
        public final int line;

        public Location(@NonNls @NotNull String path, int line) {
            if (path == null) {
                Location.$$$reportNull$$$0(0);
            }
            this.path = path;
            this.line = line;
        }

        @NotNull
        public static Location fromFileLineNumber(@NonNls @NotNull String path, int lineNumber) {
            if (path == null) {
                Location.$$$reportNull$$$0(1);
            }
            return new Location(path, lineNumber - 1);
        }

        @Nullable
        public static Location tryParse(@NonNls @NotNull String locationString) {
            if (locationString == null) {
                Location.$$$reportNull$$$0(2);
            }
            return Location.tryParse(locationString, null);
        }

        @Contract(value="_, !null -> !null")
        @Nullable
        public static Location tryParse(@NonNls @NotNull String locationString, @Nullable Location defaultValue) {
            Matcher matcher;
            if (locationString == null) {
                Location.$$$reportNull$$$0(3);
            }
            if (!(matcher = LOCATION_PATTERN.matcher(locationString)).matches()) {
                return defaultValue;
            }
            String path = matcher.group(1);
            int lineNumber = Integer.parseInt(matcher.group(2));
            return Location.fromFileLineNumber(path, lineNumber);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "locationString";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/debugger/backend/gdb/GDBTuple$Location";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromFileLineNumber";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryParse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

