/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.intellij.ide.IdeView;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import icons.JavaScriptLanguageIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonNewFileAction
extends DumbAwareAction {
    public PackageJsonNewFileAction() {
        super(JavaScriptBundle.messagePointer("action.PackageJsonNewFile.text", "package.json"), JavaScriptBundle.messagePointer("action.PackageJsonNewFile.description", "package.json"), JavaScriptLanguageIcons.Nodejs.Nodejs);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiFile packageJson;
        PsiDirectory psiDir;
        if (e == null) {
            PackageJsonNewFileAction.$$$reportNull$$$0(0);
        }
        if ((psiDir = PackageJsonNewFileAction.getPsiDirectory(e)) != null && psiDir.isValid() && (packageJson = PackageJsonUtil.createPackageJson(psiDir, true)) != null) {
            Project project = psiDir.getProject();
            IdeView view = (IdeView)e.getData(LangDataKeys.IDE_VIEW);
            Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
            if (view != null && editor != null && editor.getDocument().equals(PsiDocumentManager.getInstance((Project)project).getDocument(packageJson))) {
                int offset = PackageJsonNewFileAction.getOffsetToPreserve(editor);
                view.selectElement((PsiElement)packageJson);
                if (offset != -1 && !editor.isDisposed()) {
                    editor.getCaretModel().moveToOffset(offset);
                }
            }
        }
    }

    private static int getOffsetToPreserve(@NotNull Editor editor) {
        int offset;
        if (editor == null) {
            PackageJsonNewFileAction.$$$reportNull$$$0(1);
        }
        return (offset = editor.getCaretModel().getOffset()) == 0 ? -1 : offset;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            PackageJsonNewFileAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabledAndVisible(PackageJsonNewFileAction.isAvailable(e));
    }

    private static boolean isAvailable(@NotNull AnActionEvent e) {
        PsiDirectory psiDir;
        if (e == null) {
            PackageJsonNewFileAction.$$$reportNull$$$0(3);
        }
        if ((psiDir = PackageJsonNewFileAction.getPsiDirectory(e)) != null && psiDir.isValid()) {
            VirtualFile virtualDir = psiDir.getVirtualFile();
            return virtualDir.isValid() && virtualDir.isDirectory() && PackageJsonUtil.findChildPackageJsonFile(virtualDir) == null;
        }
        return false;
    }

    @Nullable
    private static PsiDirectory getPsiDirectory(@NotNull AnActionEvent e) {
        IdeView view;
        if (e == null) {
            PackageJsonNewFileAction.$$$reportNull$$$0(4);
        }
        PsiDirectory[] directories = (view = (IdeView)e.getData(LangDataKeys.IDE_VIEW)) != null ? view.getDirectories() : PsiDirectory.EMPTY_ARRAY;
        return directories.length == 1 ? directories[0] : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/PackageJsonNewFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getOffsetToPreserve";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getPsiDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

