/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.ActionScriptElementTypes;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flow.FlowJSElementTypes;
import com.intellij.lang.javascript.nashorn.NashornJSElementTypes;
import com.intellij.lang.javascript.types.JSClassElementTypeBase;
import com.intellij.lang.javascript.types.JSEmbeddedContentElementType;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.lang.javascript.types.TypeScriptModuleElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.Map;
import java.util.function.BiConsumer;

public abstract class JSNodeVisitor {
    public final void visit(ASTNode node) {
        IElementType type = node.getElementType();
        BiConsumer<JSNodeVisitor, ASTNode> consumer = Holder.ELEMENT_TYPES.get(type);
        if (consumer != null) {
            consumer.accept(this, node);
            return;
        }
        for (Pair condition : Holder.CONDITIONS) {
            if (!((Condition)condition.first).value((Object)type)) continue;
            ((BiConsumer)condition.second).accept(this, node);
            return;
        }
        this.visitElement(node);
    }

    protected void visitDebuggerStatement(ASTNode node) {
        this.visitStatement(node);
    }

    protected void visitStringTemplateLiteralExpression(ASTNode node) {
        this.visitLiteralExpression(node);
    }

    protected void visitTaggedTemplate(ASTNode node) {
        this.visitExpression(node);
    }

    protected void visitImportExportAlias(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitEs6ImportExportSpecifier(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitJSBindExpression(ASTNode node) {
        this.visitExpression(node);
    }

    protected void visitMappedTypeParameter(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitAssignmentProperty(ASTNode node) {
        this.visitProperty(node);
    }

    protected void visitComputedName(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitEmbeddedExpression(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypeScriptEnum(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypeScriptTupleMember(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitES6FromClause(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypeScriptTypeParameter(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitES6NamedImports(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypeScriptTypeParameterList(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypeScriptTypeArgumentList(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitDestructuringElement(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitDestructuringProperty(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitDestructuringParameter(ASTNode node) {
        this.visitParameter(node);
    }

    protected void visitFlowJSTypeCast(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypescriptTypeCast(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypescriptAsExpression(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypeAlias(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypeScriptType(ASTNode node) {
        this.visitElement(node);
    }

    protected void visitTypeScriptTemplateLiteralType(ASTNode node) {
        this.visitTypeScriptType(node);
    }

    protected void visitYieldExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitXmlLiteralExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitImportStatement(ASTNode node) {
        this.visitElement(node);
    }

    public void visitAttributeList(ASTNode node) {
        this.visitElement(node);
    }

    public void visitPackageStatement(ASTNode node) {
        this.visitElement(node);
    }

    public void visitClass(ASTNode node) {
        this.visitElement(node);
    }

    public void visitFile(ASTNode node) {
        this.visitElement(node);
    }

    public void visitCallExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitIndexedPropertyAccessExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitNewExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitFunctionExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitGlobalModuleExport(ASTNode node) {
        this.visitElement(node);
    }

    public void visitFunctionProperty(ASTNode node) {
        this.visitProperty(node);
    }

    public void visitPrefixExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitThrowExpression(ASTNode node) {
        this.visitPrefixExpression(node);
    }

    public void visitPostfixExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitConditionalExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitArrayComprehension(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitCommaExpression(ASTNode node) {
        this.visitBinaryExpression(node);
    }

    public void visitTypeMember(ASTNode node) {
        this.visitElement(node);
    }

    public void visitAssignmentExpression(ASTNode node) {
        this.visitBinaryExpression(node);
    }

    public void visitBinaryExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitProperty(ASTNode node) {
        this.visitElement(node);
    }

    public void visitObjectLiteralExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitArrayLiteralExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitParenthesizedExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitReferenceExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitLiteralExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitThisExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitForInStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitForStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitDoWhileStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitWhileStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitCaseClause(ASTNode node) {
        this.visitElement(node);
    }

    public void visitSwitchStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitCatchBlock(ASTNode node) {
        this.visitElement(node);
    }

    public void visitTryStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitThrowStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitReturnStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitWithStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitBreakStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitContinueStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitIfStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitDestructuringObject(ASTNode node) {
        this.visitSourceElement(node);
    }

    public void visitDestructuringArray(ASTNode node) {
        this.visitSourceElement(node);
    }

    public void visitEmptyStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitVarStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitES6ImportDeclaration(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitES6ExportDeclaration(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitExportDefaultAssignment(ASTNode node) {
        this.visitStatement(node);
    }

    protected void visitTypeScriptImportStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitES6DoExpression(ASTNode node) {
        this.visitExpression(node);
    }

    public void visitExpressionStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitLabeledStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitBlockStatement(ASTNode node) {
        this.visitStatement(node);
    }

    public void visitArgumentList(ASTNode node) {
        this.visitElement(node);
    }

    public void visitParameter(ASTNode node) {
        this.visitVariable(node);
    }

    public void visitVariable(ASTNode node) {
        this.visitElement(node);
    }

    public void visitLocalVariable(ASTNode node) {
        this.visitVariable(node);
    }

    public void visitParameterList(ASTNode node) {
        this.visitElement(node);
    }

    public void visitEmbeddedContent(ASTNode node) {
        this.visitElement(node);
    }

    public void visitElement(ASTNode node) {
        ProgressManager.checkCanceled();
    }

    public void visitSourceElement(ASTNode node) {
        this.visitElement(node);
    }

    public void visitFunctionDeclaration(ASTNode node) {
        this.visitSourceElement(node);
    }

    public void visitStatement(ASTNode node) {
        this.visitSourceElement(node);
    }

    public void visitExpression(ASTNode node) {
        this.visitElement(node);
    }

    public void visitDocComment(ASTNode node) {
        this.visitElement(node);
    }

    public void visitComment(ASTNode node) {
        this.visitElement(node);
    }

    public void visitTypeScriptModule(ASTNode node) {
        this.visitElement(node);
    }

    public void visitTypeScriptInterface(ASTNode node) {
        this.visitElement(node);
    }

    public void visitObjectType(ASTNode node) {
        this.visitTypeScriptType(node);
    }

    private static final class Holder {
        private static final Map<IElementType, BiConsumer<JSNodeVisitor, ASTNode>> ELEMENT_TYPES = ContainerUtil.immutableMapBuilder().put((Object)JSElementTypes.LABELED_STATEMENT, JSNodeVisitor::visitLabeledStatement).put((Object)JSElementTypes.EMPTY_STATEMENT, JSNodeVisitor::visitEmptyStatement).put((Object)JSElementTypes.IF_STATEMENT, JSNodeVisitor::visitIfStatement).put((Object)JSElementTypes.CONTINUE_STATEMENT, JSNodeVisitor::visitContinueStatement).put((Object)JSElementTypes.THROW_STATEMENT, JSNodeVisitor::visitThrowExpression).put((Object)JSStubElementTypes.DESTRUCTURING_PARAMETER, JSNodeVisitor::visitDestructuringParameter).put((Object)JSElementTypes.ARGUMENT_LIST, JSNodeVisitor::visitArgumentList).put((Object)NashornJSElementTypes.ARGUMENT_LIST, JSNodeVisitor::visitArgumentList).put((Object)JSElementTypes.EXPRESSION_STATEMENT, JSNodeVisitor::visitExpressionStatement).put((Object)JSElementTypes.BREAK_STATEMENT, JSNodeVisitor::visitBreakStatement).put((Object)JSElementTypes.WITH_STATEMENT, JSNodeVisitor::visitWithStatement).put((Object)JSElementTypes.DEBUGGER_STATEMENT, JSNodeVisitor::visitDebuggerStatement).put(JSStubElementTypes.RETURN_STATEMENT, JSNodeVisitor::visitReturnStatement).put((Object)JSElementTypes.YIELD_EXPRESSION, JSNodeVisitor::visitYieldExpression).put((Object)JSElementTypes.THROW_STATEMENT, JSNodeVisitor::visitThrowStatement).put((Object)JSElementTypes.TRY_STATEMENT, JSNodeVisitor::visitTryStatement).put((Object)JSElementTypes.CATCH_BLOCK, JSNodeVisitor::visitCatchBlock).put((Object)JSElementTypes.SWITCH_STATEMENT, JSNodeVisitor::visitSwitchStatement).put((Object)JSElementTypes.WHILE_STATEMENT, JSNodeVisitor::visitWhileStatement).put((Object)JSElementTypes.DOWHILE_STATEMENT, JSNodeVisitor::visitDoWhileStatement).put((Object)JSElementTypes.FOR_STATEMENT, JSNodeVisitor::visitForStatement).put((Object)JSElementTypes.FOR_IN_STATEMENT, JSNodeVisitor::visitForInStatement).put(JSStubElementTypes.STRING_TEMPLATE_EXPRESSION, JSNodeVisitor::visitStringTemplateLiteralExpression).put(JSStubElementTypes.LITERAL_EXPRESSION, JSNodeVisitor::visitLiteralExpression).put((Object)JSElementTypes.REFERENCE_EXPRESSION, JSNodeVisitor::visitReferenceExpression).put((Object)JSElementTypes.PARENTHESIZED_EXPRESSION, JSNodeVisitor::visitParenthesizedExpression).put((Object)TypeScriptStubElementTypes.TUPLE_MEMBER_ELEMENT, JSNodeVisitor::visitTypeScriptTupleMember).put((Object)ES6StubElementTypes.NAMED_IMPORTS, JSNodeVisitor::visitES6NamedImports).put((Object)ES6StubElementTypes.FROM_CLAUSE, JSNodeVisitor::visitES6FromClause).put(TypeScriptElementTypes.IMPORT_STATEMENT, JSNodeVisitor::visitTypeScriptImportStatement).put((Object)ES6StubElementTypes.EXPORT_DEFAULT_ASSIGNMENT, JSNodeVisitor::visitExportDefaultAssignment).put(TypeScriptStubElementTypes.EXPORT_ASSIGNMENT, JSNodeVisitor::visitExportDefaultAssignment).put(TypeScriptStubElementTypes.TYPE_ARGUMENT_LIST, JSNodeVisitor::visitTypeScriptTypeArgumentList).put(TypeScriptElementTypes.TSX_TAG_TYPE_ARGUMENTS_LIST, JSNodeVisitor::visitTypeScriptTypeArgumentList).put(TypeScriptStubElementTypes.TYPE_PARAMETER_LIST, JSNodeVisitor::visitTypeScriptTypeParameterList).put(TypeScriptStubElementTypes.TYPE_PARAMETER, JSNodeVisitor::visitTypeScriptTypeParameter).put(JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS, JSNodeVisitor::visitTypeAlias).put(JSStubElementTypes.TYPESCRIPT_ENUM, JSNodeVisitor::visitTypeScriptEnum).put(TypeScriptStubElementTypes.MAPPED_TYPE_PARAMETER, JSNodeVisitor::visitMappedTypeParameter).put(TypeScriptStubElementTypes.OBJECT_TYPE, JSNodeVisitor::visitObjectType).put((Object)ES6ElementTypes.DO_EXPRESSION, JSNodeVisitor::visitES6DoExpression).put((Object)ES6StubElementTypes.EXPORT_DECLARATION, JSNodeVisitor::visitES6ExportDeclaration).put(TypeScriptStubElementTypes.TYPESCRIPT_GLOBAL_MODULE_EXPORT, JSNodeVisitor::visitGlobalModuleExport).put(JSStubElementTypes.DESTRUCTURING_PROPERTY, JSNodeVisitor::visitDestructuringProperty).put(JSStubElementTypes.DESTRUCTURING_ARRAY, JSNodeVisitor::visitDestructuringArray).put(JSStubElementTypes.DESTRUCTURING_OBJECT, JSNodeVisitor::visitDestructuringObject).put((Object)ES6StubElementTypes.IMPORT_DECLARATION, JSNodeVisitor::visitES6ImportDeclaration).put(JSStubElementTypes.TYPESCRIPT_INTERFACE, JSNodeVisitor::visitTypeScriptInterface).put(JSStubElementTypes.IMPORT_STATEMENT, JSNodeVisitor::visitImportStatement).put((Object)ES6StubElementTypes.EXPORT_SPECIFIER, JSNodeVisitor::visitEs6ImportExportSpecifier).put((Object)ES6StubElementTypes.IMPORT_SPECIFIER, JSNodeVisitor::visitEs6ImportExportSpecifier).put((Object)ES6StubElementTypes.IMPORT_SPECIFIER_ALIAS, JSNodeVisitor::visitImportExportAlias).put((Object)ES6StubElementTypes.EXPORT_SPECIFIER_ALIAS, JSNodeVisitor::visitImportExportAlias).put(JSStubElementTypes.PACKAGE_STATEMENT, JSNodeVisitor::visitPackageStatement).put((Object)JSStubElementTypes.EMBEDDED_EXPRESSION, JSNodeVisitor::visitEmbeddedExpression).put((Object)JSTokenTypes.DOC_COMMENT, JSNodeVisitor::visitDocComment).put((Object)JSTokenTypes.C_STYLE_COMMENT, JSNodeVisitor::visitComment).put(JSStubElementTypes.CALL_EXPRESSION, JSNodeVisitor::visitCallExpression).put((Object)ES6ElementTypes.BIND_EXPRESSION, JSNodeVisitor::visitJSBindExpression).put(JSStubElementTypes.ATTRIBUTE_LIST, JSNodeVisitor::visitAttributeList).put((Object)JSStubElementTypes.ACTION_SCRIPT_ATTRIBUTE_LIST, JSNodeVisitor::visitAttributeList).put((Object)JSElementTypes.INDEXED_PROPERTY_ACCESS_EXPRESSION, JSNodeVisitor::visitIndexedPropertyAccessExpression).put((Object)ES6ElementTypes.TAGGED_TEMPLATE_EXPRESSION, JSNodeVisitor::visitTaggedTemplate).put((Object)JSElementTypes.TYPE_ASSERTION, JSNodeVisitor::visitTypescriptTypeCast).put((Object)JSElementTypes.TYPE_AS_EXPRESSION, JSNodeVisitor::visitTypescriptAsExpression).put(FlowJSElementTypes.TYPE_CAST, JSNodeVisitor::visitFlowJSTypeCast).put((Object)ES6StubElementTypes.COMPUTED_NAME, JSNodeVisitor::visitComputedName).put((Object)JSElementTypes.PREFIX_EXPRESSION, JSNodeVisitor::visitPrefixExpression).put((Object)JSElementTypes.POSTFIX_EXPRESSION, JSNodeVisitor::visitPostfixExpression).put((Object)JSElementTypes.ARRAY_COMPREHENSION, JSNodeVisitor::visitArrayComprehension).put((Object)JSElementTypes.CONDITIONAL_EXPRESSION, JSNodeVisitor::visitConditionalExpression).put((Object)JSElementTypes.COMMA_EXPRESSION, JSNodeVisitor::visitCommaExpression).put(JSStubElementTypes.ASSIGNMENT_EXPRESSION, JSNodeVisitor::visitAssignmentExpression).put((Object)JSElementTypes.BINARY_EXPRESSION, JSNodeVisitor::visitBinaryExpression).put((Object)ES6StubElementTypes.ASSIGNMENT_PROPERTY, JSNodeVisitor::visitAssignmentProperty).put(JSStubElementTypes.OBJECT_LITERAL_EXPRESSION, JSNodeVisitor::visitObjectLiteralExpression).put((Object)JSElementTypes.ARRAY_LITERAL_EXPRESSION, JSNodeVisitor::visitArrayLiteralExpression).put((Object)JSElementTypes.THIS_EXPRESSION, JSNodeVisitor::visitThisExpression).put((Object)JSElementTypes.SHARP_THIS_SHORTHAND_EXPRESSION, JSNodeVisitor::visitThisExpression).put((Object)ActionScriptElementTypes.LOCAL_VARIABLE, JSNodeVisitor::visitLocalVariable).put((Object)TypeScriptStubElementTypes.TEMPLATE_LITERAL_TYPE, JSNodeVisitor::visitTypeScriptTemplateLiteralType).build();
        private static final ImmutableList<Pair<Condition<IElementType>, BiConsumer<JSNodeVisitor, ASTNode>>> CONDITIONS;

        private Holder() {
        }

        static {
            Object[] objectArray = new Pair[19];
            objectArray[0] = Pair.create(JSFileElementType.class::isInstance, JSNodeVisitor::visitFile);
            objectArray[1] = Pair.create(arg_0 -> ((TokenSet)JSElementTypes.FUNCTION_DECLARATIONS).contains(arg_0), JSNodeVisitor::visitFunctionDeclaration);
            objectArray[2] = Pair.create(arg_0 -> ((TokenSet)JSElementTypes.PARAMETER_LISTS).contains(arg_0), JSNodeVisitor::visitParameterList);
            objectArray[3] = Pair.create(arg_0 -> ((TokenSet)JSElementTypes.BODY_VARIABLES).contains(arg_0), JSNodeVisitor::visitVariable);
            objectArray[4] = Pair.create(arg_0 -> ((TokenSet)JSExtendedLanguagesTokenSetProvider.PARAMETERS).contains(arg_0), JSNodeVisitor::visitParameter);
            objectArray[5] = Pair.create(arg_0 -> ((TokenSet)JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS).contains(arg_0), JSNodeVisitor::visitBlockStatement);
            objectArray[6] = Pair.create(arg_0 -> ((TokenSet)JSElementTypes.VAR_STATEMENTS).contains(arg_0), JSNodeVisitor::visitVarStatement);
            objectArray[7] = Pair.create(arg_0 -> ((TokenSet)JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES).contains(arg_0), JSNodeVisitor::visitCaseClause);
            objectArray[8] = Pair.create(JSPropertyElementType.class::isInstance, JSNodeVisitor::visitProperty);
            objectArray[9] = Pair.create(arg_0 -> ((TokenSet)JSElementTypes.FUNCTION_EXPRESSIONS).contains(arg_0), JSNodeVisitor::visitFunctionExpression);
            objectArray[10] = Pair.create(arg_0 -> ((TokenSet)JSElementTypes.FUNCTION_PROPERTIES).contains(arg_0), JSNodeVisitor::visitFunctionProperty);
            objectArray[11] = Pair.create(arg_0 -> ((TokenSet)JSElementTypes.NEW_EXPRESSIONS).contains(arg_0), JSNodeVisitor::visitNewExpression);
            objectArray[12] = Pair.create(JSEmbeddedContentElementType.class::isInstance, JSNodeVisitor::visitEmbeddedContent);
            objectArray[13] = Pair.create(JSClassElementTypeBase.class::isInstance, JSNodeVisitor::visitClass);
            objectArray[14] = Pair.create(arg_0 -> ((TokenSet)JSElementTypes.XML_LITERALS).contains(arg_0), JSNodeVisitor::visitXmlLiteralExpression);
            objectArray[15] = Pair.create(TypeScriptModuleElementType.class::isInstance, JSNodeVisitor::visitTypeScriptModule);
            objectArray[16] = Pair.create(arg_0 -> ((TokenSet)JSExtendedLanguagesTokenSetProvider.DESTRUCTURING_ELEMENTS).contains(arg_0), JSNodeVisitor::visitDestructuringElement);
            objectArray[17] = Pair.create(arg_0 -> ((TokenSet)TypeScriptElementTypes.TYPE_MEMBERS).contains(arg_0), JSNodeVisitor::visitTypeMember);
            objectArray[18] = Pair.create(arg_0 -> ((TokenSet)TypeScriptElementTypes.TYPESCRIPT_TYPES).contains(arg_0), JSNodeVisitor::visitTypeScriptType);
            CONDITIONS = ContainerUtil.immutableList((Object[])objectArray);
        }
    }
}

