/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.FileIntPropertyPusher;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSDisposable;
import com.intellij.lang.javascript.dialects.JSDialectsMappings;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.project.ProjectKt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryModelBackedBySyntheticLibrary;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

public final class JSLanguageLevelPusher
implements FileIntPropertyPusher<String> {
    private static final MergingUpdateQueue ourRefreshQueue = new MergingUpdateQueue("JS LanguageLevel update queue", 200, true, null, (Disposable)JSDisposable.getInstance(), null, false).setRestartTimerOnAdd(true);
    private static final Key<Pair<VirtualFile, Long>> SUB_PROJECT_MISC_FILE_KEY = Key.create((String)"js.sub.project.misc.file");
    private static final Key<Pair<String, Long>> LEVEL_IN_MISC_FILE_KEY = Key.create((String)"js.level.in.misc.file");
    private static final FileAttribute PERSISTENCE = new FileAttribute("js_language_level_persistence", 3, true);

    public void initExtra(@NotNull Project project) {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(0);
        }
        this.updateJSLibraries(project);
    }

    @NotNull
    public Key<String> getFileDataKey() {
        Key<String> key = DialectDetector.KEY;
        if (key == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(1);
        }
        return key;
    }

    public boolean pushDirectoriesOnly() {
        return true;
    }

    @NotNull
    public String getDefaultValue() {
        String string = JSLanguageLevel.DEFAULT.getId();
        if (string == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public String getImmediateValue(@NotNull Project project, @Nullable VirtualFile file2) {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            return JSRootConfiguration.getInstance(project).getLanguageLevel().getId();
        }
        String id = (String)JSDialectsMappings.getInstance(project).getImmediateMapping(file2);
        if (id != null) {
            return id;
        }
        if (file2.isDirectory()) {
            VirtualFile miscXml;
            Pair cachedValue = (Pair)file2.getUserData(SUB_PROJECT_MISC_FILE_KEY);
            long vfsStructureModificationsCount = VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS.getModificationCount();
            if (cachedValue == null || (Long)cachedValue.second != vfsStructureModificationsCount) {
                miscXml = null;
                String basePath = project.getBasePath();
                if (basePath != null) {
                    try {
                        VirtualFile ideaDirectory = ProjectKt.getProjectStoreDirectory((VirtualFile)file2);
                        if (ideaDirectory != null && (miscXml = ideaDirectory.findChild("misc.xml")) != null && VfsUtilCore.pathEqualsTo((VirtualFile)file2, (String)basePath)) {
                            miscXml = null;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                cachedValue = Pair.create((Object)miscXml, (Object)vfsStructureModificationsCount);
                file2.putUserData(SUB_PROJECT_MISC_FILE_KEY, (Object)cachedValue);
            }
            if ((miscXml = (VirtualFile)cachedValue.first) != null) {
                return JSLanguageLevelPusher.findLevelInMiscXml(miscXml);
            }
        }
        return null;
    }

    @Nullable
    private static String findLevelInMiscXml(@NotNull VirtualFile misc) {
        if (misc == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(4);
        }
        Pair cachedValue = (Pair)misc.getUserData(LEVEL_IN_MISC_FILE_KEY);
        long modificationCount = misc.getModificationCount();
        if (cachedValue == null || modificationCount != (Long)cachedValue.second) {
            String languageLevel = null;
            try {
                Element root = JDOMUtil.load((InputStream)misc.getInputStream());
                Element jsSettings = JDomSerializationUtil.findComponent((Element)root, (String)"JavaScriptSettings");
                if (jsSettings != null) {
                    languageLevel = JDOMExternalizerUtil.readField((Element)jsSettings, (String)"languageLevel");
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            cachedValue = Pair.create(languageLevel, (Object)modificationCount);
            misc.putUserData(LEVEL_IN_MISC_FILE_KEY, (Object)cachedValue);
        }
        return (String)cachedValue.first;
    }

    @Nullable
    public String getImmediateValue(@NotNull Module module) {
        if (module == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(5);
        }
        return null;
    }

    public boolean acceptsFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(6);
        }
        return false;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(7);
        }
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(8);
        }
        return true;
    }

    @NotNull
    public FileAttribute getAttribute() {
        FileAttribute fileAttribute = PERSISTENCE;
        if (fileAttribute == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(9);
        }
        return fileAttribute;
    }

    public int toInt(@NotNull String property) {
        if (property == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(10);
        }
        return JSLanguageLevel.ofId(property).ordinal();
    }

    @NotNull
    public String fromInt(int val) {
        String string = JSLanguageLevel.values()[val].getId();
        if (string == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(11);
        }
        return string;
    }

    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull String level) throws IOException {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(12);
        }
        if (fileOrDir == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(13);
        }
        if (level == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(14);
        }
        if (JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(fileOrDir)) {
            return;
        }
        super.persistAttribute(project, fileOrDir, (Object)level);
    }

    public void propertyChanged(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull String level) {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(15);
        }
        if (fileOrDir == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(16);
        }
        if (level == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(17);
        }
        PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, JSLanguageLevelPusher::isIndexedFile);
    }

    private static boolean isIndexedFile(@NotNull VirtualFile child) {
        if (child == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(18);
        }
        if (child.isDirectory()) {
            return false;
        }
        FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(child.getNameSequence());
        return JavaScriptIndex.getFileTypesToIndexJS().contains(fileType);
    }

    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(19);
        }
        this.updateJSLibraries(project);
    }

    public void updateJSLibraries(@NotNull Project project) {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(20);
        }
        if (project.isDefault()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.doUpdateJSLibraries(project);
        } else {
            ourRefreshQueue.queue(Update.create((Object)project, () -> this.doUpdateJSLibraries(project)));
        }
    }

    private void doUpdateJSLibraries(@NotNull Project project) {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(21);
        }
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        List tasks = (List)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return Collections.emptyList();
            }
            JSLanguageLevel languageLevel = JSRootConfiguration.getInstance(project).getLanguageLevel();
            Collection<VirtualFile> files = this.getApplicableLibraryFiles(project);
            return ContainerUtil.mapNotNull(files, file2 -> file2.isDirectory() ? () -> this.markRecursively(project, (VirtualFile)file2, languageLevel) : null);
        });
        if (tasks.isEmpty()) {
            return;
        }
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible((List)tasks);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            snapshot.logResponsivenessSinceCreation("Pushing JS language level of " + project.getName() + " to " + tasks.size() + " libraries");
        }
    }

    @NotNull
    public Collection<VirtualFile> getApplicableLibraryFiles(@NotNull Project project) {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(22);
        }
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (ScriptingLibraryModel model : mappings.getMappings().values()) {
            if (model instanceof ScriptingLibraryMappings.CompoundLibrary) {
                for (ScriptingLibraryModel libraryModel : ((ScriptingLibraryMappings.CompoundLibrary)model).getLibraries()) {
                    JSLanguageLevelPusher.addFilesFromModel(files, libraryModel);
                }
                continue;
            }
            JSLanguageLevelPusher.addFilesFromModel(files, model);
        }
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private static void addFilesFromModel(@NotNull List<VirtualFile> files, @NotNull ScriptingLibraryModel model) {
        if (files == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(24);
        }
        if (model == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(25);
        }
        if (model instanceof ScriptingLibraryModelBackedBySyntheticLibrary) {
            SyntheticLibrary library = ((ScriptingLibraryModelBackedBySyntheticLibrary)model).getSyntheticLibrary();
            if (library != null) {
                files.addAll(library.getSourceRoots());
            }
        } else {
            files.addAll(model.getAllFiles());
        }
    }

    private void markRecursively(Project project, @NotNull VirtualFile file2, JSLanguageLevel languageLevel) {
        if (file2 == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(26);
        }
        String id = languageLevel.getId();
        PushedFilePropertiesUpdater updater = PushedFilePropertiesUpdater.getInstance((Project)project);
        FileBasedIndex.iterateRecursively((VirtualFile)file2, fileOrDir -> {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (fileOrDir.isValid() && fileOrDir.isDirectory()) {
                    updater.findAndUpdateValue(fileOrDir, (FilePropertyPusher)this, (Object)id);
                }
            });
            return true;
        }, (ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), new HashSet(), (ProjectFileIndex)ProjectRootManager.getInstance((Project)project).getFileIndex());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 11: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 11: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 11: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "misc";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 7: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDataKey";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttribute";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "fromInt";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableLibraryFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initExtra";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 11: 
            case 23: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findLevelInMiscXml";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toInt";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "persistAttribute";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "propertyChanged";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isIndexedFile";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "afterRootsChanged";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "updateJSLibraries";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doUpdateJSLibraries";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getApplicableLibraryFiles";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addFilesFromModel";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "markRecursively";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 11: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

