/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.editor;

import com.intellij.ide.navigationToolbar.StructureAwareNavBarModelExtension;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.common.PsiTreeElementBase;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.editor.JSBreadcrumbsProvider;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.structureView.JSStructureViewElementBase;
import com.intellij.lang.typescript.structureView.TypeScriptStructureViewBuilderFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0014J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0015H\u0014J8\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00152\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00150\u001a2\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\r0\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u00020\"2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/lang/javascript/editor/JSNavBarStructureViewModel;", "Lcom/intellij/ide/navigationToolbar/StructureAwareNavBarModelExtension;", "()V", "language", "Lcom/intellij/lang/Language;", "getLanguage", "()Lcom/intellij/lang/Language;", "myProvider", "Lcom/intellij/lang/javascript/editor/JSBreadcrumbsProvider;", "childrenFromNodeAndProviders", "", "Lcom/intellij/ide/util/treeView/smartTree/TreeElement;", "parent", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "createModel", "Lcom/intellij/ide/structureView/StructureViewModel;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "findParentInModel", "Lcom/intellij/psi/PsiElement;", "root", "psiElement", "findParentInModelVisited", "parents", "", "visited", "", "getPresentableText", "", "element", "", "isAcceptableLanguage", "", "intellij.javascript.impl"})
public final class JSNavBarStructureViewModel
extends StructureAwareNavBarModelExtension {
    private final JSBreadcrumbsProvider myProvider = new JSBreadcrumbsProvider();

    @NotNull
    protected Language getLanguage() {
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)javascriptLanguage), (String)"JavascriptLanguage.INSTANCE");
        return javascriptLanguage;
    }

    @Nullable
    public String getPresentableText(@NotNull Object element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof JSElement && !(element instanceof PsiFileSystemItem)) {
            String string = this.myProvider.getElementInfo((PsiElement)element);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myProvider.getElementInfo((element as PsiElement))");
            String info = string;
            return StringUtil.isEmpty((String)info) ? null : info;
        }
        return null;
    }

    @Nullable
    protected PsiElement findParentInModel(@NotNull StructureViewTreeElement root, @NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        boolean bl = false;
        Set parents = new LinkedHashSet();
        for (PsiElement parent = psiElement.getParent(); parent != null && !(parent instanceof PsiFileSystemItem); parent = parent.getParent()) {
            parents.add(parent);
        }
        return JSNavBarStructureViewModel.findParentInModelVisited$default(this, root, psiElement, parents, null, 8, null);
    }

    /*
     * Unable to fully structure code
     */
    private final PsiElement findParentInModelVisited(StructureViewTreeElement root, PsiElement psiElement, Set<? extends PsiElement> parents, Set<StructureViewTreeElement> visited) {
        $this$filterIsInstance$iv = this.childrenFromNodeAndProviders(root);
        $i$f$filterIsInstance = false;
        var8_8 = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterIsInstanceTo = false;
        for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof StructureViewTreeElement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        children = (List)destination$iv$iv;
        for (StructureViewTreeElement child : children) {
            block13: {
                block12: {
                    value = child.getValue();
                    parentContains = CollectionsKt.contains((Iterable)parents, (Object)value);
                    if (Intrinsics.areEqual((Object)value, (Object)psiElement)) {
                        v0 = root.getValue();
                        if (!(v0 instanceof PsiElement)) {
                            v0 = null;
                        }
                        return (PsiElement)v0;
                    }
                    if (!(child instanceof JSStructureViewElementBase)) break block13;
                    Intrinsics.checkNotNullExpressionValue(((JSStructureViewElementBase)child).getAllElements(), (String)"child.allElements");
                    if (allElements.contains(psiElement)) {
                        v1 = root.getValue();
                        if (!(v1 instanceof PsiElement)) {
                            v1 = null;
                        }
                        return (PsiElement)v1;
                    }
                    if (parentContains) ** GOTO lbl-1000
                    $this$any$iv = allElements;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v2 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            it = (PsiElement)element$iv;
                            $i$a$-any-JSNavBarStructureViewModel$findParentInModelVisited$1 = false;
                            if (!parents.contains(it)) continue;
                            v2 = true;
                            break block12;
                        }
                        v2 = false;
                    }
                }
                if (v2) lbl-1000:
                // 2 sources

                {
                    v3 = true;
                } else {
                    v3 = parentContains = false;
                }
            }
            if (!parentContains || !visited.add(child)) continue;
            v4 = this.findParentInModelVisited(child, psiElement, parents, visited);
            if (v4 == null) continue;
            var10_14 = v4;
            $this$any$iv = false;
            $i$f$any = false;
            it = var10_14;
            $i$a$-let-JSNavBarStructureViewModel$findParentInModelVisited$2 = false;
            return it;
        }
        for (StructureViewTreeElement child : children) {
            if (!visited.add(child)) continue;
            v5 = this.findParentInModelVisited(child, psiElement, parents, visited);
            if (v5 == null) continue;
            var8_8 = v5;
            var9_11 = false;
            var10_12 = false;
            it = var8_8;
            $i$a$-let-JSNavBarStructureViewModel$findParentInModelVisited$3 = false;
            return it;
        }
        return null;
    }

    static /* synthetic */ PsiElement findParentInModelVisited$default(JSNavBarStructureViewModel jSNavBarStructureViewModel, StructureViewTreeElement structureViewTreeElement, PsiElement psiElement, Set set, Set set2, int n, Object object) {
        if ((n & 8) != 0) {
            boolean bl = false;
            set2 = new LinkedHashSet();
        }
        return jSNavBarStructureViewModel.findParentInModelVisited(structureViewTreeElement, psiElement, set, set2);
    }

    @Nullable
    protected StructureViewModel createModel(@NotNull PsiFile file2, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        StructureViewBuilder builder = new TypeScriptStructureViewBuilderFactory().getStructureViewBuilder(file2);
        StructureViewBuilder structureViewBuilder = builder;
        if (!(structureViewBuilder instanceof TreeBasedStructureViewBuilder)) {
            structureViewBuilder = null;
        }
        TreeBasedStructureViewBuilder treeBasedStructureViewBuilder = (TreeBasedStructureViewBuilder)structureViewBuilder;
        return treeBasedStructureViewBuilder != null ? treeBasedStructureViewBuilder.createStructureViewModel(editor) : null;
    }

    protected boolean isAcceptableLanguage(@Nullable PsiElement psiElement) {
        Language language;
        PsiElement psiElement2 = psiElement;
        Object object = language = psiElement2 != null ? psiElement2.getLanguage() : null;
        if (language instanceof JSLanguageDialect) {
            DialectOptionHolder dialectOptionHolder = ((JSLanguageDialect)language).getOptionHolder();
            Intrinsics.checkNotNullExpressionValue((Object)dialectOptionHolder, (String)"language.optionHolder");
            DialectOptionHolder optionHolder = dialectOptionHolder;
            return optionHolder.isJavaScript() || optionHolder.isTypeScript;
        }
        return false;
    }

    @NotNull
    protected List<TreeElement> childrenFromNodeAndProviders(@NotNull StructureViewTreeElement parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (parent instanceof PsiTreeElementBase) {
            Collection collection = ((PsiTreeElementBase)parent).getChildrenBase();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"parent.childrenBase");
            return CollectionsKt.toList((Iterable)collection);
        }
        return super.childrenFromNodeAndProviders(parent);
    }
}

