/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.modules;

import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSPathMappingsUtil {
    public static String replaceStarForMapping(@NotNull String mapping, @Nullable String matchedStar) {
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(0);
        }
        return matchedStar != null ? mapping.replace("*", matchedStar) : mapping;
    }

    public static boolean checkMappingPattern(@NotNull String path2, @NotNull Pattern pattern2) {
        if (path2 == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(1);
        }
        if (pattern2 == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(2);
        }
        Matcher m = pattern2.matcher(path2);
        return m.find();
    }

    @Nullable
    public static Pattern createMappingPattern(@Nullable String pattern2, @Nullable VirtualFile contextFile) {
        if (pattern2 == null) {
            return null;
        }
        return Pattern.compile(pattern2, JSPathMappingsUtil.isCaseSensitive(contextFile) ? 0 : 2);
    }

    private static boolean isCaseSensitive(@Nullable VirtualFile configDir) {
        if (configDir == null) {
            return true;
        }
        return configDir.isCaseSensitive();
    }

    @Nullable
    public static <T extends JSModulePattern> Pair<T, String> findMaxElementByPaths(@NotNull String textToMatch, @NotNull Collection<? extends T> paths) {
        if (textToMatch == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(3);
        }
        if (paths == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(4);
        }
        Pair matchedElement = null;
        int longestMatchPrefixLength = -1;
        for (JSModulePattern path2 : paths) {
            String suffix;
            String pattern2 = path2.getPattern();
            int prefixMatchIndex = pattern2.indexOf("*");
            int suffixMatchIndex = prefixMatchIndex + 1;
            if (path2.canStartWith()) {
                suffixMatchIndex = prefixMatchIndex = pattern2.length();
            }
            if (prefixMatchIndex == -1) {
                if (!pattern2.equals(textToMatch)) continue;
                return Pair.create((Object)path2, null);
            }
            String prefix = pattern2.substring(0, prefixMatchIndex);
            if (!JSPathMappingsUtil.checkPrefix(textToMatch, prefix, suffix = pattern2.substring(suffixMatchIndex)) || prefix.length() <= longestMatchPrefixLength) continue;
            longestMatchPrefixLength = prefix.length();
            matchedElement = Pair.create((Object)path2, (Object)textToMatch.substring(prefix.length(), textToMatch.length() - suffix.length()));
        }
        return matchedElement;
    }

    private static boolean checkPrefix(@NotNull String unquotedRefText, @NotNull String prefix, @NotNull String suffix) {
        if (unquotedRefText == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(5);
        }
        if (prefix == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(6);
        }
        if (suffix == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(7);
        }
        return unquotedRefText.length() >= prefix.length() + suffix.length() && unquotedRefText.startsWith(prefix) && unquotedRefText.endsWith(suffix);
    }

    public static boolean isPatternOrMappingEndsWithStar(@NotNull String patternOrMapping) {
        if (patternOrMapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(8);
        }
        return patternOrMapping.endsWith("/*") || patternOrMapping.endsWith("\\*");
    }

    @Nullable
    public static VirtualFile getPathRelativeBaseUrlOrSelfIfAbsolute(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(9);
        }
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(10);
        }
        if (JSPathMappingsUtil.isAbsolutePath(mapping)) {
            return baseUrl.getFileSystem().findFileByPath(mapping);
        }
        return JSPathMappingsUtil.getPathRelativeBaseUrl(baseUrl, mapping);
    }

    private static boolean isAbsolutePath(@NotNull String mapping) {
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(11);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && mapping.startsWith("/")) {
            return true;
        }
        return FileUtil.isAbsolute((String)mapping);
    }

    @Nullable
    public static VirtualFile getPathRelativeBaseUrl(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(12);
        }
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(13);
        }
        String path2 = FileUtil.toCanonicalPath((String)FileUtil.toSystemIndependentName((String)mapping), (char)'/');
        return baseUrl.isValid() ? baseUrl.findFileByRelativePath(path2) : null;
    }

    public static String getPatternOrMappingWithoutStar(@NotNull String patternOrMapping) {
        if (patternOrMapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(14);
        }
        int length = patternOrMapping.length();
        return patternOrMapping.endsWith("*") ? patternOrMapping.substring(0, patternOrMapping.length() > 2 ? length - 2 : 1) : patternOrMapping;
    }

    public static Collection<String> getMappings(@NotNull JSModulePathSubstitution matchedPattern, String matchedStar, boolean endsWithStar) {
        if (matchedPattern == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(15);
        }
        String pattern2 = matchedPattern.getPattern();
        boolean patternEndsWithStart = matchedStar != null && (JSPathMappingsUtil.isPatternOrMappingEndsWithStar(pattern2) || matchedPattern.canStartWith());
        ArrayList<String> result2 = new ArrayList<String>();
        for (String mapping : matchedPattern.getMappings()) {
            boolean mappingEndsWithStar = patternEndsWithStart && (JSPathMappingsUtil.isPatternOrMappingEndsWithStar(mapping) || matchedPattern.canStartWith());
            if (mappingEndsWithStar != endsWithStar) continue;
            result2.add(mapping);
        }
        return result2;
    }

    public static String getStringPathRelativeBaseUrlOrSelfIfAbsolute(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(16);
        }
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(17);
        }
        return JSPathMappingsUtil.getStringPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl.getPath(), mapping);
    }

    @NotNull
    public static String getStringPathRelativeBaseUrlOrSelfIfAbsolute(@NotNull String canonicalUrl, @NotNull String mapping) {
        if (canonicalUrl == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(18);
        }
        if (mapping == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(19);
        }
        if (JSPathMappingsUtil.isAbsolutePath(mapping)) {
            String string = mapping;
            if (string == null) {
                JSPathMappingsUtil.$$$reportNull$$$0(20);
            }
            return string;
        }
        String canonicalMapping = FileUtil.toSystemIndependentName((String)mapping);
        if (!((String)canonicalUrl).isEmpty()) {
            canonicalUrl = (String)canonicalUrl + "/";
        }
        String string = FileUtil.toCanonicalPath((String)((String)canonicalUrl + (canonicalMapping.startsWith("/") ? canonicalMapping.substring(1) : canonicalMapping)), (char)'/');
        if (string == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    public static VirtualFile getRelativeOrAbsoluteFilePath(@NotNull String path2, VirtualFile baseDir) {
        if (path2 == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(22);
        }
        if (StringUtil.isEmptyOrSpaces((String)path2)) {
            return baseDir;
        }
        String normalizedPath = FileUtil.toSystemIndependentName((String)FileUtil.toCanonicalPath((String)path2));
        if (StringUtil.isEmpty((String)normalizedPath)) {
            return baseDir;
        }
        if (!JSPathMappingsUtil.isAbsolutePath(path2)) {
            return baseDir.findFileByRelativePath(normalizedPath);
        }
        return LocalFileSystem.getInstance().findFileByPath(normalizedPath);
    }

    @NotNull
    public static JSModulePattern createPatternForString(final @NotNull String partOfString, final boolean canStartWith) {
        if (partOfString == null) {
            JSPathMappingsUtil.$$$reportNull$$$0(23);
        }
        return new JSModulePattern(){

            @Override
            @NotNull
            public String getPattern() {
                String string = partOfString;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public boolean canStartWith() {
                return canStartWith;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil$1", "getPattern"));
            }
        };
    }

    public static AsteriskCount hasZeroOrOneAsteriskCharacter(String str) {
        boolean seenAsterisk = false;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            if (str.charAt(i2) != '*') continue;
            if (!seenAsterisk) {
                seenAsterisk = true;
                continue;
            }
            return AsteriskCount.MORE;
        }
        return seenAsterisk ? AsteriskCount.ONE : AsteriskCount.ZERO;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 1: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToMatch";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedRefText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternOrMapping";
                break;
            }
            case 9: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchedPattern";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canonicalUrl";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partOfString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/modules/JSPathMappingsUtil";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringPathRelativeBaseUrlOrSelfIfAbsolute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceStarForMapping";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkMappingPattern";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findMaxElementByPaths";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkPrefix";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isPatternOrMappingEndsWithStar";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeBaseUrlOrSelfIfAbsolute";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAbsolutePath";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeBaseUrl";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getPatternOrMappingWithoutStar";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMappings";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getStringPathRelativeBaseUrlOrSelfIfAbsolute";
                break;
            }
            case 20: 
            case 21: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeOrAbsoluteFilePath";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createPatternForString";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum AsteriskCount {
        ZERO,
        ONE,
        MORE;

    }
}

