/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JSNonStrictModeUsedInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSNonStrictModeUsedInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSNonStrictModeUsedInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSFile(JSFile file2) {
                if (InjectedLanguageManager.getInstance((Project)file2.getProject()).getInjectionHost((PsiElement)file2) == null) {
                    this.checkHasUseStrict(file2, "File");
                }
            }

            @Override
            public void visitJSEmbeddedContent(JSEmbeddedContent embeddedContent) {
                this.checkHasUseStrict(embeddedContent, "Script");
            }

            private void checkHasUseStrict(JSExecutionScope executionScope, @NotNull String element) {
                DialectOptionHolder dialect;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((dialect = DialectDetector.dialectOfElement((PsiElement)executionScope)) != null && dialect.isJavaScript() && !dialect.isECMA6 && !JSResolveUtil.hasUseStrictPragma((PsiElement)executionScope)) {
                    LocalQuickFix fix = JSFixFactory.getInstance().insertUseStrict(executionScope);
                    holder.registerProblem((PsiElement)executionScope, JavaScriptBundle.message("js.strict.mode.inspection.error", element), new LocalQuickFix[]{fix});
                }
            }

            @Override
            public void visitJSExpressionStatement(JSExpressionStatement node) {
                JSExecutionScope executionScope;
                if (JSPsiImplUtils.isUseStrictStatement((PsiElement)node) && (executionScope = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)node, JSExecutionScope.class)) != null && !(executionScope instanceof PsiFile) && JSResolveUtil.isEcmaScript5(executionScope.getParent())) {
                    LocalQuickFixAndIntentionActionOnPsiElement fix = JSFixFactory.getInstance().removeASTNodeFix("js.strict.mode.remove.pragma", (PsiElement)node);
                    holder.registerProblem((PsiElement)node, JavaScriptBundle.message("js.strict.mode.inspection.redundant.pragma", new Object[0]), new LocalQuickFix[]{fix});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/JSNonStrictModeUsedInspection$1", "checkHasUseStrict"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/javascript/inspections/JSNonStrictModeUsedInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

