/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions.destructuring;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.macro.EnumMacro;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.intentions.destructuring.JSDestructuringPropagationIntentionBase;
import com.intellij.lang.javascript.intentions.destructuring.JSStatementDestructuringIntentionBase;
import com.intellij.lang.javascript.names.JSNameSuggestionsUtil;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSDestructuringShorthandedProperty;
import com.intellij.lang.javascript.psi.JSFunctionType;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.ES6ChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTupleType;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSGenerateDestructuringPatternIntention
extends JSDestructuringPropagationIntentionBase {
    private static final int MAX_PROP_COUNT = 20;
    private static final int MAX_ITEMS_SHOWN = 10;
    private static final int MAX_TYPE_DEPTH = 10;

    @Override
    @NotNull
    @IntentionName
    protected String getDescription() {
        String string = JavaScriptBundle.message("refactoring.destructuring.vars.intention.deconstruct", new Object[0]);
        if (string == null) {
            JSGenerateDestructuringPatternIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected boolean isAvailableOnElement(@NotNull PsiElement element, Project project, Editor editor) {
        PsiElement parent;
        if (element == null) {
            JSGenerateDestructuringPatternIntention.$$$reportNull$$$0(1);
        }
        if (!JSGenerateDestructuringPatternIntention.isAcceptableVariable(parent = element.getParent())) {
            return false;
        }
        if (JSGenerateDestructuringPatternIntention.findVariable(element) == null || !JSGenerateDestructuringPatternIntention.isApplicableType(JSGenerateDestructuringPatternIntention.evaluateType(parent))) {
            return false;
        }
        return (Boolean)ProgressManager.getInstance().runProcess(() -> ReferencesSearch.search((PsiElement)parent).findAll().isEmpty(), (ProgressIndicator)new EmptyProgressIndicator());
    }

    public static boolean isApplicableType(JSType jsType2) {
        JSResolvedTypeInfo info;
        if (jsType2 == null) {
            return false;
        }
        if (jsType2 instanceof JSTupleType) {
            return ((JSTupleType)jsType2).getMaxLength() != Integer.MAX_VALUE;
        }
        if (jsType2 instanceof JSPrimitiveType || jsType2 instanceof JSFunctionType) {
            return false;
        }
        if (jsType2 instanceof JSResolvableType && ((info = ((JSResolvableType)jsType2).resolveType()).isEnum() || info.isEnumLiteral())) {
            return false;
        }
        JSRecordType type = jsType2.asRecordType();
        return type.hasProperties() && type.getPropertyNames().size() <= 20;
    }

    private static JSType evaluateType(PsiElement parent) {
        return JSResolveUtil.getElementJSType(parent);
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSGenerateDestructuringPatternIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            JSGenerateDestructuringPatternIntention.$$$reportNull$$$0(3);
        }
        JSVariable variable = JSGenerateDestructuringPatternIntention.findVariable(element);
        assert (variable != null);
        JSType jsType2 = JSGenerateDestructuringPatternIntention.evaluateType((PsiElement)variable);
        HashSet<String> names = new HashSet<String>();
        List<String> variants = JSGenerateDestructuringPatternIntention.evaluateVariants((PsiElement)variable, jsType2, names, 0);
        Object parent = variable.getParent();
        if (parent instanceof JSDestructuringProperty) {
            if (parent instanceof JSDestructuringShorthandedProperty) {
                PsiElement finalParent = parent;
                parent = (PsiElement)ApplicationManager.getApplication().runWriteAction(() -> ES6ChangeUtil.expandDestructuringProperty((JSDestructuringShorthandedProperty)finalParent));
                PsiDocumentManager.getInstance((Project)variable.getProject()).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            }
            if (!((parent = ((JSDestructuringProperty)parent).getDestructuringElement()) instanceof JSVariable)) {
                return;
            }
            variable = (JSVariable)parent;
        }
        if (variants.size() == 1) {
            JSGenerateDestructuringPatternIntention.doReplace(variable, variants.iterator().next() + JSGenerateDestructuringPatternIntention.buildTail(variable));
        } else {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                JSGenerateDestructuringPatternIntention.doReplace(variable, (String)ContainerUtil.getLastItem(variants) + JSGenerateDestructuringPatternIntention.buildTail(variable));
                return;
            }
            ArrayList<String> itemsShown = new ArrayList<String>(Math.min(variants.size(), 10));
            itemsShown.addAll(ContainerUtil.getFirstItems(variants, (int)9));
            if (variants.size() > 10) {
                itemsShown.add((String)ContainerUtil.getLastItem(variants));
            }
            PsiElement identifier = variable.getNameIdentifier();
            assert (identifier != null);
            MacroCallNode macro = new MacroCallNode((Macro)new EnumMacro());
            for (String candidate : itemsShown) {
                macro.addParameter((Expression)new ConstantNode(candidate));
            }
            PsiFile file2 = identifier.getContainingFile();
            Object finalParent1 = parent;
            JSVariable finalVariable = variable;
            JSGenerateDestructuringPatternIntention.runInWriteAction(() -> this.lambda$invoke$2(identifier, (PsiElement)finalParent1, finalVariable, project, editor, macro, file2));
        }
    }

    @Nullable
    private static JSVariable findVariable(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JSGenerateDestructuringPatternIntention.$$$reportNull$$$0(4);
        }
        if ((parent = element.getParent()) instanceof JSVarStatement) {
            return (JSVariable)ArrayUtil.getFirstElement((Object[])((JSVarStatement)parent).getVariables());
        }
        if (parent instanceof JSVariable) {
            return (JSVariable)parent;
        }
        return null;
    }

    private static void runVariablesTemplate(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            JSGenerateDestructuringPatternIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            JSGenerateDestructuringPatternIntention.$$$reportNull$$$0(6);
        }
        if (file2 == null) {
            JSGenerateDestructuringPatternIntention.$$$reportNull$$$0(7);
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        Object element = file2.findElementAt(editor.getCaretModel().getOffset() - 1);
        JSDestructuringElement variable = (JSDestructuringElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSDestructuringElement.class);
        while (variable != null) {
            element = variable;
            variable = (JSDestructuringElement)PsiTreeUtil.getParentOfType((PsiElement)element, JSDestructuringElement.class);
        }
        if (element != null) {
            TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder(element);
            SyntaxTraverser.psiTraverser((PsiElement)element).filter(JSVariable.class).forEach(v -> {
                if (v.getParent() instanceof JSDestructuringShorthandedProperty) {
                    return;
                }
                PsiElement nameIdentifier = v.getNameIdentifier();
                if (nameIdentifier == null) {
                    return;
                }
                builder.replaceElement(nameIdentifier, (Expression)new ConstantNode(nameIdentifier.getText()));
            });
            builder.run(editor, true);
        }
    }

    @NotNull
    private static String buildTail(JSVariable variable) {
        StringBuilder tailBuilder = new StringBuilder();
        JSGenerateDestructuringPatternIntention.appendTypeAndInitializer(variable, tailBuilder);
        String string = tailBuilder.toString();
        if (string == null) {
            JSGenerateDestructuringPatternIntention.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static void doReplace(JSVariable variable, String destruct) {
        PsiElement parent = variable.getParent();
        JSGenerateDestructuringPatternIntention.replaceWithDestructuring((PsiElement)variable, parent, JSPsiElementFactory.createParameterOrVariableItem(destruct, parent, parent instanceof JSCatchBlock, variable instanceof JSParameter), false);
    }

    @NotNull
    public static List<String> evaluateVariants(PsiElement context, JSType jsType2, Set<String> names, int depth) {
        if (depth > 10) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSGenerateDestructuringPatternIntention.$$$reportNull$$$0(9);
            }
            return list2;
        }
        if (JSGenerateDestructuringPatternIntention.shouldSkipDestructuring(jsType2 = JSTypeUtils.getValuableType(jsType2))) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                JSGenerateDestructuringPatternIntention.$$$reportNull$$$0(10);
            }
            return list3;
        }
        if (jsType2 instanceof JSUnionType && !jsType2.isSourceStrict() && ((JSUnionType)jsType2).isAnyType()) {
            List<JSType> types2 = ((JSUnionType)jsType2).getTypes();
            List filteredTypes = ContainerUtil.filter(types2, t -> !(t instanceof JSAnyType));
            jsType2 = JSCompositeTypeFactory.createUnionType(jsType2.getSource(), filteredTypes);
        }
        if (jsType2 instanceof JSUnionOrIntersectionType && ((JSUnionOrIntersectionType)jsType2).getTypes().stream().anyMatch(t -> JSGenerateDestructuringPatternIntention.shouldSkipDestructuring(t))) {
            List list4 = ContainerUtil.emptyList();
            if (list4 == null) {
                JSGenerateDestructuringPatternIntention.$$$reportNull$$$0(11);
            }
            return list4;
        }
        List<String> list5 = jsType2 instanceof JSTupleType ? JSGenerateDestructuringPatternIntention.getTupleVariants((JSTupleType)jsType2, names, context, depth) : JSGenerateDestructuringPatternIntention.getObjectVariants(jsType2.asRecordType(), names, context, depth);
        if (list5 == null) {
            JSGenerateDestructuringPatternIntention.$$$reportNull$$$0(12);
        }
        return list5;
    }

    private static boolean shouldSkipDestructuring(JSType jsType2) {
        if (jsType2 instanceof JSPrimitiveType || jsType2 instanceof JSAnyType) {
            return true;
        }
        if (!(jsType2 instanceof JSResolvableType)) {
            return false;
        }
        JSResolvedTypeInfo info = ((JSResolvableType)jsType2).resolveType();
        return info.isEnum() || info.isEnumLiteral();
    }

    private static List<String> getObjectVariants(JSRecordType type, Set<String> existing, PsiElement context, int depth) {
        int i2;
        if (!type.hasProperties()) {
            return ContainerUtil.emptyList();
        }
        Object prefixes = new SmartList();
        prefixes.add("{");
        List allNames = ContainerUtil.sorted(type.getPropertyNames());
        List computedProperties = ContainerUtil.filter(type.getProperties(), p -> p instanceof JSRecordTypeImpl.ComputedPropertySignatureImpl);
        int size = allNames.size() + computedProperties.size();
        for (i2 = 0; i2 < allNames.size(); ++i2) {
            String name = (String)allNames.get(i2);
            JSRecordType.PropertySignature signature = type.findPropertySignature(name);
            prefixes = JSGenerateDestructuringPatternIntention.appendSignature(existing, context, depth, (List<String>)prefixes, size, i2, name, signature);
        }
        for (JSRecordType.PropertySignature property : computedProperties) {
            if (!(property instanceof JSRecordTypeImpl.ComputedPropertySignatureImpl)) continue;
            prefixes = JSGenerateDestructuringPatternIntention.appendSignature(existing, context, depth, (List<String>)prefixes, size, i2, "[" + ((JSRecordTypeImpl.ComputedPropertySignatureImpl)property).getNameRef() + "]", property);
            ++i2;
        }
        return prefixes;
    }

    @NotNull
    private static List<String> appendSignature(Set<String> existing, PsiElement context, int depth, List<String> prefixes, int size, int i2, String name, JSRecordType.PropertySignature signature) {
        JSType signatureType = signature == null ? null : TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(signature.getJSType());
        ArrayList<String> variants = JSGenerateDestructuringPatternIntention.isApplicableType(signatureType) ? new ArrayList<String>(ContainerUtil.map(JSGenerateDestructuringPatternIntention.evaluateVariants(context, signatureType, existing, depth + 1), v -> name + ": " + v)) : new ArrayList();
        Object newName = JSSymbolUtil.isValidPropertyName(name) ? name : "prop" + i2;
        newName = JSNameSuggestionsUtil.ensureUniqueVariableName((String)newName, context, existing, false);
        variants.add(0, (String)(name.equals(newName) ? name : name + ": " + (String)newName));
        existing.add((String)newName);
        List<String> list2 = prefixes = JSGenerateDestructuringPatternIntention.blowPrefixes(prefixes, variants, size, i2, "}");
        if (list2 == null) {
            JSGenerateDestructuringPatternIntention.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @NotNull
    private static List<String> blowPrefixes(List<String> prefixes, List<String> variants, int size, int i2, String rparen) {
        ArrayList<String> newPrefixes = new ArrayList<String>(prefixes.size() * variants.size());
        String comma = i2 == 0 ? "" : ", ";
        String rbrace = i2 == size - 1 ? rparen : "";
        for (String prefix : prefixes) {
            for (String variant : variants) {
                newPrefixes.add(prefix + comma + variant + rbrace);
            }
        }
        ArrayList<String> arrayList = newPrefixes;
        if (arrayList == null) {
            JSGenerateDestructuringPatternIntention.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    private static List<String> getTupleVariants(JSTupleType jsType2, Set<String> existing, PsiElement context, int depth) {
        Object prefixes = new SmartList();
        prefixes.add("[");
        int size = jsType2.getMaxLength();
        for (int i2 = 0; i2 < size; ++i2) {
            JSType type = jsType2.getTypeByIndex(i2);
            ArrayList<String> variants = JSGenerateDestructuringPatternIntention.isApplicableType(type) ? new ArrayList<String>(JSGenerateDestructuringPatternIntention.evaluateVariants(context, type, existing, depth + 1)) : new ArrayList();
            String newName = JSNameSuggestionsUtil.ensureUniqueVariableName(JSNameSuggestionsUtil.generateOrdinal(i2), context, existing, false);
            variants.add(0, newName);
            existing.add(newName);
            prefixes = JSGenerateDestructuringPatternIntention.blowPrefixes((List<String>)prefixes, variants, size, i2, "]");
        }
        return prefixes;
    }

    private /* synthetic */ void lambda$invoke$2(PsiElement identifier, PsiElement finalParent1, JSVariable finalVariable, final Project project, final Editor editor, MacroCallNode macro, final PsiFile file2) {
        PsiElement nameId = identifier;
        if (finalParent1 instanceof JSParameterList) {
            PsiElement expanded = JSGenerateDestructuringPatternIntention.expandForParameter((JSParameterList)finalParent1, (PsiElement)finalVariable, (PsiElement)finalVariable);
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            if (expanded instanceof JSParameterList) {
                nameId = ((JSParameterList)expanded).getParameterVariables()[0].getNameIdentifier();
            } else if (expanded instanceof JSParameter) {
                nameId = ((JSParameter)expanded).getNameIdentifier();
            }
        }
        if (nameId == null) {
            return;
        }
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder(nameId);
        builder.replaceElement(nameId, (Expression)macro);
        builder.run(editor, true);
        TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
        if (templateState == null) {
            return;
        }
        templateState.addTemplateStateListener((TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(@NotNull Template template, boolean brokenOff) {
                if (template == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!brokenOff) {
                    JSStatementDestructuringIntentionBase.runInWriteAction(() -> JSGenerateDestructuringPatternIntention.runVariablesTemplate(project, editor, file2));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/lang/javascript/intentions/destructuring/JSGenerateDestructuringPatternIntention$1", "templateFinished"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/destructuring/JSGenerateDestructuringPatternIntention";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/destructuring/JSGenerateDestructuringPatternIntention";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildTail";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "evaluateVariants";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "appendSignature";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "blowPrefixes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableOnElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findVariable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runVariablesTemplate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

