/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.download;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptRelatedPackagesStorage {
    public static final Type STORED_VALUE_TYPE = new TypeToken<Map<String, Collection<String>>>(){}.getType();
    private volatile Map<String, Collection<String>> myRegularMap;

    @Nullable
    public static TypeScriptRelatedPackagesStorage getStorage(@NotNull Project project) {
        if (project == null) {
            TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(0);
        }
        return (TypeScriptRelatedPackagesStorage)project.getService(TypeScriptRelatedPackagesStorage.class);
    }

    @NotNull
    public Collection<String> getRelatedPackageNames(@NotNull VirtualFile typesDirectory, @NotNull String name) {
        Map<String, Collection<String>> map;
        Collection<String> strings;
        if (typesDirectory == null) {
            TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(1);
        }
        if (name == null) {
            TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(2);
        }
        Collection<Object> collection = (strings = (map = this.getDataMap(typesDirectory)).get(name)) == null ? Collections.emptySet() : strings;
        if (collection == null) {
            TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public Map<String, Collection<String>> getDataMap(@NotNull VirtualFile file2) {
        Map<String, Collection<String>> map;
        if (file2 == null) {
            TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(4);
        }
        if ((map = this.myRegularMap) == null) {
            map = this.readData(file2);
        }
        Map<String, Collection<String>> map2 = map;
        if (map2 == null) {
            TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(5);
        }
        return map2;
    }

    public synchronized void writeData(@NotNull VirtualFile file2, @NotNull String name, @NotNull Collection<String> relatedPackageNames) {
        block6: {
            if (file2 == null) {
                TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(6);
            }
            if (name == null) {
                TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(7);
            }
            if (relatedPackageNames == null) {
                TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(8);
            }
            File relatedFilesStorage = new File(VfsUtilCore.virtualToIoFile((VirtualFile)file2), ".relatedFilesStorage");
            try {
                if (!relatedFilesStorage.exists() && !relatedFilesStorage.createNewFile()) {
                    return;
                }
                Map<String, Collection<String>> map = this.getDataMap(file2);
                HashMap<String, Collection<String>> newMap = new HashMap<String, Collection<String>>(map);
                newMap.put(name, relatedPackageNames);
                TypeScriptRelatedPackagesStorage.writeDataToFile(relatedFilesStorage, newMap);
                this.myRegularMap = newMap;
            }
            catch (IOException e) {
                if (!relatedFilesStorage.exists()) break block6;
                FileUtil.delete((File)relatedFilesStorage);
            }
        }
    }

    @NotNull
    private static Map<String, Collection<String>> readDataFromFile(@NotNull File relatedFilesStorage) throws IOException {
        String text;
        if (relatedFilesStorage == null) {
            TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(9);
        }
        if (StringUtil.isEmpty((String)(text = Files.toString((File)relatedFilesStorage, (Charset)Charsets.UTF_8)))) {
            return new HashMap<String, Collection<String>>();
        }
        Map map = (Map)new Gson().fromJson(text, STORED_VALUE_TYPE);
        if (map == null) {
            TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(10);
        }
        return map;
    }

    private static void writeDataToFile(@NotNull File relatedFilesStorage, @NotNull Map<String, Collection<String>> data) throws IOException {
        if (relatedFilesStorage == null) {
            TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(11);
        }
        if (data == null) {
            TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(12);
        }
        String result2 = new Gson().toJson(data, STORED_VALUE_TYPE);
        FileUtil.writeToFile((File)relatedFilesStorage, (String)result2);
    }

    @NotNull
    private synchronized Map<String, Collection<String>> readData(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(13);
        }
        Map<String, Collection<String>> result2 = this.readDataImpl(file2);
        this.myRegularMap = result2;
        Map<String, Collection<String>> map = result2;
        if (map == null) {
            TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(14);
        }
        return map;
    }

    @NotNull
    private Map<String, Collection<String>> readDataImpl(@NotNull VirtualFile file2) {
        Map<String, Collection<String>> tempMap;
        if (file2 == null) {
            TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(15);
        }
        if ((tempMap = this.myRegularMap) != null) {
            Map<String, Collection<String>> map = tempMap;
            if (map == null) {
                TypeScriptRelatedPackagesStorage.$$$reportNull$$$0(16);
            }
            return map;
        }
        File relatedFilesStorage = new File(file2.getPath(), ".relatedFilesStorage");
        if (!relatedFilesStorage.exists()) {
            return new HashMap<String, Collection<String>>();
        }
        try {
            return TypeScriptRelatedPackagesStorage.readDataFromFile(relatedFilesStorage);
        }
        catch (IOException e) {
            if (relatedFilesStorage.exists()) {
                FileUtil.delete((File)relatedFilesStorage);
            }
            return new HashMap<String, Collection<String>>();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 14: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 14: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typesDirectory";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/download/TypeScriptRelatedPackagesStorage";
                break;
            }
            case 4: 
            case 6: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedPackageNames";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relatedFilesStorage";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/download/TypeScriptRelatedPackagesStorage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedPackageNames";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataMap";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "readDataFromFile";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "readData";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "readDataImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStorage";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedPackageNames";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 14: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDataMap";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readDataFromFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "writeDataToFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readDataImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 14: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

