/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.option;

import com.intellij.lang.javascript.linter.option.Option;
import com.intellij.lang.javascript.linter.option.OptionEnumType;
import com.intellij.lang.javascript.linter.option.OptionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OptionTypes {
    public static final OptionType<Boolean> BOOLEAN = new BooleanOptionType();
    public static final OptionType<Integer> INTEGER = new IntegerOptionType();
    public static final OptionType<String> STRING = new StringOptionType();
    public static final String ANY_VALUE = "any";

    public static boolean isBooleanOption(@NotNull Option<?> option) {
        if (option == null) {
            OptionTypes.$$$reportNull$$$0(0);
        }
        return BOOLEAN.equals(option.getType());
    }

    public static boolean isStringOption(@NotNull Option<?> option) {
        if (option == null) {
            OptionTypes.$$$reportNull$$$0(1);
        }
        return STRING.equals(option.getType());
    }

    public static boolean isIntegerOption(@NotNull Option<?> option) {
        if (option == null) {
            OptionTypes.$$$reportNull$$$0(2);
        }
        return INTEGER.equals(option.getType());
    }

    public static boolean isEnumOption(@NotNull Option<?> option) {
        if (option == null) {
            OptionTypes.$$$reportNull$$$0(3);
        }
        return option.getType() instanceof OptionEnumType;
    }

    @NotNull
    public static OptionEnumType getOptionEnumType(@NotNull Option<?> option) {
        if (option == null) {
            OptionTypes.$$$reportNull$$$0(4);
        }
        OptionEnumType optionEnumType = (OptionEnumType)option.getType();
        if (optionEnumType == null) {
            OptionTypes.$$$reportNull$$$0(5);
        }
        return optionEnumType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/option/OptionTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/option/OptionTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionEnumType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isBooleanOption";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isStringOption";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isIntegerOption";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEnumOption";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOptionEnumType";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StringOptionType
    implements OptionType<String> {
        private StringOptionType() {
        }

        @Override
        @Nullable
        public String fromString(@NotNull String valueStr) {
            if (valueStr == null) {
                StringOptionType.$$$reportNull$$$0(0);
            }
            return valueStr;
        }

        @Override
        public boolean isValidValue(@NotNull String optionValue) {
            if (optionValue == null) {
                StringOptionType.$$$reportNull$$$0(1);
            }
            return true;
        }

        public String toString() {
            return "string";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueStr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionValue";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/linter/option/OptionTypes$StringOptionType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isValidValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class IntegerOptionType
    implements OptionType<Integer> {
        private IntegerOptionType() {
        }

        @Override
        @Nullable
        public Integer fromString(@NotNull String valueStr) {
            if (valueStr == null) {
                IntegerOptionType.$$$reportNull$$$0(0);
            }
            try {
                return Integer.parseInt(valueStr);
            }
            catch (Exception e) {
                return null;
            }
        }

        @Override
        public boolean isValidValue(@NotNull Integer optionValue) {
            if (optionValue == null) {
                IntegerOptionType.$$$reportNull$$$0(1);
            }
            return optionValue >= 0;
        }

        public String toString() {
            return "integer";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueStr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionValue";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/linter/option/OptionTypes$IntegerOptionType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isValidValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BooleanOptionType
    implements OptionType<Boolean> {
        private BooleanOptionType() {
        }

        @Override
        @Nullable
        public Boolean fromString(@NotNull String valueStr) {
            if (valueStr == null) {
                BooleanOptionType.$$$reportNull$$$0(0);
            }
            if (Boolean.TRUE.toString().equals(valueStr)) {
                return Boolean.TRUE;
            }
            if (Boolean.FALSE.toString().equals(valueStr)) {
                return Boolean.FALSE;
            }
            return null;
        }

        @Override
        public boolean isValidValue(@NotNull Boolean optionValue) {
            if (optionValue == null) {
                BooleanOptionType.$$$reportNull$$$0(1);
            }
            return true;
        }

        public String toString() {
            return "boolean";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "valueStr";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionValue";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/linter/option/OptionTypes$BooleanOptionType";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fromString";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isValidValue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

