/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi;

import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public interface JSCommonTypeNames {
    @NonNls
    public static final String ANY_TYPE = "*";
    @NonNls
    public static final String ARRAY_CLASS_NAME = "Array";
    @NonNls
    public static final String READONLY_ARRAY_CLASS_NAME = "ReadonlyArray";
    @NonNls
    public static final String NODE_LIST_ARRAY_CLASS_NAME = "NodeListOf";
    @NonNls
    public static final String ARRAY_LIKE_CLASS_NAME = "ArrayLike";
    @NonNls
    public static final String CONCAT_CLASS_NAME = "ConcatArray";
    @NonNls
    public static final String VECTOR_CLASS_NAME = "Vector";
    @NonNls
    public static final String OBJECT_CLASS_NAME = "Object";
    @NonNls
    public static final String STRING_CLASS_NAME = "String";
    @NonNls
    public static final String STRING_TYPE_NAME = "string";
    @NonNls
    public static final String REG_EXP_CLASS_NAME = "RegExp";
    @NonNls
    public static final String XML_CLASS_NAME = "XML";
    @NonNls
    public static final String XML_LIST_CLASS_NAME = "XMLList";
    @NonNls
    public static final String NUMBER_CLASS_NAME = "Number";
    @NonNls
    public static final String NUMBER_TYPE_NAME = "number";
    @NonNls
    public static final String SYMBOL_TYPE_NAME = "symbol";
    @NonNls
    public static final String UNIQUE_SYMBOL_TYPE_NAME = "unique symbol";
    @NonNls
    public static final String SYMBOL_CLASS_NAME = "Symbol";
    @NonNls
    public static final String SYMBOL_CONSTRUCTOR_CLASS_NAME = "SymbolConstructor";
    @NonNls
    public static final String SYMBOL_NAME_PREFIX = "[Symbol.";
    @NonNls
    public static final String FUNCTION_CLASS_NAME = "Function";
    @NonNls
    public static final String CALLABLE_FUNCTION_CLASS_NAME = "CallableFunction";
    @NonNls
    public static final String NEWABLE_FUNCTION_CLASS_NAME = "NewableFunction";
    @NonNls
    public static final Set<String> NODE_REQUIRE_FUNCTIONS = ContainerUtil.immutableSet((Object[])new String[]{"NodeRequireFunction", "NodeRequire"});
    @NonNls
    public static final String FUNCTION_TYPE_NAME = "function";
    @NonNls
    public static final String BOOLEAN_CLASS_NAME = "Boolean";
    @NonNls
    public static final String BOOLEAN_TYPE_NAME = "boolean";
    @NonNls
    public static final String VOID_TYPE_NAME = "void";
    @NonNls
    public static final String ERROR_CLASS_NAME = "Error";
    @NonNls
    public static final String ITERABLE_CLASS_NAME = "Iterable";
    @NonNls
    public static final String ASYNC_ITERABLE_CLASS_NAME = "AsyncIterable";
    @NonNls
    public static final String ITERABLE_ITERATOR_CLASS_NAME = "IterableIterator";
    @NonNls
    public static final String ASYNC_ITERABLE_ITERATOR_CLASS_NAME = "AsyncIterableIterator";
    @NonNls
    public static final String ITERATOR_CLASS_NAME = "Iterator";
    @NonNls
    public static final String GENERATOR_CLASS_NAME = "Generator";
    @NonNls
    public static final String ASYNC_ITERATOR_CLASS_NAME = "AsyncIterator";
    @NonNls
    public static final String ASYNC_GENERATOR_CLASS_NAME = "AsyncGenerator";
    @NonNls
    public static final String INT_TYPE_NAME = "int";
    @NonNls
    public static final String INTEGER_CLASS_NAME = "Integer";
    @NonNls
    public static final String UINT_TYPE_NAME = "uint";
    @NonNls
    public static final String NULL_TYPE_NAME = "null";
    @NonNls
    public static final String UNDEFINED_TYPE_NAME = "undefined";
    @NonNls
    public static final String ANY_TYPE_NAME = "any";
    @NonNls
    public static final String UNKNOWN_TYPE_NAME = "unknown";
    @NonNls
    public static final String INTRINSIC_TYPE_NAME = "intrinsic";
    @NonNls
    public static final String WINDOW_TYPE_NAME = "Window";
    @NonNls
    public static final String NODE_GLOBAL_TYPE_NAME = "NodeJS.Global";
    @NonNls
    public static final String ARGUMENTS_TYPE_NAME = "IArguments";
    @NonNls
    public static final String MAP_TYPE_NAME = "Map";
    @NonNls
    public static final String WEAK_MAP_TYPE_NAME = "WeakMap";
    @NonNls
    public static final String SET_TYPE_NAME = "Set";
    @NonNls
    public static final String WEAK_SET_TYPE_NAME = "WeakSet";
    @NonNls
    public static final String ITERATOR_SYMBOL = "[Symbol.iterator]";
    @NonNls
    public static final String ASYNC_ITERATOR_SYMBOL = "[Symbol.asyncIterator]";
    @NonNls
    public static final String PROMISE_CLASS_NAME = "Promise";
    @NonNls
    public static final String PROMISELIKE_INTERFACE_NAME = "PromiseLike";
    @NonNls
    public static final String NEVER_TYPE_NAME = "never";
    @NonNls
    public static final String TRUE_TYPE_NAME = "true";
    @NonNls
    public static final String FALSE_TYPE_NAME = "false";
    @NonNls
    public static final String BIGINT_CLASS_NAME = "BigInt";
    @NonNls
    public static final String BIGINT_TYPE_NAME = "bigint";
    @NonNls
    public static final String OBJECT_TYPE_NAME = "object";
    @NonNls
    public static final String CLASS_CLASS_NAME = "Class";
    @NonNls
    public static final String RECORD_CLASS_NAME = "Record";
    @NonNls
    public static final String TEMPLATE_STRINGS_ARRAY_CLASS_NAME = "TemplateStringsArray";
    @NonNls
    public static final String IMPORT_META_CLASS_NAME = "ImportMeta";
    @NonNls
    public static final String THIS_TYPE_NAME = "this";
    @NonNls
    public static final String PICK_CLASS_NAME = "Pick";
    @NonNls
    public static final String EXCLUDE_CLASS_NAME = "Exclude";
    @NonNls
    public static final String UPPERCASE = "Uppercase";
    @NonNls
    public static final String LOWERCASE = "Lowercase";
    @NonNls
    public static final String CAPITALIZE = "Capitalize";
    @NonNls
    public static final String UNCAPITALIZE = "Uncapitalize";
    public static final String[] ALL_CLASSES = new String[]{"Array", "Vector", "Object", "String", "RegExp", "XML", "XMLList", "Promise", "Number", "Function", "CallableFunction", "NewableFunction", "Boolean", "Error"};
    public static final String[] ALL = ArrayUtil.mergeArrays((String[])ALL_CLASSES, (String[])new String[]{"*", "void", "uint", "int", "object", "null", "undefined", "symbol", "bigint", "object"});
    public static final String[] KEYOF_TYPES = new String[]{"string", "number", "symbol"};
    public static final String[] TYPEOF_VALUES = new String[]{"undefined", "object", "boolean", "number", "string", "function", "symbol", "bigint"};
    public static final Set<String> TYPED_ARRAY_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"Int8Array", "Uint8Array", "Uint8ClampedArray", "Int16Array", "Uint16Array", "Int32Array", "Uint32Array", "Float32Array", "Float64Array", "BigInt64Array", "BigUint64Array"});
    public static final Set<String> NON_REFERENCE_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"void", "this", "any"});
    public static final Set<String> FUNCTION_CLASS_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"Function", "CallableFunction", "NewableFunction"});
    public static final Set<String> OBJECT_FUNCTION_CLASS_NAMES = ContainerUtil.immutableSet((Object[])new String[]{"Function", "CallableFunction", "NewableFunction", "Object"});
    public static final Set<String> ARRAY_LIKE_CLASSES = ContainerUtil.immutableSet((Object[])new String[]{"NodeListOf", "ReadonlyArray", "Array"});
    public static final Set<String> UTIL_TYPES = ContainerUtil.immutableSet((Object[])new String[]{"Partial", "Readonly", "NonNullable", "Parameters", "ConstructorParameters", "ReturnType", "InstanceType", "Required", "ThisType"});
    public static final Set<String> SET_ITERABLES = ContainerUtil.immutableSet((Object[])new String[]{"Set", "WeakSet"});
    public static final Set<String> MAP_ITERABLES = ContainerUtil.immutableSet((Object[])new String[]{"Map", "WeakMap"});
    public static final Set<String> BUILTIN_ITERABLES = JSCommonTypeNames.createImmutableSet(SET_ITERABLES, MAP_ITERABLES);
    public static final Set<String> ARRAY_LIKE_TYPES = JSCommonTypeNames.createImmutableSet(TYPED_ARRAY_NAMES, SET_ITERABLES, MAP_ITERABLES, ARRAY_LIKE_CLASSES, ContainerUtil.immutableSet((Object[])new String[]{"IArguments"}));
    public static final String TYPEOF_IDENTIFIER = "#typeof";
    public static final String CONTEXTUAL_TYPEOF_IDENTIFIER = "#ctypeof";
    public static final String COMPONENT_OF_ITERABLE_IDENTIFIER = "#compof";
    public static final String REST_IDENTIFIER = "#restof";
    public static final String TYPE_LITERAL_KEY_PREFIX = "#literalkey";
    public static final String TAGGED_LITERAL_KEY_PREFIX = "#taggedliteralkey";
    public static final char SINGLE_TYPE_SPECIAL_CHAR = '\u0001';
    public static final String MODULE_PREFIX = "module:";
    public static final String EVENT_PREFIX = "event:";
    public static final String REST_PARAM_PREFIX = "...";

    @SafeVarargs
    @NotNull
    public static <T> Set<T> createImmutableSet(Set<T> ... sets) {
        if (sets == null) {
            JSCommonTypeNames.$$$reportNull$$$0(0);
        }
        HashSet<T> result2 = new HashSet<T>();
        for (Set<T> set : sets) {
            result2.addAll(set);
        }
        Set set = Collections.unmodifiableSet(result2);
        if (set == null) {
            JSCommonTypeNames.$$$reportNull$$$0(1);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sets";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/JSCommonTypeNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/JSCommonTypeNames";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createImmutableSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createImmutableSet";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

